/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.tomcat.util.buf.UriUtil;

public class WebappServiceLoader<T> {
    private static final String CLASSES = "/WEB-INF/classes/";
    private static final String LIB = "/WEB-INF/lib/";
    private static final String SERVICES = "META-INF/services/";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Context context;
    private final ServletContext servletContext;
    private final Pattern containerSciFilterPattern;

    public WebappServiceLoader(Context context) {
        this.context = context;
        this.servletContext = context.getServletContext();
        String string = context.getContainerSciFilter();
        this.containerSciFilterPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
    }

    public List<T> load(Class<T> clazz) throws IOException {
        LinkedHashSet<String> linkedHashSet;
        String string = SERVICES + clazz.getName();
        ClassLoader classLoader = this.context.getParentClassLoader();
        Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(string) : classLoader.getResources(string);
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        HashSet<URL> hashSet = new HashSet<URL>();
        while (enumeration.hasMoreElements()) {
            linkedHashSet = enumeration.nextElement();
            hashSet.add((URL)((Object)linkedHashSet));
            this.parseConfigFile(linkedHashSet2, (URL)((Object)linkedHashSet));
        }
        if (this.containerSciFilterPattern != null) {
            linkedHashSet = linkedHashSet2.iterator();
            while (linkedHashSet.hasNext()) {
                if (!this.containerSciFilterPattern.matcher((CharSequence)linkedHashSet.next()).find()) continue;
                linkedHashSet.remove();
            }
        }
        linkedHashSet = new LinkedHashSet<String>();
        List list = (List)this.servletContext.getAttribute("javax.servlet.context.orderedLibs");
        if (list == null) {
            Enumeration<URL> enumeration2 = this.servletContext.getClassLoader().getResources(string);
            while (enumeration2.hasMoreElements()) {
                URL uRL = enumeration2.nextElement();
                if (hashSet.contains(uRL)) continue;
                this.parseConfigFile(linkedHashSet, uRL);
            }
        } else {
            URL uRL = this.servletContext.getResource(CLASSES + string);
            if (uRL != null) {
                this.parseConfigFile(linkedHashSet, uRL);
            }
            for (String string2 : list) {
                URL uRL2 = this.servletContext.getResource(LIB + string2);
                if (uRL2 == null) continue;
                String string3 = uRL2.toExternalForm();
                URL uRL3 = string3.endsWith("/") ? new URL(string3 + string) : UriUtil.buildJarUrl((String)string3, (String)string);
                try {
                    this.parseConfigFile(linkedHashSet, uRL3);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        linkedHashSet2.addAll(linkedHashSet);
        if (linkedHashSet2.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadServices(clazz, linkedHashSet2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseConfigFile(LinkedHashSet<String> linkedHashSet, URL uRL) throws IOException {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, UTF8);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() == 0) continue;
                linkedHashSet.add(string);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    List<T> loadServices(Class<T> clazz, LinkedHashSet<String> linkedHashSet) throws IOException {
        ClassLoader classLoader = this.servletContext.getClassLoader();
        ArrayList<T> arrayList = new ArrayList<T>(linkedHashSet.size());
        for (String string : linkedHashSet) {
            try {
                Class<?> clazz2 = Class.forName(string, true, classLoader);
                arrayList.add(clazz.cast(clazz2.newInstance()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new IOException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                throw new IOException(classCastException);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }
}

