/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;

public class MbeansDescriptorsSerSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsSerSource.class);
    Registry registry;
    String type;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Deprecated
    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String string, Object object) throws Exception {
        this.setRegistry(registry);
        this.setType(string);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        long l = System.currentTimeMillis();
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            if (this.source instanceof URL) {
                inputStream = ((URL)this.source).openStream();
            }
            if (this.source instanceof InputStream) {
                inputStream = (InputStream)this.source;
            }
            if (inputStream == null) {
                throw new Exception("Can't process " + this.source);
            }
            objectInputStream = new ObjectInputStream(inputStream);
            Thread.currentThread().setContextClassLoader(ManagedBean.class.getClassLoader());
            Object object = objectInputStream.readObject();
            ManagedBean[] managedBeanArray = (ManagedBean[])object;
            for (int i = 0; i < managedBeanArray.length; ++i) {
                this.registry.addManagedBean(managedBeanArray[i]);
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error reading descriptors " + this.source + " " + exception.toString()), (Throwable)exception);
            throw exception;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        long l2 = System.currentTimeMillis();
        log.info((Object)("Reading descriptors ( ser ) " + (l2 - l)));
    }
}

