/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.util.mime;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class RFC2231Utility {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final byte[] HEX_DECODE = new byte[128];

    public static boolean hasEncodedValue(String string) {
        if (string != null) {
            return string.lastIndexOf("*") == string.length() - 1;
        }
        return false;
    }

    public static String stripDelimiter(String string) {
        if (RFC2231Utility.hasEncodedValue(string)) {
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.deleteCharAt(string.lastIndexOf("*"));
            return stringBuilder.toString();
        }
        return string;
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        int n = string.indexOf(39);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        int n2 = string.indexOf(39, n + 1);
        if (n2 == -1) {
            return string;
        }
        byte[] byArray = RFC2231Utility.fromHex(string.substring(n2 + 1));
        return new String(byArray, RFC2231Utility.getJavaCharset(string2));
    }

    private static byte[] fromHex(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        int n = 0;
        while (n < string.length()) {
            char c;
            if ((c = string.charAt(n++)) == '%') {
                if (n > string.length() - 2) break;
                byte by = HEX_DECODE[string.charAt(n++) & 0x7F];
                byte by2 = HEX_DECODE[string.charAt(n++) & 0x7F];
                byteArrayOutputStream.write(by << 4 | by2);
                continue;
            }
            byteArrayOutputStream.write((byte)c);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static String getJavaCharset(String string) {
        return string;
    }

    static {
        for (int i = 0; i < HEX_DIGITS.length; ++i) {
            RFC2231Utility.HEX_DECODE[RFC2231Utility.HEX_DIGITS[i]] = (byte)i;
            RFC2231Utility.HEX_DECODE[Character.toLowerCase((char)RFC2231Utility.HEX_DIGITS[i])] = (byte)i;
        }
    }
}

