/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.res.StringManager;

public class Authorization {
    private static final StringManager sm = StringManager.getManager(Authorization.class);
    private static final Integer FIELD_TYPE_TOKEN = 0;
    private static final Integer FIELD_TYPE_QUOTED_STRING = 1;
    private static final Integer FIELD_TYPE_TOKEN_OR_QUOTED_STRING = 2;
    private static final Integer FIELD_TYPE_LHEX = 3;
    private static final Integer FIELD_TYPE_QUOTED_TOKEN = 4;
    private static final Map<String, Integer> fieldTypes = new HashMap<String, Integer>();

    public static Map<String, String> parseAuthorizationDigest(StringReader stringReader) throws IllegalArgumentException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (HttpParser.skipConstant(stringReader, "Digest") != SkipResult.FOUND) {
            return null;
        }
        String string = HttpParser.readToken(stringReader);
        if (string == null) {
            return null;
        }
        while (!string.equals("")) {
            String string2;
            if (HttpParser.skipConstant(stringReader, "=") != SkipResult.FOUND) {
                return null;
            }
            Integer n = fieldTypes.get(string.toLowerCase(Locale.ENGLISH));
            if (n == null) {
                n = FIELD_TYPE_TOKEN_OR_QUOTED_STRING;
            }
            switch (n) {
                case 0: {
                    string2 = HttpParser.readToken(stringReader);
                    break;
                }
                case 1: {
                    string2 = HttpParser.readQuotedString(stringReader, false);
                    break;
                }
                case 2: {
                    string2 = HttpParser.readTokenOrQuotedString(stringReader, false);
                    break;
                }
                case 3: {
                    string2 = HttpParser.readLhex(stringReader);
                    break;
                }
                case 4: {
                    string2 = HttpParser.readQuotedToken(stringReader);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(sm.getString("authorization.unknownType", new Object[]{n}));
                }
            }
            if (string2 == null) {
                return null;
            }
            hashMap.put(string, string2);
            if (HttpParser.skipConstant(stringReader, ",") == SkipResult.NOT_FOUND) {
                return null;
            }
            string = HttpParser.readToken(stringReader);
            if (string != null) continue;
            return null;
        }
        return hashMap;
    }

    static {
        fieldTypes.put("username", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("realm", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("nonce", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("digest-uri", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("response", FIELD_TYPE_LHEX);
        fieldTypes.put("algorithm", FIELD_TYPE_QUOTED_TOKEN);
        fieldTypes.put("cnonce", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("opaque", FIELD_TYPE_QUOTED_STRING);
        fieldTypes.put("qop", FIELD_TYPE_QUOTED_TOKEN);
        fieldTypes.put("nc", FIELD_TYPE_LHEX);
    }
}

