/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;
import java.sql.DriverManager;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.SafeForkJoinWorkerThreadFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.res.StringManager;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private static final String FORK_JOIN_POOL_THREAD_FACTORY_PROPERTY = "java.util.concurrent.ForkJoinPool.common.threadFactory";
    private boolean appContextProtection = false;
    private boolean awtThreadProtection = false;
    private boolean gcDaemonProtection = true;
    private boolean securityPolicyProtection = true;
    private boolean securityLoginConfigurationProtection = true;
    private boolean tokenPollerProtection = true;
    private boolean urlCacheProtection = true;
    private boolean xmlParsingProtection = true;
    private boolean ldapPoolProtection = true;
    private boolean driverManagerProtection = true;
    private boolean forkJoinCommonPoolProtection = true;
    private String classesToInitialize = null;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean bl) {
        this.appContextProtection = bl;
    }

    public boolean isAWTThreadProtection() {
        return this.awtThreadProtection;
    }

    public void setAWTThreadProtection(boolean bl) {
        this.awtThreadProtection = bl;
    }

    public boolean isGcDaemonProtection() {
        return this.gcDaemonProtection;
    }

    public void setGcDaemonProtection(boolean bl) {
        this.gcDaemonProtection = bl;
    }

    public boolean isSecurityPolicyProtection() {
        return this.securityPolicyProtection;
    }

    public void setSecurityPolicyProtection(boolean bl) {
        this.securityPolicyProtection = bl;
    }

    public boolean isSecurityLoginConfigurationProtection() {
        return this.securityLoginConfigurationProtection;
    }

    public void setSecurityLoginConfigurationProtection(boolean bl) {
        this.securityLoginConfigurationProtection = bl;
    }

    public boolean isTokenPollerProtection() {
        return this.tokenPollerProtection;
    }

    public void setTokenPollerProtection(boolean bl) {
        this.tokenPollerProtection = bl;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean bl) {
        this.urlCacheProtection = bl;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean bl) {
        this.xmlParsingProtection = bl;
    }

    public boolean isLdapPoolProtection() {
        return this.ldapPoolProtection;
    }

    public void setLdapPoolProtection(boolean bl) {
        this.ldapPoolProtection = bl;
    }

    public boolean isDriverManagerProtection() {
        return this.driverManagerProtection;
    }

    public void setDriverManagerProtection(boolean bl) {
        this.driverManagerProtection = bl;
    }

    public boolean getForkJoinCommonPoolProtection() {
        return this.forkJoinCommonPoolProtection;
    }

    public void setForkJoinCommonPoolProtection(boolean bl) {
        this.forkJoinCommonPoolProtection = bl;
    }

    public String getClassesToInitialize() {
        return this.classesToInitialize;
    }

    public void setClassesToInitialize(String string) {
        this.classesToInitialize = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_init".equals(lifecycleEvent.getType())) {
            if (this.driverManagerProtection) {
                DriverManager.getDrivers();
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object object;
                Object object2;
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                if (this.appContextProtection && !JreCompat.isJre8Available()) {
                    ImageIO.getCacheDirectory();
                }
                if (this.awtThreadProtection && !JreCompat.isJre9Available()) {
                    Toolkit.getDefaultToolkit();
                }
                if (this.gcDaemonProtection && !JreCompat.isJre9Available()) {
                    try {
                        object2 = Class.forName("sun.misc.GC");
                        object = ((Class)object2).getDeclaredMethod("requestLatency", Long.TYPE);
                        ((Method)object).invoke(null, 0x7FFFFFFFFFFFFFFEL);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (JreVendor.IS_ORACLE_JVM) {
                            log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)classNotFoundException);
                        } else {
                            log.debug((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)classNotFoundException);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException exception) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)exception);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)invocationTargetException);
                    }
                }
                if (this.securityPolicyProtection && !JreCompat.isJre8Available()) {
                    try {
                        object2 = Class.forName("javax.security.auth.Policy");
                        object = ((Class)object2).getMethod("getPolicy", new Class[0]);
                        ((Method)object).invoke(null, new Object[0]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)noSuchMethodException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
                        log.warn((Object)sm.getString("jreLeakListener.authPolicyFail"), (Throwable)invocationTargetException);
                    }
                }
                if (this.securityLoginConfigurationProtection && !JreCompat.isJre8Available()) {
                    try {
                        Class.forName("javax.security.auth.login.Configuration", true, ClassLoader.getSystemClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (this.tokenPollerProtection && !JreCompat.isJre9Available()) {
                    Security.getProviders();
                }
                if (this.urlCacheProtection) {
                    try {
                        JreCompat.getInstance().disableCachingForJarUrlConnections();
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)iOException);
                    }
                }
                if (this.xmlParsingProtection && !JreCompat.isJre9Available()) {
                    object2 = DocumentBuilderFactory.newInstance();
                    try {
                        object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
                        Document document = ((DocumentBuilder)object).newDocument();
                        document.createElement("dummy");
                        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)document.getImplementation());
                        dOMImplementationLS.createLSSerializer().writeToString(document);
                        document.normalize();
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        log.error((Object)sm.getString("jreLeakListener.xmlParseFail"), (Throwable)parserConfigurationException);
                    }
                }
                if (this.ldapPoolProtection && !JreCompat.isJre9Available()) {
                    try {
                        Class.forName("com.sun.jndi.ldap.LdapPoolManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (JreVendor.IS_ORACLE_JVM) {
                            log.error((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)classNotFoundException);
                        }
                        log.debug((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)classNotFoundException);
                    }
                }
                if (this.forkJoinCommonPoolProtection && JreCompat.isJre8Available() && !JreCompat.isJre9Available() && System.getProperty(FORK_JOIN_POOL_THREAD_FACTORY_PROPERTY) == null) {
                    System.setProperty(FORK_JOIN_POOL_THREAD_FACTORY_PROPERTY, SafeForkJoinWorkerThreadFactory.class.getName());
                }
                if (this.classesToInitialize != null) {
                    object2 = new StringTokenizer(this.classesToInitialize, ", \r\n\t");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        try {
                            Class.forName((String)object);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)sm.getString("jreLeakListener.classToInitializeFail", new Object[]{object}), (Throwable)classNotFoundException);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

