/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GoodsForSaleMessage
extends DOMMessage {
    private final String unitId;
    private final String settlementId;
    private final List<Goods> sellGoods;

    public GoodsForSaleMessage(Unit unit, Settlement settlement, List<Goods> sellGoods) {
        super(GoodsForSaleMessage.getXMLElementTagName());
        this.unitId = unit.getId();
        this.settlementId = settlement.getId();
        this.sellGoods = sellGoods;
    }

    public GoodsForSaleMessage(Game game, Element element) {
        super(GoodsForSaleMessage.getXMLElementTagName());
        this.unitId = element.getAttribute("unit");
        this.settlementId = element.getAttribute("settlement");
        this.sellGoods = new ArrayList<Goods>();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.sellGoods.add(new Goods(game, (Element)children.item(i)));
        }
    }

    public List<Goods> getGoods() {
        return this.sellGoods;
    }

    public Element handle(FreeColServer server, Player player, Connection connection) {
        IndianSettlement settlement;
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = player.getOurFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        try {
            settlement = unit.getAdjacentIndianSettlementSafely(this.settlementId);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().getGoodsForSale(serverPlayer, unit, settlement);
    }

    @Override
    public Element toXMLElement() {
        Element result = GoodsForSaleMessage.createMessage(GoodsForSaleMessage.getXMLElementTagName(), "unit", this.unitId, "settlement", this.settlementId);
        if (this.sellGoods != null) {
            for (Goods goods : this.sellGoods) {
                result.appendChild(goods.toXMLElement(result.getOwnerDocument()));
            }
        }
        return result;
    }

    public static String getXMLElementTagName() {
        return "goodsForSale";
    }
}

