// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3N4A.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

// +build sam,atsam3n4a

// Atmel ATSAM3N4A Microcontroller
//

package sam

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATSAM3N4A"
)

// Interrupt numbers.
const (
	IRQ_PMC    = 5  // Power Management Controller
	IRQ_EFC    = 6  // Embedded Flash Controller
	IRQ_UART0  = 8  // Universal Asynchronous Receiver Transmitter 0
	IRQ_UART1  = 9  // Universal Asynchronous Receiver Transmitter 1
	IRQ_PIOA   = 11 // Parallel Input/Output Controller A
	IRQ_PIOB   = 12 // Parallel Input/Output Controller B
	IRQ_USART0 = 14 // Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_TWI0   = 19 // Two-wire Interface 0
	IRQ_TWI1   = 20 // Two-wire Interface 1
	IRQ_SPI    = 21 // Serial Peripheral Interface
	IRQ_TC0    = 23 // Timer Counter 0
	IRQ_TC1    = 24 // Timer Counter 0
	IRQ_TC2    = 25 // Timer Counter 0
	IRQ_ADC    = 29 // Analog-to-Digital Converter
	IRQ_DACC   = 30 // Digital-to-Analog Converter Controller
	IRQ_PWM    = 31 // Pulse Width Modulation Controller
	IRQ_max    = 31 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PMC, "PMC_IRQHandler")
	_ = interrupt.Register(IRQ_EFC, "EFC_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_PIOA, "PIOA_IRQHandler")
	_ = interrupt.Register(IRQ_PIOB, "PIOB_IRQHandler")
	_ = interrupt.Register(IRQ_USART0, "USART0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI0, "TWI0_IRQHandler")
	_ = interrupt.Register(IRQ_TWI1, "TWI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI, "SPI_IRQHandler")
	_ = interrupt.Register(IRQ_TC0, "TC0_IRQHandler")
	_ = interrupt.Register(IRQ_TC1, "TC1_IRQHandler")
	_ = interrupt.Register(IRQ_TC2, "TC2_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_DACC, "DACC_IRQHandler")
	_ = interrupt.Register(IRQ_PWM, "PWM_IRQHandler")
)

// Peripherals.
var (
	SPI    = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))    // Serial Peripheral Interface
	TC0    = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))     // Timer Counter 0
	TWI0   = (*TWI_Type)(unsafe.Pointer(uintptr(0x40018000)))    // Two-wire Interface 0
	TWI1   = (*TWI_Type)(unsafe.Pointer(uintptr(0x4001c000)))    // Two-wire Interface 1
	PWM    = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))    // Pulse Width Modulation Controller
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))  // Universal Synchronous Asynchronous Receiver Transmitter 0
	ADC    = (*ADC_Type)(unsafe.Pointer(uintptr(0x40038000)))    // Analog-to-Digital Converter
	DACC   = (*DACC_Type)(unsafe.Pointer(uintptr(0x4003c000)))   // Digital-to-Analog Converter Controller
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200))) // AHB Bus Matrix
	PMC    = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))    // Power Management Controller
	UART0  = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))   // Universal Asynchronous Receiver Transmitter 0
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740))) // Chip Identifier
	UART1  = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))   // Universal Asynchronous Receiver Transmitter 1
	EFC    = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))    // Embedded Flash Controller
	PIOA   = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))    // Parallel Input/Output Controller A
	PIOB   = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))    // Parallel Input/Output Controller B
	RSTC   = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1400)))   // Reset Controller
	SUPC   = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1410)))   // Supply Controller
	RTT    = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1430)))   // Real-time Timer
	WDT    = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1450)))   // Watchdog Timer
	RTC    = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1460)))   // Real-time Clock
	GPBR   = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1490)))   // General Purpose Backup Registers
)

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	_     [12]byte
	WPMR  volatile.Register32 // 0xE4
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32 // 0x3C
	EMR   volatile.Register32 // 0x40
	CWR   volatile.Register32 // 0x44
	_     [8]byte
	CDR   [16]volatile.Register32 // 0x50
	_     [84]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	CDR  volatile.Register32 // 0x8
	IER  volatile.Register32 // 0xC
	IDR  volatile.Register32 // 0x10
	IMR  volatile.Register32 // 0x14
	ISR  volatile.Register32 // 0x18
	_    [200]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [3]volatile.Register32 // 0x0
	_            [52]byte
	MATRIX_SCFG  [4]volatile.Register32 // 0x40
	_            [48]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [120]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [204]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	_          [4]byte
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [12]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// Embedded Flash Controller
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// Bitfields for SPI: Serial Peripheral Interface
const (
	// CR: Control Register
	SPI_CR_SPIEN_Pos    = 0x0       // Position of SPIEN field.
	SPI_CR_SPIEN_Msk    = 0x1       // Bit mask of SPIEN field.
	SPI_CR_SPIEN        = 0x1       // Bit SPIEN.
	SPI_CR_SPIDIS_Pos   = 0x1       // Position of SPIDIS field.
	SPI_CR_SPIDIS_Msk   = 0x2       // Bit mask of SPIDIS field.
	SPI_CR_SPIDIS       = 0x2       // Bit SPIDIS.
	SPI_CR_SWRST_Pos    = 0x7       // Position of SWRST field.
	SPI_CR_SWRST_Msk    = 0x80      // Bit mask of SWRST field.
	SPI_CR_SWRST        = 0x80      // Bit SWRST.
	SPI_CR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_CR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// MR: Mode Register
	SPI_MR_MSTR_Pos    = 0x0        // Position of MSTR field.
	SPI_MR_MSTR_Msk    = 0x1        // Bit mask of MSTR field.
	SPI_MR_MSTR        = 0x1        // Bit MSTR.
	SPI_MR_PS_Pos      = 0x1        // Position of PS field.
	SPI_MR_PS_Msk      = 0x2        // Bit mask of PS field.
	SPI_MR_PS          = 0x2        // Bit PS.
	SPI_MR_PCSDEC_Pos  = 0x2        // Position of PCSDEC field.
	SPI_MR_PCSDEC_Msk  = 0x4        // Bit mask of PCSDEC field.
	SPI_MR_PCSDEC      = 0x4        // Bit PCSDEC.
	SPI_MR_MODFDIS_Pos = 0x4        // Position of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10       // Bit mask of MODFDIS field.
	SPI_MR_MODFDIS     = 0x10       // Bit MODFDIS.
	SPI_MR_WDRBT_Pos   = 0x5        // Position of WDRBT field.
	SPI_MR_WDRBT_Msk   = 0x20       // Bit mask of WDRBT field.
	SPI_MR_WDRBT       = 0x20       // Bit WDRBT.
	SPI_MR_LLB_Pos     = 0x7        // Position of LLB field.
	SPI_MR_LLB_Msk     = 0x80       // Bit mask of LLB field.
	SPI_MR_LLB         = 0x80       // Bit LLB.
	SPI_MR_PCS_Pos     = 0x10       // Position of PCS field.
	SPI_MR_PCS_Msk     = 0xf0000    // Bit mask of PCS field.
	SPI_MR_DLYBCS_Pos  = 0x18       // Position of DLYBCS field.
	SPI_MR_DLYBCS_Msk  = 0xff000000 // Bit mask of DLYBCS field.

	// RDR: Receive Data Register
	SPI_RDR_RD_Pos  = 0x0     // Position of RD field.
	SPI_RDR_RD_Msk  = 0xffff  // Bit mask of RD field.
	SPI_RDR_PCS_Pos = 0x10    // Position of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000 // Bit mask of PCS field.

	// TDR: Transmit Data Register
	SPI_TDR_TD_Pos       = 0x0       // Position of TD field.
	SPI_TDR_TD_Msk       = 0xffff    // Bit mask of TD field.
	SPI_TDR_PCS_Pos      = 0x10      // Position of PCS field.
	SPI_TDR_PCS_Msk      = 0xf0000   // Bit mask of PCS field.
	SPI_TDR_LASTXFER_Pos = 0x18      // Position of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000 // Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER     = 0x1000000 // Bit LASTXFER.

	// SR: Status Register
	SPI_SR_RDRF_Pos    = 0x0     // Position of RDRF field.
	SPI_SR_RDRF_Msk    = 0x1     // Bit mask of RDRF field.
	SPI_SR_RDRF        = 0x1     // Bit RDRF.
	SPI_SR_TDRE_Pos    = 0x1     // Position of TDRE field.
	SPI_SR_TDRE_Msk    = 0x2     // Bit mask of TDRE field.
	SPI_SR_TDRE        = 0x2     // Bit TDRE.
	SPI_SR_MODF_Pos    = 0x2     // Position of MODF field.
	SPI_SR_MODF_Msk    = 0x4     // Bit mask of MODF field.
	SPI_SR_MODF        = 0x4     // Bit MODF.
	SPI_SR_OVRES_Pos   = 0x3     // Position of OVRES field.
	SPI_SR_OVRES_Msk   = 0x8     // Bit mask of OVRES field.
	SPI_SR_OVRES       = 0x8     // Bit OVRES.
	SPI_SR_NSSR_Pos    = 0x8     // Position of NSSR field.
	SPI_SR_NSSR_Msk    = 0x100   // Bit mask of NSSR field.
	SPI_SR_NSSR        = 0x100   // Bit NSSR.
	SPI_SR_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY     = 0x200   // Bit TXEMPTY.
	SPI_SR_UNDES_Pos   = 0xa     // Position of UNDES field.
	SPI_SR_UNDES_Msk   = 0x400   // Bit mask of UNDES field.
	SPI_SR_UNDES       = 0x400   // Bit UNDES.
	SPI_SR_SPIENS_Pos  = 0x10    // Position of SPIENS field.
	SPI_SR_SPIENS_Msk  = 0x10000 // Bit mask of SPIENS field.
	SPI_SR_SPIENS      = 0x10000 // Bit SPIENS.

	// IER: Interrupt Enable Register
	SPI_IER_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IER_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IER_RDRF        = 0x1   // Bit RDRF.
	SPI_IER_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IER_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IER_TDRE        = 0x2   // Bit TDRE.
	SPI_IER_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IER_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IER_MODF        = 0x4   // Bit MODF.
	SPI_IER_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IER_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IER_OVRES       = 0x8   // Bit OVRES.
	SPI_IER_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IER_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IER_NSSR        = 0x100 // Bit NSSR.
	SPI_IER_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY     = 0x200 // Bit TXEMPTY.
	SPI_IER_UNDES_Pos   = 0xa   // Position of UNDES field.
	SPI_IER_UNDES_Msk   = 0x400 // Bit mask of UNDES field.
	SPI_IER_UNDES       = 0x400 // Bit UNDES.

	// IDR: Interrupt Disable Register
	SPI_IDR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IDR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IDR_RDRF        = 0x1   // Bit RDRF.
	SPI_IDR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IDR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IDR_TDRE        = 0x2   // Bit TDRE.
	SPI_IDR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IDR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IDR_MODF        = 0x4   // Bit MODF.
	SPI_IDR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IDR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IDR_OVRES       = 0x8   // Bit OVRES.
	SPI_IDR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IDR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IDR_NSSR        = 0x100 // Bit NSSR.
	SPI_IDR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY     = 0x200 // Bit TXEMPTY.
	SPI_IDR_UNDES_Pos   = 0xa   // Position of UNDES field.
	SPI_IDR_UNDES_Msk   = 0x400 // Bit mask of UNDES field.
	SPI_IDR_UNDES       = 0x400 // Bit UNDES.

	// IMR: Interrupt Mask Register
	SPI_IMR_RDRF_Pos    = 0x0   // Position of RDRF field.
	SPI_IMR_RDRF_Msk    = 0x1   // Bit mask of RDRF field.
	SPI_IMR_RDRF        = 0x1   // Bit RDRF.
	SPI_IMR_TDRE_Pos    = 0x1   // Position of TDRE field.
	SPI_IMR_TDRE_Msk    = 0x2   // Bit mask of TDRE field.
	SPI_IMR_TDRE        = 0x2   // Bit TDRE.
	SPI_IMR_MODF_Pos    = 0x2   // Position of MODF field.
	SPI_IMR_MODF_Msk    = 0x4   // Bit mask of MODF field.
	SPI_IMR_MODF        = 0x4   // Bit MODF.
	SPI_IMR_OVRES_Pos   = 0x3   // Position of OVRES field.
	SPI_IMR_OVRES_Msk   = 0x8   // Bit mask of OVRES field.
	SPI_IMR_OVRES       = 0x8   // Bit OVRES.
	SPI_IMR_NSSR_Pos    = 0x8   // Position of NSSR field.
	SPI_IMR_NSSR_Msk    = 0x100 // Bit mask of NSSR field.
	SPI_IMR_NSSR        = 0x100 // Bit NSSR.
	SPI_IMR_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY     = 0x200 // Bit TXEMPTY.
	SPI_IMR_UNDES_Pos   = 0xa   // Position of UNDES field.
	SPI_IMR_UNDES_Msk   = 0x400 // Bit mask of UNDES field.
	SPI_IMR_UNDES       = 0x400 // Bit UNDES.

	// CSR: Chip Select Register
	SPI_CSR_CPOL_Pos    = 0x0        // Position of CPOL field.
	SPI_CSR_CPOL_Msk    = 0x1        // Bit mask of CPOL field.
	SPI_CSR_CPOL        = 0x1        // Bit CPOL.
	SPI_CSR_NCPHA_Pos   = 0x1        // Position of NCPHA field.
	SPI_CSR_NCPHA_Msk   = 0x2        // Bit mask of NCPHA field.
	SPI_CSR_NCPHA       = 0x2        // Bit NCPHA.
	SPI_CSR_CSNAAT_Pos  = 0x2        // Position of CSNAAT field.
	SPI_CSR_CSNAAT_Msk  = 0x4        // Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT      = 0x4        // Bit CSNAAT.
	SPI_CSR_CSAAT_Pos   = 0x3        // Position of CSAAT field.
	SPI_CSR_CSAAT_Msk   = 0x8        // Bit mask of CSAAT field.
	SPI_CSR_CSAAT       = 0x8        // Bit CSAAT.
	SPI_CSR_BITS_Pos    = 0x4        // Position of BITS field.
	SPI_CSR_BITS_Msk    = 0xf0       // Bit mask of BITS field.
	SPI_CSR_BITS_8_BIT  = 0x0        // 8 bits for transfer
	SPI_CSR_BITS_9_BIT  = 0x1        // 9 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2        // 10 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3        // 11 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4        // 12 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5        // 13 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6        // 14 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7        // 15 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8        // 16 bits for transfer
	SPI_CSR_SCBR_Pos    = 0x8        // Position of SCBR field.
	SPI_CSR_SCBR_Msk    = 0xff00     // Bit mask of SCBR field.
	SPI_CSR_DLYBS_Pos   = 0x10       // Position of DLYBS field.
	SPI_CSR_DLYBS_Msk   = 0xff0000   // Bit mask of DLYBS field.
	SPI_CSR_DLYBCT_Pos  = 0x18       // Position of DLYBCT field.
	SPI_CSR_DLYBCT_Msk  = 0xff000000 // Bit mask of DLYBCT field.

	// WPMR: Write Protection Control Register
	SPI_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	SPI_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	SPI_WPMR_WPEN      = 0x1        // Bit WPEN.
	SPI_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protection Status Register
	SPI_WPSR_WPVS_Pos   = 0x0    // Position of WPVS field.
	SPI_WPSR_WPVS_Msk   = 0x1    // Bit mask of WPVS field.
	SPI_WPSR_WPVS       = 0x1    // Bit WPVS.
	SPI_WPSR_WPVSRC_Pos = 0x8    // Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00 // Bit mask of WPVSRC field.

	// RPR: Receive Pointer Register
	SPI_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	SPI_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	SPI_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	SPI_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	SPI_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	SPI_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	SPI_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	SPI_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	SPI_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	SPI_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	SPI_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	SPI_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	SPI_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	SPI_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	SPI_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	SPI_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	SPI_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	SPI_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	SPI_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	SPI_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	TC_CCR0_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR0_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR0_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR0_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR0_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR0_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR0_SWTRG      = 0x4 // Bit SWTRG.

	// CMR0: Channel Mode Register (channel = 0)
	TC_CMR0_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR0_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR0_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR0_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR0_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR0_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR0_CLKI                = 0x8     // Bit CLKI.
	TC_CMR0_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR0_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR0_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR0_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR0_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR0_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR0_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR0_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR0_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR0_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR0_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR0_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR0_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR0_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR0_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR0_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR0_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR0_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR0_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR0_LDRA_NONE           = 0x0     // None
	TC_CMR0_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR0_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR0_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR0_LDRB_NONE           = 0x0     // None
	TC_CMR0_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR0_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR0_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR0_WAVEFORM_MODE: Channel Mode Register (channel = 0)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR0_WAVEFORM_MODE_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI                = 0x8        // Bit CLKI.
	TC_CMR0_WAVEFORM_MODE_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR0_WAVEFORM_MODE_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_NONE        = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR0_WAVEFORM_MODE_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR0_WAVEFORM_MODE_EEVT_XC0            = 0x1        // XC0
	TC_CMR0_WAVEFORM_MODE_EEVT_XC1            = 0x2        // XC1
	TC_CMR0_WAVEFORM_MODE_EEVT_XC2            = 0x3        // XC2
	TC_CMR0_WAVEFORM_MODE_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR0_WAVEFORM_MODE_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_NONE           = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_ACPA_SET            = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_NONE           = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_ACPC_SET            = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_AEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_ASWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_NONE           = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_BCPB_SET            = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_NONE           = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_BCPC_SET            = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_NONE          = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_BEEVT_SET           = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_NONE         = 0x0        // None
	TC_CMR0_WAVEFORM_MODE_BSWTRG_SET          = 0x1        // Set
	TC_CMR0_WAVEFORM_MODE_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR0_WAVEFORM_MODE_BSWTRG_TOGGLE       = 0x3        // Toggle

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	TC_SMMR0_GCEN_Pos = 0x0 // Position of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1 // Bit mask of GCEN field.
	TC_SMMR0_GCEN     = 0x1 // Bit GCEN.
	TC_SMMR0_DOWN_Pos = 0x1 // Position of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2 // Bit mask of DOWN field.
	TC_SMMR0_DOWN     = 0x2 // Bit DOWN.

	// CV0: Counter Value (channel = 0)
	TC_CV0_CV_Pos = 0x0        // Position of CV field.
	TC_CV0_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA0: Register A (channel = 0)
	TC_RA0_RA_Pos = 0x0        // Position of RA field.
	TC_RA0_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB0: Register B (channel = 0)
	TC_RB0_RB_Pos = 0x0        // Position of RB field.
	TC_RB0_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC0: Register C (channel = 0)
	TC_RC0_RC_Pos = 0x0        // Position of RC field.
	TC_RC0_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR0: Status Register (channel = 0)
	TC_SR0_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR0_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR0_COVFS      = 0x1     // Bit COVFS.
	TC_SR0_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR0_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR0_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR0_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR0_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR0_CPAS       = 0x4     // Bit CPAS.
	TC_SR0_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR0_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR0_CPBS       = 0x8     // Bit CPBS.
	TC_SR0_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR0_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR0_CPCS       = 0x10    // Bit CPCS.
	TC_SR0_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR0_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR0_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR0_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR0_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR0_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR0_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR0_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR0_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR0_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR0_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR0_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR0_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR0_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR0_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR0_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR0_MTIOB      = 0x40000 // Bit MTIOB.

	// IER0: Interrupt Enable Register (channel = 0)
	TC_IER0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER0_COVFS     = 0x1  // Bit COVFS.
	TC_IER0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER0_CPAS      = 0x4  // Bit CPAS.
	TC_IER0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER0_CPBS      = 0x8  // Bit CPBS.
	TC_IER0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER0_CPCS      = 0x10 // Bit CPCS.
	TC_IER0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER0_ETRGS     = 0x80 // Bit ETRGS.

	// IDR0: Interrupt Disable Register (channel = 0)
	TC_IDR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR0_COVFS     = 0x1  // Bit COVFS.
	TC_IDR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR0_CPAS      = 0x4  // Bit CPAS.
	TC_IDR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR0_CPBS      = 0x8  // Bit CPBS.
	TC_IDR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR0_CPCS      = 0x10 // Bit CPCS.
	TC_IDR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR0_ETRGS     = 0x80 // Bit ETRGS.

	// IMR0: Interrupt Mask Register (channel = 0)
	TC_IMR0_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR0_COVFS     = 0x1  // Bit COVFS.
	TC_IMR0_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR0_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR0_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR0_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR0_CPAS      = 0x4  // Bit CPAS.
	TC_IMR0_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR0_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR0_CPBS      = 0x8  // Bit CPBS.
	TC_IMR0_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR0_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR0_CPCS      = 0x10 // Bit CPCS.
	TC_IMR0_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR0_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR0_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR0_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR0_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR0_ETRGS     = 0x80 // Bit ETRGS.

	// CCR1: Channel Control Register (channel = 1)
	TC_CCR1_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR1_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR1_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR1_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR1_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR1_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR1_SWTRG      = 0x4 // Bit SWTRG.

	// CMR1: Channel Mode Register (channel = 1)
	TC_CMR1_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR1_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR1_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR1_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR1_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR1_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR1_CLKI                = 0x8     // Bit CLKI.
	TC_CMR1_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR1_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR1_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR1_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR1_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR1_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR1_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR1_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR1_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR1_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR1_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR1_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR1_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR1_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR1_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR1_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR1_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR1_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR1_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR1_LDRA_NONE           = 0x0     // None
	TC_CMR1_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR1_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR1_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR1_LDRB_NONE           = 0x0     // None
	TC_CMR1_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR1_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR1_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR1_WAVEFORM_MODE: Channel Mode Register (channel = 1)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR1_WAVEFORM_MODE_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI                = 0x8        // Bit CLKI.
	TC_CMR1_WAVEFORM_MODE_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR1_WAVEFORM_MODE_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_NONE        = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR1_WAVEFORM_MODE_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR1_WAVEFORM_MODE_EEVT_XC0            = 0x1        // XC0
	TC_CMR1_WAVEFORM_MODE_EEVT_XC1            = 0x2        // XC1
	TC_CMR1_WAVEFORM_MODE_EEVT_XC2            = 0x3        // XC2
	TC_CMR1_WAVEFORM_MODE_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR1_WAVEFORM_MODE_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_NONE           = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_ACPA_SET            = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_NONE           = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_ACPC_SET            = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_AEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_ASWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_NONE           = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_BCPB_SET            = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_NONE           = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_BCPC_SET            = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_NONE          = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_BEEVT_SET           = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_NONE         = 0x0        // None
	TC_CMR1_WAVEFORM_MODE_BSWTRG_SET          = 0x1        // Set
	TC_CMR1_WAVEFORM_MODE_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR1_WAVEFORM_MODE_BSWTRG_TOGGLE       = 0x3        // Toggle

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	TC_SMMR1_GCEN_Pos = 0x0 // Position of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1 // Bit mask of GCEN field.
	TC_SMMR1_GCEN     = 0x1 // Bit GCEN.
	TC_SMMR1_DOWN_Pos = 0x1 // Position of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2 // Bit mask of DOWN field.
	TC_SMMR1_DOWN     = 0x2 // Bit DOWN.

	// CV1: Counter Value (channel = 1)
	TC_CV1_CV_Pos = 0x0        // Position of CV field.
	TC_CV1_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA1: Register A (channel = 1)
	TC_RA1_RA_Pos = 0x0        // Position of RA field.
	TC_RA1_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB1: Register B (channel = 1)
	TC_RB1_RB_Pos = 0x0        // Position of RB field.
	TC_RB1_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC1: Register C (channel = 1)
	TC_RC1_RC_Pos = 0x0        // Position of RC field.
	TC_RC1_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR1: Status Register (channel = 1)
	TC_SR1_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR1_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR1_COVFS      = 0x1     // Bit COVFS.
	TC_SR1_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR1_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR1_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR1_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR1_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR1_CPAS       = 0x4     // Bit CPAS.
	TC_SR1_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR1_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR1_CPBS       = 0x8     // Bit CPBS.
	TC_SR1_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR1_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR1_CPCS       = 0x10    // Bit CPCS.
	TC_SR1_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR1_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR1_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR1_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR1_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR1_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR1_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR1_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR1_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR1_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR1_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR1_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR1_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR1_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR1_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR1_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR1_MTIOB      = 0x40000 // Bit MTIOB.

	// IER1: Interrupt Enable Register (channel = 1)
	TC_IER1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER1_COVFS     = 0x1  // Bit COVFS.
	TC_IER1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER1_CPAS      = 0x4  // Bit CPAS.
	TC_IER1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER1_CPBS      = 0x8  // Bit CPBS.
	TC_IER1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER1_CPCS      = 0x10 // Bit CPCS.
	TC_IER1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER1_ETRGS     = 0x80 // Bit ETRGS.

	// IDR1: Interrupt Disable Register (channel = 1)
	TC_IDR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR1_COVFS     = 0x1  // Bit COVFS.
	TC_IDR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR1_CPAS      = 0x4  // Bit CPAS.
	TC_IDR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR1_CPBS      = 0x8  // Bit CPBS.
	TC_IDR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR1_CPCS      = 0x10 // Bit CPCS.
	TC_IDR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR1_ETRGS     = 0x80 // Bit ETRGS.

	// IMR1: Interrupt Mask Register (channel = 1)
	TC_IMR1_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR1_COVFS     = 0x1  // Bit COVFS.
	TC_IMR1_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR1_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR1_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR1_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR1_CPAS      = 0x4  // Bit CPAS.
	TC_IMR1_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR1_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR1_CPBS      = 0x8  // Bit CPBS.
	TC_IMR1_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR1_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR1_CPCS      = 0x10 // Bit CPCS.
	TC_IMR1_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR1_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR1_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR1_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR1_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR1_ETRGS     = 0x80 // Bit ETRGS.

	// CCR2: Channel Control Register (channel = 2)
	TC_CCR2_CLKEN_Pos  = 0x0 // Position of CLKEN field.
	TC_CCR2_CLKEN_Msk  = 0x1 // Bit mask of CLKEN field.
	TC_CCR2_CLKEN      = 0x1 // Bit CLKEN.
	TC_CCR2_CLKDIS_Pos = 0x1 // Position of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2 // Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS     = 0x2 // Bit CLKDIS.
	TC_CCR2_SWTRG_Pos  = 0x2 // Position of SWTRG field.
	TC_CCR2_SWTRG_Msk  = 0x4 // Bit mask of SWTRG field.
	TC_CCR2_SWTRG      = 0x4 // Bit SWTRG.

	// CMR2: Channel Mode Register (channel = 2)
	TC_CMR2_TCCLKS_Pos          = 0x0     // Position of TCCLKS field.
	TC_CMR2_TCCLKS_Msk          = 0x7     // Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0     // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1     // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2     // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3     // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4     // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_TCCLKS_XC0          = 0x5     // Clock selected: XC0
	TC_CMR2_TCCLKS_XC1          = 0x6     // Clock selected: XC1
	TC_CMR2_TCCLKS_XC2          = 0x7     // Clock selected: XC2
	TC_CMR2_CLKI_Pos            = 0x3     // Position of CLKI field.
	TC_CMR2_CLKI_Msk            = 0x8     // Bit mask of CLKI field.
	TC_CMR2_CLKI                = 0x8     // Bit CLKI.
	TC_CMR2_BURST_Pos           = 0x4     // Position of BURST field.
	TC_CMR2_BURST_Msk           = 0x30    // Bit mask of BURST field.
	TC_CMR2_BURST_NONE          = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_BURST_XC0           = 0x1     // XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1           = 0x2     // XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2           = 0x3     // XC2 is ANDed with the selected clock.
	TC_CMR2_LDBSTOP_Pos         = 0x6     // Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk         = 0x40    // Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP             = 0x40    // Bit LDBSTOP.
	TC_CMR2_LDBDIS_Pos          = 0x7     // Position of LDBDIS field.
	TC_CMR2_LDBDIS_Msk          = 0x80    // Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS              = 0x80    // Bit LDBDIS.
	TC_CMR2_ETRGEDG_Pos         = 0x8     // Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk         = 0x300   // Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_NONE        = 0x0     // The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_RISING      = 0x1     // Rising edge
	TC_CMR2_ETRGEDG_FALLING     = 0x2     // Falling edge
	TC_CMR2_ETRGEDG_EDGE        = 0x3     // Each edge
	TC_CMR2_ABETRG_Pos          = 0xa     // Position of ABETRG field.
	TC_CMR2_ABETRG_Msk          = 0x400   // Bit mask of ABETRG field.
	TC_CMR2_ABETRG              = 0x400   // Bit ABETRG.
	TC_CMR2_CPCTRG_Pos          = 0xe     // Position of CPCTRG field.
	TC_CMR2_CPCTRG_Msk          = 0x4000  // Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG              = 0x4000  // Bit CPCTRG.
	TC_CMR2_WAVE_Pos            = 0xf     // Position of WAVE field.
	TC_CMR2_WAVE_Msk            = 0x8000  // Bit mask of WAVE field.
	TC_CMR2_WAVE                = 0x8000  // Bit WAVE.
	TC_CMR2_LDRA_Pos            = 0x10    // Position of LDRA field.
	TC_CMR2_LDRA_Msk            = 0x30000 // Bit mask of LDRA field.
	TC_CMR2_LDRA_NONE           = 0x0     // None
	TC_CMR2_LDRA_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRA_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRA_EDGE           = 0x3     // Each edge of TIOA
	TC_CMR2_LDRB_Pos            = 0x12    // Position of LDRB field.
	TC_CMR2_LDRB_Msk            = 0xc0000 // Bit mask of LDRB field.
	TC_CMR2_LDRB_NONE           = 0x0     // None
	TC_CMR2_LDRB_RISING         = 0x1     // Rising edge of TIOA
	TC_CMR2_LDRB_FALLING        = 0x2     // Falling edge of TIOA
	TC_CMR2_LDRB_EDGE           = 0x3     // Each edge of TIOA

	// CMR2_WAVEFORM_MODE: Channel Mode Register (channel = 2)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Pos          = 0x0        // Position of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Msk          = 0x7        // Bit mask of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0        // Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1        // Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2        // Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3        // Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4        // Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC0          = 0x5        // Clock selected: XC0
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC1          = 0x6        // Clock selected: XC1
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC2          = 0x7        // Clock selected: XC2
	TC_CMR2_WAVEFORM_MODE_CLKI_Pos            = 0x3        // Position of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI_Msk            = 0x8        // Bit mask of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI                = 0x8        // Bit CLKI.
	TC_CMR2_WAVEFORM_MODE_BURST_Pos           = 0x4        // Position of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_Msk           = 0x30       // Bit mask of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_NONE          = 0x0        // The clock is not gated by an external signal.
	TC_CMR2_WAVEFORM_MODE_BURST_XC0           = 0x1        // XC0 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC1           = 0x2        // XC1 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC2           = 0x3        // XC2 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Pos         = 0x6        // Position of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Msk         = 0x40       // Bit mask of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP             = 0x40       // Bit CPCSTOP.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Pos          = 0x7        // Position of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Msk          = 0x80       // Bit mask of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS              = 0x80       // Bit CPCDIS.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Pos         = 0x8        // Position of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Msk         = 0x300      // Bit mask of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_NONE        = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_RISING      = 0x1        // Rising edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_FALLING     = 0x2        // Falling edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_EDGE        = 0x3        // Each edge
	TC_CMR2_WAVEFORM_MODE_EEVT_Pos            = 0xa        // Position of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_Msk            = 0xc00      // Bit mask of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_TIOB           = 0x0        // TIOB
	TC_CMR2_WAVEFORM_MODE_EEVT_XC0            = 0x1        // XC0
	TC_CMR2_WAVEFORM_MODE_EEVT_XC1            = 0x2        // XC1
	TC_CMR2_WAVEFORM_MODE_EEVT_XC2            = 0x3        // XC2
	TC_CMR2_WAVEFORM_MODE_ENETRG_Pos          = 0xc        // Position of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG_Msk          = 0x1000     // Bit mask of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG              = 0x1000     // Bit ENETRG.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Pos          = 0xd        // Position of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Msk          = 0x6000     // Bit mask of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP           = 0x0        // UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN       = 0x1        // UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP_RC        = 0x2        // UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN_RC    = 0x3        // UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVE_Pos            = 0xf        // Position of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE_Msk            = 0x8000     // Bit mask of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE                = 0x8000     // Bit WAVE.
	TC_CMR2_WAVEFORM_MODE_ACPA_Pos            = 0x10       // Position of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_Msk            = 0x30000    // Bit mask of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_NONE           = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_ACPA_SET            = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_ACPA_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_ACPA_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_ACPC_Pos            = 0x12       // Position of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_Msk            = 0xc0000    // Bit mask of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_NONE           = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_ACPC_SET            = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_ACPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_ACPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_AEEVT_Pos           = 0x14       // Position of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_Msk           = 0x300000   // Bit mask of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_AEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_AEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_AEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Pos          = 0x16       // Position of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Msk          = 0xc00000   // Bit mask of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_ASWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_ASWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_ASWTRG_TOGGLE       = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_BCPB_Pos            = 0x18       // Position of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_Msk            = 0x3000000  // Bit mask of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_NONE           = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_BCPB_SET            = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_BCPB_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_BCPB_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_BCPC_Pos            = 0x1a       // Position of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_Msk            = 0xc000000  // Bit mask of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_NONE           = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_BCPC_SET            = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_BCPC_CLEAR          = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_BCPC_TOGGLE         = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_BEEVT_Pos           = 0x1c       // Position of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_Msk           = 0x30000000 // Bit mask of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_NONE          = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_BEEVT_SET           = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_BEEVT_CLEAR         = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_BEEVT_TOGGLE        = 0x3        // Toggle
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Pos          = 0x1e       // Position of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Msk          = 0xc0000000 // Bit mask of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_NONE         = 0x0        // None
	TC_CMR2_WAVEFORM_MODE_BSWTRG_SET          = 0x1        // Set
	TC_CMR2_WAVEFORM_MODE_BSWTRG_CLEAR        = 0x2        // Clear
	TC_CMR2_WAVEFORM_MODE_BSWTRG_TOGGLE       = 0x3        // Toggle

	// SMMR2: Stepper Motor Mode Register (channel = 2)
	TC_SMMR2_GCEN_Pos = 0x0 // Position of GCEN field.
	TC_SMMR2_GCEN_Msk = 0x1 // Bit mask of GCEN field.
	TC_SMMR2_GCEN     = 0x1 // Bit GCEN.
	TC_SMMR2_DOWN_Pos = 0x1 // Position of DOWN field.
	TC_SMMR2_DOWN_Msk = 0x2 // Bit mask of DOWN field.
	TC_SMMR2_DOWN     = 0x2 // Bit DOWN.

	// CV2: Counter Value (channel = 2)
	TC_CV2_CV_Pos = 0x0        // Position of CV field.
	TC_CV2_CV_Msk = 0xffffffff // Bit mask of CV field.

	// RA2: Register A (channel = 2)
	TC_RA2_RA_Pos = 0x0        // Position of RA field.
	TC_RA2_RA_Msk = 0xffffffff // Bit mask of RA field.

	// RB2: Register B (channel = 2)
	TC_RB2_RB_Pos = 0x0        // Position of RB field.
	TC_RB2_RB_Msk = 0xffffffff // Bit mask of RB field.

	// RC2: Register C (channel = 2)
	TC_RC2_RC_Pos = 0x0        // Position of RC field.
	TC_RC2_RC_Msk = 0xffffffff // Bit mask of RC field.

	// SR2: Status Register (channel = 2)
	TC_SR2_COVFS_Pos  = 0x0     // Position of COVFS field.
	TC_SR2_COVFS_Msk  = 0x1     // Bit mask of COVFS field.
	TC_SR2_COVFS      = 0x1     // Bit COVFS.
	TC_SR2_LOVRS_Pos  = 0x1     // Position of LOVRS field.
	TC_SR2_LOVRS_Msk  = 0x2     // Bit mask of LOVRS field.
	TC_SR2_LOVRS      = 0x2     // Bit LOVRS.
	TC_SR2_CPAS_Pos   = 0x2     // Position of CPAS field.
	TC_SR2_CPAS_Msk   = 0x4     // Bit mask of CPAS field.
	TC_SR2_CPAS       = 0x4     // Bit CPAS.
	TC_SR2_CPBS_Pos   = 0x3     // Position of CPBS field.
	TC_SR2_CPBS_Msk   = 0x8     // Bit mask of CPBS field.
	TC_SR2_CPBS       = 0x8     // Bit CPBS.
	TC_SR2_CPCS_Pos   = 0x4     // Position of CPCS field.
	TC_SR2_CPCS_Msk   = 0x10    // Bit mask of CPCS field.
	TC_SR2_CPCS       = 0x10    // Bit CPCS.
	TC_SR2_LDRAS_Pos  = 0x5     // Position of LDRAS field.
	TC_SR2_LDRAS_Msk  = 0x20    // Bit mask of LDRAS field.
	TC_SR2_LDRAS      = 0x20    // Bit LDRAS.
	TC_SR2_LDRBS_Pos  = 0x6     // Position of LDRBS field.
	TC_SR2_LDRBS_Msk  = 0x40    // Bit mask of LDRBS field.
	TC_SR2_LDRBS      = 0x40    // Bit LDRBS.
	TC_SR2_ETRGS_Pos  = 0x7     // Position of ETRGS field.
	TC_SR2_ETRGS_Msk  = 0x80    // Bit mask of ETRGS field.
	TC_SR2_ETRGS      = 0x80    // Bit ETRGS.
	TC_SR2_CLKSTA_Pos = 0x10    // Position of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000 // Bit mask of CLKSTA field.
	TC_SR2_CLKSTA     = 0x10000 // Bit CLKSTA.
	TC_SR2_MTIOA_Pos  = 0x11    // Position of MTIOA field.
	TC_SR2_MTIOA_Msk  = 0x20000 // Bit mask of MTIOA field.
	TC_SR2_MTIOA      = 0x20000 // Bit MTIOA.
	TC_SR2_MTIOB_Pos  = 0x12    // Position of MTIOB field.
	TC_SR2_MTIOB_Msk  = 0x40000 // Bit mask of MTIOB field.
	TC_SR2_MTIOB      = 0x40000 // Bit MTIOB.

	// IER2: Interrupt Enable Register (channel = 2)
	TC_IER2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IER2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IER2_COVFS     = 0x1  // Bit COVFS.
	TC_IER2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IER2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IER2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IER2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IER2_CPAS      = 0x4  // Bit CPAS.
	TC_IER2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IER2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IER2_CPBS      = 0x8  // Bit CPBS.
	TC_IER2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IER2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IER2_CPCS      = 0x10 // Bit CPCS.
	TC_IER2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IER2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IER2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IER2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IER2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IER2_ETRGS     = 0x80 // Bit ETRGS.

	// IDR2: Interrupt Disable Register (channel = 2)
	TC_IDR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IDR2_COVFS     = 0x1  // Bit COVFS.
	TC_IDR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IDR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IDR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IDR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IDR2_CPAS      = 0x4  // Bit CPAS.
	TC_IDR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IDR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IDR2_CPBS      = 0x8  // Bit CPBS.
	TC_IDR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IDR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IDR2_CPCS      = 0x10 // Bit CPCS.
	TC_IDR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IDR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IDR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IDR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IDR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IDR2_ETRGS     = 0x80 // Bit ETRGS.

	// IMR2: Interrupt Mask Register (channel = 2)
	TC_IMR2_COVFS_Pos = 0x0  // Position of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1  // Bit mask of COVFS field.
	TC_IMR2_COVFS     = 0x1  // Bit COVFS.
	TC_IMR2_LOVRS_Pos = 0x1  // Position of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2  // Bit mask of LOVRS field.
	TC_IMR2_LOVRS     = 0x2  // Bit LOVRS.
	TC_IMR2_CPAS_Pos  = 0x2  // Position of CPAS field.
	TC_IMR2_CPAS_Msk  = 0x4  // Bit mask of CPAS field.
	TC_IMR2_CPAS      = 0x4  // Bit CPAS.
	TC_IMR2_CPBS_Pos  = 0x3  // Position of CPBS field.
	TC_IMR2_CPBS_Msk  = 0x8  // Bit mask of CPBS field.
	TC_IMR2_CPBS      = 0x8  // Bit CPBS.
	TC_IMR2_CPCS_Pos  = 0x4  // Position of CPCS field.
	TC_IMR2_CPCS_Msk  = 0x10 // Bit mask of CPCS field.
	TC_IMR2_CPCS      = 0x10 // Bit CPCS.
	TC_IMR2_LDRAS_Pos = 0x5  // Position of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20 // Bit mask of LDRAS field.
	TC_IMR2_LDRAS     = 0x20 // Bit LDRAS.
	TC_IMR2_LDRBS_Pos = 0x6  // Position of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40 // Bit mask of LDRBS field.
	TC_IMR2_LDRBS     = 0x40 // Bit LDRBS.
	TC_IMR2_ETRGS_Pos = 0x7  // Position of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80 // Bit mask of ETRGS field.
	TC_IMR2_ETRGS     = 0x80 // Bit ETRGS.

	// BCR: Block Control Register
	TC_BCR_SYNC_Pos = 0x0 // Position of SYNC field.
	TC_BCR_SYNC_Msk = 0x1 // Bit mask of SYNC field.
	TC_BCR_SYNC     = 0x1 // Bit SYNC.

	// BMR: Block Mode Register
	TC_BMR_TC0XC0S_Pos   = 0x0       // Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk   = 0x3       // Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_TCLK0 = 0x0       // Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TIOA1 = 0x2       // Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA2 = 0x3       // Signal connected to XC0: TIOA2
	TC_BMR_TC1XC1S_Pos   = 0x2       // Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk   = 0xc       // Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_TCLK1 = 0x0       // Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TIOA0 = 0x2       // Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA2 = 0x3       // Signal connected to XC1: TIOA2
	TC_BMR_TC2XC2S_Pos   = 0x4       // Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk   = 0x30      // Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_TCLK2 = 0x0       // Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TIOA0 = 0x2       // Signal connected to XC2: TIOA0
	TC_BMR_TC2XC2S_TIOA1 = 0x3       // Signal connected to XC2: TIOA1
	TC_BMR_QDEN_Pos      = 0x8       // Position of QDEN field.
	TC_BMR_QDEN_Msk      = 0x100     // Bit mask of QDEN field.
	TC_BMR_QDEN          = 0x100     // Bit QDEN.
	TC_BMR_POSEN_Pos     = 0x9       // Position of POSEN field.
	TC_BMR_POSEN_Msk     = 0x200     // Bit mask of POSEN field.
	TC_BMR_POSEN         = 0x200     // Bit POSEN.
	TC_BMR_SPEEDEN_Pos   = 0xa       // Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk   = 0x400     // Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN       = 0x400     // Bit SPEEDEN.
	TC_BMR_QDTRANS_Pos   = 0xb       // Position of QDTRANS field.
	TC_BMR_QDTRANS_Msk   = 0x800     // Bit mask of QDTRANS field.
	TC_BMR_QDTRANS       = 0x800     // Bit QDTRANS.
	TC_BMR_EDGPHA_Pos    = 0xc       // Position of EDGPHA field.
	TC_BMR_EDGPHA_Msk    = 0x1000    // Bit mask of EDGPHA field.
	TC_BMR_EDGPHA        = 0x1000    // Bit EDGPHA.
	TC_BMR_INVA_Pos      = 0xd       // Position of INVA field.
	TC_BMR_INVA_Msk      = 0x2000    // Bit mask of INVA field.
	TC_BMR_INVA          = 0x2000    // Bit INVA.
	TC_BMR_INVB_Pos      = 0xe       // Position of INVB field.
	TC_BMR_INVB_Msk      = 0x4000    // Bit mask of INVB field.
	TC_BMR_INVB          = 0x4000    // Bit INVB.
	TC_BMR_INVIDX_Pos    = 0xf       // Position of INVIDX field.
	TC_BMR_INVIDX_Msk    = 0x8000    // Bit mask of INVIDX field.
	TC_BMR_INVIDX        = 0x8000    // Bit INVIDX.
	TC_BMR_SWAP_Pos      = 0x10      // Position of SWAP field.
	TC_BMR_SWAP_Msk      = 0x10000   // Bit mask of SWAP field.
	TC_BMR_SWAP          = 0x10000   // Bit SWAP.
	TC_BMR_IDXPHB_Pos    = 0x11      // Position of IDXPHB field.
	TC_BMR_IDXPHB_Msk    = 0x20000   // Bit mask of IDXPHB field.
	TC_BMR_IDXPHB        = 0x20000   // Bit IDXPHB.
	TC_BMR_MAXFILT_Pos   = 0x14      // Position of MAXFILT field.
	TC_BMR_MAXFILT_Msk   = 0x3f00000 // Bit mask of MAXFILT field.

	// QIER: QDEC Interrupt Enable Register
	TC_QIER_IDX_Pos    = 0x0 // Position of IDX field.
	TC_QIER_IDX_Msk    = 0x1 // Bit mask of IDX field.
	TC_QIER_IDX        = 0x1 // Bit IDX.
	TC_QIER_DIRCHG_Pos = 0x1 // Position of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2 // Bit mask of DIRCHG field.
	TC_QIER_DIRCHG     = 0x2 // Bit DIRCHG.
	TC_QIER_QERR_Pos   = 0x2 // Position of QERR field.
	TC_QIER_QERR_Msk   = 0x4 // Bit mask of QERR field.
	TC_QIER_QERR       = 0x4 // Bit QERR.

	// QIDR: QDEC Interrupt Disable Register
	TC_QIDR_IDX_Pos    = 0x0 // Position of IDX field.
	TC_QIDR_IDX_Msk    = 0x1 // Bit mask of IDX field.
	TC_QIDR_IDX        = 0x1 // Bit IDX.
	TC_QIDR_DIRCHG_Pos = 0x1 // Position of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2 // Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG     = 0x2 // Bit DIRCHG.
	TC_QIDR_QERR_Pos   = 0x2 // Position of QERR field.
	TC_QIDR_QERR_Msk   = 0x4 // Bit mask of QERR field.
	TC_QIDR_QERR       = 0x4 // Bit QERR.

	// QIMR: QDEC Interrupt Mask Register
	TC_QIMR_IDX_Pos    = 0x0 // Position of IDX field.
	TC_QIMR_IDX_Msk    = 0x1 // Bit mask of IDX field.
	TC_QIMR_IDX        = 0x1 // Bit IDX.
	TC_QIMR_DIRCHG_Pos = 0x1 // Position of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2 // Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG     = 0x2 // Bit DIRCHG.
	TC_QIMR_QERR_Pos   = 0x2 // Position of QERR field.
	TC_QIMR_QERR_Msk   = 0x4 // Bit mask of QERR field.
	TC_QIMR_QERR       = 0x4 // Bit QERR.

	// QISR: QDEC Interrupt Status Register
	TC_QISR_IDX_Pos    = 0x0   // Position of IDX field.
	TC_QISR_IDX_Msk    = 0x1   // Bit mask of IDX field.
	TC_QISR_IDX        = 0x1   // Bit IDX.
	TC_QISR_DIRCHG_Pos = 0x1   // Position of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2   // Bit mask of DIRCHG field.
	TC_QISR_DIRCHG     = 0x2   // Bit DIRCHG.
	TC_QISR_QERR_Pos   = 0x2   // Position of QERR field.
	TC_QISR_QERR_Msk   = 0x4   // Bit mask of QERR field.
	TC_QISR_QERR       = 0x4   // Bit QERR.
	TC_QISR_DIR_Pos    = 0x8   // Position of DIR field.
	TC_QISR_DIR_Msk    = 0x100 // Bit mask of DIR field.
	TC_QISR_DIR        = 0x100 // Bit DIR.

	// WPMR: Write Protection Mode Register
	TC_WPMR_WPEN_Pos     = 0x0        // Position of WPEN field.
	TC_WPMR_WPEN_Msk     = 0x1        // Bit mask of WPEN field.
	TC_WPMR_WPEN         = 0x1        // Bit WPEN.
	TC_WPMR_WPKEY_Pos    = 0x8        // Position of WPKEY field.
	TC_WPMR_WPKEY_Msk    = 0xffffff00 // Bit mask of WPKEY field.
	TC_WPMR_WPKEY_PASSWD = 0x54494d   // Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
)

// Bitfields for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	TWI_CR_START_Pos = 0x0  // Position of START field.
	TWI_CR_START_Msk = 0x1  // Bit mask of START field.
	TWI_CR_START     = 0x1  // Bit START.
	TWI_CR_STOP_Pos  = 0x1  // Position of STOP field.
	TWI_CR_STOP_Msk  = 0x2  // Bit mask of STOP field.
	TWI_CR_STOP      = 0x2  // Bit STOP.
	TWI_CR_MSEN_Pos  = 0x2  // Position of MSEN field.
	TWI_CR_MSEN_Msk  = 0x4  // Bit mask of MSEN field.
	TWI_CR_MSEN      = 0x4  // Bit MSEN.
	TWI_CR_MSDIS_Pos = 0x3  // Position of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8  // Bit mask of MSDIS field.
	TWI_CR_MSDIS     = 0x8  // Bit MSDIS.
	TWI_CR_SVEN_Pos  = 0x4  // Position of SVEN field.
	TWI_CR_SVEN_Msk  = 0x10 // Bit mask of SVEN field.
	TWI_CR_SVEN      = 0x10 // Bit SVEN.
	TWI_CR_SVDIS_Pos = 0x5  // Position of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20 // Bit mask of SVDIS field.
	TWI_CR_SVDIS     = 0x20 // Bit SVDIS.
	TWI_CR_QUICK_Pos = 0x6  // Position of QUICK field.
	TWI_CR_QUICK_Msk = 0x40 // Bit mask of QUICK field.
	TWI_CR_QUICK     = 0x40 // Bit QUICK.
	TWI_CR_SWRST_Pos = 0x7  // Position of SWRST field.
	TWI_CR_SWRST_Msk = 0x80 // Bit mask of SWRST field.
	TWI_CR_SWRST     = 0x80 // Bit SWRST.

	// MMR: Master Mode Register
	TWI_MMR_IADRSZ_Pos    = 0x8      // Position of IADRSZ field.
	TWI_MMR_IADRSZ_Msk    = 0x300    // Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_NONE   = 0x0      // No internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1      // One-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2      // Two-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3      // Three-byte internal device address
	TWI_MMR_MREAD_Pos     = 0xc      // Position of MREAD field.
	TWI_MMR_MREAD_Msk     = 0x1000   // Bit mask of MREAD field.
	TWI_MMR_MREAD         = 0x1000   // Bit MREAD.
	TWI_MMR_DADR_Pos      = 0x10     // Position of DADR field.
	TWI_MMR_DADR_Msk      = 0x7f0000 // Bit mask of DADR field.

	// SMR: Slave Mode Register
	TWI_SMR_SADR_Pos = 0x10     // Position of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000 // Bit mask of SADR field.

	// IADR: Internal Address Register
	TWI_IADR_IADR_Pos = 0x0      // Position of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff // Bit mask of IADR field.

	// CWGR: Clock Waveform Generator Register
	TWI_CWGR_CLDIV_Pos = 0x0     // Position of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff    // Bit mask of CLDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8     // Position of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00  // Bit mask of CHDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10    // Position of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000 // Bit mask of CKDIV field.

	// SR: Status Register
	TWI_SR_TXCOMP_Pos = 0x0    // Position of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1    // Bit mask of TXCOMP field.
	TWI_SR_TXCOMP     = 0x1    // Bit TXCOMP.
	TWI_SR_RXRDY_Pos  = 0x1    // Position of RXRDY field.
	TWI_SR_RXRDY_Msk  = 0x2    // Bit mask of RXRDY field.
	TWI_SR_RXRDY      = 0x2    // Bit RXRDY.
	TWI_SR_TXRDY_Pos  = 0x2    // Position of TXRDY field.
	TWI_SR_TXRDY_Msk  = 0x4    // Bit mask of TXRDY field.
	TWI_SR_TXRDY      = 0x4    // Bit TXRDY.
	TWI_SR_SVREAD_Pos = 0x3    // Position of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8    // Bit mask of SVREAD field.
	TWI_SR_SVREAD     = 0x8    // Bit SVREAD.
	TWI_SR_SVACC_Pos  = 0x4    // Position of SVACC field.
	TWI_SR_SVACC_Msk  = 0x10   // Bit mask of SVACC field.
	TWI_SR_SVACC      = 0x10   // Bit SVACC.
	TWI_SR_GACC_Pos   = 0x5    // Position of GACC field.
	TWI_SR_GACC_Msk   = 0x20   // Bit mask of GACC field.
	TWI_SR_GACC       = 0x20   // Bit GACC.
	TWI_SR_OVRE_Pos   = 0x6    // Position of OVRE field.
	TWI_SR_OVRE_Msk   = 0x40   // Bit mask of OVRE field.
	TWI_SR_OVRE       = 0x40   // Bit OVRE.
	TWI_SR_NACK_Pos   = 0x8    // Position of NACK field.
	TWI_SR_NACK_Msk   = 0x100  // Bit mask of NACK field.
	TWI_SR_NACK       = 0x100  // Bit NACK.
	TWI_SR_ARBLST_Pos = 0x9    // Position of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200  // Bit mask of ARBLST field.
	TWI_SR_ARBLST     = 0x200  // Bit ARBLST.
	TWI_SR_SCLWS_Pos  = 0xa    // Position of SCLWS field.
	TWI_SR_SCLWS_Msk  = 0x400  // Bit mask of SCLWS field.
	TWI_SR_SCLWS      = 0x400  // Bit SCLWS.
	TWI_SR_EOSACC_Pos = 0xb    // Position of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800  // Bit mask of EOSACC field.
	TWI_SR_EOSACC     = 0x800  // Bit EOSACC.
	TWI_SR_ENDRX_Pos  = 0xc    // Position of ENDRX field.
	TWI_SR_ENDRX_Msk  = 0x1000 // Bit mask of ENDRX field.
	TWI_SR_ENDRX      = 0x1000 // Bit ENDRX.
	TWI_SR_ENDTX_Pos  = 0xd    // Position of ENDTX field.
	TWI_SR_ENDTX_Msk  = 0x2000 // Bit mask of ENDTX field.
	TWI_SR_ENDTX      = 0x2000 // Bit ENDTX.
	TWI_SR_RXBUFF_Pos = 0xe    // Position of RXBUFF field.
	TWI_SR_RXBUFF_Msk = 0x4000 // Bit mask of RXBUFF field.
	TWI_SR_RXBUFF     = 0x4000 // Bit RXBUFF.
	TWI_SR_TXBUFE_Pos = 0xf    // Position of TXBUFE field.
	TWI_SR_TXBUFE_Msk = 0x8000 // Bit mask of TXBUFE field.
	TWI_SR_TXBUFE     = 0x8000 // Bit TXBUFE.

	// IER: Interrupt Enable Register
	TWI_IER_TXCOMP_Pos = 0x0    // Position of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1    // Bit mask of TXCOMP field.
	TWI_IER_TXCOMP     = 0x1    // Bit TXCOMP.
	TWI_IER_RXRDY_Pos  = 0x1    // Position of RXRDY field.
	TWI_IER_RXRDY_Msk  = 0x2    // Bit mask of RXRDY field.
	TWI_IER_RXRDY      = 0x2    // Bit RXRDY.
	TWI_IER_TXRDY_Pos  = 0x2    // Position of TXRDY field.
	TWI_IER_TXRDY_Msk  = 0x4    // Bit mask of TXRDY field.
	TWI_IER_TXRDY      = 0x4    // Bit TXRDY.
	TWI_IER_SVACC_Pos  = 0x4    // Position of SVACC field.
	TWI_IER_SVACC_Msk  = 0x10   // Bit mask of SVACC field.
	TWI_IER_SVACC      = 0x10   // Bit SVACC.
	TWI_IER_GACC_Pos   = 0x5    // Position of GACC field.
	TWI_IER_GACC_Msk   = 0x20   // Bit mask of GACC field.
	TWI_IER_GACC       = 0x20   // Bit GACC.
	TWI_IER_OVRE_Pos   = 0x6    // Position of OVRE field.
	TWI_IER_OVRE_Msk   = 0x40   // Bit mask of OVRE field.
	TWI_IER_OVRE       = 0x40   // Bit OVRE.
	TWI_IER_NACK_Pos   = 0x8    // Position of NACK field.
	TWI_IER_NACK_Msk   = 0x100  // Bit mask of NACK field.
	TWI_IER_NACK       = 0x100  // Bit NACK.
	TWI_IER_ARBLST_Pos = 0x9    // Position of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200  // Bit mask of ARBLST field.
	TWI_IER_ARBLST     = 0x200  // Bit ARBLST.
	TWI_IER_SCL_WS_Pos = 0xa    // Position of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400  // Bit mask of SCL_WS field.
	TWI_IER_SCL_WS     = 0x400  // Bit SCL_WS.
	TWI_IER_EOSACC_Pos = 0xb    // Position of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800  // Bit mask of EOSACC field.
	TWI_IER_EOSACC     = 0x800  // Bit EOSACC.
	TWI_IER_ENDRX_Pos  = 0xc    // Position of ENDRX field.
	TWI_IER_ENDRX_Msk  = 0x1000 // Bit mask of ENDRX field.
	TWI_IER_ENDRX      = 0x1000 // Bit ENDRX.
	TWI_IER_ENDTX_Pos  = 0xd    // Position of ENDTX field.
	TWI_IER_ENDTX_Msk  = 0x2000 // Bit mask of ENDTX field.
	TWI_IER_ENDTX      = 0x2000 // Bit ENDTX.
	TWI_IER_RXBUFF_Pos = 0xe    // Position of RXBUFF field.
	TWI_IER_RXBUFF_Msk = 0x4000 // Bit mask of RXBUFF field.
	TWI_IER_RXBUFF     = 0x4000 // Bit RXBUFF.
	TWI_IER_TXBUFE_Pos = 0xf    // Position of TXBUFE field.
	TWI_IER_TXBUFE_Msk = 0x8000 // Bit mask of TXBUFE field.
	TWI_IER_TXBUFE     = 0x8000 // Bit TXBUFE.

	// IDR: Interrupt Disable Register
	TWI_IDR_TXCOMP_Pos = 0x0    // Position of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1    // Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP     = 0x1    // Bit TXCOMP.
	TWI_IDR_RXRDY_Pos  = 0x1    // Position of RXRDY field.
	TWI_IDR_RXRDY_Msk  = 0x2    // Bit mask of RXRDY field.
	TWI_IDR_RXRDY      = 0x2    // Bit RXRDY.
	TWI_IDR_TXRDY_Pos  = 0x2    // Position of TXRDY field.
	TWI_IDR_TXRDY_Msk  = 0x4    // Bit mask of TXRDY field.
	TWI_IDR_TXRDY      = 0x4    // Bit TXRDY.
	TWI_IDR_SVACC_Pos  = 0x4    // Position of SVACC field.
	TWI_IDR_SVACC_Msk  = 0x10   // Bit mask of SVACC field.
	TWI_IDR_SVACC      = 0x10   // Bit SVACC.
	TWI_IDR_GACC_Pos   = 0x5    // Position of GACC field.
	TWI_IDR_GACC_Msk   = 0x20   // Bit mask of GACC field.
	TWI_IDR_GACC       = 0x20   // Bit GACC.
	TWI_IDR_OVRE_Pos   = 0x6    // Position of OVRE field.
	TWI_IDR_OVRE_Msk   = 0x40   // Bit mask of OVRE field.
	TWI_IDR_OVRE       = 0x40   // Bit OVRE.
	TWI_IDR_NACK_Pos   = 0x8    // Position of NACK field.
	TWI_IDR_NACK_Msk   = 0x100  // Bit mask of NACK field.
	TWI_IDR_NACK       = 0x100  // Bit NACK.
	TWI_IDR_ARBLST_Pos = 0x9    // Position of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200  // Bit mask of ARBLST field.
	TWI_IDR_ARBLST     = 0x200  // Bit ARBLST.
	TWI_IDR_SCL_WS_Pos = 0xa    // Position of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400  // Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS     = 0x400  // Bit SCL_WS.
	TWI_IDR_EOSACC_Pos = 0xb    // Position of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800  // Bit mask of EOSACC field.
	TWI_IDR_EOSACC     = 0x800  // Bit EOSACC.
	TWI_IDR_ENDRX_Pos  = 0xc    // Position of ENDRX field.
	TWI_IDR_ENDRX_Msk  = 0x1000 // Bit mask of ENDRX field.
	TWI_IDR_ENDRX      = 0x1000 // Bit ENDRX.
	TWI_IDR_ENDTX_Pos  = 0xd    // Position of ENDTX field.
	TWI_IDR_ENDTX_Msk  = 0x2000 // Bit mask of ENDTX field.
	TWI_IDR_ENDTX      = 0x2000 // Bit ENDTX.
	TWI_IDR_RXBUFF_Pos = 0xe    // Position of RXBUFF field.
	TWI_IDR_RXBUFF_Msk = 0x4000 // Bit mask of RXBUFF field.
	TWI_IDR_RXBUFF     = 0x4000 // Bit RXBUFF.
	TWI_IDR_TXBUFE_Pos = 0xf    // Position of TXBUFE field.
	TWI_IDR_TXBUFE_Msk = 0x8000 // Bit mask of TXBUFE field.
	TWI_IDR_TXBUFE     = 0x8000 // Bit TXBUFE.

	// IMR: Interrupt Mask Register
	TWI_IMR_TXCOMP_Pos = 0x0    // Position of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1    // Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP     = 0x1    // Bit TXCOMP.
	TWI_IMR_RXRDY_Pos  = 0x1    // Position of RXRDY field.
	TWI_IMR_RXRDY_Msk  = 0x2    // Bit mask of RXRDY field.
	TWI_IMR_RXRDY      = 0x2    // Bit RXRDY.
	TWI_IMR_TXRDY_Pos  = 0x2    // Position of TXRDY field.
	TWI_IMR_TXRDY_Msk  = 0x4    // Bit mask of TXRDY field.
	TWI_IMR_TXRDY      = 0x4    // Bit TXRDY.
	TWI_IMR_SVACC_Pos  = 0x4    // Position of SVACC field.
	TWI_IMR_SVACC_Msk  = 0x10   // Bit mask of SVACC field.
	TWI_IMR_SVACC      = 0x10   // Bit SVACC.
	TWI_IMR_GACC_Pos   = 0x5    // Position of GACC field.
	TWI_IMR_GACC_Msk   = 0x20   // Bit mask of GACC field.
	TWI_IMR_GACC       = 0x20   // Bit GACC.
	TWI_IMR_OVRE_Pos   = 0x6    // Position of OVRE field.
	TWI_IMR_OVRE_Msk   = 0x40   // Bit mask of OVRE field.
	TWI_IMR_OVRE       = 0x40   // Bit OVRE.
	TWI_IMR_NACK_Pos   = 0x8    // Position of NACK field.
	TWI_IMR_NACK_Msk   = 0x100  // Bit mask of NACK field.
	TWI_IMR_NACK       = 0x100  // Bit NACK.
	TWI_IMR_ARBLST_Pos = 0x9    // Position of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200  // Bit mask of ARBLST field.
	TWI_IMR_ARBLST     = 0x200  // Bit ARBLST.
	TWI_IMR_SCL_WS_Pos = 0xa    // Position of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400  // Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS     = 0x400  // Bit SCL_WS.
	TWI_IMR_EOSACC_Pos = 0xb    // Position of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800  // Bit mask of EOSACC field.
	TWI_IMR_EOSACC     = 0x800  // Bit EOSACC.
	TWI_IMR_ENDRX_Pos  = 0xc    // Position of ENDRX field.
	TWI_IMR_ENDRX_Msk  = 0x1000 // Bit mask of ENDRX field.
	TWI_IMR_ENDRX      = 0x1000 // Bit ENDRX.
	TWI_IMR_ENDTX_Pos  = 0xd    // Position of ENDTX field.
	TWI_IMR_ENDTX_Msk  = 0x2000 // Bit mask of ENDTX field.
	TWI_IMR_ENDTX      = 0x2000 // Bit ENDTX.
	TWI_IMR_RXBUFF_Pos = 0xe    // Position of RXBUFF field.
	TWI_IMR_RXBUFF_Msk = 0x4000 // Bit mask of RXBUFF field.
	TWI_IMR_RXBUFF     = 0x4000 // Bit RXBUFF.
	TWI_IMR_TXBUFE_Pos = 0xf    // Position of TXBUFE field.
	TWI_IMR_TXBUFE_Msk = 0x8000 // Bit mask of TXBUFE field.
	TWI_IMR_TXBUFE     = 0x8000 // Bit TXBUFE.

	// RHR: Receive Holding Register
	TWI_RHR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// THR: Transmit Holding Register
	TWI_THR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.

	// RPR: Receive Pointer Register
	TWI_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	TWI_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	TWI_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	TWI_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	TWI_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	TWI_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	TWI_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	TWI_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	TWI_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	TWI_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	TWI_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	TWI_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	TWI_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	TWI_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	TWI_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	TWI_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	TWI_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	TWI_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	TWI_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	TWI_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for PWM: Pulse Width Modulation Controller
const (
	// MR: PWM Mode Register
	PWM_MR_DIVA_Pos        = 0x0       // Position of DIVA field.
	PWM_MR_DIVA_Msk        = 0xff      // Bit mask of DIVA field.
	PWM_MR_DIVA_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVA_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREA_Pos        = 0x8       // Position of PREA field.
	PWM_MR_PREA_Msk        = 0xf00     // Bit mask of PREA field.
	PWM_MR_PREA_MCK        = 0x0       // Master Clock
	PWM_MR_PREA_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREA_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREA_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREA_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREA_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREA_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREA_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREA_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREA_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREA_MCKDIV1024 = 0xa       // Master Clock divided by 1024
	PWM_MR_DIVB_Pos        = 0x10      // Position of DIVB field.
	PWM_MR_DIVB_Msk        = 0xff0000  // Bit mask of DIVB field.
	PWM_MR_DIVB_CLK_OFF    = 0x0       // CLKA, CLKB clock is turned off
	PWM_MR_DIVB_CLK_DIV1   = 0x1       // CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_PREB_Pos        = 0x18      // Position of PREB field.
	PWM_MR_PREB_Msk        = 0xf000000 // Bit mask of PREB field.
	PWM_MR_PREB_MCK        = 0x0       // Master Clock
	PWM_MR_PREB_MCKDIV2    = 0x1       // Master Clock divided by 2
	PWM_MR_PREB_MCKDIV4    = 0x2       // Master Clock divided by 4
	PWM_MR_PREB_MCKDIV8    = 0x3       // Master Clock divided by 8
	PWM_MR_PREB_MCKDIV16   = 0x4       // Master Clock divided by 16
	PWM_MR_PREB_MCKDIV32   = 0x5       // Master Clock divided by 32
	PWM_MR_PREB_MCKDIV64   = 0x6       // Master Clock divided by 64
	PWM_MR_PREB_MCKDIV128  = 0x7       // Master Clock divided by 128
	PWM_MR_PREB_MCKDIV256  = 0x8       // Master Clock divided by 256
	PWM_MR_PREB_MCKDIV512  = 0x9       // Master Clock divided by 512
	PWM_MR_PREB_MCKDIV1024 = 0xa       // Master Clock divided by 1024

	// ENA: PWM Enable Register
	PWM_ENA_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ENA_CHID0     = 0x1 // Bit CHID0.
	PWM_ENA_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ENA_CHID1     = 0x2 // Bit CHID1.
	PWM_ENA_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ENA_CHID2     = 0x4 // Bit CHID2.
	PWM_ENA_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ENA_CHID3     = 0x8 // Bit CHID3.

	// DIS: PWM Disable Register
	PWM_DIS_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_DIS_CHID0     = 0x1 // Bit CHID0.
	PWM_DIS_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_DIS_CHID1     = 0x2 // Bit CHID1.
	PWM_DIS_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_DIS_CHID2     = 0x4 // Bit CHID2.
	PWM_DIS_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_DIS_CHID3     = 0x8 // Bit CHID3.

	// SR: PWM Status Register
	PWM_SR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_SR_CHID0     = 0x1 // Bit CHID0.
	PWM_SR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_SR_CHID1     = 0x2 // Bit CHID1.
	PWM_SR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_SR_CHID2     = 0x4 // Bit CHID2.
	PWM_SR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_SR_CHID3     = 0x8 // Bit CHID3.

	// IER: PWM Interrupt Enable Register
	PWM_IER_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IER_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IER_CHID0     = 0x1 // Bit CHID0.
	PWM_IER_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IER_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IER_CHID1     = 0x2 // Bit CHID1.
	PWM_IER_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IER_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IER_CHID2     = 0x4 // Bit CHID2.
	PWM_IER_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IER_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IER_CHID3     = 0x8 // Bit CHID3.

	// IDR: PWM Interrupt Disable Register
	PWM_IDR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IDR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IDR_CHID0     = 0x1 // Bit CHID0.
	PWM_IDR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IDR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IDR_CHID1     = 0x2 // Bit CHID1.
	PWM_IDR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IDR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IDR_CHID2     = 0x4 // Bit CHID2.
	PWM_IDR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IDR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IDR_CHID3     = 0x8 // Bit CHID3.

	// IMR: PWM Interrupt Mask Register
	PWM_IMR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_IMR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_IMR_CHID0     = 0x1 // Bit CHID0.
	PWM_IMR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_IMR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_IMR_CHID1     = 0x2 // Bit CHID1.
	PWM_IMR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_IMR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_IMR_CHID2     = 0x4 // Bit CHID2.
	PWM_IMR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_IMR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_IMR_CHID3     = 0x8 // Bit CHID3.

	// ISR: PWM Interrupt Status Register
	PWM_ISR_CHID0_Pos = 0x0 // Position of CHID0 field.
	PWM_ISR_CHID0_Msk = 0x1 // Bit mask of CHID0 field.
	PWM_ISR_CHID0     = 0x1 // Bit CHID0.
	PWM_ISR_CHID1_Pos = 0x1 // Position of CHID1 field.
	PWM_ISR_CHID1_Msk = 0x2 // Bit mask of CHID1 field.
	PWM_ISR_CHID1     = 0x2 // Bit CHID1.
	PWM_ISR_CHID2_Pos = 0x2 // Position of CHID2 field.
	PWM_ISR_CHID2_Msk = 0x4 // Bit mask of CHID2 field.
	PWM_ISR_CHID2     = 0x4 // Bit CHID2.
	PWM_ISR_CHID3_Pos = 0x3 // Position of CHID3 field.
	PWM_ISR_CHID3_Msk = 0x8 // Bit mask of CHID3 field.
	PWM_ISR_CHID3     = 0x8 // Bit CHID3.

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	PWM_CMR0_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR0_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR0_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR0_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR0_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR0_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR0_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR0_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR0_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR0_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR0_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR0_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR0_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR0_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR0_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR0_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR0_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR0_CALG            = 0x100 // Bit CALG.
	PWM_CMR0_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR0_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR0_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR0_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR0_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR0_CPD             = 0x400 // Bit CPD.

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	PWM_CDTY0_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	PWM_CPRD0_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	PWM_CCNT0_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD0: PWM Channel Update Register (ch_num = 0)
	PWM_CUPD0_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD0_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	PWM_CMR1_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR1_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR1_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR1_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR1_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR1_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR1_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR1_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR1_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR1_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR1_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR1_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR1_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR1_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR1_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR1_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR1_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR1_CALG            = 0x100 // Bit CALG.
	PWM_CMR1_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR1_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR1_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR1_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR1_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR1_CPD             = 0x400 // Bit CPD.

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	PWM_CDTY1_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	PWM_CPRD1_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	PWM_CCNT1_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD1: PWM Channel Update Register (ch_num = 1)
	PWM_CUPD1_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD1_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	PWM_CMR2_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR2_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR2_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR2_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR2_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR2_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR2_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR2_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR2_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR2_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR2_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR2_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR2_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR2_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR2_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR2_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR2_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR2_CALG            = 0x100 // Bit CALG.
	PWM_CMR2_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR2_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR2_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR2_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR2_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR2_CPD             = 0x400 // Bit CPD.

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	PWM_CDTY2_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	PWM_CPRD2_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	PWM_CCNT2_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD2: PWM Channel Update Register (ch_num = 2)
	PWM_CUPD2_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD2_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	PWM_CMR3_CPRE_Pos        = 0x0   // Position of CPRE field.
	PWM_CMR3_CPRE_Msk        = 0xf   // Bit mask of CPRE field.
	PWM_CMR3_CPRE_MCK        = 0x0   // Master Clock
	PWM_CMR3_CPRE_MCKDIV2    = 0x1   // Master Clock divided by 2
	PWM_CMR3_CPRE_MCKDIV4    = 0x2   // Master Clock divided by 4
	PWM_CMR3_CPRE_MCKDIV8    = 0x3   // Master Clock divided by 8
	PWM_CMR3_CPRE_MCKDIV16   = 0x4   // Master Clock divided by 16
	PWM_CMR3_CPRE_MCKDIV32   = 0x5   // Master Clock divided by 32
	PWM_CMR3_CPRE_MCKDIV64   = 0x6   // Master Clock divided by 64
	PWM_CMR3_CPRE_MCKDIV128  = 0x7   // Master Clock divided by 128
	PWM_CMR3_CPRE_MCKDIV256  = 0x8   // Master Clock divided by 256
	PWM_CMR3_CPRE_MCKDIV512  = 0x9   // Master Clock divided by 512
	PWM_CMR3_CPRE_MCKDIV1024 = 0xa   // Master Clock divided by 1024
	PWM_CMR3_CPRE_CLKA       = 0xb   // Clock A
	PWM_CMR3_CPRE_CLKB       = 0xc   // Clock B
	PWM_CMR3_CALG_Pos        = 0x8   // Position of CALG field.
	PWM_CMR3_CALG_Msk        = 0x100 // Bit mask of CALG field.
	PWM_CMR3_CALG            = 0x100 // Bit CALG.
	PWM_CMR3_CPOL_Pos        = 0x9   // Position of CPOL field.
	PWM_CMR3_CPOL_Msk        = 0x200 // Bit mask of CPOL field.
	PWM_CMR3_CPOL            = 0x200 // Bit CPOL.
	PWM_CMR3_CPD_Pos         = 0xa   // Position of CPD field.
	PWM_CMR3_CPD_Msk         = 0x400 // Bit mask of CPD field.
	PWM_CMR3_CPD             = 0x400 // Bit CPD.

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	PWM_CDTY3_CDTY_Pos = 0x0        // Position of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffffff // Bit mask of CDTY field.

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	PWM_CPRD3_CPRD_Pos = 0x0        // Position of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffffff // Bit mask of CPRD field.

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	PWM_CCNT3_CNT_Pos = 0x0        // Position of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffffff // Bit mask of CNT field.

	// CUPD3: PWM Channel Update Register (ch_num = 3)
	PWM_CUPD3_CUPD_Pos = 0x0        // Position of CUPD field.
	PWM_CUPD3_CUPD_Msk = 0xffffffff // Bit mask of CUPD field.
)

// Bitfields for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	USART_CR_RSTRX_Pos   = 0x2     // Position of RSTRX field.
	USART_CR_RSTRX_Msk   = 0x4     // Bit mask of RSTRX field.
	USART_CR_RSTRX       = 0x4     // Bit RSTRX.
	USART_CR_RSTTX_Pos   = 0x3     // Position of RSTTX field.
	USART_CR_RSTTX_Msk   = 0x8     // Bit mask of RSTTX field.
	USART_CR_RSTTX       = 0x8     // Bit RSTTX.
	USART_CR_RXEN_Pos    = 0x4     // Position of RXEN field.
	USART_CR_RXEN_Msk    = 0x10    // Bit mask of RXEN field.
	USART_CR_RXEN        = 0x10    // Bit RXEN.
	USART_CR_RXDIS_Pos   = 0x5     // Position of RXDIS field.
	USART_CR_RXDIS_Msk   = 0x20    // Bit mask of RXDIS field.
	USART_CR_RXDIS       = 0x20    // Bit RXDIS.
	USART_CR_TXEN_Pos    = 0x6     // Position of TXEN field.
	USART_CR_TXEN_Msk    = 0x40    // Bit mask of TXEN field.
	USART_CR_TXEN        = 0x40    // Bit TXEN.
	USART_CR_TXDIS_Pos   = 0x7     // Position of TXDIS field.
	USART_CR_TXDIS_Msk   = 0x80    // Bit mask of TXDIS field.
	USART_CR_TXDIS       = 0x80    // Bit TXDIS.
	USART_CR_RSTSTA_Pos  = 0x8     // Position of RSTSTA field.
	USART_CR_RSTSTA_Msk  = 0x100   // Bit mask of RSTSTA field.
	USART_CR_RSTSTA      = 0x100   // Bit RSTSTA.
	USART_CR_STTBRK_Pos  = 0x9     // Position of STTBRK field.
	USART_CR_STTBRK_Msk  = 0x200   // Bit mask of STTBRK field.
	USART_CR_STTBRK      = 0x200   // Bit STTBRK.
	USART_CR_STPBRK_Pos  = 0xa     // Position of STPBRK field.
	USART_CR_STPBRK_Msk  = 0x400   // Bit mask of STPBRK field.
	USART_CR_STPBRK      = 0x400   // Bit STPBRK.
	USART_CR_STTTO_Pos   = 0xb     // Position of STTTO field.
	USART_CR_STTTO_Msk   = 0x800   // Bit mask of STTTO field.
	USART_CR_STTTO       = 0x800   // Bit STTTO.
	USART_CR_SENDA_Pos   = 0xc     // Position of SENDA field.
	USART_CR_SENDA_Msk   = 0x1000  // Bit mask of SENDA field.
	USART_CR_SENDA       = 0x1000  // Bit SENDA.
	USART_CR_RSTIT_Pos   = 0xd     // Position of RSTIT field.
	USART_CR_RSTIT_Msk   = 0x2000  // Bit mask of RSTIT field.
	USART_CR_RSTIT       = 0x2000  // Bit RSTIT.
	USART_CR_RSTNACK_Pos = 0xe     // Position of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000  // Bit mask of RSTNACK field.
	USART_CR_RSTNACK     = 0x4000  // Bit RSTNACK.
	USART_CR_RETTO_Pos   = 0xf     // Position of RETTO field.
	USART_CR_RETTO_Msk   = 0x8000  // Bit mask of RETTO field.
	USART_CR_RETTO       = 0x8000  // Bit RETTO.
	USART_CR_RTSEN_Pos   = 0x12    // Position of RTSEN field.
	USART_CR_RTSEN_Msk   = 0x40000 // Bit mask of RTSEN field.
	USART_CR_RTSEN       = 0x40000 // Bit RTSEN.
	USART_CR_RTSDIS_Pos  = 0x13    // Position of RTSDIS field.
	USART_CR_RTSDIS_Msk  = 0x80000 // Bit mask of RTSDIS field.
	USART_CR_RTSDIS      = 0x80000 // Bit RTSDIS.

	// CR_SPI_MODE: Control Register
	USART_CR_SPI_MODE_RSTRX_Pos  = 0x2     // Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk  = 0x4     // Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX      = 0x4     // Bit RSTRX.
	USART_CR_SPI_MODE_RSTTX_Pos  = 0x3     // Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk  = 0x8     // Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX      = 0x8     // Bit RSTTX.
	USART_CR_SPI_MODE_RXEN_Pos   = 0x4     // Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk   = 0x10    // Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN       = 0x10    // Bit RXEN.
	USART_CR_SPI_MODE_RXDIS_Pos  = 0x5     // Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk  = 0x20    // Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS      = 0x20    // Bit RXDIS.
	USART_CR_SPI_MODE_TXEN_Pos   = 0x6     // Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk   = 0x40    // Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN       = 0x40    // Bit TXEN.
	USART_CR_SPI_MODE_TXDIS_Pos  = 0x7     // Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk  = 0x80    // Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS      = 0x80    // Bit TXDIS.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8     // Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100   // Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA     = 0x100   // Bit RSTSTA.
	USART_CR_SPI_MODE_FCS_Pos    = 0x12    // Position of FCS field.
	USART_CR_SPI_MODE_FCS_Msk    = 0x40000 // Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS        = 0x40000 // Bit FCS.
	USART_CR_SPI_MODE_RCS_Pos    = 0x13    // Position of RCS field.
	USART_CR_SPI_MODE_RCS_Msk    = 0x80000 // Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS        = 0x80000 // Bit RCS.

	// MR: Mode Register
	USART_MR_USART_MODE_Pos            = 0x0        // Position of USART_MODE field.
	USART_MR_USART_MODE_Msk            = 0xf        // Bit mask of USART_MODE field.
	USART_MR_USART_MODE_NORMAL         = 0x0        // Normal mode
	USART_MR_USART_MODE_RS485          = 0x1        // RS485
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2        // Hardware Handshaking
	USART_MR_USART_MODE_IS07816_T_0    = 0x4        // IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_1    = 0x6        // IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IRDA           = 0x8        // IrDA
	USART_MR_USART_MODE_SPI_MASTER     = 0xe        // SPI Master
	USART_MR_USART_MODE_SPI_SLAVE      = 0xf        // SPI Slave
	USART_MR_USCLKS_Pos                = 0x4        // Position of USCLKS field.
	USART_MR_USCLKS_Msk                = 0x30       // Bit mask of USCLKS field.
	USART_MR_USCLKS_MCK                = 0x0        // Master Clock MCK is selected
	USART_MR_USCLKS_DIV                = 0x1        // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_SCK                = 0x3        // Serial Clock SLK is selected
	USART_MR_CHRL_Pos                  = 0x6        // Position of CHRL field.
	USART_MR_CHRL_Msk                  = 0xc0       // Bit mask of CHRL field.
	USART_MR_CHRL_5_BIT                = 0x0        // Character length is 5 bits
	USART_MR_CHRL_6_BIT                = 0x1        // Character length is 6 bits
	USART_MR_CHRL_7_BIT                = 0x2        // Character length is 7 bits
	USART_MR_CHRL_8_BIT                = 0x3        // Character length is 8 bits
	USART_MR_SYNC_Pos                  = 0x8        // Position of SYNC field.
	USART_MR_SYNC_Msk                  = 0x100      // Bit mask of SYNC field.
	USART_MR_SYNC                      = 0x100      // Bit SYNC.
	USART_MR_PAR_Pos                   = 0x9        // Position of PAR field.
	USART_MR_PAR_Msk                   = 0xe00      // Bit mask of PAR field.
	USART_MR_PAR_EVEN                  = 0x0        // Even parity
	USART_MR_PAR_ODD                   = 0x1        // Odd parity
	USART_MR_PAR_SPACE                 = 0x2        // Parity forced to 0 (Space)
	USART_MR_PAR_MARK                  = 0x3        // Parity forced to 1 (Mark)
	USART_MR_PAR_NO                    = 0x4        // No parity
	USART_MR_PAR_MULTIDROP             = 0x6        // Multidrop mode
	USART_MR_NBSTOP_Pos                = 0xc        // Position of NBSTOP field.
	USART_MR_NBSTOP_Msk                = 0x3000     // Bit mask of NBSTOP field.
	USART_MR_NBSTOP_1_BIT              = 0x0        // 1 stop bit
	USART_MR_NBSTOP_1_5_BIT            = 0x1        // 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_2_BIT              = 0x2        // 2 stop bits
	USART_MR_CHMODE_Pos                = 0xe        // Position of CHMODE field.
	USART_MR_CHMODE_Msk                = 0xc000     // Bit mask of CHMODE field.
	USART_MR_CHMODE_NORMAL             = 0x0        // Normal Mode
	USART_MR_CHMODE_AUTOMATIC          = 0x1        // Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_LOCAL_LOOPBACK     = 0x2        // Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_REMOTE_LOOPBACK    = 0x3        // Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_MSBF_Pos                  = 0x10       // Position of MSBF field.
	USART_MR_MSBF_Msk                  = 0x10000    // Bit mask of MSBF field.
	USART_MR_MSBF                      = 0x10000    // Bit MSBF.
	USART_MR_MODE9_Pos                 = 0x11       // Position of MODE9 field.
	USART_MR_MODE9_Msk                 = 0x20000    // Bit mask of MODE9 field.
	USART_MR_MODE9                     = 0x20000    // Bit MODE9.
	USART_MR_CLKO_Pos                  = 0x12       // Position of CLKO field.
	USART_MR_CLKO_Msk                  = 0x40000    // Bit mask of CLKO field.
	USART_MR_CLKO                      = 0x40000    // Bit CLKO.
	USART_MR_OVER_Pos                  = 0x13       // Position of OVER field.
	USART_MR_OVER_Msk                  = 0x80000    // Bit mask of OVER field.
	USART_MR_OVER                      = 0x80000    // Bit OVER.
	USART_MR_INACK_Pos                 = 0x14       // Position of INACK field.
	USART_MR_INACK_Msk                 = 0x100000   // Bit mask of INACK field.
	USART_MR_INACK                     = 0x100000   // Bit INACK.
	USART_MR_DSNACK_Pos                = 0x15       // Position of DSNACK field.
	USART_MR_DSNACK_Msk                = 0x200000   // Bit mask of DSNACK field.
	USART_MR_DSNACK                    = 0x200000   // Bit DSNACK.
	USART_MR_INVDATA_Pos               = 0x17       // Position of INVDATA field.
	USART_MR_INVDATA_Msk               = 0x800000   // Bit mask of INVDATA field.
	USART_MR_INVDATA                   = 0x800000   // Bit INVDATA.
	USART_MR_MAX_ITERATION_Pos         = 0x18       // Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk         = 0x7000000  // Bit mask of MAX_ITERATION field.
	USART_MR_FILTER_Pos                = 0x1c       // Position of FILTER field.
	USART_MR_FILTER_Msk                = 0x10000000 // Bit mask of FILTER field.
	USART_MR_FILTER                    = 0x10000000 // Bit FILTER.

	// MR_SPI_MODE: Mode Register
	USART_MR_SPI_MODE_USART_MODE_Pos        = 0x0      // Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk        = 0xf      // Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe      // SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE  = 0xf      // SPI Slave
	USART_MR_SPI_MODE_USCLKS_Pos            = 0x4      // Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk            = 0x30     // Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_MCK            = 0x0      // Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_DIV            = 0x1      // Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_SCK            = 0x3      // Serial Clock SLK is selected
	USART_MR_SPI_MODE_CHRL_Pos              = 0x6      // Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk              = 0xc0     // Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_8_BIT            = 0x3      // Character length is 8 bits
	USART_MR_SPI_MODE_CPHA_Pos              = 0x8      // Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk              = 0x100    // Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA                  = 0x100    // Bit CPHA.
	USART_MR_SPI_MODE_CPOL_Pos              = 0x10     // Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk              = 0x10000  // Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL                  = 0x10000  // Bit CPOL.
	USART_MR_SPI_MODE_WRDBT_Pos             = 0x14     // Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk             = 0x100000 // Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT                 = 0x100000 // Bit WRDBT.

	// IER: Interrupt Enable Register
	USART_IER_RXRDY_Pos   = 0x0     // Position of RXRDY field.
	USART_IER_RXRDY_Msk   = 0x1     // Bit mask of RXRDY field.
	USART_IER_RXRDY       = 0x1     // Bit RXRDY.
	USART_IER_TXRDY_Pos   = 0x1     // Position of TXRDY field.
	USART_IER_TXRDY_Msk   = 0x2     // Bit mask of TXRDY field.
	USART_IER_TXRDY       = 0x2     // Bit TXRDY.
	USART_IER_RXBRK_Pos   = 0x2     // Position of RXBRK field.
	USART_IER_RXBRK_Msk   = 0x4     // Bit mask of RXBRK field.
	USART_IER_RXBRK       = 0x4     // Bit RXBRK.
	USART_IER_ENDRX_Pos   = 0x3     // Position of ENDRX field.
	USART_IER_ENDRX_Msk   = 0x8     // Bit mask of ENDRX field.
	USART_IER_ENDRX       = 0x8     // Bit ENDRX.
	USART_IER_ENDTX_Pos   = 0x4     // Position of ENDTX field.
	USART_IER_ENDTX_Msk   = 0x10    // Bit mask of ENDTX field.
	USART_IER_ENDTX       = 0x10    // Bit ENDTX.
	USART_IER_OVRE_Pos    = 0x5     // Position of OVRE field.
	USART_IER_OVRE_Msk    = 0x20    // Bit mask of OVRE field.
	USART_IER_OVRE        = 0x20    // Bit OVRE.
	USART_IER_FRAME_Pos   = 0x6     // Position of FRAME field.
	USART_IER_FRAME_Msk   = 0x40    // Bit mask of FRAME field.
	USART_IER_FRAME       = 0x40    // Bit FRAME.
	USART_IER_PARE_Pos    = 0x7     // Position of PARE field.
	USART_IER_PARE_Msk    = 0x80    // Bit mask of PARE field.
	USART_IER_PARE        = 0x80    // Bit PARE.
	USART_IER_TIMEOUT_Pos = 0x8     // Position of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100   // Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT     = 0x100   // Bit TIMEOUT.
	USART_IER_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY     = 0x200   // Bit TXEMPTY.
	USART_IER_ITER_Pos    = 0xa     // Position of ITER field.
	USART_IER_ITER_Msk    = 0x400   // Bit mask of ITER field.
	USART_IER_ITER        = 0x400   // Bit ITER.
	USART_IER_TXBUFE_Pos  = 0xb     // Position of TXBUFE field.
	USART_IER_TXBUFE_Msk  = 0x800   // Bit mask of TXBUFE field.
	USART_IER_TXBUFE      = 0x800   // Bit TXBUFE.
	USART_IER_RXBUFF_Pos  = 0xc     // Position of RXBUFF field.
	USART_IER_RXBUFF_Msk  = 0x1000  // Bit mask of RXBUFF field.
	USART_IER_RXBUFF      = 0x1000  // Bit RXBUFF.
	USART_IER_NACK_Pos    = 0xd     // Position of NACK field.
	USART_IER_NACK_Msk    = 0x2000  // Bit mask of NACK field.
	USART_IER_NACK        = 0x2000  // Bit NACK.
	USART_IER_CTSIC_Pos   = 0x13    // Position of CTSIC field.
	USART_IER_CTSIC_Msk   = 0x80000 // Bit mask of CTSIC field.
	USART_IER_CTSIC       = 0x80000 // Bit CTSIC.

	// IER_SPI_MODE: Interrupt Enable Register
	USART_IER_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IER_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IER_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IER_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IDR: Interrupt Disable Register
	USART_IDR_RXRDY_Pos   = 0x0     // Position of RXRDY field.
	USART_IDR_RXRDY_Msk   = 0x1     // Bit mask of RXRDY field.
	USART_IDR_RXRDY       = 0x1     // Bit RXRDY.
	USART_IDR_TXRDY_Pos   = 0x1     // Position of TXRDY field.
	USART_IDR_TXRDY_Msk   = 0x2     // Bit mask of TXRDY field.
	USART_IDR_TXRDY       = 0x2     // Bit TXRDY.
	USART_IDR_RXBRK_Pos   = 0x2     // Position of RXBRK field.
	USART_IDR_RXBRK_Msk   = 0x4     // Bit mask of RXBRK field.
	USART_IDR_RXBRK       = 0x4     // Bit RXBRK.
	USART_IDR_ENDRX_Pos   = 0x3     // Position of ENDRX field.
	USART_IDR_ENDRX_Msk   = 0x8     // Bit mask of ENDRX field.
	USART_IDR_ENDRX       = 0x8     // Bit ENDRX.
	USART_IDR_ENDTX_Pos   = 0x4     // Position of ENDTX field.
	USART_IDR_ENDTX_Msk   = 0x10    // Bit mask of ENDTX field.
	USART_IDR_ENDTX       = 0x10    // Bit ENDTX.
	USART_IDR_OVRE_Pos    = 0x5     // Position of OVRE field.
	USART_IDR_OVRE_Msk    = 0x20    // Bit mask of OVRE field.
	USART_IDR_OVRE        = 0x20    // Bit OVRE.
	USART_IDR_FRAME_Pos   = 0x6     // Position of FRAME field.
	USART_IDR_FRAME_Msk   = 0x40    // Bit mask of FRAME field.
	USART_IDR_FRAME       = 0x40    // Bit FRAME.
	USART_IDR_PARE_Pos    = 0x7     // Position of PARE field.
	USART_IDR_PARE_Msk    = 0x80    // Bit mask of PARE field.
	USART_IDR_PARE        = 0x80    // Bit PARE.
	USART_IDR_TIMEOUT_Pos = 0x8     // Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100   // Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT     = 0x100   // Bit TIMEOUT.
	USART_IDR_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY     = 0x200   // Bit TXEMPTY.
	USART_IDR_ITER_Pos    = 0xa     // Position of ITER field.
	USART_IDR_ITER_Msk    = 0x400   // Bit mask of ITER field.
	USART_IDR_ITER        = 0x400   // Bit ITER.
	USART_IDR_TXBUFE_Pos  = 0xb     // Position of TXBUFE field.
	USART_IDR_TXBUFE_Msk  = 0x800   // Bit mask of TXBUFE field.
	USART_IDR_TXBUFE      = 0x800   // Bit TXBUFE.
	USART_IDR_RXBUFF_Pos  = 0xc     // Position of RXBUFF field.
	USART_IDR_RXBUFF_Msk  = 0x1000  // Bit mask of RXBUFF field.
	USART_IDR_RXBUFF      = 0x1000  // Bit RXBUFF.
	USART_IDR_NACK_Pos    = 0xd     // Position of NACK field.
	USART_IDR_NACK_Msk    = 0x2000  // Bit mask of NACK field.
	USART_IDR_NACK        = 0x2000  // Bit NACK.
	USART_IDR_CTSIC_Pos   = 0x13    // Position of CTSIC field.
	USART_IDR_CTSIC_Msk   = 0x80000 // Bit mask of CTSIC field.
	USART_IDR_CTSIC       = 0x80000 // Bit CTSIC.

	// IDR_SPI_MODE: Interrupt Disable Register
	USART_IDR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IDR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IDR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IDR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// IMR: Interrupt Mask Register
	USART_IMR_RXRDY_Pos   = 0x0     // Position of RXRDY field.
	USART_IMR_RXRDY_Msk   = 0x1     // Bit mask of RXRDY field.
	USART_IMR_RXRDY       = 0x1     // Bit RXRDY.
	USART_IMR_TXRDY_Pos   = 0x1     // Position of TXRDY field.
	USART_IMR_TXRDY_Msk   = 0x2     // Bit mask of TXRDY field.
	USART_IMR_TXRDY       = 0x2     // Bit TXRDY.
	USART_IMR_RXBRK_Pos   = 0x2     // Position of RXBRK field.
	USART_IMR_RXBRK_Msk   = 0x4     // Bit mask of RXBRK field.
	USART_IMR_RXBRK       = 0x4     // Bit RXBRK.
	USART_IMR_ENDRX_Pos   = 0x3     // Position of ENDRX field.
	USART_IMR_ENDRX_Msk   = 0x8     // Bit mask of ENDRX field.
	USART_IMR_ENDRX       = 0x8     // Bit ENDRX.
	USART_IMR_ENDTX_Pos   = 0x4     // Position of ENDTX field.
	USART_IMR_ENDTX_Msk   = 0x10    // Bit mask of ENDTX field.
	USART_IMR_ENDTX       = 0x10    // Bit ENDTX.
	USART_IMR_OVRE_Pos    = 0x5     // Position of OVRE field.
	USART_IMR_OVRE_Msk    = 0x20    // Bit mask of OVRE field.
	USART_IMR_OVRE        = 0x20    // Bit OVRE.
	USART_IMR_FRAME_Pos   = 0x6     // Position of FRAME field.
	USART_IMR_FRAME_Msk   = 0x40    // Bit mask of FRAME field.
	USART_IMR_FRAME       = 0x40    // Bit FRAME.
	USART_IMR_PARE_Pos    = 0x7     // Position of PARE field.
	USART_IMR_PARE_Msk    = 0x80    // Bit mask of PARE field.
	USART_IMR_PARE        = 0x80    // Bit PARE.
	USART_IMR_TIMEOUT_Pos = 0x8     // Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100   // Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT     = 0x100   // Bit TIMEOUT.
	USART_IMR_TXEMPTY_Pos = 0x9     // Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200   // Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY     = 0x200   // Bit TXEMPTY.
	USART_IMR_ITER_Pos    = 0xa     // Position of ITER field.
	USART_IMR_ITER_Msk    = 0x400   // Bit mask of ITER field.
	USART_IMR_ITER        = 0x400   // Bit ITER.
	USART_IMR_TXBUFE_Pos  = 0xb     // Position of TXBUFE field.
	USART_IMR_TXBUFE_Msk  = 0x800   // Bit mask of TXBUFE field.
	USART_IMR_TXBUFE      = 0x800   // Bit TXBUFE.
	USART_IMR_RXBUFF_Pos  = 0xc     // Position of RXBUFF field.
	USART_IMR_RXBUFF_Msk  = 0x1000  // Bit mask of RXBUFF field.
	USART_IMR_RXBUFF      = 0x1000  // Bit RXBUFF.
	USART_IMR_NACK_Pos    = 0xd     // Position of NACK field.
	USART_IMR_NACK_Msk    = 0x2000  // Bit mask of NACK field.
	USART_IMR_NACK        = 0x2000  // Bit NACK.
	USART_IMR_CTSIC_Pos   = 0x13    // Position of CTSIC field.
	USART_IMR_CTSIC_Msk   = 0x80000 // Bit mask of CTSIC field.
	USART_IMR_CTSIC       = 0x80000 // Bit CTSIC.

	// IMR_SPI_MODE: Interrupt Mask Register
	USART_IMR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_IMR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_IMR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_IMR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// CSR: Channel Status Register
	USART_CSR_RXRDY_Pos   = 0x0      // Position of RXRDY field.
	USART_CSR_RXRDY_Msk   = 0x1      // Bit mask of RXRDY field.
	USART_CSR_RXRDY       = 0x1      // Bit RXRDY.
	USART_CSR_TXRDY_Pos   = 0x1      // Position of TXRDY field.
	USART_CSR_TXRDY_Msk   = 0x2      // Bit mask of TXRDY field.
	USART_CSR_TXRDY       = 0x2      // Bit TXRDY.
	USART_CSR_RXBRK_Pos   = 0x2      // Position of RXBRK field.
	USART_CSR_RXBRK_Msk   = 0x4      // Bit mask of RXBRK field.
	USART_CSR_RXBRK       = 0x4      // Bit RXBRK.
	USART_CSR_ENDRX_Pos   = 0x3      // Position of ENDRX field.
	USART_CSR_ENDRX_Msk   = 0x8      // Bit mask of ENDRX field.
	USART_CSR_ENDRX       = 0x8      // Bit ENDRX.
	USART_CSR_ENDTX_Pos   = 0x4      // Position of ENDTX field.
	USART_CSR_ENDTX_Msk   = 0x10     // Bit mask of ENDTX field.
	USART_CSR_ENDTX       = 0x10     // Bit ENDTX.
	USART_CSR_OVRE_Pos    = 0x5      // Position of OVRE field.
	USART_CSR_OVRE_Msk    = 0x20     // Bit mask of OVRE field.
	USART_CSR_OVRE        = 0x20     // Bit OVRE.
	USART_CSR_FRAME_Pos   = 0x6      // Position of FRAME field.
	USART_CSR_FRAME_Msk   = 0x40     // Bit mask of FRAME field.
	USART_CSR_FRAME       = 0x40     // Bit FRAME.
	USART_CSR_PARE_Pos    = 0x7      // Position of PARE field.
	USART_CSR_PARE_Msk    = 0x80     // Bit mask of PARE field.
	USART_CSR_PARE        = 0x80     // Bit PARE.
	USART_CSR_TIMEOUT_Pos = 0x8      // Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100    // Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT     = 0x100    // Bit TIMEOUT.
	USART_CSR_TXEMPTY_Pos = 0x9      // Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200    // Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY     = 0x200    // Bit TXEMPTY.
	USART_CSR_ITER_Pos    = 0xa      // Position of ITER field.
	USART_CSR_ITER_Msk    = 0x400    // Bit mask of ITER field.
	USART_CSR_ITER        = 0x400    // Bit ITER.
	USART_CSR_TXBUFE_Pos  = 0xb      // Position of TXBUFE field.
	USART_CSR_TXBUFE_Msk  = 0x800    // Bit mask of TXBUFE field.
	USART_CSR_TXBUFE      = 0x800    // Bit TXBUFE.
	USART_CSR_RXBUFF_Pos  = 0xc      // Position of RXBUFF field.
	USART_CSR_RXBUFF_Msk  = 0x1000   // Bit mask of RXBUFF field.
	USART_CSR_RXBUFF      = 0x1000   // Bit RXBUFF.
	USART_CSR_NACK_Pos    = 0xd      // Position of NACK field.
	USART_CSR_NACK_Msk    = 0x2000   // Bit mask of NACK field.
	USART_CSR_NACK        = 0x2000   // Bit NACK.
	USART_CSR_CTSIC_Pos   = 0x13     // Position of CTSIC field.
	USART_CSR_CTSIC_Msk   = 0x80000  // Bit mask of CTSIC field.
	USART_CSR_CTSIC       = 0x80000  // Bit CTSIC.
	USART_CSR_CTS_Pos     = 0x17     // Position of CTS field.
	USART_CSR_CTS_Msk     = 0x800000 // Bit mask of CTS field.
	USART_CSR_CTS         = 0x800000 // Bit CTS.

	// CSR_SPI_MODE: Channel Status Register
	USART_CSR_SPI_MODE_RXRDY_Pos   = 0x0   // Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk   = 0x1   // Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY       = 0x1   // Bit RXRDY.
	USART_CSR_SPI_MODE_TXRDY_Pos   = 0x1   // Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk   = 0x2   // Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY       = 0x2   // Bit TXRDY.
	USART_CSR_SPI_MODE_OVRE_Pos    = 0x5   // Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk    = 0x20  // Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE        = 0x20  // Bit OVRE.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9   // Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200 // Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY     = 0x200 // Bit TXEMPTY.
	USART_CSR_SPI_MODE_UNRE_Pos    = 0xa   // Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk    = 0x400 // Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE        = 0x400 // Bit UNRE.

	// RHR: Receiver Holding Register
	USART_RHR_RXCHR_Pos  = 0x0    // Position of RXCHR field.
	USART_RHR_RXCHR_Msk  = 0x1ff  // Bit mask of RXCHR field.
	USART_RHR_RXSYNH_Pos = 0xf    // Position of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000 // Bit mask of RXSYNH field.
	USART_RHR_RXSYNH     = 0x8000 // Bit RXSYNH.

	// THR: Transmitter Holding Register
	USART_THR_TXCHR_Pos  = 0x0    // Position of TXCHR field.
	USART_THR_TXCHR_Msk  = 0x1ff  // Bit mask of TXCHR field.
	USART_THR_TXSYNH_Pos = 0xf    // Position of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000 // Bit mask of TXSYNH field.
	USART_THR_TXSYNH     = 0x8000 // Bit TXSYNH.

	// BRGR: Baud Rate Generator Register
	USART_BRGR_CD_Pos = 0x0     // Position of CD field.
	USART_BRGR_CD_Msk = 0xffff  // Bit mask of CD field.
	USART_BRGR_FP_Pos = 0x10    // Position of FP field.
	USART_BRGR_FP_Msk = 0x70000 // Bit mask of FP field.

	// RTOR: Receiver Time-out Register
	USART_RTOR_TO_Pos = 0x0    // Position of TO field.
	USART_RTOR_TO_Msk = 0xffff // Bit mask of TO field.

	// TTGR: Transmitter Timeguard Register
	USART_TTGR_TG_Pos = 0x0  // Position of TG field.
	USART_TTGR_TG_Msk = 0xff // Bit mask of TG field.

	// FIDI: FI DI Ratio Register
	USART_FIDI_FI_DI_RATIO_Pos = 0x0   // Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff // Bit mask of FI_DI_RATIO field.

	// NER: Number of Errors Register
	USART_NER_NB_ERRORS_Pos = 0x0  // Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff // Bit mask of NB_ERRORS field.

	// IF: IrDA Filter Register
	USART_IF_IRDA_FILTER_Pos = 0x0  // Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff // Bit mask of IRDA_FILTER field.

	// WPMR: Write Protect Mode Register
	USART_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	USART_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	USART_WPMR_WPEN      = 0x1        // Bit WPEN.
	USART_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	USART_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	USART_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	USART_WPSR_WPVS       = 0x1      // Bit WPVS.
	USART_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.

	// RPR: Receive Pointer Register
	USART_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	USART_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	USART_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	USART_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	USART_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	USART_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	USART_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	USART_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	USART_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	USART_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	USART_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	USART_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	USART_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	USART_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	USART_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	USART_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	USART_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	USART_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	USART_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	USART_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	ADC_CR_SWRST_Pos = 0x0 // Position of SWRST field.
	ADC_CR_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	ADC_CR_SWRST     = 0x1 // Bit SWRST.
	ADC_CR_START_Pos = 0x1 // Position of START field.
	ADC_CR_START_Msk = 0x2 // Bit mask of START field.
	ADC_CR_START     = 0x2 // Bit START.

	// MR: Mode Register
	ADC_MR_TRGEN_Pos        = 0x0        // Position of TRGEN field.
	ADC_MR_TRGEN_Msk        = 0x1        // Bit mask of TRGEN field.
	ADC_MR_TRGEN            = 0x1        // Bit TRGEN.
	ADC_MR_TRGEN_DIS        = 0x0        // Hardware triggers are disabled. Starting a conversion is only possible by software.
	ADC_MR_TRGEN_EN         = 0x1        // Hardware trigger selected by TRGSEL field is enabled.
	ADC_MR_TRGSEL_Pos       = 0x1        // Position of TRGSEL field.
	ADC_MR_TRGSEL_Msk       = 0xe        // Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0        // External trigger
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1        // TIO Output of the Timer Counter Channel 0
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2        // TIO Output of the Timer Counter Channel 1
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3        // TIO Output of the Timer Counter Channel 2
	ADC_MR_LOWRES_Pos       = 0x4        // Position of LOWRES field.
	ADC_MR_LOWRES_Msk       = 0x10       // Bit mask of LOWRES field.
	ADC_MR_LOWRES           = 0x10       // Bit LOWRES.
	ADC_MR_LOWRES_BITS_10   = 0x0        // 10-bit resolution
	ADC_MR_LOWRES_BITS_8    = 0x1        // 8-bit resolution
	ADC_MR_SLEEP_Pos        = 0x5        // Position of SLEEP field.
	ADC_MR_SLEEP_Msk        = 0x20       // Bit mask of SLEEP field.
	ADC_MR_SLEEP            = 0x20       // Bit SLEEP.
	ADC_MR_SLEEP_NORMAL     = 0x0        // Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_SLEEP      = 0x1        // Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_FWUP_Pos         = 0x6        // Position of FWUP field.
	ADC_MR_FWUP_Msk         = 0x40       // Bit mask of FWUP field.
	ADC_MR_FWUP             = 0x40       // Bit FWUP.
	ADC_MR_FWUP_OFF         = 0x0        // Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_ON          = 0x1        // Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FREERUN_Pos      = 0x7        // Position of FREERUN field.
	ADC_MR_FREERUN_Msk      = 0x80       // Bit mask of FREERUN field.
	ADC_MR_FREERUN          = 0x80       // Bit FREERUN.
	ADC_MR_FREERUN_OFF      = 0x0        // Normal Mode
	ADC_MR_FREERUN_ON       = 0x1        // Free Run Mode: Never wait for any trigger.
	ADC_MR_PRESCAL_Pos      = 0x8        // Position of PRESCAL field.
	ADC_MR_PRESCAL_Msk      = 0xff00     // Bit mask of PRESCAL field.
	ADC_MR_STARTUP_Pos      = 0x10       // Position of STARTUP field.
	ADC_MR_STARTUP_Msk      = 0xf0000    // Bit mask of STARTUP field.
	ADC_MR_STARTUP_SUT0     = 0x0        // 0 periods of ADCClock
	ADC_MR_STARTUP_SUT8     = 0x1        // 8 periods of ADCClock
	ADC_MR_STARTUP_SUT16    = 0x2        // 16 periods of ADCClock
	ADC_MR_STARTUP_SUT24    = 0x3        // 24 periods of ADCClock
	ADC_MR_STARTUP_SUT64    = 0x4        // 64 periods of ADCClock
	ADC_MR_STARTUP_SUT80    = 0x5        // 80 periods of ADCClock
	ADC_MR_STARTUP_SUT96    = 0x6        // 96 periods of ADCClock
	ADC_MR_STARTUP_SUT112   = 0x7        // 112 periods of ADCClock
	ADC_MR_STARTUP_SUT512   = 0x8        // 512 periods of ADCClock
	ADC_MR_STARTUP_SUT576   = 0x9        // 576 periods of ADCClock
	ADC_MR_STARTUP_SUT640   = 0xa        // 640 periods of ADCClock
	ADC_MR_STARTUP_SUT704   = 0xb        // 704 periods of ADCClock
	ADC_MR_STARTUP_SUT768   = 0xc        // 768 periods of ADCClock
	ADC_MR_STARTUP_SUT832   = 0xd        // 832 periods of ADCClock
	ADC_MR_STARTUP_SUT896   = 0xe        // 896 periods of ADCClock
	ADC_MR_STARTUP_SUT960   = 0xf        // 960 periods of ADCClock
	ADC_MR_TRACKTIM_Pos     = 0x18       // Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk     = 0xf000000  // Bit mask of TRACKTIM field.
	ADC_MR_USEQ_Pos         = 0x1f       // Position of USEQ field.
	ADC_MR_USEQ_Msk         = 0x80000000 // Bit mask of USEQ field.
	ADC_MR_USEQ             = 0x80000000 // Bit USEQ.
	ADC_MR_USEQ_NUM_ORDER   = 0x0        // Normal Mode: The controller converts channels in a simple numeric order.
	ADC_MR_USEQ_REG_ORDER   = 0x1        // User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers.

	// SEQR1: Channel Sequence Register 1
	ADC_SEQR1_USCH1_Pos = 0x0        // Position of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf        // Bit mask of USCH1 field.
	ADC_SEQR1_USCH2_Pos = 0x4        // Position of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0       // Bit mask of USCH2 field.
	ADC_SEQR1_USCH3_Pos = 0x8        // Position of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00      // Bit mask of USCH3 field.
	ADC_SEQR1_USCH4_Pos = 0xc        // Position of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000     // Bit mask of USCH4 field.
	ADC_SEQR1_USCH5_Pos = 0x10       // Position of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000    // Bit mask of USCH5 field.
	ADC_SEQR1_USCH6_Pos = 0x14       // Position of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000   // Bit mask of USCH6 field.
	ADC_SEQR1_USCH7_Pos = 0x18       // Position of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000  // Bit mask of USCH7 field.
	ADC_SEQR1_USCH8_Pos = 0x1c       // Position of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000 // Bit mask of USCH8 field.

	// SEQR2: Channel Sequence Register 2
	ADC_SEQR2_USCH9_Pos  = 0x0        // Position of USCH9 field.
	ADC_SEQR2_USCH9_Msk  = 0xf        // Bit mask of USCH9 field.
	ADC_SEQR2_USCH10_Pos = 0x4        // Position of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0       // Bit mask of USCH10 field.
	ADC_SEQR2_USCH11_Pos = 0x8        // Position of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00      // Bit mask of USCH11 field.
	ADC_SEQR2_USCH12_Pos = 0xc        // Position of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000     // Bit mask of USCH12 field.
	ADC_SEQR2_USCH13_Pos = 0x10       // Position of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000    // Bit mask of USCH13 field.
	ADC_SEQR2_USCH14_Pos = 0x14       // Position of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000   // Bit mask of USCH14 field.
	ADC_SEQR2_USCH15_Pos = 0x18       // Position of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000  // Bit mask of USCH15 field.
	ADC_SEQR2_USCH16_Pos = 0x1c       // Position of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0xf0000000 // Bit mask of USCH16 field.

	// CHER: Channel Enable Register
	ADC_CHER_CH0_Pos  = 0x0    // Position of CH0 field.
	ADC_CHER_CH0_Msk  = 0x1    // Bit mask of CH0 field.
	ADC_CHER_CH0      = 0x1    // Bit CH0.
	ADC_CHER_CH1_Pos  = 0x1    // Position of CH1 field.
	ADC_CHER_CH1_Msk  = 0x2    // Bit mask of CH1 field.
	ADC_CHER_CH1      = 0x2    // Bit CH1.
	ADC_CHER_CH2_Pos  = 0x2    // Position of CH2 field.
	ADC_CHER_CH2_Msk  = 0x4    // Bit mask of CH2 field.
	ADC_CHER_CH2      = 0x4    // Bit CH2.
	ADC_CHER_CH3_Pos  = 0x3    // Position of CH3 field.
	ADC_CHER_CH3_Msk  = 0x8    // Bit mask of CH3 field.
	ADC_CHER_CH3      = 0x8    // Bit CH3.
	ADC_CHER_CH4_Pos  = 0x4    // Position of CH4 field.
	ADC_CHER_CH4_Msk  = 0x10   // Bit mask of CH4 field.
	ADC_CHER_CH4      = 0x10   // Bit CH4.
	ADC_CHER_CH5_Pos  = 0x5    // Position of CH5 field.
	ADC_CHER_CH5_Msk  = 0x20   // Bit mask of CH5 field.
	ADC_CHER_CH5      = 0x20   // Bit CH5.
	ADC_CHER_CH6_Pos  = 0x6    // Position of CH6 field.
	ADC_CHER_CH6_Msk  = 0x40   // Bit mask of CH6 field.
	ADC_CHER_CH6      = 0x40   // Bit CH6.
	ADC_CHER_CH7_Pos  = 0x7    // Position of CH7 field.
	ADC_CHER_CH7_Msk  = 0x80   // Bit mask of CH7 field.
	ADC_CHER_CH7      = 0x80   // Bit CH7.
	ADC_CHER_CH8_Pos  = 0x8    // Position of CH8 field.
	ADC_CHER_CH8_Msk  = 0x100  // Bit mask of CH8 field.
	ADC_CHER_CH8      = 0x100  // Bit CH8.
	ADC_CHER_CH9_Pos  = 0x9    // Position of CH9 field.
	ADC_CHER_CH9_Msk  = 0x200  // Bit mask of CH9 field.
	ADC_CHER_CH9      = 0x200  // Bit CH9.
	ADC_CHER_CH10_Pos = 0xa    // Position of CH10 field.
	ADC_CHER_CH10_Msk = 0x400  // Bit mask of CH10 field.
	ADC_CHER_CH10     = 0x400  // Bit CH10.
	ADC_CHER_CH11_Pos = 0xb    // Position of CH11 field.
	ADC_CHER_CH11_Msk = 0x800  // Bit mask of CH11 field.
	ADC_CHER_CH11     = 0x800  // Bit CH11.
	ADC_CHER_CH12_Pos = 0xc    // Position of CH12 field.
	ADC_CHER_CH12_Msk = 0x1000 // Bit mask of CH12 field.
	ADC_CHER_CH12     = 0x1000 // Bit CH12.
	ADC_CHER_CH13_Pos = 0xd    // Position of CH13 field.
	ADC_CHER_CH13_Msk = 0x2000 // Bit mask of CH13 field.
	ADC_CHER_CH13     = 0x2000 // Bit CH13.
	ADC_CHER_CH14_Pos = 0xe    // Position of CH14 field.
	ADC_CHER_CH14_Msk = 0x4000 // Bit mask of CH14 field.
	ADC_CHER_CH14     = 0x4000 // Bit CH14.
	ADC_CHER_CH15_Pos = 0xf    // Position of CH15 field.
	ADC_CHER_CH15_Msk = 0x8000 // Bit mask of CH15 field.
	ADC_CHER_CH15     = 0x8000 // Bit CH15.

	// CHDR: Channel Disable Register
	ADC_CHDR_CH0_Pos  = 0x0    // Position of CH0 field.
	ADC_CHDR_CH0_Msk  = 0x1    // Bit mask of CH0 field.
	ADC_CHDR_CH0      = 0x1    // Bit CH0.
	ADC_CHDR_CH1_Pos  = 0x1    // Position of CH1 field.
	ADC_CHDR_CH1_Msk  = 0x2    // Bit mask of CH1 field.
	ADC_CHDR_CH1      = 0x2    // Bit CH1.
	ADC_CHDR_CH2_Pos  = 0x2    // Position of CH2 field.
	ADC_CHDR_CH2_Msk  = 0x4    // Bit mask of CH2 field.
	ADC_CHDR_CH2      = 0x4    // Bit CH2.
	ADC_CHDR_CH3_Pos  = 0x3    // Position of CH3 field.
	ADC_CHDR_CH3_Msk  = 0x8    // Bit mask of CH3 field.
	ADC_CHDR_CH3      = 0x8    // Bit CH3.
	ADC_CHDR_CH4_Pos  = 0x4    // Position of CH4 field.
	ADC_CHDR_CH4_Msk  = 0x10   // Bit mask of CH4 field.
	ADC_CHDR_CH4      = 0x10   // Bit CH4.
	ADC_CHDR_CH5_Pos  = 0x5    // Position of CH5 field.
	ADC_CHDR_CH5_Msk  = 0x20   // Bit mask of CH5 field.
	ADC_CHDR_CH5      = 0x20   // Bit CH5.
	ADC_CHDR_CH6_Pos  = 0x6    // Position of CH6 field.
	ADC_CHDR_CH6_Msk  = 0x40   // Bit mask of CH6 field.
	ADC_CHDR_CH6      = 0x40   // Bit CH6.
	ADC_CHDR_CH7_Pos  = 0x7    // Position of CH7 field.
	ADC_CHDR_CH7_Msk  = 0x80   // Bit mask of CH7 field.
	ADC_CHDR_CH7      = 0x80   // Bit CH7.
	ADC_CHDR_CH8_Pos  = 0x8    // Position of CH8 field.
	ADC_CHDR_CH8_Msk  = 0x100  // Bit mask of CH8 field.
	ADC_CHDR_CH8      = 0x100  // Bit CH8.
	ADC_CHDR_CH9_Pos  = 0x9    // Position of CH9 field.
	ADC_CHDR_CH9_Msk  = 0x200  // Bit mask of CH9 field.
	ADC_CHDR_CH9      = 0x200  // Bit CH9.
	ADC_CHDR_CH10_Pos = 0xa    // Position of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400  // Bit mask of CH10 field.
	ADC_CHDR_CH10     = 0x400  // Bit CH10.
	ADC_CHDR_CH11_Pos = 0xb    // Position of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800  // Bit mask of CH11 field.
	ADC_CHDR_CH11     = 0x800  // Bit CH11.
	ADC_CHDR_CH12_Pos = 0xc    // Position of CH12 field.
	ADC_CHDR_CH12_Msk = 0x1000 // Bit mask of CH12 field.
	ADC_CHDR_CH12     = 0x1000 // Bit CH12.
	ADC_CHDR_CH13_Pos = 0xd    // Position of CH13 field.
	ADC_CHDR_CH13_Msk = 0x2000 // Bit mask of CH13 field.
	ADC_CHDR_CH13     = 0x2000 // Bit CH13.
	ADC_CHDR_CH14_Pos = 0xe    // Position of CH14 field.
	ADC_CHDR_CH14_Msk = 0x4000 // Bit mask of CH14 field.
	ADC_CHDR_CH14     = 0x4000 // Bit CH14.
	ADC_CHDR_CH15_Pos = 0xf    // Position of CH15 field.
	ADC_CHDR_CH15_Msk = 0x8000 // Bit mask of CH15 field.
	ADC_CHDR_CH15     = 0x8000 // Bit CH15.

	// CHSR: Channel Status Register
	ADC_CHSR_CH0_Pos  = 0x0    // Position of CH0 field.
	ADC_CHSR_CH0_Msk  = 0x1    // Bit mask of CH0 field.
	ADC_CHSR_CH0      = 0x1    // Bit CH0.
	ADC_CHSR_CH1_Pos  = 0x1    // Position of CH1 field.
	ADC_CHSR_CH1_Msk  = 0x2    // Bit mask of CH1 field.
	ADC_CHSR_CH1      = 0x2    // Bit CH1.
	ADC_CHSR_CH2_Pos  = 0x2    // Position of CH2 field.
	ADC_CHSR_CH2_Msk  = 0x4    // Bit mask of CH2 field.
	ADC_CHSR_CH2      = 0x4    // Bit CH2.
	ADC_CHSR_CH3_Pos  = 0x3    // Position of CH3 field.
	ADC_CHSR_CH3_Msk  = 0x8    // Bit mask of CH3 field.
	ADC_CHSR_CH3      = 0x8    // Bit CH3.
	ADC_CHSR_CH4_Pos  = 0x4    // Position of CH4 field.
	ADC_CHSR_CH4_Msk  = 0x10   // Bit mask of CH4 field.
	ADC_CHSR_CH4      = 0x10   // Bit CH4.
	ADC_CHSR_CH5_Pos  = 0x5    // Position of CH5 field.
	ADC_CHSR_CH5_Msk  = 0x20   // Bit mask of CH5 field.
	ADC_CHSR_CH5      = 0x20   // Bit CH5.
	ADC_CHSR_CH6_Pos  = 0x6    // Position of CH6 field.
	ADC_CHSR_CH6_Msk  = 0x40   // Bit mask of CH6 field.
	ADC_CHSR_CH6      = 0x40   // Bit CH6.
	ADC_CHSR_CH7_Pos  = 0x7    // Position of CH7 field.
	ADC_CHSR_CH7_Msk  = 0x80   // Bit mask of CH7 field.
	ADC_CHSR_CH7      = 0x80   // Bit CH7.
	ADC_CHSR_CH8_Pos  = 0x8    // Position of CH8 field.
	ADC_CHSR_CH8_Msk  = 0x100  // Bit mask of CH8 field.
	ADC_CHSR_CH8      = 0x100  // Bit CH8.
	ADC_CHSR_CH9_Pos  = 0x9    // Position of CH9 field.
	ADC_CHSR_CH9_Msk  = 0x200  // Bit mask of CH9 field.
	ADC_CHSR_CH9      = 0x200  // Bit CH9.
	ADC_CHSR_CH10_Pos = 0xa    // Position of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400  // Bit mask of CH10 field.
	ADC_CHSR_CH10     = 0x400  // Bit CH10.
	ADC_CHSR_CH11_Pos = 0xb    // Position of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800  // Bit mask of CH11 field.
	ADC_CHSR_CH11     = 0x800  // Bit CH11.
	ADC_CHSR_CH12_Pos = 0xc    // Position of CH12 field.
	ADC_CHSR_CH12_Msk = 0x1000 // Bit mask of CH12 field.
	ADC_CHSR_CH12     = 0x1000 // Bit CH12.
	ADC_CHSR_CH13_Pos = 0xd    // Position of CH13 field.
	ADC_CHSR_CH13_Msk = 0x2000 // Bit mask of CH13 field.
	ADC_CHSR_CH13     = 0x2000 // Bit CH13.
	ADC_CHSR_CH14_Pos = 0xe    // Position of CH14 field.
	ADC_CHSR_CH14_Msk = 0x4000 // Bit mask of CH14 field.
	ADC_CHSR_CH14     = 0x4000 // Bit CH14.
	ADC_CHSR_CH15_Pos = 0xf    // Position of CH15 field.
	ADC_CHSR_CH15_Msk = 0x8000 // Bit mask of CH15 field.
	ADC_CHSR_CH15     = 0x8000 // Bit CH15.

	// LCDR: Last Converted Data Register
	ADC_LCDR_LDATA_Pos = 0x0    // Position of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff  // Bit mask of LDATA field.
	ADC_LCDR_CHNB_Pos  = 0xc    // Position of CHNB field.
	ADC_LCDR_CHNB_Msk  = 0xf000 // Bit mask of CHNB field.

	// IER: Interrupt Enable Register
	ADC_IER_EOC0_Pos   = 0x0        // Position of EOC0 field.
	ADC_IER_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	ADC_IER_EOC0       = 0x1        // Bit EOC0.
	ADC_IER_EOC1_Pos   = 0x1        // Position of EOC1 field.
	ADC_IER_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	ADC_IER_EOC1       = 0x2        // Bit EOC1.
	ADC_IER_EOC2_Pos   = 0x2        // Position of EOC2 field.
	ADC_IER_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	ADC_IER_EOC2       = 0x4        // Bit EOC2.
	ADC_IER_EOC3_Pos   = 0x3        // Position of EOC3 field.
	ADC_IER_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	ADC_IER_EOC3       = 0x8        // Bit EOC3.
	ADC_IER_EOC4_Pos   = 0x4        // Position of EOC4 field.
	ADC_IER_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	ADC_IER_EOC4       = 0x10       // Bit EOC4.
	ADC_IER_EOC5_Pos   = 0x5        // Position of EOC5 field.
	ADC_IER_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	ADC_IER_EOC5       = 0x20       // Bit EOC5.
	ADC_IER_EOC6_Pos   = 0x6        // Position of EOC6 field.
	ADC_IER_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	ADC_IER_EOC6       = 0x40       // Bit EOC6.
	ADC_IER_EOC7_Pos   = 0x7        // Position of EOC7 field.
	ADC_IER_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	ADC_IER_EOC7       = 0x80       // Bit EOC7.
	ADC_IER_EOC8_Pos   = 0x8        // Position of EOC8 field.
	ADC_IER_EOC8_Msk   = 0x100      // Bit mask of EOC8 field.
	ADC_IER_EOC8       = 0x100      // Bit EOC8.
	ADC_IER_EOC9_Pos   = 0x9        // Position of EOC9 field.
	ADC_IER_EOC9_Msk   = 0x200      // Bit mask of EOC9 field.
	ADC_IER_EOC9       = 0x200      // Bit EOC9.
	ADC_IER_EOC10_Pos  = 0xa        // Position of EOC10 field.
	ADC_IER_EOC10_Msk  = 0x400      // Bit mask of EOC10 field.
	ADC_IER_EOC10      = 0x400      // Bit EOC10.
	ADC_IER_EOC11_Pos  = 0xb        // Position of EOC11 field.
	ADC_IER_EOC11_Msk  = 0x800      // Bit mask of EOC11 field.
	ADC_IER_EOC11      = 0x800      // Bit EOC11.
	ADC_IER_EOC12_Pos  = 0xc        // Position of EOC12 field.
	ADC_IER_EOC12_Msk  = 0x1000     // Bit mask of EOC12 field.
	ADC_IER_EOC12      = 0x1000     // Bit EOC12.
	ADC_IER_EOC13_Pos  = 0xd        // Position of EOC13 field.
	ADC_IER_EOC13_Msk  = 0x2000     // Bit mask of EOC13 field.
	ADC_IER_EOC13      = 0x2000     // Bit EOC13.
	ADC_IER_EOC14_Pos  = 0xe        // Position of EOC14 field.
	ADC_IER_EOC14_Msk  = 0x4000     // Bit mask of EOC14 field.
	ADC_IER_EOC14      = 0x4000     // Bit EOC14.
	ADC_IER_EOC15_Pos  = 0xf        // Position of EOC15 field.
	ADC_IER_EOC15_Msk  = 0x8000     // Bit mask of EOC15 field.
	ADC_IER_EOC15      = 0x8000     // Bit EOC15.
	ADC_IER_DRDY_Pos   = 0x18       // Position of DRDY field.
	ADC_IER_DRDY_Msk   = 0x1000000  // Bit mask of DRDY field.
	ADC_IER_DRDY       = 0x1000000  // Bit DRDY.
	ADC_IER_GOVRE_Pos  = 0x19       // Position of GOVRE field.
	ADC_IER_GOVRE_Msk  = 0x2000000  // Bit mask of GOVRE field.
	ADC_IER_GOVRE      = 0x2000000  // Bit GOVRE.
	ADC_IER_COMPE_Pos  = 0x1a       // Position of COMPE field.
	ADC_IER_COMPE_Msk  = 0x4000000  // Bit mask of COMPE field.
	ADC_IER_COMPE      = 0x4000000  // Bit COMPE.
	ADC_IER_ENDRX_Pos  = 0x1b       // Position of ENDRX field.
	ADC_IER_ENDRX_Msk  = 0x8000000  // Bit mask of ENDRX field.
	ADC_IER_ENDRX      = 0x8000000  // Bit ENDRX.
	ADC_IER_RXBUFF_Pos = 0x1c       // Position of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x10000000 // Bit mask of RXBUFF field.
	ADC_IER_RXBUFF     = 0x10000000 // Bit RXBUFF.

	// IDR: Interrupt Disable Register
	ADC_IDR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	ADC_IDR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	ADC_IDR_EOC0       = 0x1        // Bit EOC0.
	ADC_IDR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	ADC_IDR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	ADC_IDR_EOC1       = 0x2        // Bit EOC1.
	ADC_IDR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	ADC_IDR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	ADC_IDR_EOC2       = 0x4        // Bit EOC2.
	ADC_IDR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	ADC_IDR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	ADC_IDR_EOC3       = 0x8        // Bit EOC3.
	ADC_IDR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	ADC_IDR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	ADC_IDR_EOC4       = 0x10       // Bit EOC4.
	ADC_IDR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	ADC_IDR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	ADC_IDR_EOC5       = 0x20       // Bit EOC5.
	ADC_IDR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	ADC_IDR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	ADC_IDR_EOC6       = 0x40       // Bit EOC6.
	ADC_IDR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	ADC_IDR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	ADC_IDR_EOC7       = 0x80       // Bit EOC7.
	ADC_IDR_EOC8_Pos   = 0x8        // Position of EOC8 field.
	ADC_IDR_EOC8_Msk   = 0x100      // Bit mask of EOC8 field.
	ADC_IDR_EOC8       = 0x100      // Bit EOC8.
	ADC_IDR_EOC9_Pos   = 0x9        // Position of EOC9 field.
	ADC_IDR_EOC9_Msk   = 0x200      // Bit mask of EOC9 field.
	ADC_IDR_EOC9       = 0x200      // Bit EOC9.
	ADC_IDR_EOC10_Pos  = 0xa        // Position of EOC10 field.
	ADC_IDR_EOC10_Msk  = 0x400      // Bit mask of EOC10 field.
	ADC_IDR_EOC10      = 0x400      // Bit EOC10.
	ADC_IDR_EOC11_Pos  = 0xb        // Position of EOC11 field.
	ADC_IDR_EOC11_Msk  = 0x800      // Bit mask of EOC11 field.
	ADC_IDR_EOC11      = 0x800      // Bit EOC11.
	ADC_IDR_EOC12_Pos  = 0xc        // Position of EOC12 field.
	ADC_IDR_EOC12_Msk  = 0x1000     // Bit mask of EOC12 field.
	ADC_IDR_EOC12      = 0x1000     // Bit EOC12.
	ADC_IDR_EOC13_Pos  = 0xd        // Position of EOC13 field.
	ADC_IDR_EOC13_Msk  = 0x2000     // Bit mask of EOC13 field.
	ADC_IDR_EOC13      = 0x2000     // Bit EOC13.
	ADC_IDR_EOC14_Pos  = 0xe        // Position of EOC14 field.
	ADC_IDR_EOC14_Msk  = 0x4000     // Bit mask of EOC14 field.
	ADC_IDR_EOC14      = 0x4000     // Bit EOC14.
	ADC_IDR_EOC15_Pos  = 0xf        // Position of EOC15 field.
	ADC_IDR_EOC15_Msk  = 0x8000     // Bit mask of EOC15 field.
	ADC_IDR_EOC15      = 0x8000     // Bit EOC15.
	ADC_IDR_DRDY_Pos   = 0x18       // Position of DRDY field.
	ADC_IDR_DRDY_Msk   = 0x1000000  // Bit mask of DRDY field.
	ADC_IDR_DRDY       = 0x1000000  // Bit DRDY.
	ADC_IDR_GOVRE_Pos  = 0x19       // Position of GOVRE field.
	ADC_IDR_GOVRE_Msk  = 0x2000000  // Bit mask of GOVRE field.
	ADC_IDR_GOVRE      = 0x2000000  // Bit GOVRE.
	ADC_IDR_COMPE_Pos  = 0x1a       // Position of COMPE field.
	ADC_IDR_COMPE_Msk  = 0x4000000  // Bit mask of COMPE field.
	ADC_IDR_COMPE      = 0x4000000  // Bit COMPE.
	ADC_IDR_ENDRX_Pos  = 0x1b       // Position of ENDRX field.
	ADC_IDR_ENDRX_Msk  = 0x8000000  // Bit mask of ENDRX field.
	ADC_IDR_ENDRX      = 0x8000000  // Bit ENDRX.
	ADC_IDR_RXBUFF_Pos = 0x1c       // Position of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x10000000 // Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF     = 0x10000000 // Bit RXBUFF.

	// IMR: Interrupt Mask Register
	ADC_IMR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	ADC_IMR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	ADC_IMR_EOC0       = 0x1        // Bit EOC0.
	ADC_IMR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	ADC_IMR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	ADC_IMR_EOC1       = 0x2        // Bit EOC1.
	ADC_IMR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	ADC_IMR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	ADC_IMR_EOC2       = 0x4        // Bit EOC2.
	ADC_IMR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	ADC_IMR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	ADC_IMR_EOC3       = 0x8        // Bit EOC3.
	ADC_IMR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	ADC_IMR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	ADC_IMR_EOC4       = 0x10       // Bit EOC4.
	ADC_IMR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	ADC_IMR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	ADC_IMR_EOC5       = 0x20       // Bit EOC5.
	ADC_IMR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	ADC_IMR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	ADC_IMR_EOC6       = 0x40       // Bit EOC6.
	ADC_IMR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	ADC_IMR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	ADC_IMR_EOC7       = 0x80       // Bit EOC7.
	ADC_IMR_EOC8_Pos   = 0x8        // Position of EOC8 field.
	ADC_IMR_EOC8_Msk   = 0x100      // Bit mask of EOC8 field.
	ADC_IMR_EOC8       = 0x100      // Bit EOC8.
	ADC_IMR_EOC9_Pos   = 0x9        // Position of EOC9 field.
	ADC_IMR_EOC9_Msk   = 0x200      // Bit mask of EOC9 field.
	ADC_IMR_EOC9       = 0x200      // Bit EOC9.
	ADC_IMR_EOC10_Pos  = 0xa        // Position of EOC10 field.
	ADC_IMR_EOC10_Msk  = 0x400      // Bit mask of EOC10 field.
	ADC_IMR_EOC10      = 0x400      // Bit EOC10.
	ADC_IMR_EOC11_Pos  = 0xb        // Position of EOC11 field.
	ADC_IMR_EOC11_Msk  = 0x800      // Bit mask of EOC11 field.
	ADC_IMR_EOC11      = 0x800      // Bit EOC11.
	ADC_IMR_EOC12_Pos  = 0xc        // Position of EOC12 field.
	ADC_IMR_EOC12_Msk  = 0x1000     // Bit mask of EOC12 field.
	ADC_IMR_EOC12      = 0x1000     // Bit EOC12.
	ADC_IMR_EOC13_Pos  = 0xd        // Position of EOC13 field.
	ADC_IMR_EOC13_Msk  = 0x2000     // Bit mask of EOC13 field.
	ADC_IMR_EOC13      = 0x2000     // Bit EOC13.
	ADC_IMR_EOC14_Pos  = 0xe        // Position of EOC14 field.
	ADC_IMR_EOC14_Msk  = 0x4000     // Bit mask of EOC14 field.
	ADC_IMR_EOC14      = 0x4000     // Bit EOC14.
	ADC_IMR_EOC15_Pos  = 0xf        // Position of EOC15 field.
	ADC_IMR_EOC15_Msk  = 0x8000     // Bit mask of EOC15 field.
	ADC_IMR_EOC15      = 0x8000     // Bit EOC15.
	ADC_IMR_DRDY_Pos   = 0x18       // Position of DRDY field.
	ADC_IMR_DRDY_Msk   = 0x1000000  // Bit mask of DRDY field.
	ADC_IMR_DRDY       = 0x1000000  // Bit DRDY.
	ADC_IMR_GOVRE_Pos  = 0x19       // Position of GOVRE field.
	ADC_IMR_GOVRE_Msk  = 0x2000000  // Bit mask of GOVRE field.
	ADC_IMR_GOVRE      = 0x2000000  // Bit GOVRE.
	ADC_IMR_COMPE_Pos  = 0x1a       // Position of COMPE field.
	ADC_IMR_COMPE_Msk  = 0x4000000  // Bit mask of COMPE field.
	ADC_IMR_COMPE      = 0x4000000  // Bit COMPE.
	ADC_IMR_ENDRX_Pos  = 0x1b       // Position of ENDRX field.
	ADC_IMR_ENDRX_Msk  = 0x8000000  // Bit mask of ENDRX field.
	ADC_IMR_ENDRX      = 0x8000000  // Bit ENDRX.
	ADC_IMR_RXBUFF_Pos = 0x1c       // Position of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x10000000 // Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF     = 0x10000000 // Bit RXBUFF.

	// ISR: Interrupt Status Register
	ADC_ISR_EOC0_Pos   = 0x0        // Position of EOC0 field.
	ADC_ISR_EOC0_Msk   = 0x1        // Bit mask of EOC0 field.
	ADC_ISR_EOC0       = 0x1        // Bit EOC0.
	ADC_ISR_EOC1_Pos   = 0x1        // Position of EOC1 field.
	ADC_ISR_EOC1_Msk   = 0x2        // Bit mask of EOC1 field.
	ADC_ISR_EOC1       = 0x2        // Bit EOC1.
	ADC_ISR_EOC2_Pos   = 0x2        // Position of EOC2 field.
	ADC_ISR_EOC2_Msk   = 0x4        // Bit mask of EOC2 field.
	ADC_ISR_EOC2       = 0x4        // Bit EOC2.
	ADC_ISR_EOC3_Pos   = 0x3        // Position of EOC3 field.
	ADC_ISR_EOC3_Msk   = 0x8        // Bit mask of EOC3 field.
	ADC_ISR_EOC3       = 0x8        // Bit EOC3.
	ADC_ISR_EOC4_Pos   = 0x4        // Position of EOC4 field.
	ADC_ISR_EOC4_Msk   = 0x10       // Bit mask of EOC4 field.
	ADC_ISR_EOC4       = 0x10       // Bit EOC4.
	ADC_ISR_EOC5_Pos   = 0x5        // Position of EOC5 field.
	ADC_ISR_EOC5_Msk   = 0x20       // Bit mask of EOC5 field.
	ADC_ISR_EOC5       = 0x20       // Bit EOC5.
	ADC_ISR_EOC6_Pos   = 0x6        // Position of EOC6 field.
	ADC_ISR_EOC6_Msk   = 0x40       // Bit mask of EOC6 field.
	ADC_ISR_EOC6       = 0x40       // Bit EOC6.
	ADC_ISR_EOC7_Pos   = 0x7        // Position of EOC7 field.
	ADC_ISR_EOC7_Msk   = 0x80       // Bit mask of EOC7 field.
	ADC_ISR_EOC7       = 0x80       // Bit EOC7.
	ADC_ISR_EOC8_Pos   = 0x8        // Position of EOC8 field.
	ADC_ISR_EOC8_Msk   = 0x100      // Bit mask of EOC8 field.
	ADC_ISR_EOC8       = 0x100      // Bit EOC8.
	ADC_ISR_EOC9_Pos   = 0x9        // Position of EOC9 field.
	ADC_ISR_EOC9_Msk   = 0x200      // Bit mask of EOC9 field.
	ADC_ISR_EOC9       = 0x200      // Bit EOC9.
	ADC_ISR_EOC10_Pos  = 0xa        // Position of EOC10 field.
	ADC_ISR_EOC10_Msk  = 0x400      // Bit mask of EOC10 field.
	ADC_ISR_EOC10      = 0x400      // Bit EOC10.
	ADC_ISR_EOC11_Pos  = 0xb        // Position of EOC11 field.
	ADC_ISR_EOC11_Msk  = 0x800      // Bit mask of EOC11 field.
	ADC_ISR_EOC11      = 0x800      // Bit EOC11.
	ADC_ISR_EOC12_Pos  = 0xc        // Position of EOC12 field.
	ADC_ISR_EOC12_Msk  = 0x1000     // Bit mask of EOC12 field.
	ADC_ISR_EOC12      = 0x1000     // Bit EOC12.
	ADC_ISR_EOC13_Pos  = 0xd        // Position of EOC13 field.
	ADC_ISR_EOC13_Msk  = 0x2000     // Bit mask of EOC13 field.
	ADC_ISR_EOC13      = 0x2000     // Bit EOC13.
	ADC_ISR_EOC14_Pos  = 0xe        // Position of EOC14 field.
	ADC_ISR_EOC14_Msk  = 0x4000     // Bit mask of EOC14 field.
	ADC_ISR_EOC14      = 0x4000     // Bit EOC14.
	ADC_ISR_EOC15_Pos  = 0xf        // Position of EOC15 field.
	ADC_ISR_EOC15_Msk  = 0x8000     // Bit mask of EOC15 field.
	ADC_ISR_EOC15      = 0x8000     // Bit EOC15.
	ADC_ISR_DRDY_Pos   = 0x18       // Position of DRDY field.
	ADC_ISR_DRDY_Msk   = 0x1000000  // Bit mask of DRDY field.
	ADC_ISR_DRDY       = 0x1000000  // Bit DRDY.
	ADC_ISR_GOVRE_Pos  = 0x19       // Position of GOVRE field.
	ADC_ISR_GOVRE_Msk  = 0x2000000  // Bit mask of GOVRE field.
	ADC_ISR_GOVRE      = 0x2000000  // Bit GOVRE.
	ADC_ISR_COMPE_Pos  = 0x1a       // Position of COMPE field.
	ADC_ISR_COMPE_Msk  = 0x4000000  // Bit mask of COMPE field.
	ADC_ISR_COMPE      = 0x4000000  // Bit COMPE.
	ADC_ISR_ENDRX_Pos  = 0x1b       // Position of ENDRX field.
	ADC_ISR_ENDRX_Msk  = 0x8000000  // Bit mask of ENDRX field.
	ADC_ISR_ENDRX      = 0x8000000  // Bit ENDRX.
	ADC_ISR_RXBUFF_Pos = 0x1c       // Position of RXBUFF field.
	ADC_ISR_RXBUFF_Msk = 0x10000000 // Bit mask of RXBUFF field.
	ADC_ISR_RXBUFF     = 0x10000000 // Bit RXBUFF.

	// OVER: Overrun Status Register
	ADC_OVER_OVRE0_Pos  = 0x0    // Position of OVRE0 field.
	ADC_OVER_OVRE0_Msk  = 0x1    // Bit mask of OVRE0 field.
	ADC_OVER_OVRE0      = 0x1    // Bit OVRE0.
	ADC_OVER_OVRE1_Pos  = 0x1    // Position of OVRE1 field.
	ADC_OVER_OVRE1_Msk  = 0x2    // Bit mask of OVRE1 field.
	ADC_OVER_OVRE1      = 0x2    // Bit OVRE1.
	ADC_OVER_OVRE2_Pos  = 0x2    // Position of OVRE2 field.
	ADC_OVER_OVRE2_Msk  = 0x4    // Bit mask of OVRE2 field.
	ADC_OVER_OVRE2      = 0x4    // Bit OVRE2.
	ADC_OVER_OVRE3_Pos  = 0x3    // Position of OVRE3 field.
	ADC_OVER_OVRE3_Msk  = 0x8    // Bit mask of OVRE3 field.
	ADC_OVER_OVRE3      = 0x8    // Bit OVRE3.
	ADC_OVER_OVRE4_Pos  = 0x4    // Position of OVRE4 field.
	ADC_OVER_OVRE4_Msk  = 0x10   // Bit mask of OVRE4 field.
	ADC_OVER_OVRE4      = 0x10   // Bit OVRE4.
	ADC_OVER_OVRE5_Pos  = 0x5    // Position of OVRE5 field.
	ADC_OVER_OVRE5_Msk  = 0x20   // Bit mask of OVRE5 field.
	ADC_OVER_OVRE5      = 0x20   // Bit OVRE5.
	ADC_OVER_OVRE6_Pos  = 0x6    // Position of OVRE6 field.
	ADC_OVER_OVRE6_Msk  = 0x40   // Bit mask of OVRE6 field.
	ADC_OVER_OVRE6      = 0x40   // Bit OVRE6.
	ADC_OVER_OVRE7_Pos  = 0x7    // Position of OVRE7 field.
	ADC_OVER_OVRE7_Msk  = 0x80   // Bit mask of OVRE7 field.
	ADC_OVER_OVRE7      = 0x80   // Bit OVRE7.
	ADC_OVER_OVRE8_Pos  = 0x8    // Position of OVRE8 field.
	ADC_OVER_OVRE8_Msk  = 0x100  // Bit mask of OVRE8 field.
	ADC_OVER_OVRE8      = 0x100  // Bit OVRE8.
	ADC_OVER_OVRE9_Pos  = 0x9    // Position of OVRE9 field.
	ADC_OVER_OVRE9_Msk  = 0x200  // Bit mask of OVRE9 field.
	ADC_OVER_OVRE9      = 0x200  // Bit OVRE9.
	ADC_OVER_OVRE10_Pos = 0xa    // Position of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400  // Bit mask of OVRE10 field.
	ADC_OVER_OVRE10     = 0x400  // Bit OVRE10.
	ADC_OVER_OVRE11_Pos = 0xb    // Position of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800  // Bit mask of OVRE11 field.
	ADC_OVER_OVRE11     = 0x800  // Bit OVRE11.
	ADC_OVER_OVRE12_Pos = 0xc    // Position of OVRE12 field.
	ADC_OVER_OVRE12_Msk = 0x1000 // Bit mask of OVRE12 field.
	ADC_OVER_OVRE12     = 0x1000 // Bit OVRE12.
	ADC_OVER_OVRE13_Pos = 0xd    // Position of OVRE13 field.
	ADC_OVER_OVRE13_Msk = 0x2000 // Bit mask of OVRE13 field.
	ADC_OVER_OVRE13     = 0x2000 // Bit OVRE13.
	ADC_OVER_OVRE14_Pos = 0xe    // Position of OVRE14 field.
	ADC_OVER_OVRE14_Msk = 0x4000 // Bit mask of OVRE14 field.
	ADC_OVER_OVRE14     = 0x4000 // Bit OVRE14.
	ADC_OVER_OVRE15_Pos = 0xf    // Position of OVRE15 field.
	ADC_OVER_OVRE15_Msk = 0x8000 // Bit mask of OVRE15 field.
	ADC_OVER_OVRE15     = 0x8000 // Bit OVRE15.

	// EMR: Extended Mode Register
	ADC_EMR_CMPMODE_Pos  = 0x0       // Position of CMPMODE field.
	ADC_EMR_CMPMODE_Msk  = 0x3       // Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_LOW  = 0x0       // Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1       // Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_IN   = 0x2       // Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_OUT  = 0x3       // Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPSEL_Pos   = 0x4       // Position of CMPSEL field.
	ADC_EMR_CMPSEL_Msk   = 0xf0      // Bit mask of CMPSEL field.
	ADC_EMR_CMPALL_Pos   = 0x9       // Position of CMPALL field.
	ADC_EMR_CMPALL_Msk   = 0x200     // Bit mask of CMPALL field.
	ADC_EMR_CMPALL       = 0x200     // Bit CMPALL.
	ADC_EMR_TAG_Pos      = 0x18      // Position of TAG field.
	ADC_EMR_TAG_Msk      = 0x1000000 // Bit mask of TAG field.
	ADC_EMR_TAG          = 0x1000000 // Bit TAG.

	// CWR: Compare Window Register
	ADC_CWR_LOWTHRES_Pos  = 0x0       // Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk  = 0xfff     // Bit mask of LOWTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10      // Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000 // Bit mask of HIGHTHRES field.

	// CDR: Channel Data Register
	ADC_CDR_DATA_Pos = 0x0   // Position of DATA field.
	ADC_CDR_DATA_Msk = 0xfff // Bit mask of DATA field.

	// WPMR: Write Protect Mode Register
	ADC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	ADC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	ADC_WPMR_WPEN      = 0x1        // Bit WPEN.
	ADC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	ADC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	ADC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	ADC_WPSR_WPVS       = 0x1      // Bit WPVS.
	ADC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.

	// RPR: Receive Pointer Register
	ADC_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	ADC_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// RNPR: Receive Next Pointer Register
	ADC_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	ADC_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// PTCR: Transfer Control Register
	ADC_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	ADC_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	ADC_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	ADC_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	ADC_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	ADC_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	ADC_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	ADC_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	ADC_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	ADC_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	ADC_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	ADC_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for DACC: Digital-to-Analog Converter Controller
const (
	// CR: Control Register
	DACC_CR_SWRST_Pos = 0x0 // Position of SWRST field.
	DACC_CR_SWRST_Msk = 0x1 // Bit mask of SWRST field.
	DACC_CR_SWRST     = 0x1 // Bit SWRST.

	// MR: Mode Register
	DACC_MR_TRGEN_Pos      = 0x0        // Position of TRGEN field.
	DACC_MR_TRGEN_Msk      = 0x1        // Bit mask of TRGEN field.
	DACC_MR_TRGEN          = 0x1        // Bit TRGEN.
	DACC_MR_TRGSEL_Pos     = 0x1        // Position of TRGSEL field.
	DACC_MR_TRGSEL_Msk     = 0xe        // Bit mask of TRGSEL field.
	DACC_MR_TRGSEL_TRGSEL0 = 0x0        // External trigger
	DACC_MR_TRGSEL_TRGSEL1 = 0x1        // TIO Output of the Timer Counter Channel 0
	DACC_MR_TRGSEL_TRGSEL2 = 0x2        // TIO Output of the Timer Counter Channel 1
	DACC_MR_TRGSEL_TRGSEL3 = 0x3        // TIO Output of the Timer Counter Channel 2
	DACC_MR_DACEN_Pos      = 0x4        // Position of DACEN field.
	DACC_MR_DACEN_Msk      = 0x10       // Bit mask of DACEN field.
	DACC_MR_DACEN          = 0x10       // Bit DACEN.
	DACC_MR_WORD_Pos       = 0x5        // Position of WORD field.
	DACC_MR_WORD_Msk       = 0x20       // Bit mask of WORD field.
	DACC_MR_WORD           = 0x20       // Bit WORD.
	DACC_MR_STARTUP_Pos    = 0x8        // Position of STARTUP field.
	DACC_MR_STARTUP_Msk    = 0xff00     // Bit mask of STARTUP field.
	DACC_MR_CLKDIV_Pos     = 0x10       // Position of CLKDIV field.
	DACC_MR_CLKDIV_Msk     = 0xffff0000 // Bit mask of CLKDIV field.

	// CDR: Conversion Data Register
	DACC_CDR_DATA_Pos = 0x0        // Position of DATA field.
	DACC_CDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// IER: Interrupt Enable Register
	DACC_IER_TXRDY_Pos  = 0x0 // Position of TXRDY field.
	DACC_IER_TXRDY_Msk  = 0x1 // Bit mask of TXRDY field.
	DACC_IER_TXRDY      = 0x1 // Bit TXRDY.
	DACC_IER_ENDTX_Pos  = 0x1 // Position of ENDTX field.
	DACC_IER_ENDTX_Msk  = 0x2 // Bit mask of ENDTX field.
	DACC_IER_ENDTX      = 0x2 // Bit ENDTX.
	DACC_IER_TXBUFE_Pos = 0x2 // Position of TXBUFE field.
	DACC_IER_TXBUFE_Msk = 0x4 // Bit mask of TXBUFE field.
	DACC_IER_TXBUFE     = 0x4 // Bit TXBUFE.

	// IDR: Interrupt Disable Register
	DACC_IDR_TXRDY_Pos  = 0x0 // Position of TXRDY field.
	DACC_IDR_TXRDY_Msk  = 0x1 // Bit mask of TXRDY field.
	DACC_IDR_TXRDY      = 0x1 // Bit TXRDY.
	DACC_IDR_ENDTX_Pos  = 0x1 // Position of ENDTX field.
	DACC_IDR_ENDTX_Msk  = 0x2 // Bit mask of ENDTX field.
	DACC_IDR_ENDTX      = 0x2 // Bit ENDTX.
	DACC_IDR_TXBUFE_Pos = 0x2 // Position of TXBUFE field.
	DACC_IDR_TXBUFE_Msk = 0x4 // Bit mask of TXBUFE field.
	DACC_IDR_TXBUFE     = 0x4 // Bit TXBUFE.

	// IMR: Interrupt Mask Register
	DACC_IMR_TXRDY_Pos  = 0x0 // Position of TXRDY field.
	DACC_IMR_TXRDY_Msk  = 0x1 // Bit mask of TXRDY field.
	DACC_IMR_TXRDY      = 0x1 // Bit TXRDY.
	DACC_IMR_ENDTX_Pos  = 0x1 // Position of ENDTX field.
	DACC_IMR_ENDTX_Msk  = 0x2 // Bit mask of ENDTX field.
	DACC_IMR_ENDTX      = 0x2 // Bit ENDTX.
	DACC_IMR_TXBUFE_Pos = 0x2 // Position of TXBUFE field.
	DACC_IMR_TXBUFE_Msk = 0x4 // Bit mask of TXBUFE field.
	DACC_IMR_TXBUFE     = 0x4 // Bit TXBUFE.

	// ISR: Interrupt Status Register
	DACC_ISR_TXRDY_Pos  = 0x0 // Position of TXRDY field.
	DACC_ISR_TXRDY_Msk  = 0x1 // Bit mask of TXRDY field.
	DACC_ISR_TXRDY      = 0x1 // Bit TXRDY.
	DACC_ISR_ENDTX_Pos  = 0x1 // Position of ENDTX field.
	DACC_ISR_ENDTX_Msk  = 0x2 // Bit mask of ENDTX field.
	DACC_ISR_ENDTX      = 0x2 // Bit ENDTX.
	DACC_ISR_TXBUFE_Pos = 0x2 // Position of TXBUFE field.
	DACC_ISR_TXBUFE_Msk = 0x4 // Bit mask of TXBUFE field.
	DACC_ISR_TXBUFE     = 0x4 // Bit TXBUFE.

	// WPMR: Write Protect Mode Register
	DACC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	DACC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	DACC_WPMR_WPEN      = 0x1        // Bit WPEN.
	DACC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	DACC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	DACC_WPSR_WPROTERR_Pos  = 0x0    // Position of WPROTERR field.
	DACC_WPSR_WPROTERR_Msk  = 0x1    // Bit mask of WPROTERR field.
	DACC_WPSR_WPROTERR      = 0x1    // Bit WPROTERR.
	DACC_WPSR_WPROTADDR_Pos = 0x8    // Position of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Msk = 0xff00 // Bit mask of WPROTADDR field.

	// TPR: Transmit Pointer Register
	DACC_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	DACC_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	DACC_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	DACC_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// TNPR: Transmit Next Pointer Register
	DACC_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	DACC_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	DACC_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	DACC_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	DACC_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	DACC_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	DACC_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	DACC_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	DACC_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	DACC_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	DACC_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	DACC_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	DACC_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	DACC_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	DACC_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	DACC_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	DACC_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	DACC_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	DACC_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	DACC_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	DACC_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	DACC_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	MATRIX_MATRIX_MCFG_ULBT_Pos = 0x0 // Position of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Msk = 0x7 // Bit mask of ULBT field.

	// MATRIX_SCFG: Slave Configuration Register
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos    = 0x0       // Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk    = 0xff      // Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos  = 0x10      // Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk  = 0x30000   // Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12      // Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000  // Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_ARBT_Pos          = 0x18      // Position of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Msk          = 0x3000000 // Bit mask of ARBT field.

	// MATRIX_PRAS0: Priority Register A for Slave 0
	MATRIX_MATRIX_PRAS0_M0PR_Pos = 0x0    // Position of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Msk = 0x3    // Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Pos = 0x4    // Position of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Msk = 0x30   // Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Pos = 0x8    // Position of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Msk = 0x300  // Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Pos = 0xc    // Position of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Msk = 0x3000 // Bit mask of M3PR field.

	// MATRIX_PRAS1: Priority Register A for Slave 1
	MATRIX_MATRIX_PRAS1_M0PR_Pos = 0x0    // Position of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Msk = 0x3    // Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Pos = 0x4    // Position of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Msk = 0x30   // Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Pos = 0x8    // Position of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Msk = 0x300  // Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Pos = 0xc    // Position of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Msk = 0x3000 // Bit mask of M3PR field.

	// MATRIX_PRAS2: Priority Register A for Slave 2
	MATRIX_MATRIX_PRAS2_M0PR_Pos = 0x0    // Position of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Msk = 0x3    // Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Pos = 0x4    // Position of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Msk = 0x30   // Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Pos = 0x8    // Position of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Msk = 0x300  // Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Pos = 0xc    // Position of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Msk = 0x3000 // Bit mask of M3PR field.

	// MATRIX_PRAS3: Priority Register A for Slave 3
	MATRIX_MATRIX_PRAS3_M0PR_Pos = 0x0    // Position of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Msk = 0x3    // Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Pos = 0x4    // Position of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Msk = 0x30   // Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Pos = 0x8    // Position of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Msk = 0x300  // Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Pos = 0xc    // Position of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Msk = 0x3000 // Bit mask of M3PR field.

	// CCFG_SYSIO: System I/O Configuration register
	MATRIX_CCFG_SYSIO_SYSIO4_Pos  = 0x4    // Position of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4_Msk  = 0x10   // Bit mask of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4      = 0x10   // Bit SYSIO4.
	MATRIX_CCFG_SYSIO_SYSIO5_Pos  = 0x5    // Position of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5_Msk  = 0x20   // Bit mask of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5      = 0x20   // Bit SYSIO5.
	MATRIX_CCFG_SYSIO_SYSIO6_Pos  = 0x6    // Position of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6_Msk  = 0x40   // Bit mask of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6      = 0x40   // Bit SYSIO6.
	MATRIX_CCFG_SYSIO_SYSIO7_Pos  = 0x7    // Position of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7_Msk  = 0x80   // Bit mask of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7      = 0x80   // Bit SYSIO7.
	MATRIX_CCFG_SYSIO_SYSIO12_Pos = 0xc    // Position of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Msk = 0x1000 // Bit mask of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12     = 0x1000 // Bit SYSIO12.

	// MATRIX_WPMR: Write Protect Mode Register
	MATRIX_MATRIX_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN      = 0x1        // Bit WPEN.
	MATRIX_MATRIX_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// MATRIX_WPSR: Write Protect Status Register
	MATRIX_MATRIX_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS       = 0x1      // Bit WPVS.
	MATRIX_MATRIX_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	PMC_PMC_SCER_PCK0_Pos = 0x8   // Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0     = 0x100 // Bit PCK0.
	PMC_PMC_SCER_PCK1_Pos = 0x9   // Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1     = 0x200 // Bit PCK1.
	PMC_PMC_SCER_PCK2_Pos = 0xa   // Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400 // Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2     = 0x400 // Bit PCK2.

	// PMC_SCDR: System Clock Disable Register
	PMC_PMC_SCDR_PCK0_Pos = 0x8   // Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0     = 0x100 // Bit PCK0.
	PMC_PMC_SCDR_PCK1_Pos = 0x9   // Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1     = 0x200 // Bit PCK1.
	PMC_PMC_SCDR_PCK2_Pos = 0xa   // Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400 // Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2     = 0x400 // Bit PCK2.

	// PMC_SCSR: System Clock Status Register
	PMC_PMC_SCSR_PCK0_Pos = 0x8   // Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100 // Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0     = 0x100 // Bit PCK0.
	PMC_PMC_SCSR_PCK1_Pos = 0x9   // Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200 // Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1     = 0x200 // Bit PCK1.
	PMC_PMC_SCSR_PCK2_Pos = 0xa   // Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400 // Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2     = 0x400 // Bit PCK2.

	// PMC_PCER0: Peripheral Clock Enable Register 0
	PMC_PMC_PCER0_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCER0_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCER0_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCER0_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCER0_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCER0_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCER0_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCER0_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCER0_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCER0_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCER0_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCER0_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCER0_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCER0_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCER0_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCER0_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCER0_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCER0_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCER0_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCER0_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCER0_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCER0_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCER0_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCER0_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCER0_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCER0_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCER0_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCER0_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCER0_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCER0_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCER0_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCER0_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCER0_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCER0_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCER0_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCER0_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCER0_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCER0_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCER0_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCER0_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCER0_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCER0_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCER0_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCER0_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCER0_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCER0_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCER0_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCER0_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCER0_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCER0_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCER0_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCER0_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCER0_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCER0_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCER0_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCER0_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCER0_PID31     = 0x80000000 // Bit PID31.

	// PMC_PCDR0: Peripheral Clock Disable Register 0
	PMC_PMC_PCDR0_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCDR0_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCDR0_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCDR0_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCDR0_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCDR0_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCDR0_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCDR0_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCDR0_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCDR0_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCDR0_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCDR0_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCDR0_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCDR0_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCDR0_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCDR0_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCDR0_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCDR0_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCDR0_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCDR0_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCDR0_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCDR0_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCDR0_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCDR0_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCDR0_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCDR0_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCDR0_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCDR0_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCDR0_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCDR0_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCDR0_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCDR0_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCDR0_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCDR0_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCDR0_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCDR0_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCDR0_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCDR0_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCDR0_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCDR0_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCDR0_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCDR0_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCDR0_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCDR0_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCDR0_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCDR0_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCDR0_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCDR0_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCDR0_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCDR0_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCDR0_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCDR0_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCDR0_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCDR0_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCDR0_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCDR0_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCDR0_PID31     = 0x80000000 // Bit PID31.

	// PMC_PCSR0: Peripheral Clock Status Register 0
	PMC_PMC_PCSR0_PID9_Pos  = 0x9        // Position of PID9 field.
	PMC_PMC_PCSR0_PID9_Msk  = 0x200      // Bit mask of PID9 field.
	PMC_PMC_PCSR0_PID9      = 0x200      // Bit PID9.
	PMC_PMC_PCSR0_PID10_Pos = 0xa        // Position of PID10 field.
	PMC_PMC_PCSR0_PID10_Msk = 0x400      // Bit mask of PID10 field.
	PMC_PMC_PCSR0_PID10     = 0x400      // Bit PID10.
	PMC_PMC_PCSR0_PID11_Pos = 0xb        // Position of PID11 field.
	PMC_PMC_PCSR0_PID11_Msk = 0x800      // Bit mask of PID11 field.
	PMC_PMC_PCSR0_PID11     = 0x800      // Bit PID11.
	PMC_PMC_PCSR0_PID12_Pos = 0xc        // Position of PID12 field.
	PMC_PMC_PCSR0_PID12_Msk = 0x1000     // Bit mask of PID12 field.
	PMC_PMC_PCSR0_PID12     = 0x1000     // Bit PID12.
	PMC_PMC_PCSR0_PID13_Pos = 0xd        // Position of PID13 field.
	PMC_PMC_PCSR0_PID13_Msk = 0x2000     // Bit mask of PID13 field.
	PMC_PMC_PCSR0_PID13     = 0x2000     // Bit PID13.
	PMC_PMC_PCSR0_PID14_Pos = 0xe        // Position of PID14 field.
	PMC_PMC_PCSR0_PID14_Msk = 0x4000     // Bit mask of PID14 field.
	PMC_PMC_PCSR0_PID14     = 0x4000     // Bit PID14.
	PMC_PMC_PCSR0_PID15_Pos = 0xf        // Position of PID15 field.
	PMC_PMC_PCSR0_PID15_Msk = 0x8000     // Bit mask of PID15 field.
	PMC_PMC_PCSR0_PID15     = 0x8000     // Bit PID15.
	PMC_PMC_PCSR0_PID19_Pos = 0x13       // Position of PID19 field.
	PMC_PMC_PCSR0_PID19_Msk = 0x80000    // Bit mask of PID19 field.
	PMC_PMC_PCSR0_PID19     = 0x80000    // Bit PID19.
	PMC_PMC_PCSR0_PID20_Pos = 0x14       // Position of PID20 field.
	PMC_PMC_PCSR0_PID20_Msk = 0x100000   // Bit mask of PID20 field.
	PMC_PMC_PCSR0_PID20     = 0x100000   // Bit PID20.
	PMC_PMC_PCSR0_PID21_Pos = 0x15       // Position of PID21 field.
	PMC_PMC_PCSR0_PID21_Msk = 0x200000   // Bit mask of PID21 field.
	PMC_PMC_PCSR0_PID21     = 0x200000   // Bit PID21.
	PMC_PMC_PCSR0_PID23_Pos = 0x17       // Position of PID23 field.
	PMC_PMC_PCSR0_PID23_Msk = 0x800000   // Bit mask of PID23 field.
	PMC_PMC_PCSR0_PID23     = 0x800000   // Bit PID23.
	PMC_PMC_PCSR0_PID24_Pos = 0x18       // Position of PID24 field.
	PMC_PMC_PCSR0_PID24_Msk = 0x1000000  // Bit mask of PID24 field.
	PMC_PMC_PCSR0_PID24     = 0x1000000  // Bit PID24.
	PMC_PMC_PCSR0_PID25_Pos = 0x19       // Position of PID25 field.
	PMC_PMC_PCSR0_PID25_Msk = 0x2000000  // Bit mask of PID25 field.
	PMC_PMC_PCSR0_PID25     = 0x2000000  // Bit PID25.
	PMC_PMC_PCSR0_PID26_Pos = 0x1a       // Position of PID26 field.
	PMC_PMC_PCSR0_PID26_Msk = 0x4000000  // Bit mask of PID26 field.
	PMC_PMC_PCSR0_PID26     = 0x4000000  // Bit PID26.
	PMC_PMC_PCSR0_PID27_Pos = 0x1b       // Position of PID27 field.
	PMC_PMC_PCSR0_PID27_Msk = 0x8000000  // Bit mask of PID27 field.
	PMC_PMC_PCSR0_PID27     = 0x8000000  // Bit PID27.
	PMC_PMC_PCSR0_PID28_Pos = 0x1c       // Position of PID28 field.
	PMC_PMC_PCSR0_PID28_Msk = 0x10000000 // Bit mask of PID28 field.
	PMC_PMC_PCSR0_PID28     = 0x10000000 // Bit PID28.
	PMC_PMC_PCSR0_PID29_Pos = 0x1d       // Position of PID29 field.
	PMC_PMC_PCSR0_PID29_Msk = 0x20000000 // Bit mask of PID29 field.
	PMC_PMC_PCSR0_PID29     = 0x20000000 // Bit PID29.
	PMC_PMC_PCSR0_PID30_Pos = 0x1e       // Position of PID30 field.
	PMC_PMC_PCSR0_PID30_Msk = 0x40000000 // Bit mask of PID30 field.
	PMC_PMC_PCSR0_PID30     = 0x40000000 // Bit PID30.
	PMC_PMC_PCSR0_PID31_Pos = 0x1f       // Position of PID31 field.
	PMC_PMC_PCSR0_PID31_Msk = 0x80000000 // Bit mask of PID31 field.
	PMC_PMC_PCSR0_PID31     = 0x80000000 // Bit PID31.

	// CKGR_MOR: Main Oscillator Register
	PMC_CKGR_MOR_MOSCXTEN_Pos   = 0x0       // Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk   = 0x1       // Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN       = 0x1       // Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTBY_Pos   = 0x1       // Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk   = 0x2       // Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY       = 0x2       // Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCRCEN_Pos   = 0x3       // Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk   = 0x8       // Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN       = 0x8       // Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCF_Pos    = 0x4       // Position of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Msk    = 0x70      // Bit mask of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_4_MHz  = 0x0       // The Fast RC Oscillator Frequency is at 4 MHz (default)
	PMC_CKGR_MOR_MOSCRCF_8_MHz  = 0x1       // The Fast RC Oscillator Frequency is at 8 MHz
	PMC_CKGR_MOR_MOSCRCF_12_MHz = 0x2       // The Fast RC Oscillator Frequency is at 12 MHz
	PMC_CKGR_MOR_MOSCXTST_Pos   = 0x8       // Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk   = 0xff00    // Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_KEY_Pos        = 0x10      // Position of KEY field.
	PMC_CKGR_MOR_KEY_Msk        = 0xff0000  // Bit mask of KEY field.
	PMC_CKGR_MOR_MOSCSEL_Pos    = 0x18      // Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk    = 0x1000000 // Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL        = 0x1000000 // Bit MOSCSEL.
	PMC_CKGR_MOR_CFDEN_Pos      = 0x19      // Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk      = 0x2000000 // Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN          = 0x2000000 // Bit CFDEN.

	// CKGR_MCFR: Main Clock Frequency Register
	PMC_CKGR_MCFR_MAINF_Pos    = 0x0     // Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk    = 0xffff  // Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10    // Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000 // Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY     = 0x10000 // Bit MAINFRDY.

	// CKGR_PLLAR: PLLA Register
	PMC_CKGR_PLLAR_DIVA_Pos      = 0x0        // Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk      = 0xff       // Bit mask of DIVA field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8        // Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00     // Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_MULA_Pos      = 0x10       // Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk      = 0x7ff0000  // Bit mask of MULA field.
	PMC_CKGR_PLLAR_ONE_Pos       = 0x1d       // Position of ONE field.
	PMC_CKGR_PLLAR_ONE_Msk       = 0x20000000 // Bit mask of ONE field.
	PMC_CKGR_PLLAR_ONE           = 0x20000000 // Bit ONE.

	// PMC_MCKR: Master Clock Register
	PMC_PMC_MCKR_CSS_Pos      = 0x0    // Position of CSS field.
	PMC_PMC_MCKR_CSS_Msk      = 0x3    // Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0    // Slow Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1    // Main Clock is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2    // PLLA Clock is selected
	PMC_PMC_MCKR_PRES_Pos     = 0x4    // Position of PRES field.
	PMC_PMC_MCKR_PRES_Msk     = 0x70   // Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_CLK_1   = 0x0    // Selected clock
	PMC_PMC_MCKR_PRES_CLK_2   = 0x1    // Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLK_4   = 0x2    // Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLK_8   = 0x3    // Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLK_16  = 0x4    // Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLK_32  = 0x5    // Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLK_64  = 0x6    // Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLK_3   = 0x7    // Selected clock divided by 3
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc    // Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000 // Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2     = 0x1000 // Bit PLLADIV2.

	// PMC_PCK: Programmable Clock 0 Register
	PMC_PMC_PCK_CSS_Pos      = 0x0  // Position of CSS field.
	PMC_PMC_PCK_CSS_Msk      = 0x7  // Bit mask of CSS field.
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0  // Slow Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1  // Main Clock is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2  // PLLA Clock is selected
	PMC_PMC_PCK_CSS_MCK      = 0x4  // Master Clock is selected
	PMC_PMC_PCK_PRES_Pos     = 0x4  // Position of PRES field.
	PMC_PMC_PCK_PRES_Msk     = 0x70 // Bit mask of PRES field.
	PMC_PMC_PCK_PRES_CLK_1   = 0x0  // Selected clock
	PMC_PMC_PCK_PRES_CLK_2   = 0x1  // Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLK_4   = 0x2  // Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLK_8   = 0x3  // Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLK_16  = 0x4  // Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLK_32  = 0x5  // Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLK_64  = 0x6  // Selected clock divided by 64

	// PMC_IER: Interrupt Enable Register
	PMC_PMC_IER_MOSCXTS_Pos  = 0x0     // Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk  = 0x1     // Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS      = 0x1     // Bit MOSCXTS.
	PMC_PMC_IER_LOCKA_Pos    = 0x1     // Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk    = 0x2     // Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA        = 0x2     // Bit LOCKA.
	PMC_PMC_IER_MCKRDY_Pos   = 0x3     // Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk   = 0x8     // Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY       = 0x8     // Bit MCKRDY.
	PMC_PMC_IER_PCKRDY0_Pos  = 0x8     // Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk  = 0x100   // Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0      = 0x100   // Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY1_Pos  = 0x9     // Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk  = 0x200   // Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1      = 0x200   // Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY2_Pos  = 0xa     // Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk  = 0x400   // Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2      = 0x400   // Bit PCKRDY2.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10    // Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000 // Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS     = 0x10000 // Bit MOSCSELS.
	PMC_PMC_IER_MOSCRCS_Pos  = 0x11    // Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk  = 0x20000 // Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS      = 0x20000 // Bit MOSCRCS.
	PMC_PMC_IER_CFDEV_Pos    = 0x12    // Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk    = 0x40000 // Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV        = 0x40000 // Bit CFDEV.

	// PMC_IDR: Interrupt Disable Register
	PMC_PMC_IDR_MOSCXTS_Pos  = 0x0     // Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk  = 0x1     // Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS      = 0x1     // Bit MOSCXTS.
	PMC_PMC_IDR_LOCKA_Pos    = 0x1     // Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk    = 0x2     // Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA        = 0x2     // Bit LOCKA.
	PMC_PMC_IDR_MCKRDY_Pos   = 0x3     // Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk   = 0x8     // Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY       = 0x8     // Bit MCKRDY.
	PMC_PMC_IDR_PCKRDY0_Pos  = 0x8     // Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk  = 0x100   // Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0      = 0x100   // Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY1_Pos  = 0x9     // Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk  = 0x200   // Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1      = 0x200   // Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY2_Pos  = 0xa     // Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk  = 0x400   // Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2      = 0x400   // Bit PCKRDY2.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10    // Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000 // Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS     = 0x10000 // Bit MOSCSELS.
	PMC_PMC_IDR_MOSCRCS_Pos  = 0x11    // Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk  = 0x20000 // Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS      = 0x20000 // Bit MOSCRCS.
	PMC_PMC_IDR_CFDEV_Pos    = 0x12    // Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk    = 0x40000 // Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV        = 0x40000 // Bit CFDEV.

	// PMC_SR: Status Register
	PMC_PMC_SR_MOSCXTS_Pos  = 0x0      // Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk  = 0x1      // Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS      = 0x1      // Bit MOSCXTS.
	PMC_PMC_SR_LOCKA_Pos    = 0x1      // Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk    = 0x2      // Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA        = 0x2      // Bit LOCKA.
	PMC_PMC_SR_MCKRDY_Pos   = 0x3      // Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk   = 0x8      // Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY       = 0x8      // Bit MCKRDY.
	PMC_PMC_SR_OSCSELS_Pos  = 0x7      // Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk  = 0x80     // Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS      = 0x80     // Bit OSCSELS.
	PMC_PMC_SR_PCKRDY0_Pos  = 0x8      // Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk  = 0x100    // Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0      = 0x100    // Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY1_Pos  = 0x9      // Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk  = 0x200    // Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1      = 0x200    // Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY2_Pos  = 0xa      // Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk  = 0x400    // Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2      = 0x400    // Bit PCKRDY2.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10     // Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000  // Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS     = 0x10000  // Bit MOSCSELS.
	PMC_PMC_SR_MOSCRCS_Pos  = 0x11     // Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk  = 0x20000  // Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS      = 0x20000  // Bit MOSCRCS.
	PMC_PMC_SR_CFDEV_Pos    = 0x12     // Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk    = 0x40000  // Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV        = 0x40000  // Bit CFDEV.
	PMC_PMC_SR_CFDS_Pos     = 0x13     // Position of CFDS field.
	PMC_PMC_SR_CFDS_Msk     = 0x80000  // Bit mask of CFDS field.
	PMC_PMC_SR_CFDS         = 0x80000  // Bit CFDS.
	PMC_PMC_SR_FOS_Pos      = 0x14     // Position of FOS field.
	PMC_PMC_SR_FOS_Msk      = 0x100000 // Bit mask of FOS field.
	PMC_PMC_SR_FOS          = 0x100000 // Bit FOS.

	// PMC_IMR: Interrupt Mask Register
	PMC_PMC_IMR_MOSCXTS_Pos  = 0x0     // Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk  = 0x1     // Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS      = 0x1     // Bit MOSCXTS.
	PMC_PMC_IMR_LOCKA_Pos    = 0x1     // Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk    = 0x2     // Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA        = 0x2     // Bit LOCKA.
	PMC_PMC_IMR_MCKRDY_Pos   = 0x3     // Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk   = 0x8     // Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY       = 0x8     // Bit MCKRDY.
	PMC_PMC_IMR_PCKRDY0_Pos  = 0x8     // Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk  = 0x100   // Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0      = 0x100   // Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY1_Pos  = 0x9     // Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk  = 0x200   // Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1      = 0x200   // Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY2_Pos  = 0xa     // Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk  = 0x400   // Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2      = 0x400   // Bit PCKRDY2.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10    // Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000 // Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS     = 0x10000 // Bit MOSCSELS.
	PMC_PMC_IMR_MOSCRCS_Pos  = 0x11    // Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk  = 0x20000 // Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS      = 0x20000 // Bit MOSCRCS.
	PMC_PMC_IMR_CFDEV_Pos    = 0x12    // Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk    = 0x40000 // Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV        = 0x40000 // Bit CFDEV.

	// PMC_FSMR: Fast Start-up Mode Register
	PMC_PMC_FSMR_FSTT0_Pos  = 0x0      // Position of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Msk  = 0x1      // Bit mask of FSTT0 field.
	PMC_PMC_FSMR_FSTT0      = 0x1      // Bit FSTT0.
	PMC_PMC_FSMR_FSTT1_Pos  = 0x1      // Position of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Msk  = 0x2      // Bit mask of FSTT1 field.
	PMC_PMC_FSMR_FSTT1      = 0x2      // Bit FSTT1.
	PMC_PMC_FSMR_FSTT2_Pos  = 0x2      // Position of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Msk  = 0x4      // Bit mask of FSTT2 field.
	PMC_PMC_FSMR_FSTT2      = 0x4      // Bit FSTT2.
	PMC_PMC_FSMR_FSTT3_Pos  = 0x3      // Position of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Msk  = 0x8      // Bit mask of FSTT3 field.
	PMC_PMC_FSMR_FSTT3      = 0x8      // Bit FSTT3.
	PMC_PMC_FSMR_FSTT4_Pos  = 0x4      // Position of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Msk  = 0x10     // Bit mask of FSTT4 field.
	PMC_PMC_FSMR_FSTT4      = 0x10     // Bit FSTT4.
	PMC_PMC_FSMR_FSTT5_Pos  = 0x5      // Position of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Msk  = 0x20     // Bit mask of FSTT5 field.
	PMC_PMC_FSMR_FSTT5      = 0x20     // Bit FSTT5.
	PMC_PMC_FSMR_FSTT6_Pos  = 0x6      // Position of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Msk  = 0x40     // Bit mask of FSTT6 field.
	PMC_PMC_FSMR_FSTT6      = 0x40     // Bit FSTT6.
	PMC_PMC_FSMR_FSTT7_Pos  = 0x7      // Position of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Msk  = 0x80     // Bit mask of FSTT7 field.
	PMC_PMC_FSMR_FSTT7      = 0x80     // Bit FSTT7.
	PMC_PMC_FSMR_FSTT8_Pos  = 0x8      // Position of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Msk  = 0x100    // Bit mask of FSTT8 field.
	PMC_PMC_FSMR_FSTT8      = 0x100    // Bit FSTT8.
	PMC_PMC_FSMR_FSTT9_Pos  = 0x9      // Position of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Msk  = 0x200    // Bit mask of FSTT9 field.
	PMC_PMC_FSMR_FSTT9      = 0x200    // Bit FSTT9.
	PMC_PMC_FSMR_FSTT10_Pos = 0xa      // Position of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Msk = 0x400    // Bit mask of FSTT10 field.
	PMC_PMC_FSMR_FSTT10     = 0x400    // Bit FSTT10.
	PMC_PMC_FSMR_FSTT11_Pos = 0xb      // Position of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Msk = 0x800    // Bit mask of FSTT11 field.
	PMC_PMC_FSMR_FSTT11     = 0x800    // Bit FSTT11.
	PMC_PMC_FSMR_FSTT12_Pos = 0xc      // Position of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Msk = 0x1000   // Bit mask of FSTT12 field.
	PMC_PMC_FSMR_FSTT12     = 0x1000   // Bit FSTT12.
	PMC_PMC_FSMR_FSTT13_Pos = 0xd      // Position of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Msk = 0x2000   // Bit mask of FSTT13 field.
	PMC_PMC_FSMR_FSTT13     = 0x2000   // Bit FSTT13.
	PMC_PMC_FSMR_FSTT14_Pos = 0xe      // Position of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Msk = 0x4000   // Bit mask of FSTT14 field.
	PMC_PMC_FSMR_FSTT14     = 0x4000   // Bit FSTT14.
	PMC_PMC_FSMR_FSTT15_Pos = 0xf      // Position of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Msk = 0x8000   // Bit mask of FSTT15 field.
	PMC_PMC_FSMR_FSTT15     = 0x8000   // Bit FSTT15.
	PMC_PMC_FSMR_RTTAL_Pos  = 0x10     // Position of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Msk  = 0x10000  // Bit mask of RTTAL field.
	PMC_PMC_FSMR_RTTAL      = 0x10000  // Bit RTTAL.
	PMC_PMC_FSMR_RTCAL_Pos  = 0x11     // Position of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Msk  = 0x20000  // Bit mask of RTCAL field.
	PMC_PMC_FSMR_RTCAL      = 0x20000  // Bit RTCAL.
	PMC_PMC_FSMR_LPM_Pos    = 0x14     // Position of LPM field.
	PMC_PMC_FSMR_LPM_Msk    = 0x100000 // Bit mask of LPM field.
	PMC_PMC_FSMR_LPM        = 0x100000 // Bit LPM.

	// PMC_FSPR: Fast Start-up Polarity Register
	PMC_PMC_FSPR_FSTP0_Pos  = 0x0    // Position of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Msk  = 0x1    // Bit mask of FSTP0 field.
	PMC_PMC_FSPR_FSTP0      = 0x1    // Bit FSTP0.
	PMC_PMC_FSPR_FSTP1_Pos  = 0x1    // Position of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Msk  = 0x2    // Bit mask of FSTP1 field.
	PMC_PMC_FSPR_FSTP1      = 0x2    // Bit FSTP1.
	PMC_PMC_FSPR_FSTP2_Pos  = 0x2    // Position of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Msk  = 0x4    // Bit mask of FSTP2 field.
	PMC_PMC_FSPR_FSTP2      = 0x4    // Bit FSTP2.
	PMC_PMC_FSPR_FSTP3_Pos  = 0x3    // Position of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Msk  = 0x8    // Bit mask of FSTP3 field.
	PMC_PMC_FSPR_FSTP3      = 0x8    // Bit FSTP3.
	PMC_PMC_FSPR_FSTP4_Pos  = 0x4    // Position of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Msk  = 0x10   // Bit mask of FSTP4 field.
	PMC_PMC_FSPR_FSTP4      = 0x10   // Bit FSTP4.
	PMC_PMC_FSPR_FSTP5_Pos  = 0x5    // Position of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Msk  = 0x20   // Bit mask of FSTP5 field.
	PMC_PMC_FSPR_FSTP5      = 0x20   // Bit FSTP5.
	PMC_PMC_FSPR_FSTP6_Pos  = 0x6    // Position of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Msk  = 0x40   // Bit mask of FSTP6 field.
	PMC_PMC_FSPR_FSTP6      = 0x40   // Bit FSTP6.
	PMC_PMC_FSPR_FSTP7_Pos  = 0x7    // Position of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Msk  = 0x80   // Bit mask of FSTP7 field.
	PMC_PMC_FSPR_FSTP7      = 0x80   // Bit FSTP7.
	PMC_PMC_FSPR_FSTP8_Pos  = 0x8    // Position of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Msk  = 0x100  // Bit mask of FSTP8 field.
	PMC_PMC_FSPR_FSTP8      = 0x100  // Bit FSTP8.
	PMC_PMC_FSPR_FSTP9_Pos  = 0x9    // Position of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Msk  = 0x200  // Bit mask of FSTP9 field.
	PMC_PMC_FSPR_FSTP9      = 0x200  // Bit FSTP9.
	PMC_PMC_FSPR_FSTP10_Pos = 0xa    // Position of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Msk = 0x400  // Bit mask of FSTP10 field.
	PMC_PMC_FSPR_FSTP10     = 0x400  // Bit FSTP10.
	PMC_PMC_FSPR_FSTP11_Pos = 0xb    // Position of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Msk = 0x800  // Bit mask of FSTP11 field.
	PMC_PMC_FSPR_FSTP11     = 0x800  // Bit FSTP11.
	PMC_PMC_FSPR_FSTP12_Pos = 0xc    // Position of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Msk = 0x1000 // Bit mask of FSTP12 field.
	PMC_PMC_FSPR_FSTP12     = 0x1000 // Bit FSTP12.
	PMC_PMC_FSPR_FSTP13_Pos = 0xd    // Position of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Msk = 0x2000 // Bit mask of FSTP13 field.
	PMC_PMC_FSPR_FSTP13     = 0x2000 // Bit FSTP13.
	PMC_PMC_FSPR_FSTP14_Pos = 0xe    // Position of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Msk = 0x4000 // Bit mask of FSTP14 field.
	PMC_PMC_FSPR_FSTP14     = 0x4000 // Bit FSTP14.
	PMC_PMC_FSPR_FSTP15_Pos = 0xf    // Position of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Msk = 0x8000 // Bit mask of FSTP15 field.
	PMC_PMC_FSPR_FSTP15     = 0x8000 // Bit FSTP15.

	// PMC_FOCR: Fault Output Clear Register
	PMC_PMC_FOCR_FOCLR_Pos = 0x0 // Position of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Msk = 0x1 // Bit mask of FOCLR field.
	PMC_PMC_FOCR_FOCLR     = 0x1 // Bit FOCLR.

	// PMC_WPMR: Write Protect Mode Register
	PMC_PMC_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN      = 0x1        // Bit WPEN.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// PMC_WPSR: Write Protect Status Register
	PMC_PMC_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS       = 0x1      // Bit WPVS.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.
)

// Bitfields for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	UART_CR_RSTRX_Pos  = 0x2   // Position of RSTRX field.
	UART_CR_RSTRX_Msk  = 0x4   // Bit mask of RSTRX field.
	UART_CR_RSTRX      = 0x4   // Bit RSTRX.
	UART_CR_RSTTX_Pos  = 0x3   // Position of RSTTX field.
	UART_CR_RSTTX_Msk  = 0x8   // Bit mask of RSTTX field.
	UART_CR_RSTTX      = 0x8   // Bit RSTTX.
	UART_CR_RXEN_Pos   = 0x4   // Position of RXEN field.
	UART_CR_RXEN_Msk   = 0x10  // Bit mask of RXEN field.
	UART_CR_RXEN       = 0x10  // Bit RXEN.
	UART_CR_RXDIS_Pos  = 0x5   // Position of RXDIS field.
	UART_CR_RXDIS_Msk  = 0x20  // Bit mask of RXDIS field.
	UART_CR_RXDIS      = 0x20  // Bit RXDIS.
	UART_CR_TXEN_Pos   = 0x6   // Position of TXEN field.
	UART_CR_TXEN_Msk   = 0x40  // Bit mask of TXEN field.
	UART_CR_TXEN       = 0x40  // Bit TXEN.
	UART_CR_TXDIS_Pos  = 0x7   // Position of TXDIS field.
	UART_CR_TXDIS_Msk  = 0x80  // Bit mask of TXDIS field.
	UART_CR_TXDIS      = 0x80  // Bit TXDIS.
	UART_CR_RSTSTA_Pos = 0x8   // Position of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100 // Bit mask of RSTSTA field.
	UART_CR_RSTSTA     = 0x100 // Bit RSTSTA.

	// MR: Mode Register
	UART_MR_PAR_Pos                = 0x9    // Position of PAR field.
	UART_MR_PAR_Msk                = 0xe00  // Bit mask of PAR field.
	UART_MR_PAR_EVEN               = 0x0    // Even parity
	UART_MR_PAR_ODD                = 0x1    // Odd parity
	UART_MR_PAR_SPACE              = 0x2    // Space: parity forced to 0
	UART_MR_PAR_MARK               = 0x3    // Mark: parity forced to 1
	UART_MR_PAR_NO                 = 0x4    // No parity
	UART_MR_CHMODE_Pos             = 0xe    // Position of CHMODE field.
	UART_MR_CHMODE_Msk             = 0xc000 // Bit mask of CHMODE field.
	UART_MR_CHMODE_NORMAL          = 0x0    // Normal Mode
	UART_MR_CHMODE_AUTOMATIC       = 0x1    // Automatic Echo
	UART_MR_CHMODE_LOCAL_LOOPBACK  = 0x2    // Local Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3    // Remote Loopback

	// IER: Interrupt Enable Register
	UART_IER_RXRDY_Pos   = 0x0    // Position of RXRDY field.
	UART_IER_RXRDY_Msk   = 0x1    // Bit mask of RXRDY field.
	UART_IER_RXRDY       = 0x1    // Bit RXRDY.
	UART_IER_TXRDY_Pos   = 0x1    // Position of TXRDY field.
	UART_IER_TXRDY_Msk   = 0x2    // Bit mask of TXRDY field.
	UART_IER_TXRDY       = 0x2    // Bit TXRDY.
	UART_IER_ENDRX_Pos   = 0x3    // Position of ENDRX field.
	UART_IER_ENDRX_Msk   = 0x8    // Bit mask of ENDRX field.
	UART_IER_ENDRX       = 0x8    // Bit ENDRX.
	UART_IER_ENDTX_Pos   = 0x4    // Position of ENDTX field.
	UART_IER_ENDTX_Msk   = 0x10   // Bit mask of ENDTX field.
	UART_IER_ENDTX       = 0x10   // Bit ENDTX.
	UART_IER_OVRE_Pos    = 0x5    // Position of OVRE field.
	UART_IER_OVRE_Msk    = 0x20   // Bit mask of OVRE field.
	UART_IER_OVRE        = 0x20   // Bit OVRE.
	UART_IER_FRAME_Pos   = 0x6    // Position of FRAME field.
	UART_IER_FRAME_Msk   = 0x40   // Bit mask of FRAME field.
	UART_IER_FRAME       = 0x40   // Bit FRAME.
	UART_IER_PARE_Pos    = 0x7    // Position of PARE field.
	UART_IER_PARE_Msk    = 0x80   // Bit mask of PARE field.
	UART_IER_PARE        = 0x80   // Bit PARE.
	UART_IER_TXEMPTY_Pos = 0x9    // Position of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200  // Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY     = 0x200  // Bit TXEMPTY.
	UART_IER_TXBUFE_Pos  = 0xb    // Position of TXBUFE field.
	UART_IER_TXBUFE_Msk  = 0x800  // Bit mask of TXBUFE field.
	UART_IER_TXBUFE      = 0x800  // Bit TXBUFE.
	UART_IER_RXBUFF_Pos  = 0xc    // Position of RXBUFF field.
	UART_IER_RXBUFF_Msk  = 0x1000 // Bit mask of RXBUFF field.
	UART_IER_RXBUFF      = 0x1000 // Bit RXBUFF.

	// IDR: Interrupt Disable Register
	UART_IDR_RXRDY_Pos   = 0x0    // Position of RXRDY field.
	UART_IDR_RXRDY_Msk   = 0x1    // Bit mask of RXRDY field.
	UART_IDR_RXRDY       = 0x1    // Bit RXRDY.
	UART_IDR_TXRDY_Pos   = 0x1    // Position of TXRDY field.
	UART_IDR_TXRDY_Msk   = 0x2    // Bit mask of TXRDY field.
	UART_IDR_TXRDY       = 0x2    // Bit TXRDY.
	UART_IDR_ENDRX_Pos   = 0x3    // Position of ENDRX field.
	UART_IDR_ENDRX_Msk   = 0x8    // Bit mask of ENDRX field.
	UART_IDR_ENDRX       = 0x8    // Bit ENDRX.
	UART_IDR_ENDTX_Pos   = 0x4    // Position of ENDTX field.
	UART_IDR_ENDTX_Msk   = 0x10   // Bit mask of ENDTX field.
	UART_IDR_ENDTX       = 0x10   // Bit ENDTX.
	UART_IDR_OVRE_Pos    = 0x5    // Position of OVRE field.
	UART_IDR_OVRE_Msk    = 0x20   // Bit mask of OVRE field.
	UART_IDR_OVRE        = 0x20   // Bit OVRE.
	UART_IDR_FRAME_Pos   = 0x6    // Position of FRAME field.
	UART_IDR_FRAME_Msk   = 0x40   // Bit mask of FRAME field.
	UART_IDR_FRAME       = 0x40   // Bit FRAME.
	UART_IDR_PARE_Pos    = 0x7    // Position of PARE field.
	UART_IDR_PARE_Msk    = 0x80   // Bit mask of PARE field.
	UART_IDR_PARE        = 0x80   // Bit PARE.
	UART_IDR_TXEMPTY_Pos = 0x9    // Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200  // Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY     = 0x200  // Bit TXEMPTY.
	UART_IDR_TXBUFE_Pos  = 0xb    // Position of TXBUFE field.
	UART_IDR_TXBUFE_Msk  = 0x800  // Bit mask of TXBUFE field.
	UART_IDR_TXBUFE      = 0x800  // Bit TXBUFE.
	UART_IDR_RXBUFF_Pos  = 0xc    // Position of RXBUFF field.
	UART_IDR_RXBUFF_Msk  = 0x1000 // Bit mask of RXBUFF field.
	UART_IDR_RXBUFF      = 0x1000 // Bit RXBUFF.

	// IMR: Interrupt Mask Register
	UART_IMR_RXRDY_Pos   = 0x0    // Position of RXRDY field.
	UART_IMR_RXRDY_Msk   = 0x1    // Bit mask of RXRDY field.
	UART_IMR_RXRDY       = 0x1    // Bit RXRDY.
	UART_IMR_TXRDY_Pos   = 0x1    // Position of TXRDY field.
	UART_IMR_TXRDY_Msk   = 0x2    // Bit mask of TXRDY field.
	UART_IMR_TXRDY       = 0x2    // Bit TXRDY.
	UART_IMR_ENDRX_Pos   = 0x3    // Position of ENDRX field.
	UART_IMR_ENDRX_Msk   = 0x8    // Bit mask of ENDRX field.
	UART_IMR_ENDRX       = 0x8    // Bit ENDRX.
	UART_IMR_ENDTX_Pos   = 0x4    // Position of ENDTX field.
	UART_IMR_ENDTX_Msk   = 0x10   // Bit mask of ENDTX field.
	UART_IMR_ENDTX       = 0x10   // Bit ENDTX.
	UART_IMR_OVRE_Pos    = 0x5    // Position of OVRE field.
	UART_IMR_OVRE_Msk    = 0x20   // Bit mask of OVRE field.
	UART_IMR_OVRE        = 0x20   // Bit OVRE.
	UART_IMR_FRAME_Pos   = 0x6    // Position of FRAME field.
	UART_IMR_FRAME_Msk   = 0x40   // Bit mask of FRAME field.
	UART_IMR_FRAME       = 0x40   // Bit FRAME.
	UART_IMR_PARE_Pos    = 0x7    // Position of PARE field.
	UART_IMR_PARE_Msk    = 0x80   // Bit mask of PARE field.
	UART_IMR_PARE        = 0x80   // Bit PARE.
	UART_IMR_TXEMPTY_Pos = 0x9    // Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200  // Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY     = 0x200  // Bit TXEMPTY.
	UART_IMR_TXBUFE_Pos  = 0xb    // Position of TXBUFE field.
	UART_IMR_TXBUFE_Msk  = 0x800  // Bit mask of TXBUFE field.
	UART_IMR_TXBUFE      = 0x800  // Bit TXBUFE.
	UART_IMR_RXBUFF_Pos  = 0xc    // Position of RXBUFF field.
	UART_IMR_RXBUFF_Msk  = 0x1000 // Bit mask of RXBUFF field.
	UART_IMR_RXBUFF      = 0x1000 // Bit RXBUFF.

	// SR: Status Register
	UART_SR_RXRDY_Pos   = 0x0    // Position of RXRDY field.
	UART_SR_RXRDY_Msk   = 0x1    // Bit mask of RXRDY field.
	UART_SR_RXRDY       = 0x1    // Bit RXRDY.
	UART_SR_TXRDY_Pos   = 0x1    // Position of TXRDY field.
	UART_SR_TXRDY_Msk   = 0x2    // Bit mask of TXRDY field.
	UART_SR_TXRDY       = 0x2    // Bit TXRDY.
	UART_SR_ENDRX_Pos   = 0x3    // Position of ENDRX field.
	UART_SR_ENDRX_Msk   = 0x8    // Bit mask of ENDRX field.
	UART_SR_ENDRX       = 0x8    // Bit ENDRX.
	UART_SR_ENDTX_Pos   = 0x4    // Position of ENDTX field.
	UART_SR_ENDTX_Msk   = 0x10   // Bit mask of ENDTX field.
	UART_SR_ENDTX       = 0x10   // Bit ENDTX.
	UART_SR_OVRE_Pos    = 0x5    // Position of OVRE field.
	UART_SR_OVRE_Msk    = 0x20   // Bit mask of OVRE field.
	UART_SR_OVRE        = 0x20   // Bit OVRE.
	UART_SR_FRAME_Pos   = 0x6    // Position of FRAME field.
	UART_SR_FRAME_Msk   = 0x40   // Bit mask of FRAME field.
	UART_SR_FRAME       = 0x40   // Bit FRAME.
	UART_SR_PARE_Pos    = 0x7    // Position of PARE field.
	UART_SR_PARE_Msk    = 0x80   // Bit mask of PARE field.
	UART_SR_PARE        = 0x80   // Bit PARE.
	UART_SR_TXEMPTY_Pos = 0x9    // Position of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200  // Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY     = 0x200  // Bit TXEMPTY.
	UART_SR_TXBUFE_Pos  = 0xb    // Position of TXBUFE field.
	UART_SR_TXBUFE_Msk  = 0x800  // Bit mask of TXBUFE field.
	UART_SR_TXBUFE      = 0x800  // Bit TXBUFE.
	UART_SR_RXBUFF_Pos  = 0xc    // Position of RXBUFF field.
	UART_SR_RXBUFF_Msk  = 0x1000 // Bit mask of RXBUFF field.
	UART_SR_RXBUFF      = 0x1000 // Bit RXBUFF.

	// RHR: Receive Holding Register
	UART_RHR_RXCHR_Pos = 0x0  // Position of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff // Bit mask of RXCHR field.

	// THR: Transmit Holding Register
	UART_THR_TXCHR_Pos = 0x0  // Position of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff // Bit mask of TXCHR field.

	// BRGR: Baud Rate Generator Register
	UART_BRGR_CD_Pos = 0x0    // Position of CD field.
	UART_BRGR_CD_Msk = 0xffff // Bit mask of CD field.

	// RPR: Receive Pointer Register
	UART_RPR_RXPTR_Pos = 0x0        // Position of RXPTR field.
	UART_RPR_RXPTR_Msk = 0xffffffff // Bit mask of RXPTR field.

	// RCR: Receive Counter Register
	UART_RCR_RXCTR_Pos = 0x0    // Position of RXCTR field.
	UART_RCR_RXCTR_Msk = 0xffff // Bit mask of RXCTR field.

	// TPR: Transmit Pointer Register
	UART_TPR_TXPTR_Pos = 0x0        // Position of TXPTR field.
	UART_TPR_TXPTR_Msk = 0xffffffff // Bit mask of TXPTR field.

	// TCR: Transmit Counter Register
	UART_TCR_TXCTR_Pos = 0x0    // Position of TXCTR field.
	UART_TCR_TXCTR_Msk = 0xffff // Bit mask of TXCTR field.

	// RNPR: Receive Next Pointer Register
	UART_RNPR_RXNPTR_Pos = 0x0        // Position of RXNPTR field.
	UART_RNPR_RXNPTR_Msk = 0xffffffff // Bit mask of RXNPTR field.

	// RNCR: Receive Next Counter Register
	UART_RNCR_RXNCTR_Pos = 0x0    // Position of RXNCTR field.
	UART_RNCR_RXNCTR_Msk = 0xffff // Bit mask of RXNCTR field.

	// TNPR: Transmit Next Pointer Register
	UART_TNPR_TXNPTR_Pos = 0x0        // Position of TXNPTR field.
	UART_TNPR_TXNPTR_Msk = 0xffffffff // Bit mask of TXNPTR field.

	// TNCR: Transmit Next Counter Register
	UART_TNCR_TXNCTR_Pos = 0x0    // Position of TXNCTR field.
	UART_TNCR_TXNCTR_Msk = 0xffff // Bit mask of TXNCTR field.

	// PTCR: Transfer Control Register
	UART_PTCR_RXTEN_Pos  = 0x0   // Position of RXTEN field.
	UART_PTCR_RXTEN_Msk  = 0x1   // Bit mask of RXTEN field.
	UART_PTCR_RXTEN      = 0x1   // Bit RXTEN.
	UART_PTCR_RXTDIS_Pos = 0x1   // Position of RXTDIS field.
	UART_PTCR_RXTDIS_Msk = 0x2   // Bit mask of RXTDIS field.
	UART_PTCR_RXTDIS     = 0x2   // Bit RXTDIS.
	UART_PTCR_TXTEN_Pos  = 0x8   // Position of TXTEN field.
	UART_PTCR_TXTEN_Msk  = 0x100 // Bit mask of TXTEN field.
	UART_PTCR_TXTEN      = 0x100 // Bit TXTEN.
	UART_PTCR_TXTDIS_Pos = 0x9   // Position of TXTDIS field.
	UART_PTCR_TXTDIS_Msk = 0x200 // Bit mask of TXTDIS field.
	UART_PTCR_TXTDIS     = 0x200 // Bit TXTDIS.

	// PTSR: Transfer Status Register
	UART_PTSR_RXTEN_Pos = 0x0   // Position of RXTEN field.
	UART_PTSR_RXTEN_Msk = 0x1   // Bit mask of RXTEN field.
	UART_PTSR_RXTEN     = 0x1   // Bit RXTEN.
	UART_PTSR_TXTEN_Pos = 0x8   // Position of TXTEN field.
	UART_PTSR_TXTEN_Msk = 0x100 // Bit mask of TXTEN field.
	UART_PTSR_TXTEN     = 0x100 // Bit TXTEN.
)

// Bitfields for CHIPID: Chip Identifier
const (
	// CIDR: Chip ID Register
	CHIPID_CIDR_VERSION_Pos       = 0x0        // Position of VERSION field.
	CHIPID_CIDR_VERSION_Msk       = 0x1f       // Bit mask of VERSION field.
	CHIPID_CIDR_EPROC_Pos         = 0x5        // Position of EPROC field.
	CHIPID_CIDR_EPROC_Msk         = 0xe0       // Bit mask of EPROC field.
	CHIPID_CIDR_EPROC_ARM946ES    = 0x1        // ARM946ES
	CHIPID_CIDR_EPROC_ARM7TDMI    = 0x2        // ARM7TDMI
	CHIPID_CIDR_EPROC_CM3         = 0x3        // Cortex-M3
	CHIPID_CIDR_EPROC_ARM920T     = 0x4        // ARM920T
	CHIPID_CIDR_EPROC_ARM926EJS   = 0x5        // ARM926EJS
	CHIPID_CIDR_EPROC_CA5         = 0x6        // Cortex-A5
	CHIPID_CIDR_EPROC_CM4         = 0x7        // Cortex-M4
	CHIPID_CIDR_NVPSIZ_Pos        = 0x8        // Position of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Msk        = 0xf00      // Bit mask of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_NONE       = 0x0        // None
	CHIPID_CIDR_NVPSIZ_8K         = 0x1        // 8K bytes
	CHIPID_CIDR_NVPSIZ_16K        = 0x2        // 16K bytes
	CHIPID_CIDR_NVPSIZ_32K        = 0x3        // 32K bytes
	CHIPID_CIDR_NVPSIZ_64K        = 0x5        // 64K bytes
	CHIPID_CIDR_NVPSIZ_128K       = 0x7        // 128K bytes
	CHIPID_CIDR_NVPSIZ_256K       = 0x9        // 256K bytes
	CHIPID_CIDR_NVPSIZ_512K       = 0xa        // 512K bytes
	CHIPID_CIDR_NVPSIZ_1024K      = 0xc        // 1024K bytes
	CHIPID_CIDR_NVPSIZ_2048K      = 0xe        // 2048K bytes
	CHIPID_CIDR_NVPSIZ2_Pos       = 0xc        // Position of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Msk       = 0xf000     // Bit mask of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_NONE      = 0x0        // None
	CHIPID_CIDR_NVPSIZ2_8K        = 0x1        // 8K bytes
	CHIPID_CIDR_NVPSIZ2_16K       = 0x2        // 16K bytes
	CHIPID_CIDR_NVPSIZ2_32K       = 0x3        // 32K bytes
	CHIPID_CIDR_NVPSIZ2_64K       = 0x5        // 64K bytes
	CHIPID_CIDR_NVPSIZ2_128K      = 0x7        // 128K bytes
	CHIPID_CIDR_NVPSIZ2_256K      = 0x9        // 256K bytes
	CHIPID_CIDR_NVPSIZ2_512K      = 0xa        // 512K bytes
	CHIPID_CIDR_NVPSIZ2_1024K     = 0xc        // 1024K bytes
	CHIPID_CIDR_NVPSIZ2_2048K     = 0xe        // 2048K bytes
	CHIPID_CIDR_SRAMSIZ_Pos       = 0x10       // Position of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Msk       = 0xf0000    // Bit mask of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_48K       = 0x0        // 48K bytes
	CHIPID_CIDR_SRAMSIZ_1K        = 0x1        // 1K bytes
	CHIPID_CIDR_SRAMSIZ_2K        = 0x2        // 2K bytes
	CHIPID_CIDR_SRAMSIZ_6K        = 0x3        // 6K bytes
	CHIPID_CIDR_SRAMSIZ_24K       = 0x4        // 24K bytes
	CHIPID_CIDR_SRAMSIZ_4K        = 0x5        // 4K bytes
	CHIPID_CIDR_SRAMSIZ_80K       = 0x6        // 80K bytes
	CHIPID_CIDR_SRAMSIZ_160K      = 0x7        // 160K bytes
	CHIPID_CIDR_SRAMSIZ_8K        = 0x8        // 8K bytes
	CHIPID_CIDR_SRAMSIZ_16K       = 0x9        // 16K bytes
	CHIPID_CIDR_SRAMSIZ_32K       = 0xa        // 32K bytes
	CHIPID_CIDR_SRAMSIZ_64K       = 0xb        // 64K bytes
	CHIPID_CIDR_SRAMSIZ_128K      = 0xc        // 128K bytes
	CHIPID_CIDR_SRAMSIZ_256K      = 0xd        // 256K bytes
	CHIPID_CIDR_SRAMSIZ_96K       = 0xe        // 96K bytes
	CHIPID_CIDR_SRAMSIZ_512K      = 0xf        // 512K bytes
	CHIPID_CIDR_ARCH_Pos          = 0x14       // Position of ARCH field.
	CHIPID_CIDR_ARCH_Msk          = 0xff00000  // Bit mask of ARCH field.
	CHIPID_CIDR_ARCH_AT91SAM9xx   = 0x19       // AT91SAM9xx Series
	CHIPID_CIDR_ARCH_AT91SAM9XExx = 0x29       // AT91SAM9XExx Series
	CHIPID_CIDR_ARCH_AT91x34      = 0x34       // AT91x34 Series
	CHIPID_CIDR_ARCH_CAP7         = 0x37       // CAP7 Series
	CHIPID_CIDR_ARCH_CAP9         = 0x39       // CAP9 Series
	CHIPID_CIDR_ARCH_CAP11        = 0x3b       // CAP11 Series
	CHIPID_CIDR_ARCH_AT91x40      = 0x40       // AT91x40 Series
	CHIPID_CIDR_ARCH_AT91x42      = 0x42       // AT91x42 Series
	CHIPID_CIDR_ARCH_AT91x55      = 0x55       // AT91x55 Series
	CHIPID_CIDR_ARCH_AT91SAM7Axx  = 0x60       // AT91SAM7Axx Series
	CHIPID_CIDR_ARCH_AT91SAM7AQxx = 0x61       // AT91SAM7AQxx Series
	CHIPID_CIDR_ARCH_AT91x63      = 0x63       // AT91x63 Series
	CHIPID_CIDR_ARCH_AT91SAM7Sxx  = 0x70       // AT91SAM7Sxx Series
	CHIPID_CIDR_ARCH_AT91SAM7XCxx = 0x71       // AT91SAM7XCxx Series
	CHIPID_CIDR_ARCH_AT91SAM7SExx = 0x72       // AT91SAM7SExx Series
	CHIPID_CIDR_ARCH_AT91SAM7Lxx  = 0x73       // AT91SAM7Lxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Xxx  = 0x75       // AT91SAM7Xxx Series
	CHIPID_CIDR_ARCH_AT91SAM7SLxx = 0x76       // AT91SAM7SLxx Series
	CHIPID_CIDR_ARCH_SAM3UxC      = 0x80       // SAM3UxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3UxE      = 0x81       // SAM3UxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3AxC      = 0x83       // SAM3AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4AxC      = 0x83       // SAM4AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxC      = 0x84       // SAM3XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4XxC      = 0x84       // SAM4XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxE      = 0x85       // SAM3XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM4XxE      = 0x85       // SAM4XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3XxG      = 0x86       // SAM3XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM4XxG      = 0x86       // SAM4XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM3SxA      = 0x88       // SAM3SxASeries (48-pin version)
	CHIPID_CIDR_ARCH_SAM4SxA      = 0x88       // SAM4SxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM3SxB      = 0x89       // SAM3SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM4SxB      = 0x89       // SAM4SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SxC      = 0x8a       // SAM3SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4SxC      = 0x8a       // SAM4SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_AT91x92      = 0x92       // AT91x92 Series
	CHIPID_CIDR_ARCH_SAM3NxA      = 0x93       // SAM3NxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM3NxB      = 0x94       // SAM3NxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3NxC      = 0x95       // SAM3NxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxB     = 0x99       // SAM3SDxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxC     = 0x9a       // SAM3SDxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM5A        = 0xa5       // SAM5A
	CHIPID_CIDR_ARCH_AT75Cxx      = 0xf0       // AT75Cxx Series
	CHIPID_CIDR_NVPTYP_Pos        = 0x1c       // Position of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Msk        = 0x70000000 // Bit mask of NVPTYP field.
	CHIPID_CIDR_NVPTYP_ROM        = 0x0        // ROM
	CHIPID_CIDR_NVPTYP_ROMLESS    = 0x1        // ROMless or on-chip Flash
	CHIPID_CIDR_NVPTYP_FLASH      = 0x2        // Embedded Flash Memory
	CHIPID_CIDR_NVPTYP_ROM_FLASH  = 0x3        // ROM and Embedded Flash MemoryNVPSIZ is ROM size      NVPSIZ2 is Flash size
	CHIPID_CIDR_NVPTYP_SRAM       = 0x4        // SRAM emulating ROM
	CHIPID_CIDR_EXT_Pos           = 0x1f       // Position of EXT field.
	CHIPID_CIDR_EXT_Msk           = 0x80000000 // Bit mask of EXT field.
	CHIPID_CIDR_EXT               = 0x80000000 // Bit EXT.

	// EXID: Chip ID Extension Register
	CHIPID_EXID_EXID_Pos = 0x0        // Position of EXID field.
	CHIPID_EXID_EXID_Msk = 0xffffffff // Bit mask of EXID field.
)

// Bitfields for EFC: Embedded Flash Controller
const (
	// FMR: EEFC Flash Mode Register
	EFC_FMR_FRDY_Pos = 0x0       // Position of FRDY field.
	EFC_FMR_FRDY_Msk = 0x1       // Bit mask of FRDY field.
	EFC_FMR_FRDY     = 0x1       // Bit FRDY.
	EFC_FMR_FWS_Pos  = 0x8       // Position of FWS field.
	EFC_FMR_FWS_Msk  = 0xf00     // Bit mask of FWS field.
	EFC_FMR_SCOD_Pos = 0x10      // Position of SCOD field.
	EFC_FMR_SCOD_Msk = 0x10000   // Bit mask of SCOD field.
	EFC_FMR_SCOD     = 0x10000   // Bit SCOD.
	EFC_FMR_FAM_Pos  = 0x18      // Position of FAM field.
	EFC_FMR_FAM_Msk  = 0x1000000 // Bit mask of FAM field.
	EFC_FMR_FAM      = 0x1000000 // Bit FAM.

	// FCR: EEFC Flash Command Register
	EFC_FCR_FCMD_Pos    = 0x0        // Position of FCMD field.
	EFC_FCR_FCMD_Msk    = 0xff       // Bit mask of FCMD field.
	EFC_FCR_FCMD_GETD   = 0x0        // Get Flash Descriptor
	EFC_FCR_FCMD_WP     = 0x1        // Write page
	EFC_FCR_FCMD_WPL    = 0x2        // Write page and lock
	EFC_FCR_FCMD_EWP    = 0x3        // Erase page and write page
	EFC_FCR_FCMD_EWPL   = 0x4        // Erase page and write page then lock
	EFC_FCR_FCMD_EA     = 0x5        // Erase all
	EFC_FCR_FCMD_SLB    = 0x8        // Set Lock Bit
	EFC_FCR_FCMD_CLB    = 0x9        // Clear Lock Bit
	EFC_FCR_FCMD_GLB    = 0xa        // Get Lock Bit
	EFC_FCR_FCMD_SGPB   = 0xb        // Set GPNVM Bit
	EFC_FCR_FCMD_CGPB   = 0xc        // Clear GPNVM Bit
	EFC_FCR_FCMD_GGPB   = 0xd        // Get GPNVM Bit
	EFC_FCR_FCMD_STUI   = 0xe        // Start Read Unique Identifier
	EFC_FCR_FCMD_SPUI   = 0xf        // Stop Read Unique Identifier
	EFC_FCR_FCMD_GCALB  = 0x10       // Get CALIB Bit
	EFC_FCR_FARG_Pos    = 0x8        // Position of FARG field.
	EFC_FCR_FARG_Msk    = 0xffff00   // Bit mask of FARG field.
	EFC_FCR_FKEY_Pos    = 0x18       // Position of FKEY field.
	EFC_FCR_FKEY_Msk    = 0xff000000 // Bit mask of FKEY field.
	EFC_FCR_FKEY_PASSWD = 0x5a       // The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started.

	// FSR: EEFC Flash Status Register
	EFC_FSR_FRDY_Pos   = 0x0 // Position of FRDY field.
	EFC_FSR_FRDY_Msk   = 0x1 // Bit mask of FRDY field.
	EFC_FSR_FRDY       = 0x1 // Bit FRDY.
	EFC_FSR_FCMDE_Pos  = 0x1 // Position of FCMDE field.
	EFC_FSR_FCMDE_Msk  = 0x2 // Bit mask of FCMDE field.
	EFC_FSR_FCMDE      = 0x2 // Bit FCMDE.
	EFC_FSR_FLOCKE_Pos = 0x2 // Position of FLOCKE field.
	EFC_FSR_FLOCKE_Msk = 0x4 // Bit mask of FLOCKE field.
	EFC_FSR_FLOCKE     = 0x4 // Bit FLOCKE.

	// FRR: EEFC Flash Result Register
	EFC_FRR_FVALUE_Pos = 0x0        // Position of FVALUE field.
	EFC_FRR_FVALUE_Msk = 0xffffffff // Bit mask of FVALUE field.
)

// Bitfields for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	PIO_PER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PER_P0      = 0x1        // Bit P0.
	PIO_PER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PER_P1      = 0x2        // Bit P1.
	PIO_PER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PER_P2      = 0x4        // Bit P2.
	PIO_PER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PER_P3      = 0x8        // Bit P3.
	PIO_PER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PER_P4      = 0x10       // Bit P4.
	PIO_PER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PER_P5      = 0x20       // Bit P5.
	PIO_PER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PER_P6      = 0x40       // Bit P6.
	PIO_PER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PER_P7      = 0x80       // Bit P7.
	PIO_PER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PER_P8      = 0x100      // Bit P8.
	PIO_PER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PER_P9      = 0x200      // Bit P9.
	PIO_PER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PER_P10     = 0x400      // Bit P10.
	PIO_PER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PER_P11     = 0x800      // Bit P11.
	PIO_PER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PER_P12     = 0x1000     // Bit P12.
	PIO_PER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PER_P13     = 0x2000     // Bit P13.
	PIO_PER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PER_P14     = 0x4000     // Bit P14.
	PIO_PER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PER_P15     = 0x8000     // Bit P15.
	PIO_PER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PER_P16     = 0x10000    // Bit P16.
	PIO_PER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PER_P17     = 0x20000    // Bit P17.
	PIO_PER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PER_P18     = 0x40000    // Bit P18.
	PIO_PER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PER_P19     = 0x80000    // Bit P19.
	PIO_PER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PER_P20     = 0x100000   // Bit P20.
	PIO_PER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PER_P21     = 0x200000   // Bit P21.
	PIO_PER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PER_P22     = 0x400000   // Bit P22.
	PIO_PER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PER_P23     = 0x800000   // Bit P23.
	PIO_PER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PER_P24     = 0x1000000  // Bit P24.
	PIO_PER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PER_P25     = 0x2000000  // Bit P25.
	PIO_PER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PER_P26     = 0x4000000  // Bit P26.
	PIO_PER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PER_P27     = 0x8000000  // Bit P27.
	PIO_PER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PER_P28     = 0x10000000 // Bit P28.
	PIO_PER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PER_P29     = 0x20000000 // Bit P29.
	PIO_PER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PER_P30     = 0x40000000 // Bit P30.
	PIO_PER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PER_P31     = 0x80000000 // Bit P31.

	// PDR: PIO Disable Register
	PIO_PDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PDR_P0      = 0x1        // Bit P0.
	PIO_PDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PDR_P1      = 0x2        // Bit P1.
	PIO_PDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PDR_P2      = 0x4        // Bit P2.
	PIO_PDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PDR_P3      = 0x8        // Bit P3.
	PIO_PDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PDR_P4      = 0x10       // Bit P4.
	PIO_PDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PDR_P5      = 0x20       // Bit P5.
	PIO_PDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PDR_P6      = 0x40       // Bit P6.
	PIO_PDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PDR_P7      = 0x80       // Bit P7.
	PIO_PDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PDR_P8      = 0x100      // Bit P8.
	PIO_PDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PDR_P9      = 0x200      // Bit P9.
	PIO_PDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PDR_P10     = 0x400      // Bit P10.
	PIO_PDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PDR_P11     = 0x800      // Bit P11.
	PIO_PDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PDR_P12     = 0x1000     // Bit P12.
	PIO_PDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PDR_P13     = 0x2000     // Bit P13.
	PIO_PDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PDR_P14     = 0x4000     // Bit P14.
	PIO_PDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PDR_P15     = 0x8000     // Bit P15.
	PIO_PDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PDR_P16     = 0x10000    // Bit P16.
	PIO_PDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PDR_P17     = 0x20000    // Bit P17.
	PIO_PDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PDR_P18     = 0x40000    // Bit P18.
	PIO_PDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PDR_P19     = 0x80000    // Bit P19.
	PIO_PDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PDR_P20     = 0x100000   // Bit P20.
	PIO_PDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PDR_P21     = 0x200000   // Bit P21.
	PIO_PDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PDR_P22     = 0x400000   // Bit P22.
	PIO_PDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PDR_P23     = 0x800000   // Bit P23.
	PIO_PDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PDR_P24     = 0x1000000  // Bit P24.
	PIO_PDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PDR_P25     = 0x2000000  // Bit P25.
	PIO_PDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PDR_P26     = 0x4000000  // Bit P26.
	PIO_PDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PDR_P27     = 0x8000000  // Bit P27.
	PIO_PDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PDR_P28     = 0x10000000 // Bit P28.
	PIO_PDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PDR_P29     = 0x20000000 // Bit P29.
	PIO_PDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PDR_P30     = 0x40000000 // Bit P30.
	PIO_PDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PDR_P31     = 0x80000000 // Bit P31.

	// PSR: PIO Status Register
	PIO_PSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PSR_P0      = 0x1        // Bit P0.
	PIO_PSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PSR_P1      = 0x2        // Bit P1.
	PIO_PSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PSR_P2      = 0x4        // Bit P2.
	PIO_PSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PSR_P3      = 0x8        // Bit P3.
	PIO_PSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PSR_P4      = 0x10       // Bit P4.
	PIO_PSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PSR_P5      = 0x20       // Bit P5.
	PIO_PSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PSR_P6      = 0x40       // Bit P6.
	PIO_PSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PSR_P7      = 0x80       // Bit P7.
	PIO_PSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PSR_P8      = 0x100      // Bit P8.
	PIO_PSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PSR_P9      = 0x200      // Bit P9.
	PIO_PSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PSR_P10     = 0x400      // Bit P10.
	PIO_PSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PSR_P11     = 0x800      // Bit P11.
	PIO_PSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PSR_P12     = 0x1000     // Bit P12.
	PIO_PSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PSR_P13     = 0x2000     // Bit P13.
	PIO_PSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PSR_P14     = 0x4000     // Bit P14.
	PIO_PSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PSR_P15     = 0x8000     // Bit P15.
	PIO_PSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PSR_P16     = 0x10000    // Bit P16.
	PIO_PSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PSR_P17     = 0x20000    // Bit P17.
	PIO_PSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PSR_P18     = 0x40000    // Bit P18.
	PIO_PSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PSR_P19     = 0x80000    // Bit P19.
	PIO_PSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PSR_P20     = 0x100000   // Bit P20.
	PIO_PSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PSR_P21     = 0x200000   // Bit P21.
	PIO_PSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PSR_P22     = 0x400000   // Bit P22.
	PIO_PSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PSR_P23     = 0x800000   // Bit P23.
	PIO_PSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PSR_P24     = 0x1000000  // Bit P24.
	PIO_PSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PSR_P25     = 0x2000000  // Bit P25.
	PIO_PSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PSR_P26     = 0x4000000  // Bit P26.
	PIO_PSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PSR_P27     = 0x8000000  // Bit P27.
	PIO_PSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PSR_P28     = 0x10000000 // Bit P28.
	PIO_PSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PSR_P29     = 0x20000000 // Bit P29.
	PIO_PSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PSR_P30     = 0x40000000 // Bit P30.
	PIO_PSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PSR_P31     = 0x80000000 // Bit P31.

	// OER: Output Enable Register
	PIO_OER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OER_P0      = 0x1        // Bit P0.
	PIO_OER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OER_P1      = 0x2        // Bit P1.
	PIO_OER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OER_P2      = 0x4        // Bit P2.
	PIO_OER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OER_P3      = 0x8        // Bit P3.
	PIO_OER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OER_P4      = 0x10       // Bit P4.
	PIO_OER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OER_P5      = 0x20       // Bit P5.
	PIO_OER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OER_P6      = 0x40       // Bit P6.
	PIO_OER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OER_P7      = 0x80       // Bit P7.
	PIO_OER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OER_P8      = 0x100      // Bit P8.
	PIO_OER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OER_P9      = 0x200      // Bit P9.
	PIO_OER_P10_Pos = 0xa        // Position of P10 field.
	PIO_OER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OER_P10     = 0x400      // Bit P10.
	PIO_OER_P11_Pos = 0xb        // Position of P11 field.
	PIO_OER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OER_P11     = 0x800      // Bit P11.
	PIO_OER_P12_Pos = 0xc        // Position of P12 field.
	PIO_OER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OER_P12     = 0x1000     // Bit P12.
	PIO_OER_P13_Pos = 0xd        // Position of P13 field.
	PIO_OER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OER_P13     = 0x2000     // Bit P13.
	PIO_OER_P14_Pos = 0xe        // Position of P14 field.
	PIO_OER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OER_P14     = 0x4000     // Bit P14.
	PIO_OER_P15_Pos = 0xf        // Position of P15 field.
	PIO_OER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OER_P15     = 0x8000     // Bit P15.
	PIO_OER_P16_Pos = 0x10       // Position of P16 field.
	PIO_OER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OER_P16     = 0x10000    // Bit P16.
	PIO_OER_P17_Pos = 0x11       // Position of P17 field.
	PIO_OER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OER_P17     = 0x20000    // Bit P17.
	PIO_OER_P18_Pos = 0x12       // Position of P18 field.
	PIO_OER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OER_P18     = 0x40000    // Bit P18.
	PIO_OER_P19_Pos = 0x13       // Position of P19 field.
	PIO_OER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OER_P19     = 0x80000    // Bit P19.
	PIO_OER_P20_Pos = 0x14       // Position of P20 field.
	PIO_OER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OER_P20     = 0x100000   // Bit P20.
	PIO_OER_P21_Pos = 0x15       // Position of P21 field.
	PIO_OER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OER_P21     = 0x200000   // Bit P21.
	PIO_OER_P22_Pos = 0x16       // Position of P22 field.
	PIO_OER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OER_P22     = 0x400000   // Bit P22.
	PIO_OER_P23_Pos = 0x17       // Position of P23 field.
	PIO_OER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OER_P23     = 0x800000   // Bit P23.
	PIO_OER_P24_Pos = 0x18       // Position of P24 field.
	PIO_OER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OER_P24     = 0x1000000  // Bit P24.
	PIO_OER_P25_Pos = 0x19       // Position of P25 field.
	PIO_OER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OER_P25     = 0x2000000  // Bit P25.
	PIO_OER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OER_P26     = 0x4000000  // Bit P26.
	PIO_OER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OER_P27     = 0x8000000  // Bit P27.
	PIO_OER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OER_P28     = 0x10000000 // Bit P28.
	PIO_OER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OER_P29     = 0x20000000 // Bit P29.
	PIO_OER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OER_P30     = 0x40000000 // Bit P30.
	PIO_OER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OER_P31     = 0x80000000 // Bit P31.

	// ODR: Output Disable Register
	PIO_ODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ODR_P0      = 0x1        // Bit P0.
	PIO_ODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ODR_P1      = 0x2        // Bit P1.
	PIO_ODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ODR_P2      = 0x4        // Bit P2.
	PIO_ODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ODR_P3      = 0x8        // Bit P3.
	PIO_ODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ODR_P4      = 0x10       // Bit P4.
	PIO_ODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ODR_P5      = 0x20       // Bit P5.
	PIO_ODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ODR_P6      = 0x40       // Bit P6.
	PIO_ODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ODR_P7      = 0x80       // Bit P7.
	PIO_ODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ODR_P8      = 0x100      // Bit P8.
	PIO_ODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ODR_P9      = 0x200      // Bit P9.
	PIO_ODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ODR_P10     = 0x400      // Bit P10.
	PIO_ODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ODR_P11     = 0x800      // Bit P11.
	PIO_ODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ODR_P12     = 0x1000     // Bit P12.
	PIO_ODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ODR_P13     = 0x2000     // Bit P13.
	PIO_ODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ODR_P14     = 0x4000     // Bit P14.
	PIO_ODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ODR_P15     = 0x8000     // Bit P15.
	PIO_ODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ODR_P16     = 0x10000    // Bit P16.
	PIO_ODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ODR_P17     = 0x20000    // Bit P17.
	PIO_ODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ODR_P18     = 0x40000    // Bit P18.
	PIO_ODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ODR_P19     = 0x80000    // Bit P19.
	PIO_ODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ODR_P20     = 0x100000   // Bit P20.
	PIO_ODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ODR_P21     = 0x200000   // Bit P21.
	PIO_ODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ODR_P22     = 0x400000   // Bit P22.
	PIO_ODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ODR_P23     = 0x800000   // Bit P23.
	PIO_ODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ODR_P24     = 0x1000000  // Bit P24.
	PIO_ODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ODR_P25     = 0x2000000  // Bit P25.
	PIO_ODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ODR_P26     = 0x4000000  // Bit P26.
	PIO_ODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ODR_P27     = 0x8000000  // Bit P27.
	PIO_ODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ODR_P28     = 0x10000000 // Bit P28.
	PIO_ODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ODR_P29     = 0x20000000 // Bit P29.
	PIO_ODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ODR_P30     = 0x40000000 // Bit P30.
	PIO_ODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ODR_P31     = 0x80000000 // Bit P31.

	// OSR: Output Status Register
	PIO_OSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OSR_P0      = 0x1        // Bit P0.
	PIO_OSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OSR_P1      = 0x2        // Bit P1.
	PIO_OSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OSR_P2      = 0x4        // Bit P2.
	PIO_OSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OSR_P3      = 0x8        // Bit P3.
	PIO_OSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OSR_P4      = 0x10       // Bit P4.
	PIO_OSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OSR_P5      = 0x20       // Bit P5.
	PIO_OSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OSR_P6      = 0x40       // Bit P6.
	PIO_OSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OSR_P7      = 0x80       // Bit P7.
	PIO_OSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OSR_P8      = 0x100      // Bit P8.
	PIO_OSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OSR_P9      = 0x200      // Bit P9.
	PIO_OSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OSR_P10     = 0x400      // Bit P10.
	PIO_OSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OSR_P11     = 0x800      // Bit P11.
	PIO_OSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OSR_P12     = 0x1000     // Bit P12.
	PIO_OSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OSR_P13     = 0x2000     // Bit P13.
	PIO_OSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OSR_P14     = 0x4000     // Bit P14.
	PIO_OSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OSR_P15     = 0x8000     // Bit P15.
	PIO_OSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OSR_P16     = 0x10000    // Bit P16.
	PIO_OSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OSR_P17     = 0x20000    // Bit P17.
	PIO_OSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OSR_P18     = 0x40000    // Bit P18.
	PIO_OSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OSR_P19     = 0x80000    // Bit P19.
	PIO_OSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OSR_P20     = 0x100000   // Bit P20.
	PIO_OSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OSR_P21     = 0x200000   // Bit P21.
	PIO_OSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OSR_P22     = 0x400000   // Bit P22.
	PIO_OSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OSR_P23     = 0x800000   // Bit P23.
	PIO_OSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OSR_P24     = 0x1000000  // Bit P24.
	PIO_OSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OSR_P25     = 0x2000000  // Bit P25.
	PIO_OSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OSR_P26     = 0x4000000  // Bit P26.
	PIO_OSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OSR_P27     = 0x8000000  // Bit P27.
	PIO_OSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OSR_P28     = 0x10000000 // Bit P28.
	PIO_OSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OSR_P29     = 0x20000000 // Bit P29.
	PIO_OSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OSR_P30     = 0x40000000 // Bit P30.
	PIO_OSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OSR_P31     = 0x80000000 // Bit P31.

	// IFER: Glitch Input Filter Enable Register
	PIO_IFER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFER_P0      = 0x1        // Bit P0.
	PIO_IFER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFER_P1      = 0x2        // Bit P1.
	PIO_IFER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFER_P2      = 0x4        // Bit P2.
	PIO_IFER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFER_P3      = 0x8        // Bit P3.
	PIO_IFER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFER_P4      = 0x10       // Bit P4.
	PIO_IFER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFER_P5      = 0x20       // Bit P5.
	PIO_IFER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFER_P6      = 0x40       // Bit P6.
	PIO_IFER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFER_P7      = 0x80       // Bit P7.
	PIO_IFER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFER_P8      = 0x100      // Bit P8.
	PIO_IFER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFER_P9      = 0x200      // Bit P9.
	PIO_IFER_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFER_P10     = 0x400      // Bit P10.
	PIO_IFER_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFER_P11     = 0x800      // Bit P11.
	PIO_IFER_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFER_P12     = 0x1000     // Bit P12.
	PIO_IFER_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFER_P13     = 0x2000     // Bit P13.
	PIO_IFER_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFER_P14     = 0x4000     // Bit P14.
	PIO_IFER_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFER_P15     = 0x8000     // Bit P15.
	PIO_IFER_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFER_P16     = 0x10000    // Bit P16.
	PIO_IFER_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFER_P17     = 0x20000    // Bit P17.
	PIO_IFER_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFER_P18     = 0x40000    // Bit P18.
	PIO_IFER_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFER_P19     = 0x80000    // Bit P19.
	PIO_IFER_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFER_P20     = 0x100000   // Bit P20.
	PIO_IFER_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFER_P21     = 0x200000   // Bit P21.
	PIO_IFER_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFER_P22     = 0x400000   // Bit P22.
	PIO_IFER_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFER_P23     = 0x800000   // Bit P23.
	PIO_IFER_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFER_P24     = 0x1000000  // Bit P24.
	PIO_IFER_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFER_P25     = 0x2000000  // Bit P25.
	PIO_IFER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFER_P26     = 0x4000000  // Bit P26.
	PIO_IFER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFER_P27     = 0x8000000  // Bit P27.
	PIO_IFER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFER_P28     = 0x10000000 // Bit P28.
	PIO_IFER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFER_P29     = 0x20000000 // Bit P29.
	PIO_IFER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFER_P30     = 0x40000000 // Bit P30.
	PIO_IFER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFER_P31     = 0x80000000 // Bit P31.

	// IFDR: Glitch Input Filter Disable Register
	PIO_IFDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFDR_P0      = 0x1        // Bit P0.
	PIO_IFDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFDR_P1      = 0x2        // Bit P1.
	PIO_IFDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFDR_P2      = 0x4        // Bit P2.
	PIO_IFDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFDR_P3      = 0x8        // Bit P3.
	PIO_IFDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFDR_P4      = 0x10       // Bit P4.
	PIO_IFDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFDR_P5      = 0x20       // Bit P5.
	PIO_IFDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFDR_P6      = 0x40       // Bit P6.
	PIO_IFDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFDR_P7      = 0x80       // Bit P7.
	PIO_IFDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFDR_P8      = 0x100      // Bit P8.
	PIO_IFDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFDR_P9      = 0x200      // Bit P9.
	PIO_IFDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFDR_P10     = 0x400      // Bit P10.
	PIO_IFDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFDR_P11     = 0x800      // Bit P11.
	PIO_IFDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFDR_P12     = 0x1000     // Bit P12.
	PIO_IFDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFDR_P13     = 0x2000     // Bit P13.
	PIO_IFDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFDR_P14     = 0x4000     // Bit P14.
	PIO_IFDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFDR_P15     = 0x8000     // Bit P15.
	PIO_IFDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFDR_P16     = 0x10000    // Bit P16.
	PIO_IFDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFDR_P17     = 0x20000    // Bit P17.
	PIO_IFDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFDR_P18     = 0x40000    // Bit P18.
	PIO_IFDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFDR_P19     = 0x80000    // Bit P19.
	PIO_IFDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFDR_P20     = 0x100000   // Bit P20.
	PIO_IFDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFDR_P21     = 0x200000   // Bit P21.
	PIO_IFDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFDR_P22     = 0x400000   // Bit P22.
	PIO_IFDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFDR_P23     = 0x800000   // Bit P23.
	PIO_IFDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFDR_P24     = 0x1000000  // Bit P24.
	PIO_IFDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFDR_P25     = 0x2000000  // Bit P25.
	PIO_IFDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFDR_P26     = 0x4000000  // Bit P26.
	PIO_IFDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFDR_P27     = 0x8000000  // Bit P27.
	PIO_IFDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFDR_P28     = 0x10000000 // Bit P28.
	PIO_IFDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFDR_P29     = 0x20000000 // Bit P29.
	PIO_IFDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFDR_P30     = 0x40000000 // Bit P30.
	PIO_IFDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFDR_P31     = 0x80000000 // Bit P31.

	// IFSR: Glitch Input Filter Status Register
	PIO_IFSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFSR_P0      = 0x1        // Bit P0.
	PIO_IFSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFSR_P1      = 0x2        // Bit P1.
	PIO_IFSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFSR_P2      = 0x4        // Bit P2.
	PIO_IFSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFSR_P3      = 0x8        // Bit P3.
	PIO_IFSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFSR_P4      = 0x10       // Bit P4.
	PIO_IFSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFSR_P5      = 0x20       // Bit P5.
	PIO_IFSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFSR_P6      = 0x40       // Bit P6.
	PIO_IFSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFSR_P7      = 0x80       // Bit P7.
	PIO_IFSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFSR_P8      = 0x100      // Bit P8.
	PIO_IFSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFSR_P9      = 0x200      // Bit P9.
	PIO_IFSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFSR_P10     = 0x400      // Bit P10.
	PIO_IFSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFSR_P11     = 0x800      // Bit P11.
	PIO_IFSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFSR_P12     = 0x1000     // Bit P12.
	PIO_IFSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFSR_P13     = 0x2000     // Bit P13.
	PIO_IFSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFSR_P14     = 0x4000     // Bit P14.
	PIO_IFSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFSR_P15     = 0x8000     // Bit P15.
	PIO_IFSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFSR_P16     = 0x10000    // Bit P16.
	PIO_IFSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFSR_P17     = 0x20000    // Bit P17.
	PIO_IFSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFSR_P18     = 0x40000    // Bit P18.
	PIO_IFSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFSR_P19     = 0x80000    // Bit P19.
	PIO_IFSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFSR_P20     = 0x100000   // Bit P20.
	PIO_IFSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFSR_P21     = 0x200000   // Bit P21.
	PIO_IFSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFSR_P22     = 0x400000   // Bit P22.
	PIO_IFSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFSR_P23     = 0x800000   // Bit P23.
	PIO_IFSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFSR_P24     = 0x1000000  // Bit P24.
	PIO_IFSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFSR_P25     = 0x2000000  // Bit P25.
	PIO_IFSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFSR_P26     = 0x4000000  // Bit P26.
	PIO_IFSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFSR_P27     = 0x8000000  // Bit P27.
	PIO_IFSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFSR_P28     = 0x10000000 // Bit P28.
	PIO_IFSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFSR_P29     = 0x20000000 // Bit P29.
	PIO_IFSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFSR_P30     = 0x40000000 // Bit P30.
	PIO_IFSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFSR_P31     = 0x80000000 // Bit P31.

	// SODR: Set Output Data Register
	PIO_SODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_SODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_SODR_P0      = 0x1        // Bit P0.
	PIO_SODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_SODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_SODR_P1      = 0x2        // Bit P1.
	PIO_SODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_SODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_SODR_P2      = 0x4        // Bit P2.
	PIO_SODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_SODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_SODR_P3      = 0x8        // Bit P3.
	PIO_SODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_SODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_SODR_P4      = 0x10       // Bit P4.
	PIO_SODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_SODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_SODR_P5      = 0x20       // Bit P5.
	PIO_SODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_SODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_SODR_P6      = 0x40       // Bit P6.
	PIO_SODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_SODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_SODR_P7      = 0x80       // Bit P7.
	PIO_SODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_SODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_SODR_P8      = 0x100      // Bit P8.
	PIO_SODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_SODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_SODR_P9      = 0x200      // Bit P9.
	PIO_SODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_SODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_SODR_P10     = 0x400      // Bit P10.
	PIO_SODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_SODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_SODR_P11     = 0x800      // Bit P11.
	PIO_SODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_SODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_SODR_P12     = 0x1000     // Bit P12.
	PIO_SODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_SODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_SODR_P13     = 0x2000     // Bit P13.
	PIO_SODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_SODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_SODR_P14     = 0x4000     // Bit P14.
	PIO_SODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_SODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_SODR_P15     = 0x8000     // Bit P15.
	PIO_SODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_SODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_SODR_P16     = 0x10000    // Bit P16.
	PIO_SODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_SODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_SODR_P17     = 0x20000    // Bit P17.
	PIO_SODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_SODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_SODR_P18     = 0x40000    // Bit P18.
	PIO_SODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_SODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_SODR_P19     = 0x80000    // Bit P19.
	PIO_SODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_SODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_SODR_P20     = 0x100000   // Bit P20.
	PIO_SODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_SODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_SODR_P21     = 0x200000   // Bit P21.
	PIO_SODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_SODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_SODR_P22     = 0x400000   // Bit P22.
	PIO_SODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_SODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_SODR_P23     = 0x800000   // Bit P23.
	PIO_SODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_SODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_SODR_P24     = 0x1000000  // Bit P24.
	PIO_SODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_SODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_SODR_P25     = 0x2000000  // Bit P25.
	PIO_SODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_SODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_SODR_P26     = 0x4000000  // Bit P26.
	PIO_SODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_SODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_SODR_P27     = 0x8000000  // Bit P27.
	PIO_SODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_SODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_SODR_P28     = 0x10000000 // Bit P28.
	PIO_SODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_SODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_SODR_P29     = 0x20000000 // Bit P29.
	PIO_SODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_SODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_SODR_P30     = 0x40000000 // Bit P30.
	PIO_SODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_SODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_SODR_P31     = 0x80000000 // Bit P31.

	// CODR: Clear Output Data Register
	PIO_CODR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_CODR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_CODR_P0      = 0x1        // Bit P0.
	PIO_CODR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_CODR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_CODR_P1      = 0x2        // Bit P1.
	PIO_CODR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_CODR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_CODR_P2      = 0x4        // Bit P2.
	PIO_CODR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_CODR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_CODR_P3      = 0x8        // Bit P3.
	PIO_CODR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_CODR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_CODR_P4      = 0x10       // Bit P4.
	PIO_CODR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_CODR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_CODR_P5      = 0x20       // Bit P5.
	PIO_CODR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_CODR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_CODR_P6      = 0x40       // Bit P6.
	PIO_CODR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_CODR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_CODR_P7      = 0x80       // Bit P7.
	PIO_CODR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_CODR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_CODR_P8      = 0x100      // Bit P8.
	PIO_CODR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_CODR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_CODR_P9      = 0x200      // Bit P9.
	PIO_CODR_P10_Pos = 0xa        // Position of P10 field.
	PIO_CODR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_CODR_P10     = 0x400      // Bit P10.
	PIO_CODR_P11_Pos = 0xb        // Position of P11 field.
	PIO_CODR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_CODR_P11     = 0x800      // Bit P11.
	PIO_CODR_P12_Pos = 0xc        // Position of P12 field.
	PIO_CODR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_CODR_P12     = 0x1000     // Bit P12.
	PIO_CODR_P13_Pos = 0xd        // Position of P13 field.
	PIO_CODR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_CODR_P13     = 0x2000     // Bit P13.
	PIO_CODR_P14_Pos = 0xe        // Position of P14 field.
	PIO_CODR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_CODR_P14     = 0x4000     // Bit P14.
	PIO_CODR_P15_Pos = 0xf        // Position of P15 field.
	PIO_CODR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_CODR_P15     = 0x8000     // Bit P15.
	PIO_CODR_P16_Pos = 0x10       // Position of P16 field.
	PIO_CODR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_CODR_P16     = 0x10000    // Bit P16.
	PIO_CODR_P17_Pos = 0x11       // Position of P17 field.
	PIO_CODR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_CODR_P17     = 0x20000    // Bit P17.
	PIO_CODR_P18_Pos = 0x12       // Position of P18 field.
	PIO_CODR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_CODR_P18     = 0x40000    // Bit P18.
	PIO_CODR_P19_Pos = 0x13       // Position of P19 field.
	PIO_CODR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_CODR_P19     = 0x80000    // Bit P19.
	PIO_CODR_P20_Pos = 0x14       // Position of P20 field.
	PIO_CODR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_CODR_P20     = 0x100000   // Bit P20.
	PIO_CODR_P21_Pos = 0x15       // Position of P21 field.
	PIO_CODR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_CODR_P21     = 0x200000   // Bit P21.
	PIO_CODR_P22_Pos = 0x16       // Position of P22 field.
	PIO_CODR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_CODR_P22     = 0x400000   // Bit P22.
	PIO_CODR_P23_Pos = 0x17       // Position of P23 field.
	PIO_CODR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_CODR_P23     = 0x800000   // Bit P23.
	PIO_CODR_P24_Pos = 0x18       // Position of P24 field.
	PIO_CODR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_CODR_P24     = 0x1000000  // Bit P24.
	PIO_CODR_P25_Pos = 0x19       // Position of P25 field.
	PIO_CODR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_CODR_P25     = 0x2000000  // Bit P25.
	PIO_CODR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_CODR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_CODR_P26     = 0x4000000  // Bit P26.
	PIO_CODR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_CODR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_CODR_P27     = 0x8000000  // Bit P27.
	PIO_CODR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_CODR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_CODR_P28     = 0x10000000 // Bit P28.
	PIO_CODR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_CODR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_CODR_P29     = 0x20000000 // Bit P29.
	PIO_CODR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_CODR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_CODR_P30     = 0x40000000 // Bit P30.
	PIO_CODR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_CODR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_CODR_P31     = 0x80000000 // Bit P31.

	// ODSR: Output Data Status Register
	PIO_ODSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ODSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ODSR_P0      = 0x1        // Bit P0.
	PIO_ODSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ODSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ODSR_P1      = 0x2        // Bit P1.
	PIO_ODSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ODSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ODSR_P2      = 0x4        // Bit P2.
	PIO_ODSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ODSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ODSR_P3      = 0x8        // Bit P3.
	PIO_ODSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ODSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ODSR_P4      = 0x10       // Bit P4.
	PIO_ODSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ODSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ODSR_P5      = 0x20       // Bit P5.
	PIO_ODSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ODSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ODSR_P6      = 0x40       // Bit P6.
	PIO_ODSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ODSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ODSR_P7      = 0x80       // Bit P7.
	PIO_ODSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ODSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ODSR_P8      = 0x100      // Bit P8.
	PIO_ODSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ODSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ODSR_P9      = 0x200      // Bit P9.
	PIO_ODSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ODSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ODSR_P10     = 0x400      // Bit P10.
	PIO_ODSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ODSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ODSR_P11     = 0x800      // Bit P11.
	PIO_ODSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ODSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ODSR_P12     = 0x1000     // Bit P12.
	PIO_ODSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ODSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ODSR_P13     = 0x2000     // Bit P13.
	PIO_ODSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ODSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ODSR_P14     = 0x4000     // Bit P14.
	PIO_ODSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ODSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ODSR_P15     = 0x8000     // Bit P15.
	PIO_ODSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ODSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ODSR_P16     = 0x10000    // Bit P16.
	PIO_ODSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ODSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ODSR_P17     = 0x20000    // Bit P17.
	PIO_ODSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ODSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ODSR_P18     = 0x40000    // Bit P18.
	PIO_ODSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ODSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ODSR_P19     = 0x80000    // Bit P19.
	PIO_ODSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ODSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ODSR_P20     = 0x100000   // Bit P20.
	PIO_ODSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ODSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ODSR_P21     = 0x200000   // Bit P21.
	PIO_ODSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ODSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ODSR_P22     = 0x400000   // Bit P22.
	PIO_ODSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ODSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ODSR_P23     = 0x800000   // Bit P23.
	PIO_ODSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ODSR_P24     = 0x1000000  // Bit P24.
	PIO_ODSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ODSR_P25     = 0x2000000  // Bit P25.
	PIO_ODSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ODSR_P26     = 0x4000000  // Bit P26.
	PIO_ODSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ODSR_P27     = 0x8000000  // Bit P27.
	PIO_ODSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ODSR_P28     = 0x10000000 // Bit P28.
	PIO_ODSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ODSR_P29     = 0x20000000 // Bit P29.
	PIO_ODSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ODSR_P30     = 0x40000000 // Bit P30.
	PIO_ODSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ODSR_P31     = 0x80000000 // Bit P31.

	// PDSR: Pin Data Status Register
	PIO_PDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PDSR_P0      = 0x1        // Bit P0.
	PIO_PDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PDSR_P1      = 0x2        // Bit P1.
	PIO_PDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PDSR_P2      = 0x4        // Bit P2.
	PIO_PDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PDSR_P3      = 0x8        // Bit P3.
	PIO_PDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PDSR_P4      = 0x10       // Bit P4.
	PIO_PDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PDSR_P5      = 0x20       // Bit P5.
	PIO_PDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PDSR_P6      = 0x40       // Bit P6.
	PIO_PDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PDSR_P7      = 0x80       // Bit P7.
	PIO_PDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PDSR_P8      = 0x100      // Bit P8.
	PIO_PDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PDSR_P9      = 0x200      // Bit P9.
	PIO_PDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PDSR_P10     = 0x400      // Bit P10.
	PIO_PDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PDSR_P11     = 0x800      // Bit P11.
	PIO_PDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PDSR_P12     = 0x1000     // Bit P12.
	PIO_PDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PDSR_P13     = 0x2000     // Bit P13.
	PIO_PDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PDSR_P14     = 0x4000     // Bit P14.
	PIO_PDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PDSR_P15     = 0x8000     // Bit P15.
	PIO_PDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PDSR_P16     = 0x10000    // Bit P16.
	PIO_PDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PDSR_P17     = 0x20000    // Bit P17.
	PIO_PDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PDSR_P18     = 0x40000    // Bit P18.
	PIO_PDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PDSR_P19     = 0x80000    // Bit P19.
	PIO_PDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PDSR_P20     = 0x100000   // Bit P20.
	PIO_PDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PDSR_P21     = 0x200000   // Bit P21.
	PIO_PDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PDSR_P22     = 0x400000   // Bit P22.
	PIO_PDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PDSR_P23     = 0x800000   // Bit P23.
	PIO_PDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PDSR_P24     = 0x1000000  // Bit P24.
	PIO_PDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PDSR_P25     = 0x2000000  // Bit P25.
	PIO_PDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PDSR_P26     = 0x4000000  // Bit P26.
	PIO_PDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PDSR_P27     = 0x8000000  // Bit P27.
	PIO_PDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PDSR_P28     = 0x10000000 // Bit P28.
	PIO_PDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PDSR_P29     = 0x20000000 // Bit P29.
	PIO_PDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PDSR_P30     = 0x40000000 // Bit P30.
	PIO_PDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PDSR_P31     = 0x80000000 // Bit P31.

	// IER: Interrupt Enable Register
	PIO_IER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IER_P0      = 0x1        // Bit P0.
	PIO_IER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IER_P1      = 0x2        // Bit P1.
	PIO_IER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IER_P2      = 0x4        // Bit P2.
	PIO_IER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IER_P3      = 0x8        // Bit P3.
	PIO_IER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IER_P4      = 0x10       // Bit P4.
	PIO_IER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IER_P5      = 0x20       // Bit P5.
	PIO_IER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IER_P6      = 0x40       // Bit P6.
	PIO_IER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IER_P7      = 0x80       // Bit P7.
	PIO_IER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IER_P8      = 0x100      // Bit P8.
	PIO_IER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IER_P9      = 0x200      // Bit P9.
	PIO_IER_P10_Pos = 0xa        // Position of P10 field.
	PIO_IER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IER_P10     = 0x400      // Bit P10.
	PIO_IER_P11_Pos = 0xb        // Position of P11 field.
	PIO_IER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IER_P11     = 0x800      // Bit P11.
	PIO_IER_P12_Pos = 0xc        // Position of P12 field.
	PIO_IER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IER_P12     = 0x1000     // Bit P12.
	PIO_IER_P13_Pos = 0xd        // Position of P13 field.
	PIO_IER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IER_P13     = 0x2000     // Bit P13.
	PIO_IER_P14_Pos = 0xe        // Position of P14 field.
	PIO_IER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IER_P14     = 0x4000     // Bit P14.
	PIO_IER_P15_Pos = 0xf        // Position of P15 field.
	PIO_IER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IER_P15     = 0x8000     // Bit P15.
	PIO_IER_P16_Pos = 0x10       // Position of P16 field.
	PIO_IER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IER_P16     = 0x10000    // Bit P16.
	PIO_IER_P17_Pos = 0x11       // Position of P17 field.
	PIO_IER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IER_P17     = 0x20000    // Bit P17.
	PIO_IER_P18_Pos = 0x12       // Position of P18 field.
	PIO_IER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IER_P18     = 0x40000    // Bit P18.
	PIO_IER_P19_Pos = 0x13       // Position of P19 field.
	PIO_IER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IER_P19     = 0x80000    // Bit P19.
	PIO_IER_P20_Pos = 0x14       // Position of P20 field.
	PIO_IER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IER_P20     = 0x100000   // Bit P20.
	PIO_IER_P21_Pos = 0x15       // Position of P21 field.
	PIO_IER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IER_P21     = 0x200000   // Bit P21.
	PIO_IER_P22_Pos = 0x16       // Position of P22 field.
	PIO_IER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IER_P22     = 0x400000   // Bit P22.
	PIO_IER_P23_Pos = 0x17       // Position of P23 field.
	PIO_IER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IER_P23     = 0x800000   // Bit P23.
	PIO_IER_P24_Pos = 0x18       // Position of P24 field.
	PIO_IER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IER_P24     = 0x1000000  // Bit P24.
	PIO_IER_P25_Pos = 0x19       // Position of P25 field.
	PIO_IER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IER_P25     = 0x2000000  // Bit P25.
	PIO_IER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IER_P26     = 0x4000000  // Bit P26.
	PIO_IER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IER_P27     = 0x8000000  // Bit P27.
	PIO_IER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IER_P28     = 0x10000000 // Bit P28.
	PIO_IER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IER_P29     = 0x20000000 // Bit P29.
	PIO_IER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IER_P30     = 0x40000000 // Bit P30.
	PIO_IER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IER_P31     = 0x80000000 // Bit P31.

	// IDR: Interrupt Disable Register
	PIO_IDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IDR_P0      = 0x1        // Bit P0.
	PIO_IDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IDR_P1      = 0x2        // Bit P1.
	PIO_IDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IDR_P2      = 0x4        // Bit P2.
	PIO_IDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IDR_P3      = 0x8        // Bit P3.
	PIO_IDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IDR_P4      = 0x10       // Bit P4.
	PIO_IDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IDR_P5      = 0x20       // Bit P5.
	PIO_IDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IDR_P6      = 0x40       // Bit P6.
	PIO_IDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IDR_P7      = 0x80       // Bit P7.
	PIO_IDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IDR_P8      = 0x100      // Bit P8.
	PIO_IDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IDR_P9      = 0x200      // Bit P9.
	PIO_IDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IDR_P10     = 0x400      // Bit P10.
	PIO_IDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IDR_P11     = 0x800      // Bit P11.
	PIO_IDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IDR_P12     = 0x1000     // Bit P12.
	PIO_IDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IDR_P13     = 0x2000     // Bit P13.
	PIO_IDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IDR_P14     = 0x4000     // Bit P14.
	PIO_IDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IDR_P15     = 0x8000     // Bit P15.
	PIO_IDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IDR_P16     = 0x10000    // Bit P16.
	PIO_IDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IDR_P17     = 0x20000    // Bit P17.
	PIO_IDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IDR_P18     = 0x40000    // Bit P18.
	PIO_IDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IDR_P19     = 0x80000    // Bit P19.
	PIO_IDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IDR_P20     = 0x100000   // Bit P20.
	PIO_IDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IDR_P21     = 0x200000   // Bit P21.
	PIO_IDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IDR_P22     = 0x400000   // Bit P22.
	PIO_IDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IDR_P23     = 0x800000   // Bit P23.
	PIO_IDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IDR_P24     = 0x1000000  // Bit P24.
	PIO_IDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IDR_P25     = 0x2000000  // Bit P25.
	PIO_IDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IDR_P26     = 0x4000000  // Bit P26.
	PIO_IDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IDR_P27     = 0x8000000  // Bit P27.
	PIO_IDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IDR_P28     = 0x10000000 // Bit P28.
	PIO_IDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IDR_P29     = 0x20000000 // Bit P29.
	PIO_IDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IDR_P30     = 0x40000000 // Bit P30.
	PIO_IDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IDR_P31     = 0x80000000 // Bit P31.

	// IMR: Interrupt Mask Register
	PIO_IMR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IMR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IMR_P0      = 0x1        // Bit P0.
	PIO_IMR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IMR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IMR_P1      = 0x2        // Bit P1.
	PIO_IMR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IMR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IMR_P2      = 0x4        // Bit P2.
	PIO_IMR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IMR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IMR_P3      = 0x8        // Bit P3.
	PIO_IMR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IMR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IMR_P4      = 0x10       // Bit P4.
	PIO_IMR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IMR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IMR_P5      = 0x20       // Bit P5.
	PIO_IMR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IMR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IMR_P6      = 0x40       // Bit P6.
	PIO_IMR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IMR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IMR_P7      = 0x80       // Bit P7.
	PIO_IMR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IMR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IMR_P8      = 0x100      // Bit P8.
	PIO_IMR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IMR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IMR_P9      = 0x200      // Bit P9.
	PIO_IMR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IMR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IMR_P10     = 0x400      // Bit P10.
	PIO_IMR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IMR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IMR_P11     = 0x800      // Bit P11.
	PIO_IMR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IMR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IMR_P12     = 0x1000     // Bit P12.
	PIO_IMR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IMR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IMR_P13     = 0x2000     // Bit P13.
	PIO_IMR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IMR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IMR_P14     = 0x4000     // Bit P14.
	PIO_IMR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IMR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IMR_P15     = 0x8000     // Bit P15.
	PIO_IMR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IMR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IMR_P16     = 0x10000    // Bit P16.
	PIO_IMR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IMR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IMR_P17     = 0x20000    // Bit P17.
	PIO_IMR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IMR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IMR_P18     = 0x40000    // Bit P18.
	PIO_IMR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IMR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IMR_P19     = 0x80000    // Bit P19.
	PIO_IMR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IMR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IMR_P20     = 0x100000   // Bit P20.
	PIO_IMR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IMR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IMR_P21     = 0x200000   // Bit P21.
	PIO_IMR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IMR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IMR_P22     = 0x400000   // Bit P22.
	PIO_IMR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IMR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IMR_P23     = 0x800000   // Bit P23.
	PIO_IMR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IMR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IMR_P24     = 0x1000000  // Bit P24.
	PIO_IMR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IMR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IMR_P25     = 0x2000000  // Bit P25.
	PIO_IMR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IMR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IMR_P26     = 0x4000000  // Bit P26.
	PIO_IMR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IMR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IMR_P27     = 0x8000000  // Bit P27.
	PIO_IMR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IMR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IMR_P28     = 0x10000000 // Bit P28.
	PIO_IMR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IMR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IMR_P29     = 0x20000000 // Bit P29.
	PIO_IMR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IMR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IMR_P30     = 0x40000000 // Bit P30.
	PIO_IMR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IMR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IMR_P31     = 0x80000000 // Bit P31.

	// ISR: Interrupt Status Register
	PIO_ISR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ISR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ISR_P0      = 0x1        // Bit P0.
	PIO_ISR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ISR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ISR_P1      = 0x2        // Bit P1.
	PIO_ISR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ISR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ISR_P2      = 0x4        // Bit P2.
	PIO_ISR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ISR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ISR_P3      = 0x8        // Bit P3.
	PIO_ISR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ISR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ISR_P4      = 0x10       // Bit P4.
	PIO_ISR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ISR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ISR_P5      = 0x20       // Bit P5.
	PIO_ISR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ISR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ISR_P6      = 0x40       // Bit P6.
	PIO_ISR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ISR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ISR_P7      = 0x80       // Bit P7.
	PIO_ISR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ISR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ISR_P8      = 0x100      // Bit P8.
	PIO_ISR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ISR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ISR_P9      = 0x200      // Bit P9.
	PIO_ISR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ISR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ISR_P10     = 0x400      // Bit P10.
	PIO_ISR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ISR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ISR_P11     = 0x800      // Bit P11.
	PIO_ISR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ISR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ISR_P12     = 0x1000     // Bit P12.
	PIO_ISR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ISR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ISR_P13     = 0x2000     // Bit P13.
	PIO_ISR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ISR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ISR_P14     = 0x4000     // Bit P14.
	PIO_ISR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ISR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ISR_P15     = 0x8000     // Bit P15.
	PIO_ISR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ISR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ISR_P16     = 0x10000    // Bit P16.
	PIO_ISR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ISR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ISR_P17     = 0x20000    // Bit P17.
	PIO_ISR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ISR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ISR_P18     = 0x40000    // Bit P18.
	PIO_ISR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ISR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ISR_P19     = 0x80000    // Bit P19.
	PIO_ISR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ISR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ISR_P20     = 0x100000   // Bit P20.
	PIO_ISR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ISR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ISR_P21     = 0x200000   // Bit P21.
	PIO_ISR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ISR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ISR_P22     = 0x400000   // Bit P22.
	PIO_ISR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ISR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ISR_P23     = 0x800000   // Bit P23.
	PIO_ISR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ISR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ISR_P24     = 0x1000000  // Bit P24.
	PIO_ISR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ISR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ISR_P25     = 0x2000000  // Bit P25.
	PIO_ISR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ISR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ISR_P26     = 0x4000000  // Bit P26.
	PIO_ISR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ISR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ISR_P27     = 0x8000000  // Bit P27.
	PIO_ISR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ISR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ISR_P28     = 0x10000000 // Bit P28.
	PIO_ISR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ISR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ISR_P29     = 0x20000000 // Bit P29.
	PIO_ISR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ISR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ISR_P30     = 0x40000000 // Bit P30.
	PIO_ISR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ISR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ISR_P31     = 0x80000000 // Bit P31.

	// MDER: Multi-driver Enable Register
	PIO_MDER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDER_P0      = 0x1        // Bit P0.
	PIO_MDER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDER_P1      = 0x2        // Bit P1.
	PIO_MDER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDER_P2      = 0x4        // Bit P2.
	PIO_MDER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDER_P3      = 0x8        // Bit P3.
	PIO_MDER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDER_P4      = 0x10       // Bit P4.
	PIO_MDER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDER_P5      = 0x20       // Bit P5.
	PIO_MDER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDER_P6      = 0x40       // Bit P6.
	PIO_MDER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDER_P7      = 0x80       // Bit P7.
	PIO_MDER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDER_P8      = 0x100      // Bit P8.
	PIO_MDER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDER_P9      = 0x200      // Bit P9.
	PIO_MDER_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDER_P10     = 0x400      // Bit P10.
	PIO_MDER_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDER_P11     = 0x800      // Bit P11.
	PIO_MDER_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDER_P12     = 0x1000     // Bit P12.
	PIO_MDER_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDER_P13     = 0x2000     // Bit P13.
	PIO_MDER_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDER_P14     = 0x4000     // Bit P14.
	PIO_MDER_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDER_P15     = 0x8000     // Bit P15.
	PIO_MDER_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDER_P16     = 0x10000    // Bit P16.
	PIO_MDER_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDER_P17     = 0x20000    // Bit P17.
	PIO_MDER_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDER_P18     = 0x40000    // Bit P18.
	PIO_MDER_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDER_P19     = 0x80000    // Bit P19.
	PIO_MDER_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDER_P20     = 0x100000   // Bit P20.
	PIO_MDER_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDER_P21     = 0x200000   // Bit P21.
	PIO_MDER_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDER_P22     = 0x400000   // Bit P22.
	PIO_MDER_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDER_P23     = 0x800000   // Bit P23.
	PIO_MDER_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDER_P24     = 0x1000000  // Bit P24.
	PIO_MDER_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDER_P25     = 0x2000000  // Bit P25.
	PIO_MDER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDER_P26     = 0x4000000  // Bit P26.
	PIO_MDER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDER_P27     = 0x8000000  // Bit P27.
	PIO_MDER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDER_P28     = 0x10000000 // Bit P28.
	PIO_MDER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDER_P29     = 0x20000000 // Bit P29.
	PIO_MDER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDER_P30     = 0x40000000 // Bit P30.
	PIO_MDER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDER_P31     = 0x80000000 // Bit P31.

	// MDDR: Multi-driver Disable Register
	PIO_MDDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDDR_P0      = 0x1        // Bit P0.
	PIO_MDDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDDR_P1      = 0x2        // Bit P1.
	PIO_MDDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDDR_P2      = 0x4        // Bit P2.
	PIO_MDDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDDR_P3      = 0x8        // Bit P3.
	PIO_MDDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDDR_P4      = 0x10       // Bit P4.
	PIO_MDDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDDR_P5      = 0x20       // Bit P5.
	PIO_MDDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDDR_P6      = 0x40       // Bit P6.
	PIO_MDDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDDR_P7      = 0x80       // Bit P7.
	PIO_MDDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDDR_P8      = 0x100      // Bit P8.
	PIO_MDDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDDR_P9      = 0x200      // Bit P9.
	PIO_MDDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDDR_P10     = 0x400      // Bit P10.
	PIO_MDDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDDR_P11     = 0x800      // Bit P11.
	PIO_MDDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDDR_P12     = 0x1000     // Bit P12.
	PIO_MDDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDDR_P13     = 0x2000     // Bit P13.
	PIO_MDDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDDR_P14     = 0x4000     // Bit P14.
	PIO_MDDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDDR_P15     = 0x8000     // Bit P15.
	PIO_MDDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDDR_P16     = 0x10000    // Bit P16.
	PIO_MDDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDDR_P17     = 0x20000    // Bit P17.
	PIO_MDDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDDR_P18     = 0x40000    // Bit P18.
	PIO_MDDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDDR_P19     = 0x80000    // Bit P19.
	PIO_MDDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDDR_P20     = 0x100000   // Bit P20.
	PIO_MDDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDDR_P21     = 0x200000   // Bit P21.
	PIO_MDDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDDR_P22     = 0x400000   // Bit P22.
	PIO_MDDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDDR_P23     = 0x800000   // Bit P23.
	PIO_MDDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDDR_P24     = 0x1000000  // Bit P24.
	PIO_MDDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDDR_P25     = 0x2000000  // Bit P25.
	PIO_MDDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDDR_P26     = 0x4000000  // Bit P26.
	PIO_MDDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDDR_P27     = 0x8000000  // Bit P27.
	PIO_MDDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDDR_P28     = 0x10000000 // Bit P28.
	PIO_MDDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDDR_P29     = 0x20000000 // Bit P29.
	PIO_MDDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDDR_P30     = 0x40000000 // Bit P30.
	PIO_MDDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDDR_P31     = 0x80000000 // Bit P31.

	// MDSR: Multi-driver Status Register
	PIO_MDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_MDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_MDSR_P0      = 0x1        // Bit P0.
	PIO_MDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_MDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_MDSR_P1      = 0x2        // Bit P1.
	PIO_MDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_MDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_MDSR_P2      = 0x4        // Bit P2.
	PIO_MDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_MDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_MDSR_P3      = 0x8        // Bit P3.
	PIO_MDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_MDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_MDSR_P4      = 0x10       // Bit P4.
	PIO_MDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_MDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_MDSR_P5      = 0x20       // Bit P5.
	PIO_MDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_MDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_MDSR_P6      = 0x40       // Bit P6.
	PIO_MDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_MDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_MDSR_P7      = 0x80       // Bit P7.
	PIO_MDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_MDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_MDSR_P8      = 0x100      // Bit P8.
	PIO_MDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_MDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_MDSR_P9      = 0x200      // Bit P9.
	PIO_MDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_MDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_MDSR_P10     = 0x400      // Bit P10.
	PIO_MDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_MDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_MDSR_P11     = 0x800      // Bit P11.
	PIO_MDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_MDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_MDSR_P12     = 0x1000     // Bit P12.
	PIO_MDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_MDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_MDSR_P13     = 0x2000     // Bit P13.
	PIO_MDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_MDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_MDSR_P14     = 0x4000     // Bit P14.
	PIO_MDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_MDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_MDSR_P15     = 0x8000     // Bit P15.
	PIO_MDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_MDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_MDSR_P16     = 0x10000    // Bit P16.
	PIO_MDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_MDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_MDSR_P17     = 0x20000    // Bit P17.
	PIO_MDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_MDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_MDSR_P18     = 0x40000    // Bit P18.
	PIO_MDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_MDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_MDSR_P19     = 0x80000    // Bit P19.
	PIO_MDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_MDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_MDSR_P20     = 0x100000   // Bit P20.
	PIO_MDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_MDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_MDSR_P21     = 0x200000   // Bit P21.
	PIO_MDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_MDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_MDSR_P22     = 0x400000   // Bit P22.
	PIO_MDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_MDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_MDSR_P23     = 0x800000   // Bit P23.
	PIO_MDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_MDSR_P24     = 0x1000000  // Bit P24.
	PIO_MDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_MDSR_P25     = 0x2000000  // Bit P25.
	PIO_MDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_MDSR_P26     = 0x4000000  // Bit P26.
	PIO_MDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_MDSR_P27     = 0x8000000  // Bit P27.
	PIO_MDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_MDSR_P28     = 0x10000000 // Bit P28.
	PIO_MDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_MDSR_P29     = 0x20000000 // Bit P29.
	PIO_MDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_MDSR_P30     = 0x40000000 // Bit P30.
	PIO_MDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_MDSR_P31     = 0x80000000 // Bit P31.

	// PUDR: Pull-up Disable Register
	PIO_PUDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUDR_P0      = 0x1        // Bit P0.
	PIO_PUDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUDR_P1      = 0x2        // Bit P1.
	PIO_PUDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUDR_P2      = 0x4        // Bit P2.
	PIO_PUDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUDR_P3      = 0x8        // Bit P3.
	PIO_PUDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUDR_P4      = 0x10       // Bit P4.
	PIO_PUDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUDR_P5      = 0x20       // Bit P5.
	PIO_PUDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUDR_P6      = 0x40       // Bit P6.
	PIO_PUDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUDR_P7      = 0x80       // Bit P7.
	PIO_PUDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUDR_P8      = 0x100      // Bit P8.
	PIO_PUDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUDR_P9      = 0x200      // Bit P9.
	PIO_PUDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUDR_P10     = 0x400      // Bit P10.
	PIO_PUDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUDR_P11     = 0x800      // Bit P11.
	PIO_PUDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUDR_P12     = 0x1000     // Bit P12.
	PIO_PUDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUDR_P13     = 0x2000     // Bit P13.
	PIO_PUDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUDR_P14     = 0x4000     // Bit P14.
	PIO_PUDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUDR_P15     = 0x8000     // Bit P15.
	PIO_PUDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUDR_P16     = 0x10000    // Bit P16.
	PIO_PUDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUDR_P17     = 0x20000    // Bit P17.
	PIO_PUDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUDR_P18     = 0x40000    // Bit P18.
	PIO_PUDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUDR_P19     = 0x80000    // Bit P19.
	PIO_PUDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUDR_P20     = 0x100000   // Bit P20.
	PIO_PUDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUDR_P21     = 0x200000   // Bit P21.
	PIO_PUDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUDR_P22     = 0x400000   // Bit P22.
	PIO_PUDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUDR_P23     = 0x800000   // Bit P23.
	PIO_PUDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUDR_P24     = 0x1000000  // Bit P24.
	PIO_PUDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUDR_P25     = 0x2000000  // Bit P25.
	PIO_PUDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUDR_P26     = 0x4000000  // Bit P26.
	PIO_PUDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUDR_P27     = 0x8000000  // Bit P27.
	PIO_PUDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUDR_P28     = 0x10000000 // Bit P28.
	PIO_PUDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUDR_P29     = 0x20000000 // Bit P29.
	PIO_PUDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUDR_P30     = 0x40000000 // Bit P30.
	PIO_PUDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUDR_P31     = 0x80000000 // Bit P31.

	// PUER: Pull-up Enable Register
	PIO_PUER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUER_P0      = 0x1        // Bit P0.
	PIO_PUER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUER_P1      = 0x2        // Bit P1.
	PIO_PUER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUER_P2      = 0x4        // Bit P2.
	PIO_PUER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUER_P3      = 0x8        // Bit P3.
	PIO_PUER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUER_P4      = 0x10       // Bit P4.
	PIO_PUER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUER_P5      = 0x20       // Bit P5.
	PIO_PUER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUER_P6      = 0x40       // Bit P6.
	PIO_PUER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUER_P7      = 0x80       // Bit P7.
	PIO_PUER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUER_P8      = 0x100      // Bit P8.
	PIO_PUER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUER_P9      = 0x200      // Bit P9.
	PIO_PUER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUER_P10     = 0x400      // Bit P10.
	PIO_PUER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUER_P11     = 0x800      // Bit P11.
	PIO_PUER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUER_P12     = 0x1000     // Bit P12.
	PIO_PUER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUER_P13     = 0x2000     // Bit P13.
	PIO_PUER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUER_P14     = 0x4000     // Bit P14.
	PIO_PUER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUER_P15     = 0x8000     // Bit P15.
	PIO_PUER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUER_P16     = 0x10000    // Bit P16.
	PIO_PUER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUER_P17     = 0x20000    // Bit P17.
	PIO_PUER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUER_P18     = 0x40000    // Bit P18.
	PIO_PUER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUER_P19     = 0x80000    // Bit P19.
	PIO_PUER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUER_P20     = 0x100000   // Bit P20.
	PIO_PUER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUER_P21     = 0x200000   // Bit P21.
	PIO_PUER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUER_P22     = 0x400000   // Bit P22.
	PIO_PUER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUER_P23     = 0x800000   // Bit P23.
	PIO_PUER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUER_P24     = 0x1000000  // Bit P24.
	PIO_PUER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUER_P25     = 0x2000000  // Bit P25.
	PIO_PUER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUER_P26     = 0x4000000  // Bit P26.
	PIO_PUER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUER_P27     = 0x8000000  // Bit P27.
	PIO_PUER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUER_P28     = 0x10000000 // Bit P28.
	PIO_PUER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUER_P29     = 0x20000000 // Bit P29.
	PIO_PUER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUER_P30     = 0x40000000 // Bit P30.
	PIO_PUER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUER_P31     = 0x80000000 // Bit P31.

	// PUSR: Pad Pull-up Status Register
	PIO_PUSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PUSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PUSR_P0      = 0x1        // Bit P0.
	PIO_PUSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PUSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PUSR_P1      = 0x2        // Bit P1.
	PIO_PUSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PUSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PUSR_P2      = 0x4        // Bit P2.
	PIO_PUSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PUSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PUSR_P3      = 0x8        // Bit P3.
	PIO_PUSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PUSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PUSR_P4      = 0x10       // Bit P4.
	PIO_PUSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PUSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PUSR_P5      = 0x20       // Bit P5.
	PIO_PUSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PUSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PUSR_P6      = 0x40       // Bit P6.
	PIO_PUSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PUSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PUSR_P7      = 0x80       // Bit P7.
	PIO_PUSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PUSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PUSR_P8      = 0x100      // Bit P8.
	PIO_PUSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PUSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PUSR_P9      = 0x200      // Bit P9.
	PIO_PUSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PUSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PUSR_P10     = 0x400      // Bit P10.
	PIO_PUSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PUSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PUSR_P11     = 0x800      // Bit P11.
	PIO_PUSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PUSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PUSR_P12     = 0x1000     // Bit P12.
	PIO_PUSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PUSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PUSR_P13     = 0x2000     // Bit P13.
	PIO_PUSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PUSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PUSR_P14     = 0x4000     // Bit P14.
	PIO_PUSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PUSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PUSR_P15     = 0x8000     // Bit P15.
	PIO_PUSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PUSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PUSR_P16     = 0x10000    // Bit P16.
	PIO_PUSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PUSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PUSR_P17     = 0x20000    // Bit P17.
	PIO_PUSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PUSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PUSR_P18     = 0x40000    // Bit P18.
	PIO_PUSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PUSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PUSR_P19     = 0x80000    // Bit P19.
	PIO_PUSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PUSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PUSR_P20     = 0x100000   // Bit P20.
	PIO_PUSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PUSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PUSR_P21     = 0x200000   // Bit P21.
	PIO_PUSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PUSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PUSR_P22     = 0x400000   // Bit P22.
	PIO_PUSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PUSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PUSR_P23     = 0x800000   // Bit P23.
	PIO_PUSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PUSR_P24     = 0x1000000  // Bit P24.
	PIO_PUSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PUSR_P25     = 0x2000000  // Bit P25.
	PIO_PUSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PUSR_P26     = 0x4000000  // Bit P26.
	PIO_PUSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PUSR_P27     = 0x8000000  // Bit P27.
	PIO_PUSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PUSR_P28     = 0x10000000 // Bit P28.
	PIO_PUSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PUSR_P29     = 0x20000000 // Bit P29.
	PIO_PUSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PUSR_P30     = 0x40000000 // Bit P30.
	PIO_PUSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PUSR_P31     = 0x80000000 // Bit P31.

	// ABCDSR: Peripheral Select Register
	PIO_ABCDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ABCDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ABCDSR_P0      = 0x1        // Bit P0.
	PIO_ABCDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ABCDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ABCDSR_P1      = 0x2        // Bit P1.
	PIO_ABCDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ABCDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ABCDSR_P2      = 0x4        // Bit P2.
	PIO_ABCDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ABCDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ABCDSR_P3      = 0x8        // Bit P3.
	PIO_ABCDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ABCDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ABCDSR_P4      = 0x10       // Bit P4.
	PIO_ABCDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ABCDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ABCDSR_P5      = 0x20       // Bit P5.
	PIO_ABCDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ABCDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ABCDSR_P6      = 0x40       // Bit P6.
	PIO_ABCDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ABCDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ABCDSR_P7      = 0x80       // Bit P7.
	PIO_ABCDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ABCDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ABCDSR_P8      = 0x100      // Bit P8.
	PIO_ABCDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ABCDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ABCDSR_P9      = 0x200      // Bit P9.
	PIO_ABCDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ABCDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ABCDSR_P10     = 0x400      // Bit P10.
	PIO_ABCDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ABCDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ABCDSR_P11     = 0x800      // Bit P11.
	PIO_ABCDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ABCDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ABCDSR_P12     = 0x1000     // Bit P12.
	PIO_ABCDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ABCDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ABCDSR_P13     = 0x2000     // Bit P13.
	PIO_ABCDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ABCDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ABCDSR_P14     = 0x4000     // Bit P14.
	PIO_ABCDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ABCDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ABCDSR_P15     = 0x8000     // Bit P15.
	PIO_ABCDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ABCDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ABCDSR_P16     = 0x10000    // Bit P16.
	PIO_ABCDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ABCDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ABCDSR_P17     = 0x20000    // Bit P17.
	PIO_ABCDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ABCDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ABCDSR_P18     = 0x40000    // Bit P18.
	PIO_ABCDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ABCDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ABCDSR_P19     = 0x80000    // Bit P19.
	PIO_ABCDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ABCDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ABCDSR_P20     = 0x100000   // Bit P20.
	PIO_ABCDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ABCDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ABCDSR_P21     = 0x200000   // Bit P21.
	PIO_ABCDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ABCDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ABCDSR_P22     = 0x400000   // Bit P22.
	PIO_ABCDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ABCDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ABCDSR_P23     = 0x800000   // Bit P23.
	PIO_ABCDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ABCDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ABCDSR_P24     = 0x1000000  // Bit P24.
	PIO_ABCDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ABCDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ABCDSR_P25     = 0x2000000  // Bit P25.
	PIO_ABCDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ABCDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ABCDSR_P26     = 0x4000000  // Bit P26.
	PIO_ABCDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ABCDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ABCDSR_P27     = 0x8000000  // Bit P27.
	PIO_ABCDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ABCDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ABCDSR_P28     = 0x10000000 // Bit P28.
	PIO_ABCDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ABCDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ABCDSR_P29     = 0x20000000 // Bit P29.
	PIO_ABCDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ABCDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ABCDSR_P30     = 0x40000000 // Bit P30.
	PIO_ABCDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ABCDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ABCDSR_P31     = 0x80000000 // Bit P31.

	// IFSCDR: Input Filter Slow Clock Disable Register
	PIO_IFSCDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFSCDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFSCDR_P0      = 0x1        // Bit P0.
	PIO_IFSCDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFSCDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFSCDR_P1      = 0x2        // Bit P1.
	PIO_IFSCDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFSCDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFSCDR_P2      = 0x4        // Bit P2.
	PIO_IFSCDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFSCDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFSCDR_P3      = 0x8        // Bit P3.
	PIO_IFSCDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFSCDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFSCDR_P4      = 0x10       // Bit P4.
	PIO_IFSCDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFSCDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFSCDR_P5      = 0x20       // Bit P5.
	PIO_IFSCDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFSCDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFSCDR_P6      = 0x40       // Bit P6.
	PIO_IFSCDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFSCDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFSCDR_P7      = 0x80       // Bit P7.
	PIO_IFSCDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFSCDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFSCDR_P8      = 0x100      // Bit P8.
	PIO_IFSCDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFSCDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFSCDR_P9      = 0x200      // Bit P9.
	PIO_IFSCDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFSCDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFSCDR_P10     = 0x400      // Bit P10.
	PIO_IFSCDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFSCDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFSCDR_P11     = 0x800      // Bit P11.
	PIO_IFSCDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFSCDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFSCDR_P12     = 0x1000     // Bit P12.
	PIO_IFSCDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFSCDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFSCDR_P13     = 0x2000     // Bit P13.
	PIO_IFSCDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFSCDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFSCDR_P14     = 0x4000     // Bit P14.
	PIO_IFSCDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFSCDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFSCDR_P15     = 0x8000     // Bit P15.
	PIO_IFSCDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFSCDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFSCDR_P16     = 0x10000    // Bit P16.
	PIO_IFSCDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFSCDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFSCDR_P17     = 0x20000    // Bit P17.
	PIO_IFSCDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFSCDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFSCDR_P18     = 0x40000    // Bit P18.
	PIO_IFSCDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFSCDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFSCDR_P19     = 0x80000    // Bit P19.
	PIO_IFSCDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFSCDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFSCDR_P20     = 0x100000   // Bit P20.
	PIO_IFSCDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFSCDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFSCDR_P21     = 0x200000   // Bit P21.
	PIO_IFSCDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFSCDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFSCDR_P22     = 0x400000   // Bit P22.
	PIO_IFSCDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFSCDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFSCDR_P23     = 0x800000   // Bit P23.
	PIO_IFSCDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFSCDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFSCDR_P24     = 0x1000000  // Bit P24.
	PIO_IFSCDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFSCDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFSCDR_P25     = 0x2000000  // Bit P25.
	PIO_IFSCDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFSCDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFSCDR_P26     = 0x4000000  // Bit P26.
	PIO_IFSCDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFSCDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFSCDR_P27     = 0x8000000  // Bit P27.
	PIO_IFSCDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFSCDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFSCDR_P28     = 0x10000000 // Bit P28.
	PIO_IFSCDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFSCDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFSCDR_P29     = 0x20000000 // Bit P29.
	PIO_IFSCDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFSCDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFSCDR_P30     = 0x40000000 // Bit P30.
	PIO_IFSCDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFSCDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFSCDR_P31     = 0x80000000 // Bit P31.

	// IFSCER: Input Filter Slow Clock Enable Register
	PIO_IFSCER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFSCER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFSCER_P0      = 0x1        // Bit P0.
	PIO_IFSCER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFSCER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFSCER_P1      = 0x2        // Bit P1.
	PIO_IFSCER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFSCER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFSCER_P2      = 0x4        // Bit P2.
	PIO_IFSCER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFSCER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFSCER_P3      = 0x8        // Bit P3.
	PIO_IFSCER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFSCER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFSCER_P4      = 0x10       // Bit P4.
	PIO_IFSCER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFSCER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFSCER_P5      = 0x20       // Bit P5.
	PIO_IFSCER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFSCER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFSCER_P6      = 0x40       // Bit P6.
	PIO_IFSCER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFSCER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFSCER_P7      = 0x80       // Bit P7.
	PIO_IFSCER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFSCER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFSCER_P8      = 0x100      // Bit P8.
	PIO_IFSCER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFSCER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFSCER_P9      = 0x200      // Bit P9.
	PIO_IFSCER_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFSCER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFSCER_P10     = 0x400      // Bit P10.
	PIO_IFSCER_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFSCER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFSCER_P11     = 0x800      // Bit P11.
	PIO_IFSCER_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFSCER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFSCER_P12     = 0x1000     // Bit P12.
	PIO_IFSCER_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFSCER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFSCER_P13     = 0x2000     // Bit P13.
	PIO_IFSCER_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFSCER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFSCER_P14     = 0x4000     // Bit P14.
	PIO_IFSCER_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFSCER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFSCER_P15     = 0x8000     // Bit P15.
	PIO_IFSCER_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFSCER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFSCER_P16     = 0x10000    // Bit P16.
	PIO_IFSCER_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFSCER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFSCER_P17     = 0x20000    // Bit P17.
	PIO_IFSCER_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFSCER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFSCER_P18     = 0x40000    // Bit P18.
	PIO_IFSCER_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFSCER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFSCER_P19     = 0x80000    // Bit P19.
	PIO_IFSCER_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFSCER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFSCER_P20     = 0x100000   // Bit P20.
	PIO_IFSCER_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFSCER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFSCER_P21     = 0x200000   // Bit P21.
	PIO_IFSCER_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFSCER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFSCER_P22     = 0x400000   // Bit P22.
	PIO_IFSCER_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFSCER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFSCER_P23     = 0x800000   // Bit P23.
	PIO_IFSCER_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFSCER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFSCER_P24     = 0x1000000  // Bit P24.
	PIO_IFSCER_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFSCER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFSCER_P25     = 0x2000000  // Bit P25.
	PIO_IFSCER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFSCER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFSCER_P26     = 0x4000000  // Bit P26.
	PIO_IFSCER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFSCER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFSCER_P27     = 0x8000000  // Bit P27.
	PIO_IFSCER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFSCER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFSCER_P28     = 0x10000000 // Bit P28.
	PIO_IFSCER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFSCER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFSCER_P29     = 0x20000000 // Bit P29.
	PIO_IFSCER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFSCER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFSCER_P30     = 0x40000000 // Bit P30.
	PIO_IFSCER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFSCER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFSCER_P31     = 0x80000000 // Bit P31.

	// IFSCSR: Input Filter Slow Clock Status Register
	PIO_IFSCSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_IFSCSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_IFSCSR_P0      = 0x1        // Bit P0.
	PIO_IFSCSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_IFSCSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_IFSCSR_P1      = 0x2        // Bit P1.
	PIO_IFSCSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_IFSCSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_IFSCSR_P2      = 0x4        // Bit P2.
	PIO_IFSCSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_IFSCSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_IFSCSR_P3      = 0x8        // Bit P3.
	PIO_IFSCSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_IFSCSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_IFSCSR_P4      = 0x10       // Bit P4.
	PIO_IFSCSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_IFSCSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_IFSCSR_P5      = 0x20       // Bit P5.
	PIO_IFSCSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_IFSCSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_IFSCSR_P6      = 0x40       // Bit P6.
	PIO_IFSCSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_IFSCSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_IFSCSR_P7      = 0x80       // Bit P7.
	PIO_IFSCSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_IFSCSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_IFSCSR_P8      = 0x100      // Bit P8.
	PIO_IFSCSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_IFSCSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_IFSCSR_P9      = 0x200      // Bit P9.
	PIO_IFSCSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_IFSCSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_IFSCSR_P10     = 0x400      // Bit P10.
	PIO_IFSCSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_IFSCSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_IFSCSR_P11     = 0x800      // Bit P11.
	PIO_IFSCSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_IFSCSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_IFSCSR_P12     = 0x1000     // Bit P12.
	PIO_IFSCSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_IFSCSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_IFSCSR_P13     = 0x2000     // Bit P13.
	PIO_IFSCSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_IFSCSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_IFSCSR_P14     = 0x4000     // Bit P14.
	PIO_IFSCSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_IFSCSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_IFSCSR_P15     = 0x8000     // Bit P15.
	PIO_IFSCSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_IFSCSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_IFSCSR_P16     = 0x10000    // Bit P16.
	PIO_IFSCSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_IFSCSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_IFSCSR_P17     = 0x20000    // Bit P17.
	PIO_IFSCSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_IFSCSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_IFSCSR_P18     = 0x40000    // Bit P18.
	PIO_IFSCSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_IFSCSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_IFSCSR_P19     = 0x80000    // Bit P19.
	PIO_IFSCSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_IFSCSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_IFSCSR_P20     = 0x100000   // Bit P20.
	PIO_IFSCSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_IFSCSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_IFSCSR_P21     = 0x200000   // Bit P21.
	PIO_IFSCSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_IFSCSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_IFSCSR_P22     = 0x400000   // Bit P22.
	PIO_IFSCSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_IFSCSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_IFSCSR_P23     = 0x800000   // Bit P23.
	PIO_IFSCSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_IFSCSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_IFSCSR_P24     = 0x1000000  // Bit P24.
	PIO_IFSCSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_IFSCSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_IFSCSR_P25     = 0x2000000  // Bit P25.
	PIO_IFSCSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_IFSCSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_IFSCSR_P26     = 0x4000000  // Bit P26.
	PIO_IFSCSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_IFSCSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_IFSCSR_P27     = 0x8000000  // Bit P27.
	PIO_IFSCSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_IFSCSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_IFSCSR_P28     = 0x10000000 // Bit P28.
	PIO_IFSCSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_IFSCSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_IFSCSR_P29     = 0x20000000 // Bit P29.
	PIO_IFSCSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_IFSCSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_IFSCSR_P30     = 0x40000000 // Bit P30.
	PIO_IFSCSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_IFSCSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_IFSCSR_P31     = 0x80000000 // Bit P31.

	// SCDR: Slow Clock Divider Debouncing Register
	PIO_SCDR_DIV_Pos = 0x0    // Position of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff // Bit mask of DIV field.

	// PPDDR: Pad Pull-down Disable Register
	PIO_PPDDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PPDDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PPDDR_P0      = 0x1        // Bit P0.
	PIO_PPDDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PPDDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PPDDR_P1      = 0x2        // Bit P1.
	PIO_PPDDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PPDDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PPDDR_P2      = 0x4        // Bit P2.
	PIO_PPDDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PPDDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PPDDR_P3      = 0x8        // Bit P3.
	PIO_PPDDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PPDDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PPDDR_P4      = 0x10       // Bit P4.
	PIO_PPDDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PPDDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PPDDR_P5      = 0x20       // Bit P5.
	PIO_PPDDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PPDDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PPDDR_P6      = 0x40       // Bit P6.
	PIO_PPDDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PPDDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PPDDR_P7      = 0x80       // Bit P7.
	PIO_PPDDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PPDDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PPDDR_P8      = 0x100      // Bit P8.
	PIO_PPDDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PPDDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PPDDR_P9      = 0x200      // Bit P9.
	PIO_PPDDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PPDDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PPDDR_P10     = 0x400      // Bit P10.
	PIO_PPDDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PPDDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PPDDR_P11     = 0x800      // Bit P11.
	PIO_PPDDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PPDDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PPDDR_P12     = 0x1000     // Bit P12.
	PIO_PPDDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PPDDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PPDDR_P13     = 0x2000     // Bit P13.
	PIO_PPDDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PPDDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PPDDR_P14     = 0x4000     // Bit P14.
	PIO_PPDDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PPDDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PPDDR_P15     = 0x8000     // Bit P15.
	PIO_PPDDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PPDDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PPDDR_P16     = 0x10000    // Bit P16.
	PIO_PPDDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PPDDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PPDDR_P17     = 0x20000    // Bit P17.
	PIO_PPDDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PPDDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PPDDR_P18     = 0x40000    // Bit P18.
	PIO_PPDDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PPDDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PPDDR_P19     = 0x80000    // Bit P19.
	PIO_PPDDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PPDDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PPDDR_P20     = 0x100000   // Bit P20.
	PIO_PPDDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PPDDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PPDDR_P21     = 0x200000   // Bit P21.
	PIO_PPDDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PPDDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PPDDR_P22     = 0x400000   // Bit P22.
	PIO_PPDDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PPDDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PPDDR_P23     = 0x800000   // Bit P23.
	PIO_PPDDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PPDDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PPDDR_P24     = 0x1000000  // Bit P24.
	PIO_PPDDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PPDDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PPDDR_P25     = 0x2000000  // Bit P25.
	PIO_PPDDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PPDDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PPDDR_P26     = 0x4000000  // Bit P26.
	PIO_PPDDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PPDDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PPDDR_P27     = 0x8000000  // Bit P27.
	PIO_PPDDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PPDDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PPDDR_P28     = 0x10000000 // Bit P28.
	PIO_PPDDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PPDDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PPDDR_P29     = 0x20000000 // Bit P29.
	PIO_PPDDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PPDDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PPDDR_P30     = 0x40000000 // Bit P30.
	PIO_PPDDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PPDDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PPDDR_P31     = 0x80000000 // Bit P31.

	// PPDER: Pad Pull-down Enable Register
	PIO_PPDER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PPDER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PPDER_P0      = 0x1        // Bit P0.
	PIO_PPDER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PPDER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PPDER_P1      = 0x2        // Bit P1.
	PIO_PPDER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PPDER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PPDER_P2      = 0x4        // Bit P2.
	PIO_PPDER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PPDER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PPDER_P3      = 0x8        // Bit P3.
	PIO_PPDER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PPDER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PPDER_P4      = 0x10       // Bit P4.
	PIO_PPDER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PPDER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PPDER_P5      = 0x20       // Bit P5.
	PIO_PPDER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PPDER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PPDER_P6      = 0x40       // Bit P6.
	PIO_PPDER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PPDER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PPDER_P7      = 0x80       // Bit P7.
	PIO_PPDER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PPDER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PPDER_P8      = 0x100      // Bit P8.
	PIO_PPDER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PPDER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PPDER_P9      = 0x200      // Bit P9.
	PIO_PPDER_P10_Pos = 0xa        // Position of P10 field.
	PIO_PPDER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PPDER_P10     = 0x400      // Bit P10.
	PIO_PPDER_P11_Pos = 0xb        // Position of P11 field.
	PIO_PPDER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PPDER_P11     = 0x800      // Bit P11.
	PIO_PPDER_P12_Pos = 0xc        // Position of P12 field.
	PIO_PPDER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PPDER_P12     = 0x1000     // Bit P12.
	PIO_PPDER_P13_Pos = 0xd        // Position of P13 field.
	PIO_PPDER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PPDER_P13     = 0x2000     // Bit P13.
	PIO_PPDER_P14_Pos = 0xe        // Position of P14 field.
	PIO_PPDER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PPDER_P14     = 0x4000     // Bit P14.
	PIO_PPDER_P15_Pos = 0xf        // Position of P15 field.
	PIO_PPDER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PPDER_P15     = 0x8000     // Bit P15.
	PIO_PPDER_P16_Pos = 0x10       // Position of P16 field.
	PIO_PPDER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PPDER_P16     = 0x10000    // Bit P16.
	PIO_PPDER_P17_Pos = 0x11       // Position of P17 field.
	PIO_PPDER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PPDER_P17     = 0x20000    // Bit P17.
	PIO_PPDER_P18_Pos = 0x12       // Position of P18 field.
	PIO_PPDER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PPDER_P18     = 0x40000    // Bit P18.
	PIO_PPDER_P19_Pos = 0x13       // Position of P19 field.
	PIO_PPDER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PPDER_P19     = 0x80000    // Bit P19.
	PIO_PPDER_P20_Pos = 0x14       // Position of P20 field.
	PIO_PPDER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PPDER_P20     = 0x100000   // Bit P20.
	PIO_PPDER_P21_Pos = 0x15       // Position of P21 field.
	PIO_PPDER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PPDER_P21     = 0x200000   // Bit P21.
	PIO_PPDER_P22_Pos = 0x16       // Position of P22 field.
	PIO_PPDER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PPDER_P22     = 0x400000   // Bit P22.
	PIO_PPDER_P23_Pos = 0x17       // Position of P23 field.
	PIO_PPDER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PPDER_P23     = 0x800000   // Bit P23.
	PIO_PPDER_P24_Pos = 0x18       // Position of P24 field.
	PIO_PPDER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PPDER_P24     = 0x1000000  // Bit P24.
	PIO_PPDER_P25_Pos = 0x19       // Position of P25 field.
	PIO_PPDER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PPDER_P25     = 0x2000000  // Bit P25.
	PIO_PPDER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PPDER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PPDER_P26     = 0x4000000  // Bit P26.
	PIO_PPDER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PPDER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PPDER_P27     = 0x8000000  // Bit P27.
	PIO_PPDER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PPDER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PPDER_P28     = 0x10000000 // Bit P28.
	PIO_PPDER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PPDER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PPDER_P29     = 0x20000000 // Bit P29.
	PIO_PPDER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PPDER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PPDER_P30     = 0x40000000 // Bit P30.
	PIO_PPDER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PPDER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PPDER_P31     = 0x80000000 // Bit P31.

	// PPDSR: Pad Pull-down Status Register
	PIO_PPDSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_PPDSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_PPDSR_P0      = 0x1        // Bit P0.
	PIO_PPDSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_PPDSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_PPDSR_P1      = 0x2        // Bit P1.
	PIO_PPDSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_PPDSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_PPDSR_P2      = 0x4        // Bit P2.
	PIO_PPDSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_PPDSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_PPDSR_P3      = 0x8        // Bit P3.
	PIO_PPDSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_PPDSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_PPDSR_P4      = 0x10       // Bit P4.
	PIO_PPDSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_PPDSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_PPDSR_P5      = 0x20       // Bit P5.
	PIO_PPDSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_PPDSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_PPDSR_P6      = 0x40       // Bit P6.
	PIO_PPDSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_PPDSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_PPDSR_P7      = 0x80       // Bit P7.
	PIO_PPDSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_PPDSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_PPDSR_P8      = 0x100      // Bit P8.
	PIO_PPDSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_PPDSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_PPDSR_P9      = 0x200      // Bit P9.
	PIO_PPDSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_PPDSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_PPDSR_P10     = 0x400      // Bit P10.
	PIO_PPDSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_PPDSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_PPDSR_P11     = 0x800      // Bit P11.
	PIO_PPDSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_PPDSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_PPDSR_P12     = 0x1000     // Bit P12.
	PIO_PPDSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_PPDSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_PPDSR_P13     = 0x2000     // Bit P13.
	PIO_PPDSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_PPDSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_PPDSR_P14     = 0x4000     // Bit P14.
	PIO_PPDSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_PPDSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_PPDSR_P15     = 0x8000     // Bit P15.
	PIO_PPDSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_PPDSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_PPDSR_P16     = 0x10000    // Bit P16.
	PIO_PPDSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_PPDSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_PPDSR_P17     = 0x20000    // Bit P17.
	PIO_PPDSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_PPDSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_PPDSR_P18     = 0x40000    // Bit P18.
	PIO_PPDSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_PPDSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_PPDSR_P19     = 0x80000    // Bit P19.
	PIO_PPDSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_PPDSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_PPDSR_P20     = 0x100000   // Bit P20.
	PIO_PPDSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_PPDSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_PPDSR_P21     = 0x200000   // Bit P21.
	PIO_PPDSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_PPDSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_PPDSR_P22     = 0x400000   // Bit P22.
	PIO_PPDSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_PPDSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_PPDSR_P23     = 0x800000   // Bit P23.
	PIO_PPDSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_PPDSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_PPDSR_P24     = 0x1000000  // Bit P24.
	PIO_PPDSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_PPDSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_PPDSR_P25     = 0x2000000  // Bit P25.
	PIO_PPDSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_PPDSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_PPDSR_P26     = 0x4000000  // Bit P26.
	PIO_PPDSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_PPDSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_PPDSR_P27     = 0x8000000  // Bit P27.
	PIO_PPDSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_PPDSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_PPDSR_P28     = 0x10000000 // Bit P28.
	PIO_PPDSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_PPDSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_PPDSR_P29     = 0x20000000 // Bit P29.
	PIO_PPDSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_PPDSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_PPDSR_P30     = 0x40000000 // Bit P30.
	PIO_PPDSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_PPDSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_PPDSR_P31     = 0x80000000 // Bit P31.

	// OWER: Output Write Enable
	PIO_OWER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWER_P0      = 0x1        // Bit P0.
	PIO_OWER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWER_P1      = 0x2        // Bit P1.
	PIO_OWER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWER_P2      = 0x4        // Bit P2.
	PIO_OWER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWER_P3      = 0x8        // Bit P3.
	PIO_OWER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWER_P4      = 0x10       // Bit P4.
	PIO_OWER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWER_P5      = 0x20       // Bit P5.
	PIO_OWER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWER_P6      = 0x40       // Bit P6.
	PIO_OWER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWER_P7      = 0x80       // Bit P7.
	PIO_OWER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWER_P8      = 0x100      // Bit P8.
	PIO_OWER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWER_P9      = 0x200      // Bit P9.
	PIO_OWER_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWER_P10     = 0x400      // Bit P10.
	PIO_OWER_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWER_P11     = 0x800      // Bit P11.
	PIO_OWER_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWER_P12     = 0x1000     // Bit P12.
	PIO_OWER_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWER_P13     = 0x2000     // Bit P13.
	PIO_OWER_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWER_P14     = 0x4000     // Bit P14.
	PIO_OWER_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWER_P15     = 0x8000     // Bit P15.
	PIO_OWER_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWER_P16     = 0x10000    // Bit P16.
	PIO_OWER_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWER_P17     = 0x20000    // Bit P17.
	PIO_OWER_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWER_P18     = 0x40000    // Bit P18.
	PIO_OWER_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWER_P19     = 0x80000    // Bit P19.
	PIO_OWER_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWER_P20     = 0x100000   // Bit P20.
	PIO_OWER_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWER_P21     = 0x200000   // Bit P21.
	PIO_OWER_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWER_P22     = 0x400000   // Bit P22.
	PIO_OWER_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWER_P23     = 0x800000   // Bit P23.
	PIO_OWER_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWER_P24     = 0x1000000  // Bit P24.
	PIO_OWER_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWER_P25     = 0x2000000  // Bit P25.
	PIO_OWER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWER_P26     = 0x4000000  // Bit P26.
	PIO_OWER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWER_P27     = 0x8000000  // Bit P27.
	PIO_OWER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWER_P28     = 0x10000000 // Bit P28.
	PIO_OWER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWER_P29     = 0x20000000 // Bit P29.
	PIO_OWER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWER_P30     = 0x40000000 // Bit P30.
	PIO_OWER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWER_P31     = 0x80000000 // Bit P31.

	// OWDR: Output Write Disable
	PIO_OWDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWDR_P0      = 0x1        // Bit P0.
	PIO_OWDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWDR_P1      = 0x2        // Bit P1.
	PIO_OWDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWDR_P2      = 0x4        // Bit P2.
	PIO_OWDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWDR_P3      = 0x8        // Bit P3.
	PIO_OWDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWDR_P4      = 0x10       // Bit P4.
	PIO_OWDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWDR_P5      = 0x20       // Bit P5.
	PIO_OWDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWDR_P6      = 0x40       // Bit P6.
	PIO_OWDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWDR_P7      = 0x80       // Bit P7.
	PIO_OWDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWDR_P8      = 0x100      // Bit P8.
	PIO_OWDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWDR_P9      = 0x200      // Bit P9.
	PIO_OWDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWDR_P10     = 0x400      // Bit P10.
	PIO_OWDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWDR_P11     = 0x800      // Bit P11.
	PIO_OWDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWDR_P12     = 0x1000     // Bit P12.
	PIO_OWDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWDR_P13     = 0x2000     // Bit P13.
	PIO_OWDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWDR_P14     = 0x4000     // Bit P14.
	PIO_OWDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWDR_P15     = 0x8000     // Bit P15.
	PIO_OWDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWDR_P16     = 0x10000    // Bit P16.
	PIO_OWDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWDR_P17     = 0x20000    // Bit P17.
	PIO_OWDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWDR_P18     = 0x40000    // Bit P18.
	PIO_OWDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWDR_P19     = 0x80000    // Bit P19.
	PIO_OWDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWDR_P20     = 0x100000   // Bit P20.
	PIO_OWDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWDR_P21     = 0x200000   // Bit P21.
	PIO_OWDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWDR_P22     = 0x400000   // Bit P22.
	PIO_OWDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWDR_P23     = 0x800000   // Bit P23.
	PIO_OWDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWDR_P24     = 0x1000000  // Bit P24.
	PIO_OWDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWDR_P25     = 0x2000000  // Bit P25.
	PIO_OWDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWDR_P26     = 0x4000000  // Bit P26.
	PIO_OWDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWDR_P27     = 0x8000000  // Bit P27.
	PIO_OWDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWDR_P28     = 0x10000000 // Bit P28.
	PIO_OWDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWDR_P29     = 0x20000000 // Bit P29.
	PIO_OWDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWDR_P30     = 0x40000000 // Bit P30.
	PIO_OWDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWDR_P31     = 0x80000000 // Bit P31.

	// OWSR: Output Write Status Register
	PIO_OWSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_OWSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_OWSR_P0      = 0x1        // Bit P0.
	PIO_OWSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_OWSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_OWSR_P1      = 0x2        // Bit P1.
	PIO_OWSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_OWSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_OWSR_P2      = 0x4        // Bit P2.
	PIO_OWSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_OWSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_OWSR_P3      = 0x8        // Bit P3.
	PIO_OWSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_OWSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_OWSR_P4      = 0x10       // Bit P4.
	PIO_OWSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_OWSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_OWSR_P5      = 0x20       // Bit P5.
	PIO_OWSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_OWSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_OWSR_P6      = 0x40       // Bit P6.
	PIO_OWSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_OWSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_OWSR_P7      = 0x80       // Bit P7.
	PIO_OWSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_OWSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_OWSR_P8      = 0x100      // Bit P8.
	PIO_OWSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_OWSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_OWSR_P9      = 0x200      // Bit P9.
	PIO_OWSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_OWSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_OWSR_P10     = 0x400      // Bit P10.
	PIO_OWSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_OWSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_OWSR_P11     = 0x800      // Bit P11.
	PIO_OWSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_OWSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_OWSR_P12     = 0x1000     // Bit P12.
	PIO_OWSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_OWSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_OWSR_P13     = 0x2000     // Bit P13.
	PIO_OWSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_OWSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_OWSR_P14     = 0x4000     // Bit P14.
	PIO_OWSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_OWSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_OWSR_P15     = 0x8000     // Bit P15.
	PIO_OWSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_OWSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_OWSR_P16     = 0x10000    // Bit P16.
	PIO_OWSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_OWSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_OWSR_P17     = 0x20000    // Bit P17.
	PIO_OWSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_OWSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_OWSR_P18     = 0x40000    // Bit P18.
	PIO_OWSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_OWSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_OWSR_P19     = 0x80000    // Bit P19.
	PIO_OWSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_OWSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_OWSR_P20     = 0x100000   // Bit P20.
	PIO_OWSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_OWSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_OWSR_P21     = 0x200000   // Bit P21.
	PIO_OWSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_OWSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_OWSR_P22     = 0x400000   // Bit P22.
	PIO_OWSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_OWSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_OWSR_P23     = 0x800000   // Bit P23.
	PIO_OWSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_OWSR_P24     = 0x1000000  // Bit P24.
	PIO_OWSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_OWSR_P25     = 0x2000000  // Bit P25.
	PIO_OWSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_OWSR_P26     = 0x4000000  // Bit P26.
	PIO_OWSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_OWSR_P27     = 0x8000000  // Bit P27.
	PIO_OWSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_OWSR_P28     = 0x10000000 // Bit P28.
	PIO_OWSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_OWSR_P29     = 0x20000000 // Bit P29.
	PIO_OWSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_OWSR_P30     = 0x40000000 // Bit P30.
	PIO_OWSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_OWSR_P31     = 0x80000000 // Bit P31.

	// AIMER: Additional Interrupt Modes Enable Register
	PIO_AIMER_P0_Pos  = 0x0        // Position of P0 field.
	PIO_AIMER_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_AIMER_P0      = 0x1        // Bit P0.
	PIO_AIMER_P1_Pos  = 0x1        // Position of P1 field.
	PIO_AIMER_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_AIMER_P1      = 0x2        // Bit P1.
	PIO_AIMER_P2_Pos  = 0x2        // Position of P2 field.
	PIO_AIMER_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_AIMER_P2      = 0x4        // Bit P2.
	PIO_AIMER_P3_Pos  = 0x3        // Position of P3 field.
	PIO_AIMER_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_AIMER_P3      = 0x8        // Bit P3.
	PIO_AIMER_P4_Pos  = 0x4        // Position of P4 field.
	PIO_AIMER_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_AIMER_P4      = 0x10       // Bit P4.
	PIO_AIMER_P5_Pos  = 0x5        // Position of P5 field.
	PIO_AIMER_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_AIMER_P5      = 0x20       // Bit P5.
	PIO_AIMER_P6_Pos  = 0x6        // Position of P6 field.
	PIO_AIMER_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_AIMER_P6      = 0x40       // Bit P6.
	PIO_AIMER_P7_Pos  = 0x7        // Position of P7 field.
	PIO_AIMER_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_AIMER_P7      = 0x80       // Bit P7.
	PIO_AIMER_P8_Pos  = 0x8        // Position of P8 field.
	PIO_AIMER_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_AIMER_P8      = 0x100      // Bit P8.
	PIO_AIMER_P9_Pos  = 0x9        // Position of P9 field.
	PIO_AIMER_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_AIMER_P9      = 0x200      // Bit P9.
	PIO_AIMER_P10_Pos = 0xa        // Position of P10 field.
	PIO_AIMER_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_AIMER_P10     = 0x400      // Bit P10.
	PIO_AIMER_P11_Pos = 0xb        // Position of P11 field.
	PIO_AIMER_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_AIMER_P11     = 0x800      // Bit P11.
	PIO_AIMER_P12_Pos = 0xc        // Position of P12 field.
	PIO_AIMER_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_AIMER_P12     = 0x1000     // Bit P12.
	PIO_AIMER_P13_Pos = 0xd        // Position of P13 field.
	PIO_AIMER_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_AIMER_P13     = 0x2000     // Bit P13.
	PIO_AIMER_P14_Pos = 0xe        // Position of P14 field.
	PIO_AIMER_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_AIMER_P14     = 0x4000     // Bit P14.
	PIO_AIMER_P15_Pos = 0xf        // Position of P15 field.
	PIO_AIMER_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_AIMER_P15     = 0x8000     // Bit P15.
	PIO_AIMER_P16_Pos = 0x10       // Position of P16 field.
	PIO_AIMER_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_AIMER_P16     = 0x10000    // Bit P16.
	PIO_AIMER_P17_Pos = 0x11       // Position of P17 field.
	PIO_AIMER_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_AIMER_P17     = 0x20000    // Bit P17.
	PIO_AIMER_P18_Pos = 0x12       // Position of P18 field.
	PIO_AIMER_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_AIMER_P18     = 0x40000    // Bit P18.
	PIO_AIMER_P19_Pos = 0x13       // Position of P19 field.
	PIO_AIMER_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_AIMER_P19     = 0x80000    // Bit P19.
	PIO_AIMER_P20_Pos = 0x14       // Position of P20 field.
	PIO_AIMER_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_AIMER_P20     = 0x100000   // Bit P20.
	PIO_AIMER_P21_Pos = 0x15       // Position of P21 field.
	PIO_AIMER_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_AIMER_P21     = 0x200000   // Bit P21.
	PIO_AIMER_P22_Pos = 0x16       // Position of P22 field.
	PIO_AIMER_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_AIMER_P22     = 0x400000   // Bit P22.
	PIO_AIMER_P23_Pos = 0x17       // Position of P23 field.
	PIO_AIMER_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_AIMER_P23     = 0x800000   // Bit P23.
	PIO_AIMER_P24_Pos = 0x18       // Position of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_AIMER_P24     = 0x1000000  // Bit P24.
	PIO_AIMER_P25_Pos = 0x19       // Position of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_AIMER_P25     = 0x2000000  // Bit P25.
	PIO_AIMER_P26_Pos = 0x1a       // Position of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_AIMER_P26     = 0x4000000  // Bit P26.
	PIO_AIMER_P27_Pos = 0x1b       // Position of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_AIMER_P27     = 0x8000000  // Bit P27.
	PIO_AIMER_P28_Pos = 0x1c       // Position of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_AIMER_P28     = 0x10000000 // Bit P28.
	PIO_AIMER_P29_Pos = 0x1d       // Position of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_AIMER_P29     = 0x20000000 // Bit P29.
	PIO_AIMER_P30_Pos = 0x1e       // Position of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_AIMER_P30     = 0x40000000 // Bit P30.
	PIO_AIMER_P31_Pos = 0x1f       // Position of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_AIMER_P31     = 0x80000000 // Bit P31.

	// AIMDR: Additional Interrupt Modes Disables Register
	PIO_AIMDR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_AIMDR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_AIMDR_P0      = 0x1        // Bit P0.
	PIO_AIMDR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_AIMDR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_AIMDR_P1      = 0x2        // Bit P1.
	PIO_AIMDR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_AIMDR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_AIMDR_P2      = 0x4        // Bit P2.
	PIO_AIMDR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_AIMDR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_AIMDR_P3      = 0x8        // Bit P3.
	PIO_AIMDR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_AIMDR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_AIMDR_P4      = 0x10       // Bit P4.
	PIO_AIMDR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_AIMDR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_AIMDR_P5      = 0x20       // Bit P5.
	PIO_AIMDR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_AIMDR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_AIMDR_P6      = 0x40       // Bit P6.
	PIO_AIMDR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_AIMDR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_AIMDR_P7      = 0x80       // Bit P7.
	PIO_AIMDR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_AIMDR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_AIMDR_P8      = 0x100      // Bit P8.
	PIO_AIMDR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_AIMDR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_AIMDR_P9      = 0x200      // Bit P9.
	PIO_AIMDR_P10_Pos = 0xa        // Position of P10 field.
	PIO_AIMDR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_AIMDR_P10     = 0x400      // Bit P10.
	PIO_AIMDR_P11_Pos = 0xb        // Position of P11 field.
	PIO_AIMDR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_AIMDR_P11     = 0x800      // Bit P11.
	PIO_AIMDR_P12_Pos = 0xc        // Position of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_AIMDR_P12     = 0x1000     // Bit P12.
	PIO_AIMDR_P13_Pos = 0xd        // Position of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_AIMDR_P13     = 0x2000     // Bit P13.
	PIO_AIMDR_P14_Pos = 0xe        // Position of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_AIMDR_P14     = 0x4000     // Bit P14.
	PIO_AIMDR_P15_Pos = 0xf        // Position of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_AIMDR_P15     = 0x8000     // Bit P15.
	PIO_AIMDR_P16_Pos = 0x10       // Position of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_AIMDR_P16     = 0x10000    // Bit P16.
	PIO_AIMDR_P17_Pos = 0x11       // Position of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_AIMDR_P17     = 0x20000    // Bit P17.
	PIO_AIMDR_P18_Pos = 0x12       // Position of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_AIMDR_P18     = 0x40000    // Bit P18.
	PIO_AIMDR_P19_Pos = 0x13       // Position of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_AIMDR_P19     = 0x80000    // Bit P19.
	PIO_AIMDR_P20_Pos = 0x14       // Position of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_AIMDR_P20     = 0x100000   // Bit P20.
	PIO_AIMDR_P21_Pos = 0x15       // Position of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_AIMDR_P21     = 0x200000   // Bit P21.
	PIO_AIMDR_P22_Pos = 0x16       // Position of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_AIMDR_P22     = 0x400000   // Bit P22.
	PIO_AIMDR_P23_Pos = 0x17       // Position of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_AIMDR_P23     = 0x800000   // Bit P23.
	PIO_AIMDR_P24_Pos = 0x18       // Position of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_AIMDR_P24     = 0x1000000  // Bit P24.
	PIO_AIMDR_P25_Pos = 0x19       // Position of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_AIMDR_P25     = 0x2000000  // Bit P25.
	PIO_AIMDR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_AIMDR_P26     = 0x4000000  // Bit P26.
	PIO_AIMDR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_AIMDR_P27     = 0x8000000  // Bit P27.
	PIO_AIMDR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_AIMDR_P28     = 0x10000000 // Bit P28.
	PIO_AIMDR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_AIMDR_P29     = 0x20000000 // Bit P29.
	PIO_AIMDR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_AIMDR_P30     = 0x40000000 // Bit P30.
	PIO_AIMDR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_AIMDR_P31     = 0x80000000 // Bit P31.

	// AIMMR: Additional Interrupt Modes Mask Register
	PIO_AIMMR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_AIMMR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_AIMMR_P0      = 0x1        // Bit P0.
	PIO_AIMMR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_AIMMR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_AIMMR_P1      = 0x2        // Bit P1.
	PIO_AIMMR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_AIMMR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_AIMMR_P2      = 0x4        // Bit P2.
	PIO_AIMMR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_AIMMR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_AIMMR_P3      = 0x8        // Bit P3.
	PIO_AIMMR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_AIMMR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_AIMMR_P4      = 0x10       // Bit P4.
	PIO_AIMMR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_AIMMR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_AIMMR_P5      = 0x20       // Bit P5.
	PIO_AIMMR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_AIMMR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_AIMMR_P6      = 0x40       // Bit P6.
	PIO_AIMMR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_AIMMR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_AIMMR_P7      = 0x80       // Bit P7.
	PIO_AIMMR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_AIMMR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_AIMMR_P8      = 0x100      // Bit P8.
	PIO_AIMMR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_AIMMR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_AIMMR_P9      = 0x200      // Bit P9.
	PIO_AIMMR_P10_Pos = 0xa        // Position of P10 field.
	PIO_AIMMR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_AIMMR_P10     = 0x400      // Bit P10.
	PIO_AIMMR_P11_Pos = 0xb        // Position of P11 field.
	PIO_AIMMR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_AIMMR_P11     = 0x800      // Bit P11.
	PIO_AIMMR_P12_Pos = 0xc        // Position of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_AIMMR_P12     = 0x1000     // Bit P12.
	PIO_AIMMR_P13_Pos = 0xd        // Position of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_AIMMR_P13     = 0x2000     // Bit P13.
	PIO_AIMMR_P14_Pos = 0xe        // Position of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_AIMMR_P14     = 0x4000     // Bit P14.
	PIO_AIMMR_P15_Pos = 0xf        // Position of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_AIMMR_P15     = 0x8000     // Bit P15.
	PIO_AIMMR_P16_Pos = 0x10       // Position of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_AIMMR_P16     = 0x10000    // Bit P16.
	PIO_AIMMR_P17_Pos = 0x11       // Position of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_AIMMR_P17     = 0x20000    // Bit P17.
	PIO_AIMMR_P18_Pos = 0x12       // Position of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_AIMMR_P18     = 0x40000    // Bit P18.
	PIO_AIMMR_P19_Pos = 0x13       // Position of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_AIMMR_P19     = 0x80000    // Bit P19.
	PIO_AIMMR_P20_Pos = 0x14       // Position of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_AIMMR_P20     = 0x100000   // Bit P20.
	PIO_AIMMR_P21_Pos = 0x15       // Position of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_AIMMR_P21     = 0x200000   // Bit P21.
	PIO_AIMMR_P22_Pos = 0x16       // Position of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_AIMMR_P22     = 0x400000   // Bit P22.
	PIO_AIMMR_P23_Pos = 0x17       // Position of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_AIMMR_P23     = 0x800000   // Bit P23.
	PIO_AIMMR_P24_Pos = 0x18       // Position of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_AIMMR_P24     = 0x1000000  // Bit P24.
	PIO_AIMMR_P25_Pos = 0x19       // Position of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_AIMMR_P25     = 0x2000000  // Bit P25.
	PIO_AIMMR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_AIMMR_P26     = 0x4000000  // Bit P26.
	PIO_AIMMR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_AIMMR_P27     = 0x8000000  // Bit P27.
	PIO_AIMMR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_AIMMR_P28     = 0x10000000 // Bit P28.
	PIO_AIMMR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_AIMMR_P29     = 0x20000000 // Bit P29.
	PIO_AIMMR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_AIMMR_P30     = 0x40000000 // Bit P30.
	PIO_AIMMR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_AIMMR_P31     = 0x80000000 // Bit P31.

	// ESR: Edge Select Register
	PIO_ESR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ESR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ESR_P0      = 0x1        // Bit P0.
	PIO_ESR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ESR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ESR_P1      = 0x2        // Bit P1.
	PIO_ESR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ESR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ESR_P2      = 0x4        // Bit P2.
	PIO_ESR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ESR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ESR_P3      = 0x8        // Bit P3.
	PIO_ESR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ESR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ESR_P4      = 0x10       // Bit P4.
	PIO_ESR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ESR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ESR_P5      = 0x20       // Bit P5.
	PIO_ESR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ESR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ESR_P6      = 0x40       // Bit P6.
	PIO_ESR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ESR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ESR_P7      = 0x80       // Bit P7.
	PIO_ESR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ESR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ESR_P8      = 0x100      // Bit P8.
	PIO_ESR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ESR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ESR_P9      = 0x200      // Bit P9.
	PIO_ESR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ESR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ESR_P10     = 0x400      // Bit P10.
	PIO_ESR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ESR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ESR_P11     = 0x800      // Bit P11.
	PIO_ESR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ESR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ESR_P12     = 0x1000     // Bit P12.
	PIO_ESR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ESR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ESR_P13     = 0x2000     // Bit P13.
	PIO_ESR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ESR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ESR_P14     = 0x4000     // Bit P14.
	PIO_ESR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ESR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ESR_P15     = 0x8000     // Bit P15.
	PIO_ESR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ESR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ESR_P16     = 0x10000    // Bit P16.
	PIO_ESR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ESR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ESR_P17     = 0x20000    // Bit P17.
	PIO_ESR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ESR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ESR_P18     = 0x40000    // Bit P18.
	PIO_ESR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ESR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ESR_P19     = 0x80000    // Bit P19.
	PIO_ESR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ESR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ESR_P20     = 0x100000   // Bit P20.
	PIO_ESR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ESR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ESR_P21     = 0x200000   // Bit P21.
	PIO_ESR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ESR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ESR_P22     = 0x400000   // Bit P22.
	PIO_ESR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ESR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ESR_P23     = 0x800000   // Bit P23.
	PIO_ESR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ESR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ESR_P24     = 0x1000000  // Bit P24.
	PIO_ESR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ESR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ESR_P25     = 0x2000000  // Bit P25.
	PIO_ESR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ESR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ESR_P26     = 0x4000000  // Bit P26.
	PIO_ESR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ESR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ESR_P27     = 0x8000000  // Bit P27.
	PIO_ESR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ESR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ESR_P28     = 0x10000000 // Bit P28.
	PIO_ESR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ESR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ESR_P29     = 0x20000000 // Bit P29.
	PIO_ESR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ESR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ESR_P30     = 0x40000000 // Bit P30.
	PIO_ESR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ESR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ESR_P31     = 0x80000000 // Bit P31.

	// LSR: Level Select Register
	PIO_LSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_LSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_LSR_P0      = 0x1        // Bit P0.
	PIO_LSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_LSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_LSR_P1      = 0x2        // Bit P1.
	PIO_LSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_LSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_LSR_P2      = 0x4        // Bit P2.
	PIO_LSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_LSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_LSR_P3      = 0x8        // Bit P3.
	PIO_LSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_LSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_LSR_P4      = 0x10       // Bit P4.
	PIO_LSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_LSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_LSR_P5      = 0x20       // Bit P5.
	PIO_LSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_LSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_LSR_P6      = 0x40       // Bit P6.
	PIO_LSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_LSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_LSR_P7      = 0x80       // Bit P7.
	PIO_LSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_LSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_LSR_P8      = 0x100      // Bit P8.
	PIO_LSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_LSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_LSR_P9      = 0x200      // Bit P9.
	PIO_LSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_LSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_LSR_P10     = 0x400      // Bit P10.
	PIO_LSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_LSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_LSR_P11     = 0x800      // Bit P11.
	PIO_LSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_LSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_LSR_P12     = 0x1000     // Bit P12.
	PIO_LSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_LSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_LSR_P13     = 0x2000     // Bit P13.
	PIO_LSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_LSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_LSR_P14     = 0x4000     // Bit P14.
	PIO_LSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_LSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_LSR_P15     = 0x8000     // Bit P15.
	PIO_LSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_LSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_LSR_P16     = 0x10000    // Bit P16.
	PIO_LSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_LSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_LSR_P17     = 0x20000    // Bit P17.
	PIO_LSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_LSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_LSR_P18     = 0x40000    // Bit P18.
	PIO_LSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_LSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_LSR_P19     = 0x80000    // Bit P19.
	PIO_LSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_LSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_LSR_P20     = 0x100000   // Bit P20.
	PIO_LSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_LSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_LSR_P21     = 0x200000   // Bit P21.
	PIO_LSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_LSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_LSR_P22     = 0x400000   // Bit P22.
	PIO_LSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_LSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_LSR_P23     = 0x800000   // Bit P23.
	PIO_LSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_LSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_LSR_P24     = 0x1000000  // Bit P24.
	PIO_LSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_LSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_LSR_P25     = 0x2000000  // Bit P25.
	PIO_LSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_LSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_LSR_P26     = 0x4000000  // Bit P26.
	PIO_LSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_LSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_LSR_P27     = 0x8000000  // Bit P27.
	PIO_LSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_LSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_LSR_P28     = 0x10000000 // Bit P28.
	PIO_LSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_LSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_LSR_P29     = 0x20000000 // Bit P29.
	PIO_LSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_LSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_LSR_P30     = 0x40000000 // Bit P30.
	PIO_LSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_LSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_LSR_P31     = 0x80000000 // Bit P31.

	// ELSR: Edge/Level Status Register
	PIO_ELSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_ELSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_ELSR_P0      = 0x1        // Bit P0.
	PIO_ELSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_ELSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_ELSR_P1      = 0x2        // Bit P1.
	PIO_ELSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_ELSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_ELSR_P2      = 0x4        // Bit P2.
	PIO_ELSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_ELSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_ELSR_P3      = 0x8        // Bit P3.
	PIO_ELSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_ELSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_ELSR_P4      = 0x10       // Bit P4.
	PIO_ELSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_ELSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_ELSR_P5      = 0x20       // Bit P5.
	PIO_ELSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_ELSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_ELSR_P6      = 0x40       // Bit P6.
	PIO_ELSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_ELSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_ELSR_P7      = 0x80       // Bit P7.
	PIO_ELSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_ELSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_ELSR_P8      = 0x100      // Bit P8.
	PIO_ELSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_ELSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_ELSR_P9      = 0x200      // Bit P9.
	PIO_ELSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_ELSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_ELSR_P10     = 0x400      // Bit P10.
	PIO_ELSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_ELSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_ELSR_P11     = 0x800      // Bit P11.
	PIO_ELSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_ELSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_ELSR_P12     = 0x1000     // Bit P12.
	PIO_ELSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_ELSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_ELSR_P13     = 0x2000     // Bit P13.
	PIO_ELSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_ELSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_ELSR_P14     = 0x4000     // Bit P14.
	PIO_ELSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_ELSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_ELSR_P15     = 0x8000     // Bit P15.
	PIO_ELSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_ELSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_ELSR_P16     = 0x10000    // Bit P16.
	PIO_ELSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_ELSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_ELSR_P17     = 0x20000    // Bit P17.
	PIO_ELSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_ELSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_ELSR_P18     = 0x40000    // Bit P18.
	PIO_ELSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_ELSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_ELSR_P19     = 0x80000    // Bit P19.
	PIO_ELSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_ELSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_ELSR_P20     = 0x100000   // Bit P20.
	PIO_ELSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_ELSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_ELSR_P21     = 0x200000   // Bit P21.
	PIO_ELSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_ELSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_ELSR_P22     = 0x400000   // Bit P22.
	PIO_ELSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_ELSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_ELSR_P23     = 0x800000   // Bit P23.
	PIO_ELSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_ELSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_ELSR_P24     = 0x1000000  // Bit P24.
	PIO_ELSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_ELSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_ELSR_P25     = 0x2000000  // Bit P25.
	PIO_ELSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_ELSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_ELSR_P26     = 0x4000000  // Bit P26.
	PIO_ELSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_ELSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_ELSR_P27     = 0x8000000  // Bit P27.
	PIO_ELSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_ELSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_ELSR_P28     = 0x10000000 // Bit P28.
	PIO_ELSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_ELSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_ELSR_P29     = 0x20000000 // Bit P29.
	PIO_ELSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_ELSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_ELSR_P30     = 0x40000000 // Bit P30.
	PIO_ELSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_ELSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_ELSR_P31     = 0x80000000 // Bit P31.

	// FELLSR: Falling Edge/Low Level Select Register
	PIO_FELLSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_FELLSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_FELLSR_P0      = 0x1        // Bit P0.
	PIO_FELLSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_FELLSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_FELLSR_P1      = 0x2        // Bit P1.
	PIO_FELLSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_FELLSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_FELLSR_P2      = 0x4        // Bit P2.
	PIO_FELLSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_FELLSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_FELLSR_P3      = 0x8        // Bit P3.
	PIO_FELLSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_FELLSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_FELLSR_P4      = 0x10       // Bit P4.
	PIO_FELLSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_FELLSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_FELLSR_P5      = 0x20       // Bit P5.
	PIO_FELLSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_FELLSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_FELLSR_P6      = 0x40       // Bit P6.
	PIO_FELLSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_FELLSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_FELLSR_P7      = 0x80       // Bit P7.
	PIO_FELLSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_FELLSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_FELLSR_P8      = 0x100      // Bit P8.
	PIO_FELLSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_FELLSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_FELLSR_P9      = 0x200      // Bit P9.
	PIO_FELLSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_FELLSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_FELLSR_P10     = 0x400      // Bit P10.
	PIO_FELLSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_FELLSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_FELLSR_P11     = 0x800      // Bit P11.
	PIO_FELLSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_FELLSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_FELLSR_P12     = 0x1000     // Bit P12.
	PIO_FELLSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_FELLSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_FELLSR_P13     = 0x2000     // Bit P13.
	PIO_FELLSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_FELLSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_FELLSR_P14     = 0x4000     // Bit P14.
	PIO_FELLSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_FELLSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_FELLSR_P15     = 0x8000     // Bit P15.
	PIO_FELLSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_FELLSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_FELLSR_P16     = 0x10000    // Bit P16.
	PIO_FELLSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_FELLSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_FELLSR_P17     = 0x20000    // Bit P17.
	PIO_FELLSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_FELLSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_FELLSR_P18     = 0x40000    // Bit P18.
	PIO_FELLSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_FELLSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_FELLSR_P19     = 0x80000    // Bit P19.
	PIO_FELLSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_FELLSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_FELLSR_P20     = 0x100000   // Bit P20.
	PIO_FELLSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_FELLSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_FELLSR_P21     = 0x200000   // Bit P21.
	PIO_FELLSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_FELLSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_FELLSR_P22     = 0x400000   // Bit P22.
	PIO_FELLSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_FELLSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_FELLSR_P23     = 0x800000   // Bit P23.
	PIO_FELLSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_FELLSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_FELLSR_P24     = 0x1000000  // Bit P24.
	PIO_FELLSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_FELLSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_FELLSR_P25     = 0x2000000  // Bit P25.
	PIO_FELLSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_FELLSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_FELLSR_P26     = 0x4000000  // Bit P26.
	PIO_FELLSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_FELLSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_FELLSR_P27     = 0x8000000  // Bit P27.
	PIO_FELLSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_FELLSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_FELLSR_P28     = 0x10000000 // Bit P28.
	PIO_FELLSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_FELLSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_FELLSR_P29     = 0x20000000 // Bit P29.
	PIO_FELLSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_FELLSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_FELLSR_P30     = 0x40000000 // Bit P30.
	PIO_FELLSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_FELLSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_FELLSR_P31     = 0x80000000 // Bit P31.

	// REHLSR: Rising Edge/ High Level Select Register
	PIO_REHLSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_REHLSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_REHLSR_P0      = 0x1        // Bit P0.
	PIO_REHLSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_REHLSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_REHLSR_P1      = 0x2        // Bit P1.
	PIO_REHLSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_REHLSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_REHLSR_P2      = 0x4        // Bit P2.
	PIO_REHLSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_REHLSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_REHLSR_P3      = 0x8        // Bit P3.
	PIO_REHLSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_REHLSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_REHLSR_P4      = 0x10       // Bit P4.
	PIO_REHLSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_REHLSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_REHLSR_P5      = 0x20       // Bit P5.
	PIO_REHLSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_REHLSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_REHLSR_P6      = 0x40       // Bit P6.
	PIO_REHLSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_REHLSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_REHLSR_P7      = 0x80       // Bit P7.
	PIO_REHLSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_REHLSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_REHLSR_P8      = 0x100      // Bit P8.
	PIO_REHLSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_REHLSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_REHLSR_P9      = 0x200      // Bit P9.
	PIO_REHLSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_REHLSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_REHLSR_P10     = 0x400      // Bit P10.
	PIO_REHLSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_REHLSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_REHLSR_P11     = 0x800      // Bit P11.
	PIO_REHLSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_REHLSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_REHLSR_P12     = 0x1000     // Bit P12.
	PIO_REHLSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_REHLSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_REHLSR_P13     = 0x2000     // Bit P13.
	PIO_REHLSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_REHLSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_REHLSR_P14     = 0x4000     // Bit P14.
	PIO_REHLSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_REHLSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_REHLSR_P15     = 0x8000     // Bit P15.
	PIO_REHLSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_REHLSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_REHLSR_P16     = 0x10000    // Bit P16.
	PIO_REHLSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_REHLSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_REHLSR_P17     = 0x20000    // Bit P17.
	PIO_REHLSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_REHLSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_REHLSR_P18     = 0x40000    // Bit P18.
	PIO_REHLSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_REHLSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_REHLSR_P19     = 0x80000    // Bit P19.
	PIO_REHLSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_REHLSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_REHLSR_P20     = 0x100000   // Bit P20.
	PIO_REHLSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_REHLSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_REHLSR_P21     = 0x200000   // Bit P21.
	PIO_REHLSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_REHLSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_REHLSR_P22     = 0x400000   // Bit P22.
	PIO_REHLSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_REHLSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_REHLSR_P23     = 0x800000   // Bit P23.
	PIO_REHLSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_REHLSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_REHLSR_P24     = 0x1000000  // Bit P24.
	PIO_REHLSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_REHLSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_REHLSR_P25     = 0x2000000  // Bit P25.
	PIO_REHLSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_REHLSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_REHLSR_P26     = 0x4000000  // Bit P26.
	PIO_REHLSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_REHLSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_REHLSR_P27     = 0x8000000  // Bit P27.
	PIO_REHLSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_REHLSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_REHLSR_P28     = 0x10000000 // Bit P28.
	PIO_REHLSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_REHLSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_REHLSR_P29     = 0x20000000 // Bit P29.
	PIO_REHLSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_REHLSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_REHLSR_P30     = 0x40000000 // Bit P30.
	PIO_REHLSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_REHLSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_REHLSR_P31     = 0x80000000 // Bit P31.

	// FRLHSR: Fall/Rise - Low/High Status Register
	PIO_FRLHSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_FRLHSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_FRLHSR_P0      = 0x1        // Bit P0.
	PIO_FRLHSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_FRLHSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_FRLHSR_P1      = 0x2        // Bit P1.
	PIO_FRLHSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_FRLHSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_FRLHSR_P2      = 0x4        // Bit P2.
	PIO_FRLHSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_FRLHSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_FRLHSR_P3      = 0x8        // Bit P3.
	PIO_FRLHSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_FRLHSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_FRLHSR_P4      = 0x10       // Bit P4.
	PIO_FRLHSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_FRLHSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_FRLHSR_P5      = 0x20       // Bit P5.
	PIO_FRLHSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_FRLHSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_FRLHSR_P6      = 0x40       // Bit P6.
	PIO_FRLHSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_FRLHSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_FRLHSR_P7      = 0x80       // Bit P7.
	PIO_FRLHSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_FRLHSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_FRLHSR_P8      = 0x100      // Bit P8.
	PIO_FRLHSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_FRLHSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_FRLHSR_P9      = 0x200      // Bit P9.
	PIO_FRLHSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_FRLHSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_FRLHSR_P10     = 0x400      // Bit P10.
	PIO_FRLHSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_FRLHSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_FRLHSR_P11     = 0x800      // Bit P11.
	PIO_FRLHSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_FRLHSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_FRLHSR_P12     = 0x1000     // Bit P12.
	PIO_FRLHSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_FRLHSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_FRLHSR_P13     = 0x2000     // Bit P13.
	PIO_FRLHSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_FRLHSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_FRLHSR_P14     = 0x4000     // Bit P14.
	PIO_FRLHSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_FRLHSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_FRLHSR_P15     = 0x8000     // Bit P15.
	PIO_FRLHSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_FRLHSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_FRLHSR_P16     = 0x10000    // Bit P16.
	PIO_FRLHSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_FRLHSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_FRLHSR_P17     = 0x20000    // Bit P17.
	PIO_FRLHSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_FRLHSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_FRLHSR_P18     = 0x40000    // Bit P18.
	PIO_FRLHSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_FRLHSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_FRLHSR_P19     = 0x80000    // Bit P19.
	PIO_FRLHSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_FRLHSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_FRLHSR_P20     = 0x100000   // Bit P20.
	PIO_FRLHSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_FRLHSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_FRLHSR_P21     = 0x200000   // Bit P21.
	PIO_FRLHSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_FRLHSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_FRLHSR_P22     = 0x400000   // Bit P22.
	PIO_FRLHSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_FRLHSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_FRLHSR_P23     = 0x800000   // Bit P23.
	PIO_FRLHSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_FRLHSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_FRLHSR_P24     = 0x1000000  // Bit P24.
	PIO_FRLHSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_FRLHSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_FRLHSR_P25     = 0x2000000  // Bit P25.
	PIO_FRLHSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_FRLHSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_FRLHSR_P26     = 0x4000000  // Bit P26.
	PIO_FRLHSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_FRLHSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_FRLHSR_P27     = 0x8000000  // Bit P27.
	PIO_FRLHSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_FRLHSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_FRLHSR_P28     = 0x10000000 // Bit P28.
	PIO_FRLHSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_FRLHSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_FRLHSR_P29     = 0x20000000 // Bit P29.
	PIO_FRLHSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_FRLHSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_FRLHSR_P30     = 0x40000000 // Bit P30.
	PIO_FRLHSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_FRLHSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_FRLHSR_P31     = 0x80000000 // Bit P31.

	// LOCKSR: Lock Status
	PIO_LOCKSR_P0_Pos  = 0x0        // Position of P0 field.
	PIO_LOCKSR_P0_Msk  = 0x1        // Bit mask of P0 field.
	PIO_LOCKSR_P0      = 0x1        // Bit P0.
	PIO_LOCKSR_P1_Pos  = 0x1        // Position of P1 field.
	PIO_LOCKSR_P1_Msk  = 0x2        // Bit mask of P1 field.
	PIO_LOCKSR_P1      = 0x2        // Bit P1.
	PIO_LOCKSR_P2_Pos  = 0x2        // Position of P2 field.
	PIO_LOCKSR_P2_Msk  = 0x4        // Bit mask of P2 field.
	PIO_LOCKSR_P2      = 0x4        // Bit P2.
	PIO_LOCKSR_P3_Pos  = 0x3        // Position of P3 field.
	PIO_LOCKSR_P3_Msk  = 0x8        // Bit mask of P3 field.
	PIO_LOCKSR_P3      = 0x8        // Bit P3.
	PIO_LOCKSR_P4_Pos  = 0x4        // Position of P4 field.
	PIO_LOCKSR_P4_Msk  = 0x10       // Bit mask of P4 field.
	PIO_LOCKSR_P4      = 0x10       // Bit P4.
	PIO_LOCKSR_P5_Pos  = 0x5        // Position of P5 field.
	PIO_LOCKSR_P5_Msk  = 0x20       // Bit mask of P5 field.
	PIO_LOCKSR_P5      = 0x20       // Bit P5.
	PIO_LOCKSR_P6_Pos  = 0x6        // Position of P6 field.
	PIO_LOCKSR_P6_Msk  = 0x40       // Bit mask of P6 field.
	PIO_LOCKSR_P6      = 0x40       // Bit P6.
	PIO_LOCKSR_P7_Pos  = 0x7        // Position of P7 field.
	PIO_LOCKSR_P7_Msk  = 0x80       // Bit mask of P7 field.
	PIO_LOCKSR_P7      = 0x80       // Bit P7.
	PIO_LOCKSR_P8_Pos  = 0x8        // Position of P8 field.
	PIO_LOCKSR_P8_Msk  = 0x100      // Bit mask of P8 field.
	PIO_LOCKSR_P8      = 0x100      // Bit P8.
	PIO_LOCKSR_P9_Pos  = 0x9        // Position of P9 field.
	PIO_LOCKSR_P9_Msk  = 0x200      // Bit mask of P9 field.
	PIO_LOCKSR_P9      = 0x200      // Bit P9.
	PIO_LOCKSR_P10_Pos = 0xa        // Position of P10 field.
	PIO_LOCKSR_P10_Msk = 0x400      // Bit mask of P10 field.
	PIO_LOCKSR_P10     = 0x400      // Bit P10.
	PIO_LOCKSR_P11_Pos = 0xb        // Position of P11 field.
	PIO_LOCKSR_P11_Msk = 0x800      // Bit mask of P11 field.
	PIO_LOCKSR_P11     = 0x800      // Bit P11.
	PIO_LOCKSR_P12_Pos = 0xc        // Position of P12 field.
	PIO_LOCKSR_P12_Msk = 0x1000     // Bit mask of P12 field.
	PIO_LOCKSR_P12     = 0x1000     // Bit P12.
	PIO_LOCKSR_P13_Pos = 0xd        // Position of P13 field.
	PIO_LOCKSR_P13_Msk = 0x2000     // Bit mask of P13 field.
	PIO_LOCKSR_P13     = 0x2000     // Bit P13.
	PIO_LOCKSR_P14_Pos = 0xe        // Position of P14 field.
	PIO_LOCKSR_P14_Msk = 0x4000     // Bit mask of P14 field.
	PIO_LOCKSR_P14     = 0x4000     // Bit P14.
	PIO_LOCKSR_P15_Pos = 0xf        // Position of P15 field.
	PIO_LOCKSR_P15_Msk = 0x8000     // Bit mask of P15 field.
	PIO_LOCKSR_P15     = 0x8000     // Bit P15.
	PIO_LOCKSR_P16_Pos = 0x10       // Position of P16 field.
	PIO_LOCKSR_P16_Msk = 0x10000    // Bit mask of P16 field.
	PIO_LOCKSR_P16     = 0x10000    // Bit P16.
	PIO_LOCKSR_P17_Pos = 0x11       // Position of P17 field.
	PIO_LOCKSR_P17_Msk = 0x20000    // Bit mask of P17 field.
	PIO_LOCKSR_P17     = 0x20000    // Bit P17.
	PIO_LOCKSR_P18_Pos = 0x12       // Position of P18 field.
	PIO_LOCKSR_P18_Msk = 0x40000    // Bit mask of P18 field.
	PIO_LOCKSR_P18     = 0x40000    // Bit P18.
	PIO_LOCKSR_P19_Pos = 0x13       // Position of P19 field.
	PIO_LOCKSR_P19_Msk = 0x80000    // Bit mask of P19 field.
	PIO_LOCKSR_P19     = 0x80000    // Bit P19.
	PIO_LOCKSR_P20_Pos = 0x14       // Position of P20 field.
	PIO_LOCKSR_P20_Msk = 0x100000   // Bit mask of P20 field.
	PIO_LOCKSR_P20     = 0x100000   // Bit P20.
	PIO_LOCKSR_P21_Pos = 0x15       // Position of P21 field.
	PIO_LOCKSR_P21_Msk = 0x200000   // Bit mask of P21 field.
	PIO_LOCKSR_P21     = 0x200000   // Bit P21.
	PIO_LOCKSR_P22_Pos = 0x16       // Position of P22 field.
	PIO_LOCKSR_P22_Msk = 0x400000   // Bit mask of P22 field.
	PIO_LOCKSR_P22     = 0x400000   // Bit P22.
	PIO_LOCKSR_P23_Pos = 0x17       // Position of P23 field.
	PIO_LOCKSR_P23_Msk = 0x800000   // Bit mask of P23 field.
	PIO_LOCKSR_P23     = 0x800000   // Bit P23.
	PIO_LOCKSR_P24_Pos = 0x18       // Position of P24 field.
	PIO_LOCKSR_P24_Msk = 0x1000000  // Bit mask of P24 field.
	PIO_LOCKSR_P24     = 0x1000000  // Bit P24.
	PIO_LOCKSR_P25_Pos = 0x19       // Position of P25 field.
	PIO_LOCKSR_P25_Msk = 0x2000000  // Bit mask of P25 field.
	PIO_LOCKSR_P25     = 0x2000000  // Bit P25.
	PIO_LOCKSR_P26_Pos = 0x1a       // Position of P26 field.
	PIO_LOCKSR_P26_Msk = 0x4000000  // Bit mask of P26 field.
	PIO_LOCKSR_P26     = 0x4000000  // Bit P26.
	PIO_LOCKSR_P27_Pos = 0x1b       // Position of P27 field.
	PIO_LOCKSR_P27_Msk = 0x8000000  // Bit mask of P27 field.
	PIO_LOCKSR_P27     = 0x8000000  // Bit P27.
	PIO_LOCKSR_P28_Pos = 0x1c       // Position of P28 field.
	PIO_LOCKSR_P28_Msk = 0x10000000 // Bit mask of P28 field.
	PIO_LOCKSR_P28     = 0x10000000 // Bit P28.
	PIO_LOCKSR_P29_Pos = 0x1d       // Position of P29 field.
	PIO_LOCKSR_P29_Msk = 0x20000000 // Bit mask of P29 field.
	PIO_LOCKSR_P29     = 0x20000000 // Bit P29.
	PIO_LOCKSR_P30_Pos = 0x1e       // Position of P30 field.
	PIO_LOCKSR_P30_Msk = 0x40000000 // Bit mask of P30 field.
	PIO_LOCKSR_P30     = 0x40000000 // Bit P30.
	PIO_LOCKSR_P31_Pos = 0x1f       // Position of P31 field.
	PIO_LOCKSR_P31_Msk = 0x80000000 // Bit mask of P31 field.
	PIO_LOCKSR_P31     = 0x80000000 // Bit P31.

	// WPMR: Write Protect Mode Register
	PIO_WPMR_WPEN_Pos  = 0x0        // Position of WPEN field.
	PIO_WPMR_WPEN_Msk  = 0x1        // Bit mask of WPEN field.
	PIO_WPMR_WPEN      = 0x1        // Bit WPEN.
	PIO_WPMR_WPKEY_Pos = 0x8        // Position of WPKEY field.
	PIO_WPMR_WPKEY_Msk = 0xffffff00 // Bit mask of WPKEY field.

	// WPSR: Write Protect Status Register
	PIO_WPSR_WPVS_Pos   = 0x0      // Position of WPVS field.
	PIO_WPSR_WPVS_Msk   = 0x1      // Bit mask of WPVS field.
	PIO_WPSR_WPVS       = 0x1      // Bit WPVS.
	PIO_WPSR_WPVSRC_Pos = 0x8      // Position of WPVSRC field.
	PIO_WPSR_WPVSRC_Msk = 0xffff00 // Bit mask of WPVSRC field.

	// SCHMITT: Schmitt Trigger Register
	PIO_SCHMITT_SCHMITT0_Pos  = 0x0        // Position of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0_Msk  = 0x1        // Bit mask of SCHMITT0 field.
	PIO_SCHMITT_SCHMITT0      = 0x1        // Bit SCHMITT0.
	PIO_SCHMITT_SCHMITT1_Pos  = 0x1        // Position of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1_Msk  = 0x2        // Bit mask of SCHMITT1 field.
	PIO_SCHMITT_SCHMITT1      = 0x2        // Bit SCHMITT1.
	PIO_SCHMITT_SCHMITT2_Pos  = 0x2        // Position of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2_Msk  = 0x4        // Bit mask of SCHMITT2 field.
	PIO_SCHMITT_SCHMITT2      = 0x4        // Bit SCHMITT2.
	PIO_SCHMITT_SCHMITT3_Pos  = 0x3        // Position of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3_Msk  = 0x8        // Bit mask of SCHMITT3 field.
	PIO_SCHMITT_SCHMITT3      = 0x8        // Bit SCHMITT3.
	PIO_SCHMITT_SCHMITT4_Pos  = 0x4        // Position of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4_Msk  = 0x10       // Bit mask of SCHMITT4 field.
	PIO_SCHMITT_SCHMITT4      = 0x10       // Bit SCHMITT4.
	PIO_SCHMITT_SCHMITT5_Pos  = 0x5        // Position of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5_Msk  = 0x20       // Bit mask of SCHMITT5 field.
	PIO_SCHMITT_SCHMITT5      = 0x20       // Bit SCHMITT5.
	PIO_SCHMITT_SCHMITT6_Pos  = 0x6        // Position of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6_Msk  = 0x40       // Bit mask of SCHMITT6 field.
	PIO_SCHMITT_SCHMITT6      = 0x40       // Bit SCHMITT6.
	PIO_SCHMITT_SCHMITT7_Pos  = 0x7        // Position of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7_Msk  = 0x80       // Bit mask of SCHMITT7 field.
	PIO_SCHMITT_SCHMITT7      = 0x80       // Bit SCHMITT7.
	PIO_SCHMITT_SCHMITT8_Pos  = 0x8        // Position of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8_Msk  = 0x100      // Bit mask of SCHMITT8 field.
	PIO_SCHMITT_SCHMITT8      = 0x100      // Bit SCHMITT8.
	PIO_SCHMITT_SCHMITT9_Pos  = 0x9        // Position of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9_Msk  = 0x200      // Bit mask of SCHMITT9 field.
	PIO_SCHMITT_SCHMITT9      = 0x200      // Bit SCHMITT9.
	PIO_SCHMITT_SCHMITT10_Pos = 0xa        // Position of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10_Msk = 0x400      // Bit mask of SCHMITT10 field.
	PIO_SCHMITT_SCHMITT10     = 0x400      // Bit SCHMITT10.
	PIO_SCHMITT_SCHMITT11_Pos = 0xb        // Position of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11_Msk = 0x800      // Bit mask of SCHMITT11 field.
	PIO_SCHMITT_SCHMITT11     = 0x800      // Bit SCHMITT11.
	PIO_SCHMITT_SCHMITT12_Pos = 0xc        // Position of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12_Msk = 0x1000     // Bit mask of SCHMITT12 field.
	PIO_SCHMITT_SCHMITT12     = 0x1000     // Bit SCHMITT12.
	PIO_SCHMITT_SCHMITT13_Pos = 0xd        // Position of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13_Msk = 0x2000     // Bit mask of SCHMITT13 field.
	PIO_SCHMITT_SCHMITT13     = 0x2000     // Bit SCHMITT13.
	PIO_SCHMITT_SCHMITT14_Pos = 0xe        // Position of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14_Msk = 0x4000     // Bit mask of SCHMITT14 field.
	PIO_SCHMITT_SCHMITT14     = 0x4000     // Bit SCHMITT14.
	PIO_SCHMITT_SCHMITT15_Pos = 0xf        // Position of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15_Msk = 0x8000     // Bit mask of SCHMITT15 field.
	PIO_SCHMITT_SCHMITT15     = 0x8000     // Bit SCHMITT15.
	PIO_SCHMITT_SCHMITT16_Pos = 0x10       // Position of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16_Msk = 0x10000    // Bit mask of SCHMITT16 field.
	PIO_SCHMITT_SCHMITT16     = 0x10000    // Bit SCHMITT16.
	PIO_SCHMITT_SCHMITT17_Pos = 0x11       // Position of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17_Msk = 0x20000    // Bit mask of SCHMITT17 field.
	PIO_SCHMITT_SCHMITT17     = 0x20000    // Bit SCHMITT17.
	PIO_SCHMITT_SCHMITT18_Pos = 0x12       // Position of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18_Msk = 0x40000    // Bit mask of SCHMITT18 field.
	PIO_SCHMITT_SCHMITT18     = 0x40000    // Bit SCHMITT18.
	PIO_SCHMITT_SCHMITT19_Pos = 0x13       // Position of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19_Msk = 0x80000    // Bit mask of SCHMITT19 field.
	PIO_SCHMITT_SCHMITT19     = 0x80000    // Bit SCHMITT19.
	PIO_SCHMITT_SCHMITT20_Pos = 0x14       // Position of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20_Msk = 0x100000   // Bit mask of SCHMITT20 field.
	PIO_SCHMITT_SCHMITT20     = 0x100000   // Bit SCHMITT20.
	PIO_SCHMITT_SCHMITT21_Pos = 0x15       // Position of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21_Msk = 0x200000   // Bit mask of SCHMITT21 field.
	PIO_SCHMITT_SCHMITT21     = 0x200000   // Bit SCHMITT21.
	PIO_SCHMITT_SCHMITT22_Pos = 0x16       // Position of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22_Msk = 0x400000   // Bit mask of SCHMITT22 field.
	PIO_SCHMITT_SCHMITT22     = 0x400000   // Bit SCHMITT22.
	PIO_SCHMITT_SCHMITT23_Pos = 0x17       // Position of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23_Msk = 0x800000   // Bit mask of SCHMITT23 field.
	PIO_SCHMITT_SCHMITT23     = 0x800000   // Bit SCHMITT23.
	PIO_SCHMITT_SCHMITT24_Pos = 0x18       // Position of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24_Msk = 0x1000000  // Bit mask of SCHMITT24 field.
	PIO_SCHMITT_SCHMITT24     = 0x1000000  // Bit SCHMITT24.
	PIO_SCHMITT_SCHMITT25_Pos = 0x19       // Position of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25_Msk = 0x2000000  // Bit mask of SCHMITT25 field.
	PIO_SCHMITT_SCHMITT25     = 0x2000000  // Bit SCHMITT25.
	PIO_SCHMITT_SCHMITT26_Pos = 0x1a       // Position of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26_Msk = 0x4000000  // Bit mask of SCHMITT26 field.
	PIO_SCHMITT_SCHMITT26     = 0x4000000  // Bit SCHMITT26.
	PIO_SCHMITT_SCHMITT27_Pos = 0x1b       // Position of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27_Msk = 0x8000000  // Bit mask of SCHMITT27 field.
	PIO_SCHMITT_SCHMITT27     = 0x8000000  // Bit SCHMITT27.
	PIO_SCHMITT_SCHMITT28_Pos = 0x1c       // Position of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28_Msk = 0x10000000 // Bit mask of SCHMITT28 field.
	PIO_SCHMITT_SCHMITT28     = 0x10000000 // Bit SCHMITT28.
	PIO_SCHMITT_SCHMITT29_Pos = 0x1d       // Position of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29_Msk = 0x20000000 // Bit mask of SCHMITT29 field.
	PIO_SCHMITT_SCHMITT29     = 0x20000000 // Bit SCHMITT29.
	PIO_SCHMITT_SCHMITT30_Pos = 0x1e       // Position of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30_Msk = 0x40000000 // Bit mask of SCHMITT30 field.
	PIO_SCHMITT_SCHMITT30     = 0x40000000 // Bit SCHMITT30.
	PIO_SCHMITT_SCHMITT31_Pos = 0x1f       // Position of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31_Msk = 0x80000000 // Bit mask of SCHMITT31 field.
	PIO_SCHMITT_SCHMITT31     = 0x80000000 // Bit SCHMITT31.
)

// Bitfields for RSTC: Reset Controller
const (
	// CR: Control Register
	SYSC_CR_PROCRST_Pos = 0x0        // Position of PROCRST field.
	SYSC_CR_PROCRST_Msk = 0x1        // Bit mask of PROCRST field.
	SYSC_CR_PROCRST     = 0x1        // Bit PROCRST.
	SYSC_CR_PERRST_Pos  = 0x2        // Position of PERRST field.
	SYSC_CR_PERRST_Msk  = 0x4        // Bit mask of PERRST field.
	SYSC_CR_PERRST      = 0x4        // Bit PERRST.
	SYSC_CR_EXTRST_Pos  = 0x3        // Position of EXTRST field.
	SYSC_CR_EXTRST_Msk  = 0x8        // Bit mask of EXTRST field.
	SYSC_CR_EXTRST      = 0x8        // Bit EXTRST.
	SYSC_CR_KEY_Pos     = 0x18       // Position of KEY field.
	SYSC_CR_KEY_Msk     = 0xff000000 // Bit mask of KEY field.

	// SR: Status Register
	SYSC_SR_URSTS_Pos  = 0x0     // Position of URSTS field.
	SYSC_SR_URSTS_Msk  = 0x1     // Bit mask of URSTS field.
	SYSC_SR_URSTS      = 0x1     // Bit URSTS.
	SYSC_SR_RSTTYP_Pos = 0x8     // Position of RSTTYP field.
	SYSC_SR_RSTTYP_Msk = 0x700   // Bit mask of RSTTYP field.
	SYSC_SR_NRSTL_Pos  = 0x10    // Position of NRSTL field.
	SYSC_SR_NRSTL_Msk  = 0x10000 // Bit mask of NRSTL field.
	SYSC_SR_NRSTL      = 0x10000 // Bit NRSTL.
	SYSC_SR_SRCMP_Pos  = 0x11    // Position of SRCMP field.
	SYSC_SR_SRCMP_Msk  = 0x20000 // Bit mask of SRCMP field.
	SYSC_SR_SRCMP      = 0x20000 // Bit SRCMP.

	// MR: Mode Register
	SYSC_MR_URSTEN_Pos  = 0x0        // Position of URSTEN field.
	SYSC_MR_URSTEN_Msk  = 0x1        // Bit mask of URSTEN field.
	SYSC_MR_URSTEN      = 0x1        // Bit URSTEN.
	SYSC_MR_URSTIEN_Pos = 0x4        // Position of URSTIEN field.
	SYSC_MR_URSTIEN_Msk = 0x10       // Bit mask of URSTIEN field.
	SYSC_MR_URSTIEN     = 0x10       // Bit URSTIEN.
	SYSC_MR_ERSTL_Pos   = 0x8        // Position of ERSTL field.
	SYSC_MR_ERSTL_Msk   = 0xf00      // Bit mask of ERSTL field.
	SYSC_MR_KEY_Pos     = 0x18       // Position of KEY field.
	SYSC_MR_KEY_Msk     = 0xff000000 // Bit mask of KEY field.
)
