# Copyright: (c) 2018, Pluribus Networks
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import json

from ansible_collections.community.network.tests.unit.compat.mock import patch
from ansible_collections.community.network.plugins.modules.network.netvisor import pn_vtep
from ansible_collections.community.network.tests.unit.plugins.modules.utils import set_module_args
from .nvos_module import TestNvosModule, load_fixture


class TestVtepModule(TestNvosModule):

    module = pn_vtep

    def setUp(self):
        self.mock_run_nvos_commands = patch('ansible_collections.community.network.plugins.modules.network.netvisor.pn_vtep.run_cli')
        self.run_nvos_commands = self.mock_run_nvos_commands.start()

        self.mock_run_check_cli = patch('ansible_collections.community.network.plugins.modules.network.netvisor.pn_vtep.check_cli')
        self.run_check_cli = self.mock_run_check_cli.start()

    def tearDown(self):
        self.mock_run_nvos_commands.stop()
        self.mock_run_check_cli.stop()

    def run_cli_patch(self, module, cli, state_map):
        if state_map['present'] == 'vtep-create':
            results = dict(
                changed=True,
                cli_cmd=cli
            )
        elif state_map['absent'] == 'vtep-delete':
            results = dict(
                changed=True,
                cli_cmd=cli
            )
        module.exit_json(**results)

    def load_fixtures(self, commands=None, state=None, transport='cli'):
        self.run_nvos_commands.side_effect = self.run_cli_patch
        if state == 'present':
            self.run_check_cli.return_value = False
        if state == 'absent':
            self.run_check_cli.return_value = True

    def test_vtep_create(self):
        set_module_args({'pn_cliswitch': 'sw01', 'pn_name': 'foo',
                         'pn_vrouter_name': 'sw01-vrouter', 'pn_location': 'sw01', 'pn_ip': '192.168.1.10',
                         'pn_virtual_ip': '192.168.1.9', 'state': 'present'})
        result = self.execute_module(changed=True, state='present')
        expected_cmd = ' switch sw01 vtep-create name foo vrouter-name sw01-vrouter ip 192.168.1.10 location sw01 virtual-ip 192.168.1.9 '
        self.assertEqual(result['cli_cmd'], expected_cmd)

    def test_vtep_delete(self):
        set_module_args({'pn_cliswitch': 'sw01', 'pn_name': 'foo',
                         'state': 'absent'})
        result = self.execute_module(changed=True, state='absent')
        expected_cmd = ' switch sw01 vtep-delete name foo '
        self.assertEqual(result['cli_cmd'], expected_cmd)
