/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.apache.tomcat.util.buf.B2CConverter;

public final class URLEncoder
implements Cloneable {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final URLEncoder DEFAULT = new URLEncoder();
    public static final URLEncoder QUERY = new URLEncoder();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public URLEncoder() {
        this(new BitSet(256));
        char c;
        for (c = 'a'; c <= 'z'; c = (char)((char)(c + '\u0001'))) {
            this.addSafeCharacter(c);
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.addSafeCharacter(c);
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            this.addSafeCharacter(c);
        }
    }

    private URLEncoder(BitSet bitSet) {
        this.safeCharacters = bitSet;
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public void removeSafeCharacter(char c) {
        this.safeCharacters.clear(c);
    }

    public void setEncodeSpaceAsPlus(boolean bl) {
        this.encodeSpaceAsPlus = bl;
    }

    @Deprecated
    public String encode(String string) {
        return this.encode(string, "UTF-8");
    }

    @Deprecated
    public String encode(String string, String string2) {
        Charset charset;
        try {
            charset = B2CConverter.getCharset((String)string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            charset = Charset.defaultCharset();
        }
        return this.encode(string, charset);
    }

    public String encode(String string, Charset charset) {
        int n = 10;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);
        for (int i = 0; i < string.length(); ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            if (this.safeCharacters.get(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                stringBuilder.append('+');
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            for (byte by : byArray = byteArrayOutputStream.toByteArray()) {
                stringBuilder.append('%');
                int n2 = by & 0xF;
                int n3 = (by & 0xF0) >> 4;
                stringBuilder.append(hexadecimal[n3]);
                stringBuilder.append(hexadecimal[n2]);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuilder.toString();
    }

    public Object clone() {
        URLEncoder uRLEncoder = new URLEncoder((BitSet)this.safeCharacters.clone());
        uRLEncoder.setEncodeSpaceAsPlus(this.encodeSpaceAsPlus);
        return uRLEncoder;
    }

    static {
        DEFAULT.addSafeCharacter('-');
        DEFAULT.addSafeCharacter('.');
        DEFAULT.addSafeCharacter('_');
        DEFAULT.addSafeCharacter('~');
        DEFAULT.addSafeCharacter('!');
        DEFAULT.addSafeCharacter('$');
        DEFAULT.addSafeCharacter('&');
        DEFAULT.addSafeCharacter('\'');
        DEFAULT.addSafeCharacter('(');
        DEFAULT.addSafeCharacter(')');
        DEFAULT.addSafeCharacter('*');
        DEFAULT.addSafeCharacter('+');
        DEFAULT.addSafeCharacter(',');
        DEFAULT.addSafeCharacter(';');
        DEFAULT.addSafeCharacter('=');
        DEFAULT.addSafeCharacter(':');
        DEFAULT.addSafeCharacter('@');
        DEFAULT.addSafeCharacter('/');
        QUERY.setEncodeSpaceAsPlus(true);
        QUERY.addSafeCharacter('*');
        QUERY.addSafeCharacter('-');
        QUERY.addSafeCharacter('.');
        QUERY.addSafeCharacter('_');
        QUERY.addSafeCharacter('=');
        QUERY.addSafeCharacter('&');
    }
}

