/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.builder.multithreaded;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ConcurrencyDependencyGraph;
import org.apache.maven.lifecycle.internal.builder.multithreaded.ThreadOutputMuxer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=Builder.class, hint="multithreaded")
public class MultiThreadedBuilder
implements Builder {
    @Requirement
    private Logger logger;
    @Requirement
    private LifecycleModuleBuilder lifecycleModuleBuilder;

    @Override
    public void build(MavenSession session, ReactorContext reactorContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) throws ExecutionException, InterruptedException {
        int nThreads = Math.min(session.getRequest().getDegreeOfConcurrency(), session.getProjects().size());
        boolean parallel = nThreads >= 2;
        session.setParallel(parallel);
        for (ProjectSegment segment : projectBuilds) {
            segment.getSession().setParallel(parallel);
        }
        ExecutorService executor = Executors.newFixedThreadPool(nThreads, new BuildThreadFactory());
        ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
        ThreadOutputMuxer muxer = null;
        for (TaskSegment taskSegment : taskSegments) {
            ProjectBuildList segmentProjectBuilds = projectBuilds.getByTaskSegment(taskSegment);
            Map<MavenProject, ProjectSegment> projectBuildMap = projectBuilds.selectSegment(taskSegment);
            try {
                ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(segmentProjectBuilds, session.getProjectDependencyGraph());
                this.multiThreadedProjectTaskSegmentBuild(analyzer, reactorContext, session, service, taskSegment, projectBuildMap, muxer);
                if (!reactorContext.getReactorBuildStatus().isHalted()) continue;
            }
            catch (Exception e2) {
                session.getResult().addException(e2);
            }
            break;
        }
        executor.shutdown();
        executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    private void multiThreadedProjectTaskSegmentBuild(ConcurrencyDependencyGraph analyzer, ReactorContext reactorContext, MavenSession rootSession, CompletionService<ProjectSegment> service, TaskSegment taskSegment, Map<MavenProject, ProjectSegment> projectBuildList, ThreadOutputMuxer muxer) {
        for (MavenProject mavenProject : analyzer.getRootSchedulableBuilds()) {
            ProjectSegment projectSegment = projectBuildList.get(mavenProject);
            this.logger.debug("Scheduling: " + projectSegment.getProject());
            Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, projectSegment, reactorContext, taskSegment, muxer);
            service.submit(cb);
        }
        for (int i = 0; i < analyzer.getNumberOfBuilds(); ++i) {
            try {
                ProjectSegment projectBuild = service.take().get();
                if (reactorContext.getReactorBuildStatus().isHalted()) break;
                if (analyzer.getNumberOfBuilds() <= 1) continue;
                List<MavenProject> newItemsThatCanBeBuilt = analyzer.markAsFinished(projectBuild.getProject());
                for (MavenProject mavenProject : newItemsThatCanBeBuilt) {
                    ProjectSegment scheduledDependent = projectBuildList.get(mavenProject);
                    this.logger.debug("Scheduling: " + scheduledDependent);
                    Callable<ProjectSegment> cb = this.createBuildCallable(rootSession, scheduledDependent, reactorContext, taskSegment, muxer);
                    service.submit(cb);
                }
                continue;
            }
            catch (InterruptedException e2) {
                rootSession.getResult().addException(e2);
                break;
            }
            catch (ExecutionException e3) {
                rootSession.getResult().addException(e3);
                break;
            }
        }
    }

    private Callable<ProjectSegment> createBuildCallable(final MavenSession rootSession, final ProjectSegment projectBuild, final ReactorContext reactorContext, final TaskSegment taskSegment, ThreadOutputMuxer muxer) {
        return new Callable<ProjectSegment>(){

            @Override
            public ProjectSegment call() {
                MultiThreadedBuilder.this.lifecycleModuleBuilder.buildProject(projectBuild.getSession(), rootSession, reactorContext, projectBuild.getProject(), taskSegment);
                return projectBuild;
            }
        };
    }
}

