/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filterpanel;

import javafx.beans.property.StringProperty;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import org.controlsfx.control.textfield.CustomTextField;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;

public class JFXSearchPanel
extends CustomTextField {
    public JFXSearchPanel() {
        this.init();
        this.setPrefWidth(350.0);
        this.setMinWidth(350.0);
        this.setMaxWidth(350.0);
    }

    private void init() {
        GlyphFont fontAwesome = GlyphFontRegistry.font("FontAwesome");
        this.setLeft(fontAwesome.create(FontAwesome.Glyph.SEARCH));
        this.setRight(fontAwesome.create(FontAwesome.Glyph.REMOVE));
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                if (!this.getText().isEmpty()) {
                    this.setText("");
                }
                event.consume();
            }
        });
        Node rightNode = this.getRight();
        rightNode.setOnMouseClicked(evt -> this.setText(""));
        rightNode.setCursor(Cursor.DEFAULT);
        rightNode.setVisible(false);
        StringProperty textProperty = this.textProperty();
        textProperty.addListener((observable2, oldValue, newValue) -> rightNode.setVisible(!newValue.isEmpty()));
    }
}

