/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.res.StringManager;

public abstract class SSLImplementation {
    private static final Log logger = LogFactory.getLog(SSLImplementation.class);
    private static final StringManager sm = StringManager.getManager(SSLImplementation.class);

    public static SSLImplementation getInstance(String string) throws ClassNotFoundException {
        if (string == null) {
            return new JSSEImplementation();
        }
        try {
            Class<?> clazz = Class.forName(string);
            return (SSLImplementation)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            String string2 = sm.getString("sslImplementation.cnfe", new Object[]{string});
            if (logger.isDebugEnabled()) {
                logger.debug((Object)string2, (Throwable)exception);
            }
            throw new ClassNotFoundException(string2, exception);
        }
    }

    public abstract SSLSupport getSSLSupport(SSLSession var1);

    public abstract SSLUtil getSSLUtil(SSLHostConfigCertificate var1);

    public abstract boolean isAlpnSupported();
}

