/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;

public class TLSClientHelloExtractor {
    private static final Log log = LogFactory.getLog(TLSClientHelloExtractor.class);
    private static final StringManager sm = StringManager.getManager(TLSClientHelloExtractor.class);
    private final ExtractorResult result;
    private final List<Cipher> clientRequestedCiphers;
    private final String sniValue;
    private final List<String> clientRequestedApplicationProtocols;
    private static final int TLS_RECORD_HEADER_LEN = 5;
    private static final int TLS_EXTENSION_SERVER_NAME = 0;
    private static final int TLS_EXTENSION_ALPN = 16;
    public static byte[] USE_TLS_RESPONSE = "HTTP/1.1 400 \r\nContent-Type: text/plain;charset=UTF-8\r\nConnection: close\r\n\r\nBad Request\r\nThis combination of host and port requires TLS.\r\n".getBytes(StandardCharsets.UTF_8);

    public TLSClientHelloExtractor(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        ExtractorResult extractorResult = ExtractorResult.NOT_PRESENT;
        ArrayList<Cipher> arrayList = new ArrayList<Cipher>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = null;
        try {
            char c;
            int n3;
            byteBuffer.flip();
            if (!TLSClientHelloExtractor.isAvailable(byteBuffer, 5)) {
                extractorResult = TLSClientHelloExtractor.handleIncompleteRead(byteBuffer);
                return;
            }
            if (!TLSClientHelloExtractor.isTLSHandshake(byteBuffer)) {
                if (TLSClientHelloExtractor.isHttp(byteBuffer)) {
                    extractorResult = ExtractorResult.NON_SECURE;
                }
                return;
            }
            if (!TLSClientHelloExtractor.isAllRecordAvailable(byteBuffer)) {
                extractorResult = TLSClientHelloExtractor.handleIncompleteRead(byteBuffer);
                return;
            }
            if (!TLSClientHelloExtractor.isClientHello(byteBuffer)) {
                return;
            }
            if (!TLSClientHelloExtractor.isAllClientHelloAvailable(byteBuffer)) {
                log.warn((Object)sm.getString("sniExtractor.clientHelloTooBig"));
                return;
            }
            TLSClientHelloExtractor.skipBytes(byteBuffer, 2);
            TLSClientHelloExtractor.skipBytes(byteBuffer, 32);
            TLSClientHelloExtractor.skipBytes(byteBuffer, byteBuffer.get() & 0xFF);
            int n4 = byteBuffer.getChar() / 2;
            for (n3 = 0; n3 < n4; ++n3) {
                c = byteBuffer.getChar();
                arrayList.add(Cipher.valueOf(c));
            }
            TLSClientHelloExtractor.skipBytes(byteBuffer, byteBuffer.get() & 0xFF);
            if (!byteBuffer.hasRemaining()) {
                return;
            }
            TLSClientHelloExtractor.skipBytes(byteBuffer, 2);
            block16: while (byteBuffer.hasRemaining() && (string == null || arrayList2.size() == 0)) {
                n3 = byteBuffer.getChar();
                c = byteBuffer.getChar();
                switch (n3) {
                    case 0: {
                        string = TLSClientHelloExtractor.readSniExtension(byteBuffer);
                        continue block16;
                    }
                    case 16: {
                        TLSClientHelloExtractor.readAlpnExtension(byteBuffer, arrayList2);
                        continue block16;
                    }
                }
                TLSClientHelloExtractor.skipBytes(byteBuffer, c);
            }
            extractorResult = ExtractorResult.COMPLETE;
        }
        catch (IllegalArgumentException | BufferUnderflowException runtimeException) {
            throw new IOException(sm.getString("sniExtractor.clientHelloInvalid"), runtimeException);
        }
        finally {
            this.result = extractorResult;
            this.clientRequestedCiphers = arrayList;
            this.clientRequestedApplicationProtocols = arrayList2;
            this.sniValue = string;
            byteBuffer.limit(n2);
            byteBuffer.position(n);
        }
    }

    public ExtractorResult getResult() {
        return this.result;
    }

    public String getSNIValue() {
        if (this.result == ExtractorResult.COMPLETE) {
            return this.sniValue;
        }
        throw new IllegalStateException();
    }

    public List<Cipher> getClientRequestedCiphers() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedCiphers;
        }
        throw new IllegalStateException();
    }

    public List<String> getClientRequestedApplicationProtocols() {
        if (this.result == ExtractorResult.COMPLETE || this.result == ExtractorResult.NOT_PRESENT) {
            return this.clientRequestedApplicationProtocols;
        }
        throw new IllegalStateException();
    }

    private static ExtractorResult handleIncompleteRead(ByteBuffer byteBuffer) {
        if (byteBuffer.limit() == byteBuffer.capacity()) {
            return ExtractorResult.UNDERFLOW;
        }
        return ExtractorResult.NEED_READ;
    }

    private static boolean isAvailable(ByteBuffer byteBuffer, int n) {
        if (byteBuffer.remaining() < n) {
            byteBuffer.position(byteBuffer.limit());
            return false;
        }
        return true;
    }

    private static boolean isTLSHandshake(ByteBuffer byteBuffer) {
        if (byteBuffer.get() != 22) {
            return false;
        }
        byte by = byteBuffer.get();
        byte by2 = byteBuffer.get();
        return by >= 3 && (by != 3 || by2 != 0);
    }

    private static boolean isHttp(ByteBuffer byteBuffer) {
        byte by = 0;
        byteBuffer.position(0);
        do {
            if (byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) == 13 || by == 10);
        do {
            if (HttpParser.isToken(by) && byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) != 32 && by != 9);
        while (by == 32 || by == 9) {
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        while (by != 32 && by != 9) {
            if (HttpParser.isNotRequestTarget(by) || !byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        while (by == 32 || by == 9) {
            if (!byteBuffer.hasRemaining()) {
                return false;
            }
            by = byteBuffer.get();
        }
        do {
            if (HttpParser.isHttpProtocol(by) && byteBuffer.hasRemaining()) continue;
            return false;
        } while ((by = byteBuffer.get()) != 13 && by != 10);
        return true;
    }

    private static boolean isAllRecordAvailable(ByteBuffer byteBuffer) {
        char c = byteBuffer.getChar();
        return TLSClientHelloExtractor.isAvailable(byteBuffer, c);
    }

    private static boolean isClientHello(ByteBuffer byteBuffer) {
        return byteBuffer.get() == 1;
    }

    private static boolean isAllClientHelloAvailable(ByteBuffer byteBuffer) {
        int n = ((byteBuffer.get() & 0xFF) << 16) + ((byteBuffer.get() & 0xFF) << 8) + (byteBuffer.get() & 0xFF);
        return TLSClientHelloExtractor.isAvailable(byteBuffer, n);
    }

    private static void skipBytes(ByteBuffer byteBuffer, int n) {
        byteBuffer.position(byteBuffer.position() + n);
    }

    private static String readSniExtension(ByteBuffer byteBuffer) {
        TLSClientHelloExtractor.skipBytes(byteBuffer, 3);
        char c = byteBuffer.getChar();
        byte[] byArray = new byte[c];
        byteBuffer.get(byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    private static void readAlpnExtension(ByteBuffer byteBuffer, List<String> list) {
        char c = byteBuffer.getChar();
        byte[] byArray = new byte[255];
        while (c > '\u0000') {
            int n = byteBuffer.get() & 0xFF;
            byteBuffer.get(byArray, 0, n);
            list.add(new String(byArray, 0, n, StandardCharsets.UTF_8));
            c = (char)(c - '\u0001');
            c = (char)(c - n);
        }
    }

    public static enum ExtractorResult {
        COMPLETE,
        NOT_PRESENT,
        UNDERFLOW,
        NEED_READ,
        NON_SECURE;

    }
}

