/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.HmacCore;
import com.sun.crypto.provider.PBKDF2Core;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBMAC1Core
extends HmacCore {
    private final String kdfAlgo;
    private final String hashAlgo;
    private final int blockLength;

    PBMAC1Core(String kdfAlgo, String hashAlgo, int blockLength) throws NoSuchAlgorithmException {
        super(hashAlgo, blockLength);
        this.kdfAlgo = kdfAlgo;
        this.hashAlgo = hashAlgo;
        this.blockLength = blockLength;
    }

    private static PBKDF2Core getKDFImpl(String algo) {
        PBKDF2Core kdf = null;
        switch (algo) {
            case "HmacSHA1": {
                kdf = new PBKDF2Core.HmacSHA1();
                break;
            }
            case "HmacSHA224": {
                kdf = new PBKDF2Core.HmacSHA224();
                break;
            }
            case "HmacSHA256": {
                kdf = new PBKDF2Core.HmacSHA256();
                break;
            }
            case "HmacSHA384": {
                kdf = new PBKDF2Core.HmacSHA384();
                break;
            }
            case "HmacSHA512": {
                kdf = new PBKDF2Core.HmacSHA512();
                break;
            }
            default: {
                throw new ProviderException("No MAC implementation for " + algo);
            }
        }
        return kdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKey s;
        PBEKeySpec pbeSpec;
        char[] passwdChars;
        byte[] salt = null;
        int iCount = 0;
        if (key instanceof PBEKey) {
            PBEKey pbeKey = (PBEKey)key;
            passwdChars = pbeKey.getPassword();
            salt = pbeKey.getSalt();
            iCount = pbeKey.getIterationCount();
        } else if (key instanceof SecretKey) {
            byte[] passwdBytes;
            if (!key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3) || (passwdBytes = key.getEncoded()) == null) {
                throw new InvalidKeyException("Missing password");
            }
            passwdChars = new char[passwdBytes.length];
            for (int i = 0; i < passwdChars.length; ++i) {
                passwdChars[i] = (char)(passwdBytes[i] & 0x7F);
            }
            Arrays.fill(passwdBytes, (byte)0);
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        try {
            if (params == null) {
                if (salt == null || iCount == 0) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec required for salt and iteration count");
                }
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
                }
                PBEParameterSpec pbeParams = (PBEParameterSpec)params;
                if (salt != null) {
                    if (!Arrays.equals(salt, pbeParams.getSalt())) {
                        throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                    }
                } else {
                    salt = pbeParams.getSalt();
                }
                if (iCount != 0) {
                    if (iCount != pbeParams.getIterationCount()) {
                        throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                    }
                } else {
                    iCount = pbeParams.getIterationCount();
                }
            }
            if (salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            if (iCount <= 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            pbeSpec = new PBEKeySpec(passwdChars, salt, iCount, this.blockLength);
        }
        finally {
            Arrays.fill(passwdChars, '\u0000');
        }
        PBKDF2Core kdf = PBMAC1Core.getKDFImpl(this.kdfAlgo);
        try {
            s = kdf.engineGenerateSecret(pbeSpec);
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct PBE key");
            ike.initCause(ikse);
            throw ike;
        }
        byte[] derivedKey = s.getEncoded();
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, this.kdfAlgo);
        super.engineInit(cipherKey, null);
    }

    public static final class HmacSHA512
    extends PBMAC1Core {
        public HmacSHA512() throws NoSuchAlgorithmException {
            super("HmacSHA512", "SHA-512", 128);
        }
    }

    public static final class HmacSHA384
    extends PBMAC1Core {
        public HmacSHA384() throws NoSuchAlgorithmException {
            super("HmacSHA384", "SHA-384", 128);
        }
    }

    public static final class HmacSHA256
    extends PBMAC1Core {
        public HmacSHA256() throws NoSuchAlgorithmException {
            super("HmacSHA256", "SHA-256", 64);
        }
    }

    public static final class HmacSHA224
    extends PBMAC1Core {
        public HmacSHA224() throws NoSuchAlgorithmException {
            super("HmacSHA224", "SHA-224", 64);
        }
    }

    public static final class HmacSHA1
    extends PBMAC1Core {
        public HmacSHA1() throws NoSuchAlgorithmException {
            super("HmacSHA1", "SHA1", 64);
        }
    }
}

