/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.flow.internal;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.internal.SafeCollector;
import kotlinx.coroutines.internal.ScopeCoroutine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0019\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0082\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/flow/internal/SafeCollector;", "T", "Lkotlinx/coroutines/flow/FlowCollector;", "collector", "collectContext", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/CoroutineContext;)V", "collectContextSize", "", "lastEmissionContext", "checkContext", "", "currentContext", "emit", "value", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transitiveCoroutineParent", "Lkotlinx/coroutines/Job;", "collectJob", "kotlinx-coroutines-core"})
public final class SafeCollector<T>
implements FlowCollector<T> {
    private final int collectContextSize;
    private CoroutineContext lastEmissionContext;
    private final FlowCollector<T> collector;
    private final CoroutineContext collectContext;

    @Override
    @Nullable
    public Object emit(T value2, @NotNull Continuation<? super Unit> $completion) {
        CoroutineContext currentContext = $completion.getContext();
        if (this.lastEmissionContext != currentContext) {
            this.checkContext(currentContext);
            this.lastEmissionContext = currentContext;
        }
        Object object = this.collector.emit(value2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void checkContext(CoroutineContext currentContext) {
        int result2 = ((Number)currentContext.fold(0, (Function2)new Function2<Integer, CoroutineContext.Element, Integer>(this){
            final /* synthetic */ SafeCollector this$0;

            public final int invoke(int count2, @NotNull CoroutineContext.Element element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                CoroutineContext.Key<?> key = element.getKey();
                ? collectElement = SafeCollector.access$getCollectContext$p(this.this$0).get(key);
                if (key != Job.Key) {
                    return element != collectElement ? Integer.MIN_VALUE : count2 + 1;
                }
                Job collectJob = (Job)collectElement;
                Job emissionParentJob = SafeCollector.access$transitiveCoroutineParent(this.this$0, (Job)element, collectJob);
                if (emissionParentJob != collectJob) {
                    String string = "Flow invariant is violated:\n\t\tEmission from another coroutine is detected.\n" + "\t\tChild of " + emissionParentJob + ", expected child of " + collectJob + ".\n" + "\t\tFlowCollector is not thread-safe and concurrent emissions are prohibited.\n" + "\t\tTo mitigate this restriction please use 'channelFlow' builder instead of 'flow'";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return collectJob == null ? count2 : count2 + 1;
            }
            {
                this.this$0 = safeCollector;
                super(2);
            }
        })).intValue();
        if (result2 != this.collectContextSize) {
            String string = "Flow invariant is violated:\n" + "\t\tFlow was collected in " + this.collectContext + ",\n" + "\t\tbut emission happened in " + currentContext + ".\n" + "\t\tPlease refer to 'flow' documentation or use 'flowOn' instead";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final Job transitiveCoroutineParent(@Nullable Job $this$transitiveCoroutineParent, Job collectJob) {
        while ($this$transitiveCoroutineParent != null) {
            if ($this$transitiveCoroutineParent == collectJob) {
                return $this$transitiveCoroutineParent;
            }
            if (!($this$transitiveCoroutineParent instanceof ScopeCoroutine)) {
                return $this$transitiveCoroutineParent;
            }
            $this$transitiveCoroutineParent = ((ScopeCoroutine)$this$transitiveCoroutineParent).getParent$kotlinx_coroutines_core();
        }
        return null;
    }

    public SafeCollector(@NotNull FlowCollector<? super T> collector, @NotNull CoroutineContext collectContext) {
        Intrinsics.checkParameterIsNotNull(collector, "collector");
        Intrinsics.checkParameterIsNotNull(collectContext, "collectContext");
        this.collector = collector;
        this.collectContext = collectContext;
        this.collectContextSize = ((Number)this.collectContext.fold(0, collectContextSize.1.INSTANCE)).intValue();
    }

    public static final /* synthetic */ CoroutineContext access$getCollectContext$p(SafeCollector $this) {
        return $this.collectContext;
    }

    public static final /* synthetic */ Job access$transitiveCoroutineParent(SafeCollector $this, Job $this$access_u24transitiveCoroutineParent, Job collectJob) {
        return $this.transitiveCoroutineParent($this$access_u24transitiveCoroutineParent, collectJob);
    }
}

