/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jdbc.pool.interceptor;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.PooledConnection;
import org.apache.tomcat.jdbc.pool.interceptor.AbstractCreateStatementInterceptor;

public class StatementFinalizer
extends AbstractCreateStatementInterceptor {
    private static final Log log = LogFactory.getLog(StatementFinalizer.class);
    protected ArrayList<WeakReference<Statement>> statements = new ArrayList();

    @Override
    public Object createStatement(Object proxy, Method method, Object[] args, Object statement, long time) {
        try {
            if (statement instanceof Statement) {
                this.statements.add(new WeakReference<Statement>((Statement)statement));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return statement;
    }

    @Override
    public void closeInvoked() {
        while (!this.statements.isEmpty()) {
            WeakReference<Statement> ws = this.statements.remove(0);
            Statement st = (Statement)ws.get();
            if (st == null) continue;
            try {
                st.close();
            }
            catch (Exception ignore) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Unable to closed statement upon connection close.", (Throwable)ignore);
            }
        }
    }

    @Override
    public void reset(ConnectionPool parent, PooledConnection con) {
        this.statements.clear();
        super.reset(parent, con);
    }
}

