/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.MemoryRuleSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;

public class JAASMemoryLoginModule
extends MemoryRealm
implements LoginModule {
    private static final Log log = LogFactory.getLog(JAASMemoryLoginModule.class);
    protected CallbackHandler callbackHandler = null;
    protected boolean committed = false;
    protected Map<String, ?> options = null;
    protected String pathname = "conf/tomcat-users.xml";
    protected Principal principal = null;
    protected Map<String, ?> sharedState = null;
    protected Subject subject = null;

    public JAASMemoryLoginModule() {
        log.debug((Object)"MEMORY LOGIN MODULE");
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.principal == null) {
            return false;
        }
        if (this.committed) {
            this.logout();
        } else {
            this.committed = false;
            this.principal = null;
        }
        log.debug((Object)"Abort");
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        log.debug((Object)("commit " + this.principal));
        if (this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            if (this.principal instanceof GenericPrincipal) {
                String[] stringArray;
                for (String string : stringArray = ((GenericPrincipal)this.principal).getRoles()) {
                    this.subject.getPrincipals().add(new GenericPrincipal(string, null, null));
                }
            }
        }
        this.committed = true;
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        log.debug((Object)"Init");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        if (map2.get("pathname") != null) {
            this.pathname = (String)map2.get("pathname");
        }
        this.load();
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler specified");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new TextInputCallback("nonce"), new TextInputCallback("nc"), new TextInputCallback("cnonce"), new TextInputCallback("qop"), new TextInputCallback("realmName"), new TextInputCallback("md5a2"), new TextInputCallback("authMethod")};
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            string2 = new String(((PasswordCallback)callbackArray[1]).getPassword());
            string3 = ((TextInputCallback)callbackArray[2]).getText();
            string4 = ((TextInputCallback)callbackArray[3]).getText();
            string5 = ((TextInputCallback)callbackArray[4]).getText();
            string6 = ((TextInputCallback)callbackArray[5]).getText();
            string7 = ((TextInputCallback)callbackArray[6]).getText();
            string8 = ((TextInputCallback)callbackArray[7]).getText();
            string9 = ((TextInputCallback)callbackArray[8]).getText();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.toString());
        }
        if (string9 == null) {
            this.principal = super.authenticate(string, string2);
        } else if (string9.equals("DIGEST")) {
            this.principal = super.authenticate(string, string2, string3, string4, string5, string6, string7, string8);
        } else if (string9.equals("CLIENT_CERT")) {
            this.principal = super.getPrincipal(string);
        } else {
            throw new LoginException("Unknown authentication method");
        }
        log.debug((Object)("login " + string + " " + this.principal));
        if (this.principal != null) {
            return true;
        }
        throw new FailedLoginException("Username or password is incorrect");
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        this.committed = false;
        this.principal = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (!file.exists() || !file.canRead()) {
            log.warn((Object)("Cannot load configuration file " + file.getAbsolutePath()));
            return;
        }
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addRuleSet((RuleSet)new MemoryRuleSet());
        try {
            digester.push((Object)this);
            digester.parse(file);
        }
        catch (Exception exception) {
            log.warn((Object)("Error processing configuration file " + file.getAbsolutePath()), (Throwable)exception);
            return;
        }
        finally {
            digester.reset();
        }
    }
}

