/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements KeyedPoolableObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    protected KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pstmtPool = null;

    public PoolingConnection(Connection connection) {
        super(connection);
    }

    public PoolingConnection(Connection connection, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool) {
        super(connection);
        this._pstmtPool = keyedObjectPool;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                keyedObjectPool.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Cannot close connection").initCause(exception);
            }
        }
        this.getInnermostDelegate().close();
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string, n));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached", noSuchElementException).initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string, n, n2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(string, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow callableStatement from pool failed", exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(string, n, n2, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow callableStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string, n, n2, n3));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string, nArray));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(string, stringArray));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow prepareStatement from pool failed", exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(string, n, n2, n3, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("MaxOpenCallableStatements limit reached", noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Borrow callableStatement from pool failed", exception);
        }
    }

    protected PStmtKey createKey(String string) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String string, int[] nArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), nArray);
    }

    protected PStmtKey createKey(String string, int n) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n);
    }

    protected PStmtKey createKey(String string, int n, int n2) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3);
    }

    protected PStmtKey createKey(String string, int n, int n2, int n3, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, n3, statementType);
    }

    protected PStmtKey createKey(String string, int n, int n2, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), n, n2, statementType);
    }

    protected PStmtKey createKey(String string, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), statementType, null);
    }

    protected PStmtKey createKey(String string, String[] stringArray) {
        return new PStmtKey(this.normalizeSQL(string), this.getCatalogOrNull(), this.getSchemaOrNull(), stringArray);
    }

    protected String normalizeSQL(String string) {
        return string.trim();
    }

    private String getCatalogOrNull() {
        String string = null;
        try {
            string = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    private String getSchemaOrNull() {
        String string = null;
        try {
            string = this.getSchema();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    @Override
    public DelegatingPreparedStatement makeObject(PStmtKey pStmtKey) throws Exception {
        if (pStmtKey == null) {
            throw new IllegalArgumentException("Prepared statement key is null.");
        }
        if (pStmtKey.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement preparedStatement = (PreparedStatement)pStmtKey.createStatement(this.getDelegate());
            PoolablePreparedStatement<PStmtKey> poolablePreparedStatement = new PoolablePreparedStatement<PStmtKey>(preparedStatement, pStmtKey, this._pstmtPool, this);
            return poolablePreparedStatement;
        }
        CallableStatement callableStatement = (CallableStatement)pStmtKey.createStatement(this.getDelegate());
        return new PoolableCallableStatement(callableStatement, pStmtKey, this._pstmtPool, this);
    }

    @Override
    public void destroyObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.activate();
    }

    @Override
    public void passivateObject(PStmtKey pStmtKey, DelegatingPreparedStatement delegatingPreparedStatement) throws Exception {
        delegatingPreparedStatement.clearParameters();
        delegatingPreparedStatement.passivate();
    }

    @Override
    public String toString() {
        if (this._pstmtPool != null) {
            return "PoolingConnection: " + this._pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

