/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp.datasources;

import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp.datasources.SharedPoolDataSource;

public class SharedPoolDataSourceFactory
extends InstanceKeyObjectFactory {
    private static final String SHARED_POOL_CLASSNAME = SharedPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String string) {
        return SHARED_POOL_CLASSNAME.equals(string);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference reference) {
        SharedPoolDataSource sharedPoolDataSource = new SharedPoolDataSource();
        RefAddr refAddr = reference.get("maxActive");
        if (refAddr != null && refAddr.getContent() != null) {
            sharedPoolDataSource.setMaxActive(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxIdle")) != null && refAddr.getContent() != null) {
            sharedPoolDataSource.setMaxIdle(Integer.parseInt(refAddr.getContent().toString()));
        }
        if ((refAddr = reference.get("maxWait")) != null && refAddr.getContent() != null) {
            sharedPoolDataSource.setMaxWait(Integer.parseInt(refAddr.getContent().toString()));
        }
        return sharedPoolDataSource;
    }
}

