/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;
import org.apache.tomcat.util.ExceptionUtils;

public class UserDatabaseRealm
extends RealmBase {
    protected volatile UserDatabase database = null;
    private final Object databaseLock = new Object();
    protected String resourceName = "UserDatabase";
    private boolean localJndiResource = false;

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public boolean getLocalJndiResource() {
        return this.localJndiResource;
    }

    public void setLocalJndiResource(boolean bl) {
        this.localJndiResource = bl;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String object) {
        Object object2;
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase == null) {
            return false;
        }
        if (wrapper != null && (object2 = wrapper.findSecurityReference((String)object)) != null) {
            object = object2;
        }
        if (principal instanceof GenericPrincipal && ((GenericPrincipal)(object2 = (GenericPrincipal)principal)).getUserPrincipal() instanceof User) {
            principal = ((GenericPrincipal)object2).getUserPrincipal();
        }
        if (!(principal instanceof User)) {
            return super.hasRole(null, principal, (String)object);
        }
        if ("*".equals(object)) {
            return true;
        }
        if (object == null) {
            return false;
        }
        object2 = (User)principal;
        Role role = userDatabase.findRole((String)object);
        if (role == null) {
            return false;
        }
        if (object2.isInRole(role)) {
            return true;
        }
        Iterator<Group> iterator = object2.getGroups();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.isInRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void backgroundProcess() {
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase != null) {
            userDatabase.backgroundProcess();
        }
    }

    @Override
    protected String getPassword(String string) {
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase == null) {
            return null;
        }
        User user = userDatabase.findUser(string);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    @Override
    protected Principal getPrincipal(String string) {
        Object object;
        UserDatabase userDatabase = this.getUserDatabase();
        if (userDatabase == null) {
            return null;
        }
        User user = userDatabase.findUser(string);
        if (user == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = user.getRoles();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList.add(object.getName());
        }
        object = user.getGroups();
        while (object.hasNext()) {
            Group group = (Group)object.next();
            iterator = group.getRoles();
            while (iterator.hasNext()) {
                Role role = iterator.next();
                arrayList.add(role.getName());
            }
        }
        return new GenericPrincipal(string, user.getPassword(), arrayList, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDatabase getUserDatabase() {
        if (this.database == null) {
            Object object = this.databaseLock;
            synchronized (object) {
                if (this.database == null) {
                    try {
                        Context context = null;
                        if (this.localJndiResource) {
                            context = ContextBindings.getClassLoader();
                            context = (Context)context.lookup("comp/env");
                        } else {
                            context = this.getServer().getGlobalNamingContext();
                        }
                        this.database = (UserDatabase)context.lookup(this.resourceName);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable((Throwable)throwable);
                        this.containerLog.error((Object)sm.getString("userDatabaseRealm.lookup", new Object[]{this.resourceName}), throwable);
                        this.database = null;
                    }
                }
            }
        }
        return this.database;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        UserDatabase userDatabase;
        if (!this.localJndiResource && (userDatabase = this.getUserDatabase()) == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", new Object[]{this.resourceName}));
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.database = null;
    }
}

