/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class SSLValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(SSLValve.class);
    private String sslClientCertHeader = "ssl_client_cert";
    private String sslCipherHeader = "ssl_cipher";
    private String sslSessionIdHeader = "ssl_session_id";
    private String sslCipherUserKeySizeHeader = "ssl_cipher_usekeysize";

    public SSLValve() {
        super(true);
    }

    public String getSslClientCertHeader() {
        return this.sslClientCertHeader;
    }

    public void setSslClientCertHeader(String string) {
        this.sslClientCertHeader = string;
    }

    public String getSslCipherHeader() {
        return this.sslCipherHeader;
    }

    public void setSslCipherHeader(String string) {
        this.sslCipherHeader = string;
    }

    public String getSslSessionIdHeader() {
        return this.sslSessionIdHeader;
    }

    public void setSslSessionIdHeader(String string) {
        this.sslSessionIdHeader = string;
    }

    public String getSslCipherUserKeySizeHeader() {
        return this.sslCipherUserKeySizeHeader;
    }

    public void setSslCipherUserKeySizeHeader(String string) {
        this.sslCipherUserKeySizeHeader = string;
    }

    public String mygetHeader(Request request, String string) {
        String string2 = request.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if ("(null)".equals(string2)) {
            return null;
        }
        return string2;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String string = this.mygetHeader(request, this.sslClientCertHeader);
        if (string != null && (string = string.trim()).length() > 27) {
            String string2 = string.substring(27);
            String string3 = "-----BEGIN CERTIFICATE-----\n";
            String string4 = string3.concat(string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes(StandardCharsets.ISO_8859_1));
            X509Certificate[] x509CertificateArray = null;
            String string5 = (String)request.getConnector().getProperty("clientCertProvider");
            try {
                CertificateFactory certificateFactory = string5 == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", string5);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                x509CertificateArray = new X509Certificate[]{x509Certificate};
            }
            catch (CertificateException certificateException) {
                log.warn((Object)sm.getString("sslValve.certError", new Object[]{string4}), (Throwable)certificateException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                log.error((Object)sm.getString("sslValve.invalidProvider", new Object[]{string5}), (Throwable)noSuchProviderException);
            }
            request.setAttribute("javax.servlet.request.X509Certificate", x509CertificateArray);
        }
        if ((string = this.mygetHeader(request, this.sslCipherHeader)) != null) {
            request.setAttribute("javax.servlet.request.cipher_suite", string);
        }
        if ((string = this.mygetHeader(request, this.sslSessionIdHeader)) != null) {
            request.setAttribute("javax.servlet.request.ssl_session_id", string);
        }
        if ((string = this.mygetHeader(request, this.sslCipherUserKeySizeHeader)) != null) {
            request.setAttribute("javax.servlet.request.key_size", Integer.valueOf(string));
        }
        this.getNext().invoke(request, response);
    }
}

