/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class CheckMissingAndExtraRequires
implements HotSwapCompilerPass,
NodeTraversal.Callback {
    private final AbstractCompiler compiler;
    private final CodingConvention codingConvention;
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private final Set<String> providedNames = new HashSet<String>();
    private final Map<String, Node> requires = new HashMap<String, Node>();
    private final Map<String, Node> usages = new HashMap<String, Node>();
    private final Set<String> weakUsages = new HashSet<String>();
    @Nullable
    private Node googScopeBlock;
    public static final DiagnosticType MISSING_REQUIRE_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_WARNING", "missing require: ''{0}''");
    static final DiagnosticType MISSING_REQUIRE_FOR_GOOG_SCOPE = DiagnosticType.disabled("JSC_MISSING_REQUIRE_FOR_GOOG_SCOPE", "missing require: ''{0}''");
    public static final DiagnosticType MISSING_REQUIRE_STRICT_WARNING = DiagnosticType.disabled("JSC_MISSING_REQUIRE_STRICT_WARNING", "missing require: ''{0}''");

    CheckMissingAndExtraRequires(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.codingConvention = compiler.getCodingConvention();
    }

    @Override
    public void process(Node externs, Node root) {
        this.reset();
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.reset();
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    private static boolean isClassName(String name) {
        return CheckMissingAndExtraRequires.isClassOrConstantName(name) && !name.equals(name.toUpperCase(Locale.ROOT));
    }

    private static boolean isClassOrConstantName(String name) {
        return name != null && name.length() > 1 && Character.isUpperCase(name.charAt(0));
    }

    private static ImmutableList<String> getClassNames(String qualifiedName) {
        ImmutableList.Builder classNames = ImmutableList.builder();
        List<String> parts = DOT_SPLITTER.splitToList(qualifiedName);
        for (int i = 0; i < parts.size(); ++i) {
            String part = parts.get(i);
            if (!CheckMissingAndExtraRequires.isClassOrConstantName(part)) continue;
            classNames.add(DOT_JOINER.join(parts.subList(0, i + 1)));
        }
        return classNames.build();
    }

    private String extractNamespace(Node call, String ... primitiveNames) {
        Node callee = call.getFirstChild();
        if (!callee.isGetProp()) {
            return null;
        }
        for (String primitiveName : primitiveNames) {
            Node target;
            if (!callee.matchesQualifiedName(primitiveName) || (target = callee.getNext()) == null || !target.isString()) continue;
            return target.getString();
        }
        return null;
    }

    private String extractNamespaceIfRequire(Node call) {
        return this.extractNamespace(call, "goog.require", "goog.requireType");
    }

    private String extractNamespaceIfProvide(Node call) {
        return this.extractNamespace(call, "goog.provide");
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        Node function;
        if (n.isCall() && n.getFirstChild().matchesQualifiedName("goog.scope") && (function = n.getSecondChild()).isFunction()) {
            this.googScopeBlock = NodeUtil.getFunctionBody(function);
        }
        return parent == null || !parent.isScript() || !t.getInput().isExtern();
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.maybeAddJsDocUsages(t, n);
        switch (n.getToken()) {
            case ASSIGN: {
                this.maybeAddProvidedName(n);
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                this.maybeAddProvidedName(n);
                this.maybeAddGoogScopeUsage(t, n, parent);
                break;
            }
            case FUNCTION: {
                if (!NodeUtil.isStatement(n)) break;
                this.maybeAddProvidedName(n);
                break;
            }
            case NAME: {
                if (NodeUtil.isLValue(n) || parent.isGetProp() || parent.isImportSpec()) break;
                this.visitQualifiedName(n);
                break;
            }
            case GETPROP: {
                if (parent.isGetProp() || !n.isQualifiedName()) break;
                this.visitQualifiedName(n);
                break;
            }
            case CALL: {
                this.visitCallNode(t, n, parent);
                break;
            }
            case SCRIPT: {
                this.visitScriptNode();
                this.reset();
                break;
            }
            case NEW: {
                this.visitNewNode(t, n);
                break;
            }
            case CLASS: {
                this.visitClassNode(t, n);
                break;
            }
            case IMPORT: {
                this.visitImportNode(n);
                break;
            }
        }
    }

    private void reset() {
        this.usages.clear();
        this.weakUsages.clear();
        this.requires.clear();
        this.providedNames.clear();
        this.googScopeBlock = null;
    }

    private void visitScriptNode() {
        HashSet<String> namespaces = new HashSet<String>();
        for (Map.Entry<String, Node> entry : this.usages.entrySet()) {
            Node node;
            String namespace = entry.getKey();
            boolean isMissing = this.isMissingRequire(namespace, node = entry.getValue());
            if (isMissing && (namespace.endsWith(".call") || namespace.endsWith(".apply") || namespace.endsWith(".bind"))) {
                String namespaceMinusApply = namespace.substring(0, namespace.lastIndexOf(46));
                isMissing = this.isMissingRequire(namespaceMinusApply, node);
            }
            if (!isMissing || namespaces.contains(namespace)) continue;
            if (node.isCall()) {
                String defaultName = namespace.lastIndexOf(46) > 0 ? namespace.substring(0, namespace.lastIndexOf(46)) : namespace;
                String nameToReport = Iterables.getFirst(CheckMissingAndExtraRequires.getClassNames(namespace), defaultName);
                this.compiler.report(JSError.make(node, MISSING_REQUIRE_STRICT_WARNING, nameToReport));
            } else if (node.getParent().isName() && node.getParent().getGrandparent() == this.googScopeBlock) {
                this.compiler.report(JSError.make(node, MISSING_REQUIRE_FOR_GOOG_SCOPE, namespace));
            } else if (node.isGetProp() && !node.getParent().isClass()) {
                this.compiler.report(JSError.make(node, MISSING_REQUIRE_STRICT_WARNING, namespace));
            } else {
                this.compiler.report(JSError.make(node, MISSING_REQUIRE_WARNING, namespace));
            }
            namespaces.add(namespace);
        }
    }

    private boolean isMissingRequire(String namespace, Node node) {
        if (namespace.startsWith("goog.global.") || namespace.equals("goog.module.get") || namespace.equals("goog.module.declareLegacyNamespace")) {
            return false;
        }
        JSDocInfo info = NodeUtil.getBestJSDocInfo(NodeUtil.getEnclosingStatement(node));
        if (info != null && info.getSuppressions().contains("missingRequire")) {
            return false;
        }
        ImmutableList<String> classNames = CheckMissingAndExtraRequires.getClassNames(namespace);
        String nonNullClassName = Iterables.getFirst(classNames, namespace);
        String parentNamespace = null;
        int separatorIndex = nonNullClassName.lastIndexOf(46);
        if (separatorIndex > 0) {
            parentNamespace = nonNullClassName.substring(0, separatorIndex);
        }
        if ("goog".equals(parentNamespace) && !CheckMissingAndExtraRequires.isClassName(nonNullClassName.substring(separatorIndex + 1))) {
            return false;
        }
        boolean providedByConstructors = this.providedNames.contains(namespace) || this.providedNames.contains(parentNamespace);
        boolean providedByRequires = this.requires.containsKey(namespace) || this.requires.containsKey(parentNamespace);
        for (String className : classNames) {
            if (this.providedNames.contains(className)) {
                providedByConstructors = true;
                break;
            }
            if (!this.requires.containsKey(className)) continue;
            providedByRequires = true;
            break;
        }
        return !providedByRequires && !providedByConstructors;
    }

    private void visitRequire(String localName, Node node) {
        this.requires.putIfAbsent(localName, node);
        for (String className : CheckMissingAndExtraRequires.getClassNames(localName)) {
            this.requires.put(className, node);
        }
    }

    private void visitImportNode(Node importNode) {
        Node namedImports;
        Node defaultImport = importNode.getFirstChild();
        if (defaultImport.isName()) {
            this.visitRequire(defaultImport.getString(), importNode);
        }
        if ((namedImports = defaultImport.getNext()).isImportSpecs()) {
            for (Node importSpec : namedImports.children()) {
                this.visitRequire(importSpec.getLastChild().getString(), importNode);
            }
        }
    }

    private void visitGoogRequire(String namespace, Node googRequireCall, Node parent) {
        if (parent.isName()) {
            this.visitRequire(parent.getString(), googRequireCall);
        } else if (parent.isDestructuringLhs() && parent.getFirstChild().isObjectPattern()) {
            if (parent.getFirstChild().hasChildren()) {
                for (Node stringKey : parent.getFirstChild().children()) {
                    Node importName = stringKey.getFirstChild();
                    if (!importName.isName()) continue;
                    this.visitRequire(importName.getString(), importName);
                }
            } else {
                this.visitRequire(namespace, googRequireCall);
            }
        } else {
            this.visitRequire(namespace, googRequireCall);
        }
    }

    private void visitCallNode(NodeTraversal t, Node call, Node parent) {
        Var var;
        Node root;
        String required = this.extractNamespaceIfRequire(call);
        if (required != null) {
            this.visitGoogRequire(required, call, parent);
            return;
        }
        String provided = this.extractNamespaceIfProvide(call);
        if (provided != null) {
            this.providedNames.add(provided);
            return;
        }
        Node callee = call.getFirstChild();
        if (callee.matchesQualifiedName("goog.module.get") && call.getSecondChild().isString()) {
            this.weakUsages.add(call.getSecondChild().getString());
        }
        if (this.codingConvention.isClassFactoryCall(call)) {
            if (parent.isName()) {
                this.providedNames.add(parent.getString());
            } else if (parent.isAssign()) {
                this.providedNames.add(parent.getFirstChild().getQualifiedName());
            }
        }
        if (callee.isName()) {
            this.weakUsages.add(callee.getString());
        } else if (callee.isQualifiedName() && (root = NodeUtil.getRootOfQualifiedName(callee)).isName() && ((var = (Var)t.getScope().getVar(root.getString())) == null || !var.isExtern() && var.isGlobal())) {
            this.usages.put(callee.getQualifiedName(), call);
        }
    }

    private void addWeakUsagesOfAllPrefixes(String qualifiedName) {
        int i = qualifiedName.indexOf(46);
        while (i != -1) {
            String prefix = qualifiedName.substring(0, i);
            this.weakUsages.add(prefix);
            i = qualifiedName.indexOf(46, i + 1);
        }
        this.weakUsages.add(qualifiedName);
    }

    private void visitQualifiedName(Node n) {
        Preconditions.checkState(n.isName() || n.isGetProp() || n.isStringKey(), n);
        String qualifiedName = n.isStringKey() ? n.getString() : n.getQualifiedName();
        this.addWeakUsagesOfAllPrefixes(qualifiedName);
    }

    private void visitNewNode(NodeTraversal t, Node newNode) {
        Node qNameNode = newNode.getFirstChild();
        if (!qNameNode.isQualifiedName()) {
            return;
        }
        Node root = NodeUtil.getRootOfQualifiedName(qNameNode);
        if (!root.isName()) {
            return;
        }
        String name = root.getString();
        Var var = (Var)t.getScope().getVar(name);
        if (var != null && (var.isExtern() || var.getSourceFile() == newNode.getStaticSourceFile())) {
            return;
        }
        this.usages.put(qNameNode.getQualifiedName(), newNode);
        while (qNameNode != null) {
            this.weakUsages.add(qNameNode.getQualifiedName());
            qNameNode = qNameNode.getFirstChild();
        }
    }

    private void visitClassNode(NodeTraversal t, Node classNode) {
        Node extendClass;
        String name = NodeUtil.getName(classNode);
        if (name != null) {
            this.providedNames.add(name);
        }
        if (!(extendClass = classNode.getSecondChild()).isQualifiedName()) {
            return;
        }
        Node root = NodeUtil.getRootOfQualifiedName(extendClass);
        if (root.isName()) {
            String rootName = root.getString();
            Var var = (Var)t.getScope().getVar(rootName);
            if (var == null || !var.isLocal() && !var.isExtern()) {
                ImmutableList<String> classNames = CheckMissingAndExtraRequires.getClassNames(extendClass.getQualifiedName());
                String outermostClassName = Iterables.getFirst(classNames, extendClass.getQualifiedName());
                this.usages.put(outermostClassName, extendClass);
            }
        }
    }

    private void maybeAddProvidedName(Node n) {
        Node name = n.getFirstChild();
        if (name.isQualifiedName()) {
            this.providedNames.add(name.getQualifiedName());
        }
    }

    private void maybeAddGoogScopeUsage(NodeTraversal t, Node n, Node parent) {
        Var var;
        Node root;
        Node rhs;
        Preconditions.checkState(NodeUtil.isNameDeclaration(n));
        if (n.hasOneChild() && parent == this.googScopeBlock && (rhs = n.getFirstFirstChild()) != null && rhs.isQualifiedName() && (root = NodeUtil.getRootOfQualifiedName(rhs)).isName() && ((var = (Var)t.getScope().getVar(root.getString())) == null || var.isGlobal() && !var.isExtern())) {
            this.usages.put(rhs.getQualifiedName(), rhs);
        }
    }

    private boolean declaresFunctionOrClass(Node n) {
        if (n.isFunction() || n.isClass()) {
            return true;
        }
        if (n.isAssign() && (n.getLastChild().isFunction() || n.getLastChild().isClass())) {
            return true;
        }
        return NodeUtil.isNameDeclaration(n) && n.getFirstChild().hasChildren() && (n.getFirstFirstChild().isFunction() || n.getFirstFirstChild().isClass());
    }

    private void maybeAddJsDocUsages(NodeTraversal t, Node n) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (this.declaresFunctionOrClass(n)) {
            for (JSTypeExpression expr : info.getImplementedInterfaces()) {
                this.maybeAddUsage(t, n, expr);
            }
            if (info.getBaseType() != null) {
                this.maybeAddUsage(t, n, info.getBaseType());
            }
            for (JSTypeExpression extendedInterface : info.getExtendedInterfaces()) {
                this.maybeAddUsage(t, n, extendedInterface);
            }
        }
        for (Node typeNode : info.getTypeNodes()) {
            this.maybeAddWeakUsage(t, n, typeNode);
        }
    }

    private void maybeAddWeakUsage(NodeTraversal t, Node n, Node typeNode) {
        this.maybeAddUsage(t, n, typeNode, false, Predicates.alwaysTrue());
    }

    private void maybeAddUsage(NodeTraversal t, Node n, final JSTypeExpression expr) {
        Predicate<Node> pred = new Predicate<Node>(){

            @Override
            public boolean apply(Node n) {
                return n == expr.getRoot();
            }
        };
        this.maybeAddUsage(t, n, expr.getRoot(), true, pred);
    }

    private void maybeAddUsage(final NodeTraversal t, final Node n, Node rootTypeNode, final boolean markStrongUsages, Predicate<Node> pred) {
        NodeUtil.Visitor visitor = new NodeUtil.Visitor(){

            @Override
            public void visit(Node typeNode) {
                if (typeNode.isString()) {
                    String typeString = typeNode.getString();
                    String rootName = Splitter.on('.').split(typeString).iterator().next();
                    Var var = (Var)t.getScope().getVar(rootName);
                    if (var == null || var.isGlobal() && !var.isExtern()) {
                        if (markStrongUsages) {
                            CheckMissingAndExtraRequires.this.usages.put(typeString, n);
                        } else {
                            CheckMissingAndExtraRequires.this.addWeakUsagesOfAllPrefixes(typeString);
                        }
                    } else {
                        CheckMissingAndExtraRequires.this.addWeakUsagesOfAllPrefixes(typeString);
                    }
                }
            }
        };
        NodeUtil.visitPreOrder(rootTypeNode, visitor, pred);
    }
}

