/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.ClosurePrimitiveErrors;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class ClosureRewriteModule
implements HotSwapCompilerPass {
    static final DiagnosticType INVALID_MODULE_NAMESPACE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_MODULE_NAMESPACE", "goog.module parameter must be string literals");
    static final DiagnosticType INVALID_PROVIDE_NAMESPACE = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_NAMESPACE", "goog.provide parameter must be a string literal.");
    static final DiagnosticType INVALID_PROVIDE_CALL = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_PROVIDE_CALL", "goog.provide can not be called in goog.module.");
    static final DiagnosticType INVALID_GET_ALIAS = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_GET_ALIAS", "goog.module.get should not be aliased.");
    static final DiagnosticType INVALID_EXPORT_COMPUTED_PROPERTY = DiagnosticType.error("JSC_GOOG_MODULE_INVALID_EXPORT_COMPUTED_PROPERTY", "Computed properties are not yet supported in goog.module exports.");
    static final DiagnosticType USELESS_USE_STRICT_DIRECTIVE = DiagnosticType.disabled("JSC_USELESS_USE_STRICT_DIRECTIVE", "'use strict' is unnecessary in goog.module files.");
    static final DiagnosticType IMPORT_INLINING_SHADOWS_VAR = DiagnosticType.error("JSC_IMPORT_INLINING_SHADOWS_VAR", "Inlining of reference to import \"{1}\" shadows var \"{0}\".");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT", "Destructuring import only allowed for importing module with named exports.\nSee https://github.com/google/closure-compiler/wiki/goog.module-style");
    static final DiagnosticType ILLEGAL_DESTRUCTURING_NOT_EXPORTED = DiagnosticType.error("JSC_ILLEGAL_DESTRUCTURING_NOT_EXPORTED", "Destructuring import reference to name \"{0}\" was not exported in module {1}");
    static final DiagnosticType LOAD_MODULE_FN_MISSING_RETURN = DiagnosticType.error("JSC_LOAD_MODULE_FN_MISSING_RETURN", "goog.loadModule function should end with 'return exports;'");
    static final DiagnosticType ILLEGAL_MODULE_RENAMING_CONFLICT = DiagnosticType.error("JSC_ILLEGAL_MODULE_RENAMING_CONFLICT", "Internal compiler error: rewritten module global name {0} is already in use.");
    private static final ImmutableSet<String> USE_STRICT_ONLY = ImmutableSet.of("use strict");
    private static final String MODULE_EXPORTS_PREFIX = "module$exports$";
    private static final String MODULE_CONTENTS_PREFIX = "module$contents$";
    private static final Node GOOG_FORWARDDECLARE = IR.getprop(IR.name("goog"), IR.string("forwardDeclare"));
    private static final Node GOOG_LOADMODULE = IR.getprop(IR.name("goog"), IR.string("loadModule"));
    private static final Node GOOG_MODULE = IR.getprop(IR.name("goog"), IR.string("module"));
    private static final Node GOOG_MODULE_DECLARELEGACYNAMESPACE = IR.getprop(GOOG_MODULE, IR.string("declareLegacyNamespace"));
    private static final Node GOOG_MODULE_GET = IR.getprop(GOOG_MODULE.cloneTree(), IR.string("get"));
    private static final Node GOOG_PROVIDE = IR.getprop(IR.name("goog"), IR.string("provide"));
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), IR.string("require"));
    private static final Node GOOG_REQUIRETYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final boolean preserveSugar;
    private final LinkedHashMap<String, Node> syntheticExterns = new LinkedHashMap();
    private Scope globalScope = null;
    private final NodeUtil.Visitor replaceJsDocRefs = new NodeUtil.Visitor(){

        @Override
        public void visit(Node typeRefNode) {
            String rootOfType;
            if (!typeRefNode.isString()) {
                return;
            }
            String typeName = typeRefNode.getString();
            int dot = typeName.indexOf(46);
            String string = rootOfType = dot == -1 ? typeName : typeName.substring(0, dot);
            if (((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.namesToInlineByAlias.containsKey(rootOfType)) {
                if (ClosureRewriteModule.this.preprocessorSymbolTable != null) {
                    Node moduleOnlyNode = typeRefNode.cloneNode();
                    ClosureRewriteModule.this.safeSetString(moduleOnlyNode, rootOfType);
                    moduleOnlyNode.setLength(rootOfType.length());
                    ClosureRewriteModule.this.maybeAddAliasToSymbolTable(moduleOnlyNode, ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.namespaceId);
                }
                String aliasedNamespace = ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.namesToInlineByAlias.get((Object)rootOfType).newName;
                String remainder = dot == -1 ? "" : typeName.substring(dot);
                ClosureRewriteModule.this.safeSetString(typeRefNode, aliasedNamespace + remainder);
            } else if (((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.isModule && ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.topLevelNames.contains(rootOfType)) {
                ClosureRewriteModule.this.safeSetString(typeRefNode, ((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.contentsPrefix + typeName);
            } else {
                this.rewriteIfClosureNamespaceRef(typeName, typeRefNode);
            }
        }

        private void rewriteIfClosureNamespaceRef(String typeName, Node typeRefNode) {
            String prefixTypeName = typeName;
            String suffix = "";
            while (true) {
                String binaryNamespaceIfModule = ClosureRewriteModule.this.rewriteState.getBinaryNamespace(prefixTypeName);
                if (ClosureRewriteModule.this.legacyScriptNamespacesAndPrefixes.contains(prefixTypeName) && binaryNamespaceIfModule == null) {
                    return;
                }
                if (binaryNamespaceIfModule != null) {
                    ClosureRewriteModule.this.safeSetString(typeRefNode, binaryNamespaceIfModule + suffix);
                    return;
                }
                if (!prefixTypeName.contains(".")) break;
                prefixTypeName = prefixTypeName.substring(0, prefixTypeName.lastIndexOf(46));
                suffix = typeName.substring(prefixTypeName.length());
            }
        }
    };
    private final Deque<ScriptDescription> scriptStack = new ArrayDeque<ScriptDescription>();
    private ScriptDescription currentScript = null;
    private final GlobalRewriteState rewriteState;
    private final Set<String> legacyScriptNamespacesAndPrefixes = new HashSet<String>();
    private final List<UnrecognizedRequire> unrecognizedRequires = new ArrayList<UnrecognizedRequire>();
    private final ArrayList<Node> googModuleGetCalls = new ArrayList();
    private final TypedScope globalTypedScope;

    static String getBinaryModuleNamespace(String namespaceId) {
        return MODULE_EXPORTS_PREFIX + namespaceId.replace('.', '$');
    }

    private void rewriteJsdoc(JSDocInfo info) {
        for (Node typeNode : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeNode, this.replaceJsDocRefs);
        }
    }

    ClosureRewriteModule(AbstractCompiler compiler, PreprocessorSymbolTable preprocessorSymbolTable, GlobalRewriteState moduleRewriteState, @Nullable TypedScope globalTypedScope) {
        Preconditions.checkArgument(globalTypedScope == null || globalTypedScope.isGlobal());
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.rewriteState = moduleRewriteState != null ? moduleRewriteState : new GlobalRewriteState();
        this.preserveSugar = compiler.getOptions().shouldPreserveGoogModule();
        this.globalTypedScope = globalTypedScope;
    }

    @Override
    public void process(Node externs, Node root) {
        ArrayDeque<ScriptDescription> scriptDescriptions = new ArrayDeque<ScriptDescription>();
        Iterable<Node> scriptNodes = Iterables.concat(externs.children(), root.children());
        for (Node c : scriptNodes) {
            Preconditions.checkState(c.isScript(), c);
            NodeTraversal.traverse(this.compiler, c, new UnwrapGoogLoadModule());
            this.pushScript(new ScriptDescription());
            this.currentScript.rootNode = c;
            scriptDescriptions.addLast(this.currentScript);
            NodeTraversal.traverse(this.compiler, c, new ScriptPreprocessor());
            NodeTraversal.traverse(this.compiler, c, new ScriptRecorder());
            this.popScript();
        }
        this.reportUnrecognizedRequires();
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        NodeTraversal.traverseRoots(this.compiler, new ScriptUpdater(scriptDescriptions), externs, root);
        this.declareSyntheticExterns();
        this.googModuleGetCalls.forEach(this::updateGoogModuleGetCall);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState(scriptRoot.isScript(), scriptRoot);
        NodeTraversal.traverse(this.compiler, scriptRoot, new UnwrapGoogLoadModule());
        this.rewriteState.removeRoot(originalRoot);
        ArrayDeque<ScriptDescription> scriptDescriptions = new ArrayDeque<ScriptDescription>();
        ScriptDescription currentDescript = new ScriptDescription();
        scriptDescriptions.addLast(currentDescript);
        Preconditions.checkState(this.scriptStack.isEmpty());
        this.pushScript(currentDescript);
        this.currentScript.rootNode = scriptRoot;
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptPreprocessor());
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptRecorder());
        this.popScript();
        if (this.compiler.hasHaltingErrors()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, scriptRoot, new ScriptUpdater(scriptDescriptions));
        this.googModuleGetCalls.forEach(this::updateGoogModuleGetCall);
        this.reportUnrecognizedRequires();
    }

    private void declareSyntheticExterns() {
        ImmutableList<Node> vars = this.syntheticExterns.values().stream().filter(lhs -> !this.isNameInGlobalScope(lhs.getString())).map(lhs -> IR.var(this.astFactory.createName(lhs.getString(), JSTypeNative.UNKNOWN_TYPE)).srcrefTree((Node)lhs)).collect(ImmutableList.toImmutableList());
        if (vars.isEmpty()) {
            return;
        }
        Node root = this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
        vars.forEach(root::addChildToBack);
    }

    private boolean isNameInGlobalScope(String name) {
        return this.legacyScriptNamespacesAndPrefixes.contains(name) || this.globalScope.getVar(name) != null;
    }

    private void preprocessExportDeclaration(Node n) {
        if (!(n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n) && n.getGrandparent().isExprResult())) {
            return;
        }
        Preconditions.checkState(this.currentScript.defaultExportRhs == null);
        Node exportRhs = n.getNext();
        if (ClosureRewriteModule.isNamedExportsLiteral(exportRhs)) {
            Node insertionPoint = n.getGrandparent();
            for (Node key = exportRhs.getFirstChild(); key != null; key = key.getNext()) {
                String exportName = key.getString();
                JSDocInfo jsdoc = key.getJSDocInfo();
                Node rhs = key.removeFirstChild();
                Node lhs = this.astFactory.createGetProp(this.astFactory.createName("exports", n.getJSType()), exportName).srcrefTree(key);
                Node newExport = IR.exprResult(this.astFactory.createAssign(lhs, rhs).srcref(key).setJSDocInfo(jsdoc)).srcref(key);
                insertionPoint.getParent().addChildAfter(newExport, insertionPoint);
                insertionPoint = newExport;
            }
            n.getGrandparent().detach();
        }
    }

    static boolean isNamedExportsLiteral(Node objLit) {
        if (!objLit.isObjectLit() || !objLit.hasChildren()) {
            return false;
        }
        for (Node key = objLit.getFirstChild(); key != null; key = key.getNext()) {
            if (!key.isStringKey() || key.isQuotedString()) {
                return false;
            }
            if (key.getFirstChild().isName()) continue;
            return false;
        }
        return true;
    }

    private void recordModuleBody(Node moduleRoot) {
        this.pushScript(new ScriptDescription());
        this.currentScript.rootNode = moduleRoot;
        this.currentScript.isModule = true;
    }

    private void recordGoogModule(NodeTraversal t, Node call) {
        String namespaceId;
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isString()) {
            t.report(namespaceIdNode, INVALID_MODULE_NAMESPACE, new String[0]);
            return;
        }
        this.currentScript.namespaceId = namespaceId = namespaceIdNode.getString();
        this.currentScript.contentsPrefix = ClosureRewriteModule.toModuleContentsPrefix(namespaceId);
        Node scriptNode = NodeUtil.getEnclosingScript(this.currentScript.rootNode);
        this.rewriteState.scriptDescriptionsByGoogModuleNamespace.put(namespaceId, this.currentScript);
        this.rewriteState.namespaceIdsByScriptNode.put(scriptNode, namespaceId);
    }

    private void recordGoogDeclareLegacyNamespace() {
        this.currentScript.declareLegacyNamespace = true;
        this.updateLegacyScriptNamespacesAndPrefixes(this.currentScript.namespaceId);
    }

    private void updateLegacyScriptNamespacesAndPrefixes(String namespace) {
        this.legacyScriptNamespacesAndPrefixes.add(namespace);
        int dot = namespace.lastIndexOf(46);
        while (dot != -1) {
            namespace = namespace.substring(0, dot);
            this.legacyScriptNamespacesAndPrefixes.add(namespace);
            dot = namespace.lastIndexOf(46);
        }
    }

    private void recordGoogProvide(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isString()) {
            t.report(namespaceIdNode, INVALID_PROVIDE_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        if (this.currentScript.isModule) {
            t.report(namespaceIdNode, INVALID_PROVIDE_CALL, new String[0]);
        }
        Node scriptNode = NodeUtil.getEnclosingScript(call);
        this.rewriteState.providedNamespaces.add(namespaceId);
        this.rewriteState.namespaceIdsByScriptNode.put(scriptNode, namespaceId);
        this.updateLegacyScriptNamespacesAndPrefixes(namespaceId);
    }

    private void recordGoogRequire(NodeTraversal t, Node call, boolean mustBeOrdered) {
        ClosureRewriteModule.maybeSplitMultiVar(call);
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isString()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_REQUIRE_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        boolean targetIsAModule = this.rewriteState.containsModule(namespaceId);
        boolean targetIsALegacyScript = this.rewriteState.providedNamespaces.contains(namespaceId);
        if (this.currentScript.isModule && !targetIsAModule && !targetIsALegacyScript) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, namespaceId, mustBeOrdered));
        }
    }

    private void recordGoogRequireType(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        if (!namespaceIdNode.isString()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_REQUIRE_TYPE_NAMESPACE, new String[0]);
            return;
        }
        this.recordGoogRequire(t, call, false);
    }

    private void recordGoogForwardDeclare(NodeTraversal t, Node call) {
        Node namespaceNode = call.getLastChild();
        if (!call.hasTwoChildren() || !namespaceNode.isString()) {
            t.report(namespaceNode, ClosurePrimitiveErrors.INVALID_FORWARD_DECLARE_NAMESPACE, new String[0]);
            return;
        }
        boolean mustBeOrdered = false;
        this.recordGoogRequire(t, call, mustBeOrdered);
    }

    private void recordGoogModuleGet(NodeTraversal t, Node call) {
        boolean isFillingAnAlias;
        Node namespaceIdNode = call.getLastChild();
        if (!call.hasTwoChildren() || !namespaceIdNode.isString()) {
            t.report(namespaceIdNode, ClosurePrimitiveErrors.INVALID_GET_NAMESPACE, new String[0]);
            return;
        }
        String namespaceId = namespaceIdNode.getString();
        if (!this.rewriteState.containsModule(namespaceId)) {
            this.unrecognizedRequires.add(new UnrecognizedRequire(call, namespaceId, false));
        }
        this.googModuleGetCalls.add(call);
        Node maybeAssign = call.getParent();
        boolean bl = isFillingAnAlias = maybeAssign.isAssign() && maybeAssign.getFirstChild().isName() && maybeAssign.getParent().isExprResult();
        if (!isFillingAnAlias || !this.currentScript.isModule) {
            return;
        }
        String aliasName = call.getParent().getFirstChild().getString();
        Var aliasVar = (Var)t.getScope().getVar(aliasName);
        if (aliasVar == null) {
            t.report(call, INVALID_GET_ALIAS, new String[0]);
            return;
        }
        Node aliasVarNodeRhs = NodeUtil.getRValueOfLValue(aliasVar.getNode());
        if (aliasVarNodeRhs == null || !ClosureRewriteModule.isCallTo(aliasVarNodeRhs, GOOG_FORWARDDECLARE) || !namespaceId.equals(aliasVarNodeRhs.getLastChild().getString())) {
            t.report(call, INVALID_GET_ALIAS, new String[0]);
            return;
        }
        this.compiler.reportChangeToEnclosingScope(maybeAssign);
        maybeAssign.getParent().detach();
        this.googModuleGetCalls.remove(this.googModuleGetCalls.size() - 1);
    }

    private void recordTopLevelClassOrFunctionName(Node classOrFunctionNode) {
        Node nameNode = classOrFunctionNode.getFirstChild();
        if (nameNode.isName() && !Strings.isNullOrEmpty(nameNode.getString())) {
            String name = nameNode.getString();
            this.currentScript.topLevelNames.add(name);
        }
    }

    private void recordTopLevelVarNames(Node varNode) {
        for (Node lhs : NodeUtil.findLhsNodesInNode(varNode)) {
            String name = lhs.getString();
            this.currentScript.topLevelNames.add(name);
        }
    }

    private void maybeRecordExportDeclaration(NodeTraversal t, Node n) {
        if (!(this.currentScript.isModule && n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        Preconditions.checkState(this.currentScript.defaultExportRhs == null, this.currentScript.defaultExportRhs);
        Node exportRhs = n.getNext();
        Preconditions.checkState(!ClosureRewriteModule.isNamedExportsLiteral(exportRhs), "Exports object should have been converted already");
        this.currentScript.defaultExportRhs = exportRhs;
        this.currentScript.willCreateExportsObject = true;
        ExportDefinition defaultExport = ExportDefinition.newDefaultExport(t, exportRhs);
        if (!this.currentScript.declareLegacyNamespace && defaultExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
            String localName;
            this.currentScript.defaultExportLocalName = localName = defaultExport.getLocalName();
            this.recordExportToInline(defaultExport);
        }
    }

    private void updateModuleBodyEarly(Node moduleScopeRoot) {
        this.pushScript(this.currentScript.removeFirstChildScript());
        this.currentScript.rootNode = moduleScopeRoot;
    }

    private void updateGoogModule(NodeTraversal t, Node call) {
        Preconditions.checkState(this.currentScript.isModule, this.currentScript);
        if (this.currentScript.declareLegacyNamespace) {
            call.getFirstChild().getLastChild().setString("provide");
            this.compiler.reportChangeToEnclosingScope(call);
        }
        if (!this.currentScript.willCreateExportsObject) {
            Preconditions.checkState(!this.currentScript.hasCreatedExportObject, this.currentScript);
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(call), AddAt.AFTER, t);
        }
        if (!this.currentScript.declareLegacyNamespace && !this.preserveSugar) {
            this.compiler.reportChangeToEnclosingScope(call);
            NodeUtil.getEnclosingStatement(call).detach();
        }
        Node callee = call.getFirstChild();
        Node arg = callee.getNext();
        this.maybeAddToSymbolTable(callee);
        this.maybeAddToSymbolTable(ClosureRewriteModule.createNamespaceNode(arg));
    }

    private static void updateGoogDeclareLegacyNamespace(Node call) {
        NodeUtil.getEnclosingStatement(call).detach();
    }

    private void updateGoogRequire(NodeTraversal t, Node call) {
        Node namespaceIdNode = call.getLastChild();
        Node statementNode = NodeUtil.getEnclosingStatement(call);
        String namespaceId = namespaceIdNode.getString();
        boolean targetIsNonLegacyGoogModule = this.rewriteState.containsModule(namespaceId) && !this.rewriteState.isLegacyModule(namespaceId);
        boolean importHasAlias = NodeUtil.isNameDeclaration(statementNode);
        boolean isDestructuring = statementNode.getFirstChild().isDestructuringLhs();
        boolean currentScriptIsAModule = this.currentScript.isModule;
        boolean requireDirectlyStoredInAlias = NodeUtil.isNameDeclaration(call.getGrandparent());
        if (currentScriptIsAModule && requireDirectlyStoredInAlias && this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT)) {
            Node lhs = call.getParent();
            String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
            if (exportedNamespace != null) {
                if (lhs.isName()) {
                    String aliasName = statementNode.getFirstChild().getString();
                    this.recordNameToInline(aliasName, exportedNamespace, namespaceId);
                    this.maybeAddAliasToSymbolTable(statementNode.getFirstChild(), this.currentScript.namespaceId);
                } else if (lhs.isDestructuringLhs() && lhs.getFirstChild().isObjectPattern()) {
                    this.maybeWarnForInvalidDestructuring(t, lhs.getParent(), namespaceId);
                    for (Node importSpec : lhs.getFirstChild().children()) {
                        Preconditions.checkState(importSpec.hasChildren(), importSpec);
                        String importedProperty = importSpec.getString();
                        Node aliasNode = importSpec.getFirstChild();
                        String aliasName = aliasNode.getString();
                        String fullName = exportedNamespace + "." + importedProperty;
                        this.recordNameToInline(aliasName, fullName, null);
                        this.maybeAddAliasToSymbolTable(aliasNode, this.currentScript.namespaceId);
                        this.safeSetString(aliasNode, this.currentScript.contentsPrefix + aliasName);
                    }
                } else {
                    throw new RuntimeException("Illegal goog.module import: " + lhs);
                }
            }
        }
        if (this.currentScript.isModule || targetIsNonLegacyGoogModule) {
            if (isDestructuring) {
                if (!this.preserveSugar) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else if (targetIsNonLegacyGoogModule) {
                if (!this.isTopLevel(t, statementNode, ScopeType.EXEC_CONTEXT)) {
                    Node binaryNamespaceName = this.astFactory.createName(this.rewriteState.getBinaryNamespace(namespaceId), this.rewriteState.getGoogModuleNamespaceType(namespaceId));
                    binaryNamespaceName.setOriginalName(namespaceId);
                    call.replaceWith(binaryNamespaceName);
                    this.compiler.reportChangeToEnclosingScope(binaryNamespaceName);
                } else if (!(!importHasAlias && this.rewriteState.isLegacyModule(namespaceId) || this.preserveSugar)) {
                    this.compiler.reportChangeToEnclosingScope(statementNode);
                    statementNode.detach();
                }
            } else {
                call.detach();
                statementNode.replaceWith(IR.exprResult(call));
                this.compiler.reportChangeToEnclosingScope(call);
            }
            if (targetIsNonLegacyGoogModule && !this.preserveSugar) {
                Node callee = call.getFirstChild();
                Node arg = callee.getNext();
                this.maybeAddToSymbolTable(callee);
                this.maybeAddToSymbolTable(ClosureRewriteModule.createNamespaceNode(arg));
            }
        }
    }

    private void maybeWarnForInvalidDestructuring(NodeTraversal t, Node importNode, String importedNamespace) {
        Preconditions.checkArgument(importNode.getFirstChild().isDestructuringLhs(), importNode);
        ScriptDescription importedModule = (ScriptDescription)this.rewriteState.scriptDescriptionsByGoogModuleNamespace.get(importedNamespace);
        if (importedModule == null) {
            return;
        }
        if (importedModule.defaultExportRhs != null) {
            t.report(importNode, ILLEGAL_DESTRUCTURING_DEFAULT_EXPORT, new String[0]);
            return;
        }
        Node objPattern = importNode.getFirstFirstChild();
        for (Node key = objPattern.getFirstChild(); key != null; key = key.getNext()) {
            String exportName = key.getString();
            if (importedModule.namedExports.contains(exportName)) continue;
            t.report(importNode, ILLEGAL_DESTRUCTURING_NOT_EXPORTED, exportName, importedNamespace);
        }
    }

    private void updateGoogForwardDeclare(NodeTraversal t, Node call) {
        this.updateGoogRequire(t, call);
    }

    private void updateGoogModuleGetCall(Node call) {
        Node namespaceIdNode = call.getSecondChild();
        String namespaceId = namespaceIdNode.getString();
        String exportedNamespace = this.rewriteState.getExportedNamespaceOrScript(namespaceId);
        if (exportedNamespace != null) {
            this.compiler.reportChangeToEnclosingScope(call);
            Node exportedNamespaceName = this.astFactory.createQName(this.globalTypedScope, exportedNamespace).srcrefTree(call);
            exportedNamespaceName.setJSType(this.rewriteState.getGoogModuleNamespaceType(namespaceId));
            exportedNamespaceName.setOriginalName(namespaceId);
            call.replaceWith(exportedNamespaceName);
        }
    }

    private void recordExportsPropertyAssignment(NodeTraversal t, Node getpropNode) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState(parent.isAssign() || parent.isExprResult(), parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState(exportsNameNode.getString().equals("exports"), exportsNameNode);
        if (t.inModuleScope()) {
            String exportName = getpropNode.getLastChild().getString();
            this.currentScript.namedExports.add(exportName);
            Node exportRhs = getpropNode.getNext();
            ExportDefinition namedExport = ExportDefinition.newNamedExport(t, exportName, exportRhs);
            if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExportRhs == null && namedExport.hasInlinableName(this.currentScript.exportsToInline.keySet())) {
                this.recordExportToInline(namedExport);
                parent.getParent().detach();
            }
        }
    }

    private void updateExportsPropertyAssignment(Node getpropNode, NodeTraversal t) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = getpropNode.getParent();
        Preconditions.checkState(parent.isAssign() || parent.isExprResult(), parent);
        Node exportsNameNode = getpropNode.getFirstChild();
        Preconditions.checkState(exportsNameNode.getString().equals("exports"));
        String exportedNamespace = this.currentScript.getExportedNamespace();
        this.safeSetMaybeQualifiedString(exportsNameNode, exportedNamespace, false);
        Node jsdocNode = parent.isAssign() ? parent : getpropNode;
        ClosureRewriteModule.markConstAndCopyJsDoc(jsdocNode, jsdocNode);
        if (!this.currentScript.hasCreatedExportObject) {
            this.exportTheEmptyBinaryNamespaceAt(NodeUtil.getEnclosingStatement(parent), AddAt.BEFORE, t);
        }
    }

    private void maybeUpdateTopLevelName(NodeTraversal t, Node nameNode) {
        Node destructuringLhsNode;
        String name = nameNode.getString();
        if (!this.currentScript.isModule || !this.currentScript.topLevelNames.contains(name)) {
            return;
        }
        Var var = (Var)t.getScope().getVar(name);
        if (var == null || ((Scope)var.getScope()).getRootNode() != this.currentScript.rootNode) {
            return;
        }
        if (var.getNameNode() == nameNode && nameNode.getParent().isStringKey() && nameNode.getGrandparent().isObjectPattern() && (ClosureRewriteModule.isCallTo((destructuringLhsNode = nameNode.getGrandparent().getParent()).getLastChild(), GOOG_REQUIRE) || ClosureRewriteModule.isCallTo(destructuringLhsNode.getLastChild(), GOOG_REQUIRETYPE))) {
            return;
        }
        boolean nameIsAnAlias = this.currentScript.namesToInlineByAlias.containsKey(name);
        if (nameIsAnAlias && var.getNode() != nameNode) {
            this.maybeAddAliasToSymbolTable(nameNode, this.currentScript.namespaceId);
            AliasName inline = this.currentScript.namesToInlineByAlias.get(name);
            String namespaceToInline = inline.newName;
            if (namespaceToInline.equals(this.currentScript.getBinaryNamespace())) {
                this.currentScript.hasCreatedExportObject = true;
            }
            boolean isModuleNamespace = inline.namespaceId != null && this.rewriteState.scriptDescriptionsByGoogModuleNamespace.containsKey(inline.namespaceId) && !((ScriptDescription)((GlobalRewriteState)this.rewriteState).scriptDescriptionsByGoogModuleNamespace.get((Object)inline.namespaceId)).willCreateExportsObject;
            this.safeSetMaybeQualifiedString(nameNode, namespaceToInline, isModuleNamespace);
            if (namespaceToInline.indexOf(46) != -1) {
                String firstQualifiedName = namespaceToInline.substring(0, namespaceToInline.indexOf(46));
                Var shadowedVar = (Var)t.getScope().getVar(firstQualifiedName);
                if (shadowedVar == null || shadowedVar.isGlobal() || ((Scope)shadowedVar.getScope()).isModuleScope()) {
                    return;
                }
                t.report(shadowedVar.getNode(), IMPORT_INLINING_SHADOWS_VAR, shadowedVar.getName(), namespaceToInline);
            }
            return;
        }
        this.safeSetString(nameNode, this.currentScript.contentsPrefix + name);
    }

    private void maybeUpdateExportObjectLiteral(NodeTraversal t, Node n) {
        if (!this.currentScript.isModule) {
            return;
        }
        Node parent = n.getParent();
        Node rhs = parent.getLastChild();
        if (rhs.isObjectLit()) {
            for (Node c = rhs.getFirstChild(); c != null; c = c.getNext()) {
                if (c.isComputedProp()) {
                    t.report(c, INVALID_EXPORT_COMPUTED_PROPERTY, new String[0]);
                    continue;
                }
                if (!c.isStringKey()) continue;
                Node value = c.getFirstChild();
                this.maybeUpdateExportDeclToNode(t, c, value);
            }
        }
    }

    private void maybeUpdateExportDeclToNode(NodeTraversal t, Node target, Node value) {
        if (!this.currentScript.isModule) {
            return;
        }
        if (value.isName()) {
            JSDocInfo info;
            StaticScope varScope;
            Scope currentScope = t.getScope();
            Var v = (Var)t.getScope().getVar(value.getString());
            if (v != null && ((AbstractScope)(varScope = v.getScope())).getDepth() == currentScope.getDepth() && (info = v.getJSDocInfo()) != null && info.hasTypedefType()) {
                JSDocInfoBuilder builder = JSDocInfoBuilder.copyFrom(info);
                target.setJSDocInfo(builder.build());
                return;
            }
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(target, target);
    }

    private void maybeUpdateExportDeclaration(NodeTraversal t, Node n) {
        Node jsdocNode;
        if (!(this.currentScript.isModule && n.getString().equals("exports") && ClosureRewriteModule.isAssignTarget(n))) {
            return;
        }
        Node assignNode = n.getParent();
        if (!this.currentScript.declareLegacyNamespace && this.currentScript.defaultExportLocalName != null) {
            assignNode.getParent().detach();
            Node binaryNamespaceName = this.astFactory.createName(this.currentScript.getBinaryNamespace(), n.getJSType());
            this.declareGlobalVariable(binaryNamespaceName, t);
            return;
        }
        Node rhs = assignNode.getLastChild();
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = this.astFactory.createQName(this.globalTypedScope, this.currentScript.namespaceId).srcrefTree(n);
            legacyQname.setJSType(n.getJSType());
            assignNode.replaceChild(n, legacyQname);
            jsdocNode = assignNode;
        } else {
            rhs.detach();
            Node exprResultNode = assignNode.getParent();
            Node binaryNamespaceName = this.astFactory.createName(this.currentScript.getBinaryNamespace(), n.getJSType());
            binaryNamespaceName.setOriginalName("exports");
            this.declareGlobalVariable(binaryNamespaceName, t);
            Node exportsObjectCreationNode = IR.var(binaryNamespaceName, rhs);
            exportsObjectCreationNode.useSourceInfoIfMissingFromForTree(exprResultNode);
            exportsObjectCreationNode.putBooleanProp(Node.IS_NAMESPACE, true);
            exprResultNode.replaceWith(exportsObjectCreationNode);
            jsdocNode = exportsObjectCreationNode;
            this.currentScript.hasCreatedExportObject = true;
        }
        ClosureRewriteModule.markConstAndCopyJsDoc(assignNode, jsdocNode);
        this.compiler.reportChangeToEnclosingScope(jsdocNode);
        this.maybeUpdateExportObjectLiteral(t, rhs);
    }

    private void maybeUpdateExportNameRef(Node n) {
        if (!this.currentScript.isModule || !"exports".equals(n.getString()) || n.getParent() == null) {
            return;
        }
        if (n.getParent().isParamList()) {
            return;
        }
        if (this.currentScript.declareLegacyNamespace) {
            Node legacyQname = this.astFactory.createQName(this.globalTypedScope, this.currentScript.namespaceId).srcrefTree(n);
            legacyQname.setJSType(n.getJSType());
            n.replaceWith(legacyQname);
            this.compiler.reportChangeToEnclosingScope(legacyQname);
            return;
        }
        this.safeSetString(n, this.currentScript.getBinaryNamespace());
        Preconditions.checkState(this.currentScript.willCreateExportsObject || this.currentScript.hasCreatedExportObject);
    }

    void updateModuleBody(Node moduleBody) {
        Preconditions.checkArgument(moduleBody.isModuleBody() && moduleBody.getParent().getBooleanProp(Node.GOOG_MODULE), moduleBody);
        moduleBody.setToken(Token.BLOCK);
        NodeUtil.tryMergeBlock(moduleBody, true);
        for (ExportDefinition export : this.currentScript.exportsToInline.values()) {
            Node nameNode = export.nameDecl.getNameNode();
            this.safeSetMaybeQualifiedString(nameNode, this.currentScript.getBinaryNamespace() + export.getExportPostfix(), false);
        }
        Preconditions.checkState(this.currentScript.isModule, this.currentScript);
        Preconditions.checkState(this.currentScript.declareLegacyNamespace || this.currentScript.hasCreatedExportObject, this.currentScript);
        this.popScript();
    }

    private void pushScript(ScriptDescription newCurrentScript) {
        this.currentScript = newCurrentScript;
        if (!this.scriptStack.isEmpty()) {
            ScriptDescription parentScript = this.scriptStack.peek();
            parentScript.addChildScript(this.currentScript);
        }
        this.scriptStack.addFirst(this.currentScript);
    }

    private void popScript() {
        this.scriptStack.removeFirst();
        this.currentScript = this.scriptStack.peekFirst();
    }

    private void exportTheEmptyBinaryNamespaceAt(Node atNode, AddAt addAt, NodeTraversal t) {
        if (this.currentScript.declareLegacyNamespace) {
            return;
        }
        String binaryNamespaceString = this.currentScript.getBinaryNamespace();
        JSType moduleType = this.currentScript.rootNode.getJSType();
        Node binaryNamespaceName = this.astFactory.createName(binaryNamespaceString, moduleType);
        binaryNamespaceName.setOriginalName(this.currentScript.namespaceId);
        this.declareGlobalVariable(binaryNamespaceName, t);
        Node binaryNamespaceExportNode = IR.var(binaryNamespaceName, this.astFactory.createObjectLit(new Node[0]));
        if (addAt == AddAt.BEFORE) {
            atNode.getParent().addChildBefore(binaryNamespaceExportNode, atNode);
        } else if (addAt == AddAt.AFTER) {
            atNode.getParent().addChildAfter(binaryNamespaceExportNode, atNode);
        }
        binaryNamespaceExportNode.putBooleanProp(Node.IS_NAMESPACE, true);
        binaryNamespaceExportNode.srcrefTree(atNode);
        ClosureRewriteModule.markConst(binaryNamespaceExportNode);
        this.compiler.reportChangeToEnclosingScope(binaryNamespaceExportNode);
        this.currentScript.hasCreatedExportObject = true;
    }

    static void checkAndSetStrictModeDirective(NodeTraversal t, Node n) {
        Preconditions.checkState(n.isScript(), n);
        Set<String> directives = n.getDirectives();
        if (directives != null && directives.contains("use strict")) {
            t.report(n, USELESS_USE_STRICT_DIRECTIVE, new String[0]);
        } else if (directives == null) {
            n.setDirectives(USE_STRICT_ONLY);
        } else {
            ImmutableCollection.Builder builder = new ImmutableSet.Builder().add("use strict");
            ((ImmutableSet.Builder)builder).addAll(directives);
            n.setDirectives((Set<String>)((Object)((ImmutableSet.Builder)builder).build()));
        }
    }

    private static void markConst(Node n) {
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
        builder.recordConstancy();
        n.setJSDocInfo(builder.build());
    }

    private static void maybeSplitMultiVar(Node rhsNode) {
        Node statementNode = rhsNode.getGrandparent();
        if (!statementNode.isVar() || !statementNode.hasMoreThanOneChild()) {
            return;
        }
        Node nameNode = rhsNode.getParent();
        nameNode.detach();
        rhsNode.detach();
        statementNode.getParent().addChildBefore(IR.var(nameNode, rhsNode), statementNode);
    }

    private static void markConstAndCopyJsDoc(Node from, Node target) {
        JSDocInfo info = from.getJSDocInfo();
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
        builder.recordConstancy();
        target.setJSDocInfo(builder.build());
    }

    private void recordExportToInline(ExportDefinition exportDefinition) {
        Preconditions.checkState(exportDefinition.hasInlinableName(this.currentScript.exportsToInline.keySet()), "exportDefinition: %s\n\nexportsToInline keys: %s", (Object)exportDefinition, this.currentScript.exportsToInline.keySet());
        Preconditions.checkState(null == this.currentScript.exportsToInline.put(exportDefinition.nameDecl, exportDefinition), "Already found a mapping for inlining export: %s", (Object)exportDefinition.nameDecl);
        String localName = exportDefinition.getLocalName();
        String fullExportedName = this.currentScript.getBinaryNamespace() + exportDefinition.getExportPostfix();
        this.recordNameToInline(localName, fullExportedName, null);
    }

    private void recordNameToInline(String aliasName, String newName, @Nullable String namespaceId) {
        Preconditions.checkNotNull(aliasName);
        Preconditions.checkNotNull(newName);
        Preconditions.checkState(null == this.currentScript.namesToInlineByAlias.put(aliasName, new AliasName(newName, namespaceId)), "Already found a mapping for inlining short name: %s", (Object)aliasName);
    }

    private void reportUnrecognizedRequires() {
        for (UnrecognizedRequire unrecognizedRequire : this.unrecognizedRequires) {
            String namespaceId = unrecognizedRequire.namespaceId;
            Node requireNode = unrecognizedRequire.requireNode;
            boolean targetGoogModuleExists = this.rewriteState.containsModule(namespaceId);
            boolean targetLegacyScriptExists = this.rewriteState.providedNamespaces.contains(namespaceId);
            if (targetGoogModuleExists || targetLegacyScriptExists || this.preserveSugar || NodeUtil.getEnclosingScript(requireNode) == null) continue;
            this.compiler.reportChangeToEnclosingScope(requireNode);
            Node enclosingStatement = NodeUtil.getEnclosingStatement(requireNode);
            if (!NodeUtil.isNameDeclaration(enclosingStatement)) {
                requireNode.replaceWith(this.astFactory.createNull().srcref(requireNode));
                continue;
            }
            enclosingStatement.detach();
            for (Node lhs : NodeUtil.findLhsNodesInNode(enclosingStatement)) {
                this.syntheticExterns.putIfAbsent(lhs.getString(), lhs);
            }
        }
        this.unrecognizedRequires.clear();
    }

    private void safeSetString(Node n, String newString) {
        Node changeScope;
        if (n.getString().equals(newString)) {
            return;
        }
        String originalName = n.getString();
        n.setString(newString);
        if (n.getOriginalName() == null) {
            n.setOriginalName(originalName);
        }
        if ((changeScope = NodeUtil.getEnclosingChangeScopeRoot(n)) != null) {
            this.compiler.reportChangeToChangeScope(changeScope);
        }
    }

    private void safeSetMaybeQualifiedString(Node nameNode, String newString, boolean isModuleNamespace) {
        if (!newString.contains(".")) {
            this.safeSetString(nameNode, newString);
            Node parent = nameNode.getParent();
            if (isModuleNamespace && parent.isGetProp() && nameNode.getGrandparent().isCall() && parent.isFirstChildOf(nameNode.getGrandparent())) {
                nameNode.getGrandparent().putBooleanProp(Node.FREE_CALL, true);
            }
            return;
        }
        Node nameParent = nameNode.getParent();
        Node newQualifiedName = this.astFactory.createQName(this.globalTypedScope, newString).srcrefTree(nameNode);
        newQualifiedName.setDefineName(nameNode.getDefineName());
        boolean replaced = ClosureRewriteModule.safeSetStringIfDeclaration(nameParent, nameNode, newQualifiedName);
        if (replaced) {
            return;
        }
        nameParent.replaceChild(nameNode, newQualifiedName);
        if (newQualifiedName.hasChildren()) {
            newQualifiedName.getFirstChild().makeNonIndexableRecursive();
        }
        this.compiler.reportChangeToEnclosingScope(newQualifiedName);
    }

    private static boolean safeSetStringIfDeclaration(Node nameParent, Node nameNode, Node newQualifiedName) {
        JSDocInfo jsdoc = nameParent.getJSDocInfo();
        switch (nameParent.getToken()) {
            case CLASS: 
            case FUNCTION: {
                if (!NodeUtil.isStatement(nameParent) || nameParent.getFirstChild() != nameNode) {
                    return false;
                }
                Node statementParent = nameParent.getParent();
                Node placeholder = IR.empty();
                statementParent.replaceChild(nameParent, placeholder);
                Node newDeclaration = NodeUtil.getDeclarationFromName(newQualifiedName, nameParent, Token.VAR, jsdoc);
                if (NodeUtil.isExprAssign(newDeclaration)) {
                    Node assign = newDeclaration.getOnlyChild();
                    assign.setJSType(nameNode.getJSType());
                }
                nameParent.setJSDocInfo(null);
                newDeclaration.useSourceInfoIfMissingFromForTree(nameParent);
                ClosureRewriteModule.replaceStringNodeLocationForExportedTopLevelVariable(newDeclaration, nameNode.getSourcePosition(), nameNode.getLength());
                statementParent.replaceChild(placeholder, newDeclaration);
                NodeUtil.removeName(nameParent);
                return true;
            }
            case CONST: 
            case LET: 
            case VAR: {
                Node newStatement;
                Node rhs;
                Node node = rhs = nameNode.hasChildren() ? nameNode.getLastChild().detach() : null;
                if (jsdoc == null) {
                    jsdoc = nameNode.getJSDocInfo();
                }
                if (NodeUtil.isExprAssign(newStatement = NodeUtil.getDeclarationFromName(newQualifiedName, rhs, Token.VAR, jsdoc))) {
                    Node assign = newStatement.getOnlyChild();
                    assign.setJSType(nameNode.getJSType());
                    if (nameParent.isConst()) {
                        JSDocInfoBuilder jsdocBuilder = JSDocInfoBuilder.maybeCopyFrom(jsdoc);
                        jsdocBuilder.recordConstancy();
                        jsdoc = jsdocBuilder.build();
                        assign.setJSDocInfo(jsdoc);
                    }
                }
                newStatement.useSourceInfoIfMissingFromForTree(nameParent);
                int nameLength = nameNode.getOriginalName() != null ? nameNode.getOriginalName().length() : nameNode.getString().length();
                ClosureRewriteModule.replaceStringNodeLocationForExportedTopLevelVariable(newStatement, nameNode.getSourcePosition(), nameLength);
                NodeUtil.replaceDeclarationChild(nameNode, newStatement);
                return true;
            }
            case OBJECT_PATTERN: 
            case ARRAY_PATTERN: 
            case PARAM_LIST: {
                throw new RuntimeException("Not supported");
            }
        }
        return false;
    }

    private static void replaceStringNodeLocationForExportedTopLevelVariable(Node n, int sourcePosition, int length) {
        Node getProp;
        Node assign;
        if (n.hasOneChild() && (assign = n.getFirstChild()) != null && assign.isAssign() && (getProp = assign.getFirstChild()) != null && getProp.isGetProp()) {
            for (Node child : getProp.children()) {
                child.setSourceEncodedPosition(sourcePosition);
                child.setLength(length);
            }
        }
    }

    private boolean isTopLevel(NodeTraversal t, Node n, ScopeType scopeType) {
        if (scopeType == ScopeType.EXEC_CONTEXT) {
            return t.inGlobalScope() || t.getClosestHoistScopeRoot() == this.currentScript.rootNode;
        }
        return n.getParent() == this.currentScript.rootNode;
    }

    private static String toModuleContentsPrefix(String namespaceId) {
        return MODULE_CONTENTS_PREFIX + namespaceId.replace('.', '$') + "_";
    }

    public static boolean isModuleExport(String name) {
        return name.startsWith(MODULE_EXPORTS_PREFIX);
    }

    public static boolean isModuleContent(String name) {
        return name.startsWith(MODULE_CONTENTS_PREFIX);
    }

    private static boolean isExportPropertyAssignment(Node n) {
        Node target = n.getFirstChild();
        return (ClosureRewriteModule.isAssignTarget(n) || ClosureRewriteModule.isTypedefTarget(n)) && target.isName() && target.getString().equals("exports");
    }

    private static boolean isAssignTarget(Node n) {
        Node parent = n.getParent();
        return parent.isAssign() && parent.getFirstChild() == n;
    }

    private static boolean isTypedefTarget(Node n) {
        Node parent = n.getParent();
        return parent.isExprResult() && parent.getFirstChild() == n;
    }

    private void maybeAddToSymbolTable(Node n) {
        if (this.preprocessorSymbolTable != null) {
            this.preprocessorSymbolTable.addReference(n);
        }
    }

    private void maybeAddAliasToSymbolTable(Node n, String module) {
        if (this.preprocessorSymbolTable != null) {
            n.putBooleanProp(Node.MODULE_ALIAS, true);
            String nodeName = n.isString() ? n.getString() : this.preprocessorSymbolTable.getQualifiedName(n);
            String name = "alias_" + module + "_" + nodeName;
            this.preprocessorSymbolTable.addReference(n, name);
        }
    }

    private static Node createNamespaceNode(Node n) {
        return Node.newString(n.getString()).useSourceInfoFrom(n);
    }

    private static boolean isCallTo(Node n, Node targetMethod) {
        if (!n.isCall()) {
            return false;
        }
        Node method = n.getFirstChild();
        return method.isGetProp() && method.matchesQualifiedName(targetMethod);
    }

    private void declareGlobalVariable(Node n, NodeTraversal t) {
        Preconditions.checkState(n.isName());
        if (this.globalTypedScope == null) {
            return;
        }
        String name = n.getString();
        if (this.globalTypedScope.hasOwnSlot(name)) {
            t.report(t.getCurrentScript(), ILLEGAL_MODULE_RENAMING_CONFLICT, name);
        } else {
            JSType type = Preconditions.checkNotNull(n.getJSType());
            this.globalTypedScope.declare(name, n, type, t.getInput(), false);
        }
    }

    private class UnwrapGoogLoadModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private UnwrapGoogLoadModule() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case SCRIPT: {
                    return true;
                }
                case EXPR_RESULT: {
                    Node call = n.getFirstChild();
                    if (ClosureRewriteModule.isCallTo(call, GOOG_LOADMODULE) && call.getLastChild().isFunction()) {
                        parent.putBooleanProp(Node.GOOG_MODULE, true);
                        Node functionNode = call.getLastChild();
                        ClosureRewriteModule.this.compiler.reportFunctionDeleted(functionNode);
                        Node moduleBody = functionNode.getLastChild().detach();
                        moduleBody.setToken(Token.MODULE_BODY);
                        Node exportsParameter = NodeUtil.getFunctionParameters(functionNode).getOnlyChild();
                        moduleBody.setJSType(exportsParameter.getJSType());
                        n.replaceWith(moduleBody);
                        Node returnNode = moduleBody.getLastChild();
                        if (!returnNode.isReturn()) {
                            ClosureRewriteModule.this.compiler.report(JSError.make(moduleBody, LOAD_MODULE_FN_MISSING_RETURN, new String[0]));
                        } else {
                            returnNode.detach();
                        }
                        t.reportCodeChange();
                    }
                    return false;
                }
            }
            return false;
        }
    }

    static class GlobalRewriteState {
        private final Map<String, ScriptDescription> scriptDescriptionsByGoogModuleNamespace = new HashMap<String, ScriptDescription>();
        private final Multimap<Node, String> namespaceIdsByScriptNode = HashMultimap.create();
        private final Set<String> providedNamespaces = new HashSet<String>();

        GlobalRewriteState() {
        }

        boolean containsModule(String namespaceId) {
            return this.scriptDescriptionsByGoogModuleNamespace.containsKey(namespaceId);
        }

        boolean isLegacyModule(String namespaceId) {
            Preconditions.checkArgument(this.containsModule(namespaceId));
            return this.scriptDescriptionsByGoogModuleNamespace.get((Object)namespaceId).declareLegacyNamespace;
        }

        @Nullable
        String getBinaryNamespace(String namespaceId) {
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return script == null ? null : script.getBinaryNamespace();
        }

        @Nullable
        JSType getGoogModuleNamespaceType(String namespaceId) {
            ScriptDescription googModule = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return googModule == null ? null : googModule.rootNode.getJSType();
        }

        @Nullable
        private String getExportedNamespaceOrScript(String namespaceId) {
            if (this.providedNamespaces.contains(namespaceId)) {
                return namespaceId;
            }
            ScriptDescription script = this.scriptDescriptionsByGoogModuleNamespace.get(namespaceId);
            return script == null ? null : script.getExportedNamespace();
        }

        void removeRoot(Node toRemove) {
            if (this.namespaceIdsByScriptNode.containsKey(toRemove)) {
                this.scriptDescriptionsByGoogModuleNamespace.keySet().removeAll(this.namespaceIdsByScriptNode.removeAll(toRemove));
            }
        }
    }

    private class ScriptUpdater
    implements NodeTraversal.Callback {
        final Deque<ScriptDescription> scriptDescriptions;

        ScriptUpdater(Deque<ScriptDescription> scriptDescriptions) {
            this.scriptDescriptions = scriptDescriptions;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case SCRIPT: {
                    ScriptDescription currentDescription = this.scriptDescriptions.removeFirst();
                    Preconditions.checkState(currentDescription.rootNode == n);
                    if (n.isFromExterns() && !NodeUtil.isFromTypeSummary(n)) {
                        return false;
                    }
                    Preconditions.checkState(ClosureRewriteModule.this.scriptStack.isEmpty());
                    ClosureRewriteModule.this.pushScript(currentDescription);
                    t.getScope();
                    if (ClosureRewriteModule.this.globalScope != null) break;
                    ClosureRewriteModule.this.globalScope = (Scope)t.getScope().getGlobalScope();
                    break;
                }
                case MODULE_BODY: {
                    if (parent.getBooleanProp(Node.GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateModuleBodyEarly(n);
                        break;
                    }
                    return false;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.updateGoogModule(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.updateGoogDeclareLegacyNamespace(n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE) || method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.updateGoogRequire(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_FORWARDDECLARE) || parent.isExprResult()) break;
                    ClosureRewriteModule.this.updateGoogForwardDeclare(t, n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(n)) break;
                    ClosureRewriteModule.this.updateExportsPropertyAssignment(n, t);
                    break;
                }
            }
            if (n.getJSDocInfo() != null) {
                ClosureRewriteModule.this.rewriteJsdoc(n.getJSDocInfo());
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.updateModuleBody(n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeUpdateTopLevelName(t, n);
                    ClosureRewriteModule.this.maybeUpdateExportDeclaration(t, n);
                    t.getScope();
                    ClosureRewriteModule.this.maybeUpdateExportNameRef(n);
                    break;
                }
                case SCRIPT: {
                    Preconditions.checkState(((ClosureRewriteModule)ClosureRewriteModule.this).currentScript.rootNode == n);
                    ClosureRewriteModule.this.popScript();
                    break;
                }
            }
        }
    }

    private class ScriptRecorder
    implements NodeTraversal.Callback {
        private ScriptRecorder() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case MODULE_BODY: {
                    ClosureRewriteModule.this.recordModuleBody(n);
                    break;
                }
                case CALL: {
                    Node method = n.getFirstChild();
                    if (!method.isGetProp()) break;
                    if (method.matchesQualifiedName(GOOG_MODULE)) {
                        ClosureRewriteModule.this.recordGoogModule(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_MODULE_DECLARELEGACYNAMESPACE)) {
                        ClosureRewriteModule.this.recordGoogDeclareLegacyNamespace();
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_PROVIDE)) {
                        ClosureRewriteModule.this.recordGoogProvide(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRE)) {
                        ClosureRewriteModule.this.recordGoogRequire(t, n, true);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_REQUIRETYPE)) {
                        ClosureRewriteModule.this.recordGoogRequireType(t, n);
                        break;
                    }
                    if (method.matchesQualifiedName(GOOG_FORWARDDECLARE) && !parent.isExprResult()) {
                        ClosureRewriteModule.this.recordGoogForwardDeclare(t, n);
                        break;
                    }
                    if (!method.matchesQualifiedName(GOOG_MODULE_GET)) break;
                    ClosureRewriteModule.this.recordGoogModuleGet(t, n);
                    break;
                }
                case CLASS: 
                case FUNCTION: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelClassOrFunctionName(n);
                    break;
                }
                case CONST: 
                case LET: 
                case VAR: {
                    if (!ClosureRewriteModule.this.isTopLevel(t, n, n.isVar() ? ScopeType.EXEC_CONTEXT : ScopeType.BLOCK)) break;
                    ClosureRewriteModule.this.recordTopLevelVarNames(n);
                    break;
                }
                case GETPROP: {
                    if (!ClosureRewriteModule.isExportPropertyAssignment(n)) break;
                    ClosureRewriteModule.this.recordExportsPropertyAssignment(t, n);
                    break;
                }
                case NAME: {
                    ClosureRewriteModule.this.maybeRecordExportDeclaration(t, n);
                    break;
                }
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isModuleBody()) {
                ClosureRewriteModule.this.popScript();
            }
        }
    }

    private class ScriptPreprocessor
    extends NodeTraversal.AbstractPreOrderCallback {
        private ScriptPreprocessor() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case ROOT: 
                case MODULE_BODY: {
                    return true;
                }
                case SCRIPT: {
                    if (NodeUtil.isGoogModuleFile(n)) {
                        ClosureRewriteModule.checkAndSetStrictModeDirective(t, n);
                    }
                    return true;
                }
                case NAME: {
                    ClosureRewriteModule.this.preprocessExportDeclaration(n);
                    return true;
                }
            }
            return !parent.isScript();
        }
    }

    private static final class ScriptDescription {
        boolean isModule;
        boolean declareLegacyNamespace;
        String namespaceId;
        String contentsPrefix;
        final Set<String> topLevelNames = new HashSet<String>();
        final Deque<ScriptDescription> childScripts = new ArrayDeque<ScriptDescription>();
        final Map<String, AliasName> namesToInlineByAlias = new HashMap<String, AliasName>();
        boolean willCreateExportsObject;
        boolean hasCreatedExportObject;
        Node defaultExportRhs;
        String defaultExportLocalName;
        Set<String> namedExports = new HashSet<String>();
        Map<Var, ExportDefinition> exportsToInline = new HashMap<Var, ExportDefinition>();
        Node rootNode;

        private ScriptDescription() {
        }

        public void addChildScript(ScriptDescription childScript) {
            this.childScripts.addLast(childScript);
        }

        public ScriptDescription removeFirstChildScript() {
            return this.childScripts.removeFirst();
        }

        @Nullable
        String getBinaryNamespace() {
            if (!this.isModule || this.declareLegacyNamespace) {
                return null;
            }
            return ClosureRewriteModule.getBinaryModuleNamespace(this.namespaceId);
        }

        @Nullable
        String getExportedNamespace() {
            if (this.declareLegacyNamespace) {
                return this.namespaceId;
            }
            return this.getBinaryNamespace();
        }
    }

    private static class AliasName {
        final String newName;
        @Nullable
        final String namespaceId;

        AliasName(String newName, @Nullable String namespaceId) {
            this.newName = newName;
            this.namespaceId = namespaceId;
        }
    }

    private static final class ExportDefinition {
        @Nullable
        String exportName;
        @Nullable
        Node rhs;
        @Nullable
        Var nameDecl;
        private static final ImmutableSet<Token> INLINABLE_NAME_PARENTS = ImmutableSet.of(Token.VAR, Token.CONST, Token.LET, Token.FUNCTION, Token.CLASS);

        private ExportDefinition() {
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("exportName", this.exportName).add("rhs", this.rhs).add("nameDecl", this.nameDecl).omitNullValues().toString();
        }

        static ExportDefinition newDefaultExport(NodeTraversal t, Node rhs) {
            return ExportDefinition.newNamedExport(t, null, rhs);
        }

        static ExportDefinition newNamedExport(NodeTraversal t, String name, Node rhs) {
            ExportDefinition newExport = new ExportDefinition();
            newExport.exportName = name;
            newExport.rhs = rhs;
            if (rhs != null && (rhs.isName() || rhs.isStringKey())) {
                newExport.nameDecl = (Var)t.getScope().getVar(rhs.getString());
            }
            return newExport;
        }

        String getExportPostfix() {
            if (this.exportName == null) {
                return "";
            }
            return "." + this.exportName;
        }

        boolean hasInlinableName(Set<Var> exportedNames) {
            if (this.nameDecl == null || exportedNames.contains(this.nameDecl) || !INLINABLE_NAME_PARENTS.contains((Object)this.nameDecl.getParentNode().getToken()) || NodeUtil.isFunctionDeclaration(this.nameDecl.getParentNode())) {
                return false;
            }
            Node initialValue = this.nameDecl.getInitialValue();
            if (initialValue == null || !initialValue.isCall()) {
                return true;
            }
            Node method = initialValue.getFirstChild();
            if (!method.isGetProp()) {
                return true;
            }
            Node maybeGoog = method.getFirstChild();
            if (!maybeGoog.isName() || !maybeGoog.getString().equals("goog")) {
                return true;
            }
            String name = maybeGoog.getNext().getString();
            return !name.equals("require") && !name.equals("forwardDeclare") && !name.equals("getMsg");
        }

        String getLocalName() {
            return this.nameDecl.getName();
        }
    }

    private static final class UnrecognizedRequire {
        final Node requireNode;
        final String namespaceId;
        final boolean mustBeOrdered;

        UnrecognizedRequire(Node requireNode, String namespaceId, boolean mustBeOrdered) {
            this.requireNode = requireNode;
            this.namespaceId = namespaceId;
            this.mustBeOrdered = mustBeOrdered;
        }
    }

    private static enum ScopeType {
        EXEC_CONTEXT,
        BLOCK;

    }

    private static enum AddAt {
        BEFORE,
        AFTER;

    }
}

