/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

final class RewriteCatchWithNoBinding
implements HotSwapCompilerPass {
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.OPTIONAL_CATCH_BINDING);
    private static final String BINDING_NAME = "$jscomp$unused$catch";
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;

    RewriteCatchWithNoBinding(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, TRANSPILED_FEATURES, new AddBindings());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, new AddBindings());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    private class AddBindings
    extends NodeTraversal.AbstractPostOrderCallback {
        private AddBindings() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isCatch() || !n.getFirstChild().isEmpty()) {
                return;
            }
            Node name = RewriteCatchWithNoBinding.this.astFactory.createNameWithUnknownType(RewriteCatchWithNoBinding.BINDING_NAME);
            n.getFirstChild().replaceWith(name.srcrefTree(n.getFirstChild()));
            t.reportCodeChange();
        }
    }
}

