/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

final class RewriteNewDotTarget
implements HotSwapCompilerPass {
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.NEW_TARGET);
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;

    RewriteNewDotTarget(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
    }

    private Node createThisDotConstructorForFunction(Node functionNode) {
        return this.astFactory.createGetProp(this.astFactory.createThisForFunction(functionNode), "constructor");
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, TRANSPILED_FEATURES, new RewriteNewDotTargetCallback());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, new RewriteNewDotTargetCallback());
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    private class RewriteNewDotTargetCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private RewriteNewDotTargetCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.getToken() == Token.NEW_TARGET) {
                Node enclosingNonArrowFunction = NodeUtil.getEnclosingNonArrowFunction(n);
                if (enclosingNonArrowFunction != null && NodeUtil.isEs6Constructor(enclosingNonArrowFunction)) {
                    n.replaceWith(RewriteNewDotTarget.this.createThisDotConstructorForFunction(enclosingNonArrowFunction).srcrefTree(n));
                    t.reportCodeChange();
                } else {
                    Es6ToEs3Util.cannotConvertYet(RewriteNewDotTarget.this.compiler, n, "new.target");
                }
            }
        }
    }
}

