/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;

public final class RewriteNullishCoalesceOperator
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String TEMP_VAR_NAME_PREFIX = "$jscomp$nullish$tmp";
    private static final FeatureSet TRANSPILED_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.NULL_COALESCE_OP);
    private final AbstractCompiler compiler;
    private final AstFactory astFactory;
    private final Supplier<String> uniqueNameIdSuppier;

    public RewriteNullishCoalesceOperator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.uniqueNameIdSuppier = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, TRANSPILED_FEATURES, this);
        TranspilationPasses.processTranspile(this.compiler, root, TRANSPILED_FEATURES, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, TRANSPILED_FEATURES, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, TRANSPILED_FEATURES);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isNullishCoalesce()) {
            this.visitNullishCoalesce(t, n);
            t.reportCodeChange();
        }
    }

    private void visitNullishCoalesce(NodeTraversal t, Node n) {
        String tempVarName = TEMP_VAR_NAME_PREFIX + this.uniqueNameIdSuppier.get();
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node body = enclosingStatement.getParent();
        Node left = n.removeFirstChild();
        Node right = n.getLastChild().detach();
        Node let = this.astFactory.createSingleLetNameDeclaration(tempVarName);
        Node assignName = this.astFactory.createName(tempVarName, left.getJSType());
        Node assign = this.astFactory.createAssign(assignName, left);
        Node ne = this.astFactory.createNe(assign, this.astFactory.createNull());
        Node hookName = this.astFactory.createName(tempVarName, left.getJSType());
        Node hook = this.astFactory.createHook(ne, hookName, right);
        let.useSourceInfoIfMissingFromForTree(left);
        assignName.useSourceInfoIfMissingFromForTree(left);
        assign.useSourceInfoIfMissingFromForTree(left);
        ne.useSourceInfoIfMissingFromForTree(left);
        hookName.useSourceInfoIfMissingFromForTree(left);
        body.addChildBefore(let, enclosingStatement);
        n.replaceWith(hook);
        NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.LET_DECLARATIONS, this.compiler);
        this.compiler.reportChangeToEnclosingScope(hook);
    }
}

