// Generated by gmmproc 2.64.2 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUFFERLIST_H
#define _GSTREAMERMM_BUFFERLIST_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2015 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>


namespace Gst
{

class Buffer;

/** A grouped scatter data buffer type for data-passing.
 * Buffer lists are units of grouped scatter/gather data transfer in GStreamer.
 *
 * Buffer lists are created with create() and filled with data using a
 * Gst::BufferListIterator. The iterator has no current buffer; its cursor
 * position lies between buffers, immediately before the buffer that would be
 * returned by Gst::BufferListIterator::next(). After iterating to the end of a group the iterator must
 * be advanced to the next group by a call to
 * Gst::BufferListIterator::next_group() before any further calls to
 * Gst::BufferListIterator::next() can return buffers again. The cursor
 * position of a newly created iterator lies before the first group; a call to
 * Gst::BufferListIterator::next_group() is necessary before calls to
 * Gst::BufferListIterator::next() can return buffers.
 *
 * For more details, see the C API docs.
 */
class BufferList : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = BufferList;
  using BaseObjectType = GstBufferList;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<BufferList> create();

  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstBufferList*       gobj();

  ///Provides access to the underlying C instance.
  const GstBufferList* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBufferList* gobj_copy() const;

  BufferList() = delete;

  // noncopyable
  BufferList(const BufferList&) = delete;
  BufferList& operator=(const BufferList&) = delete;

protected:
  // Do not derive this.  Gst::BufferList can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  /** For example,
   * Gst::BufferListItem on_foreach(const Glib::RefPtr<Gst::Buffer>& buffer,
   * guint group, guint idx);.
   * A slot that will be called from foreach(). The buffer field will be a
   * reference to the buffer at idx in group.
   *
   * When this function returns Gst::BUFFER_LIST_CONTINUE, the next buffer will
   * be returned. When Gst::BUFFER_LIST_SKIP_GROUP is returned, all remaining
   * buffers in the current group will be skipped and the first buffer of the
   * next group is returned (if any). When Gst::BUFFER_LIST_END is returned,
   * foreach() will return.
   *
   * When the buffer is set to 0, the item will be removed from the bufferlist.
   * When the buffer has been made writable, the new buffer reference can be
   * assigned to the buffer.
   */
  typedef sigc::slot< bool, Glib::RefPtr<Gst::Buffer>&, guint> SlotForeach;

public:

  
  /** Remove @a length buffers starting from @a idx in @a list. The following buffers
   * are moved to close the gap.
   * 
   * @param idx The index.
   * @param length The amount to remove.
   */
  void remove(guint idx, guint length);

  
  /** Get the buffer at @a idx.
   * 
   * @param idx The index.
   * @return The buffer at @a idx in @a group
   * or <tt>nullptr</tt> when there is no buffer. The buffer remains valid as
   * long as @a list is valid and buffer is not removed from the list.
   */
  Glib::RefPtr<Gst::Buffer> remove(guint idx);

  
  /** Returns the number of buffers in @a list.
   * 
   * @return The number of buffers in the buffer list.
   */
  guint length() const;

  
  /** Create a shallow copy of the given buffer list. This will make a newly
   * allocated copy of the source list with copies of buffer pointers. The
   * refcount of buffers pointed to will be increased by one.
   */
  void copy() const;

  
  /** Create a copy of the given buffer list. This will make a newly allocated
   * copy of the buffer that the source buffer list contains.
   */
  void copy_deep() const;

  
  /** Insert @a buffer at @a idx in @a list. Other buffers are moved to make room for
   * this new buffer.
   * 
   * A -1 value for @a idx will append the buffer at the end.
   * 
   * @param idx The index.
   * @param buffer A Gst::Buffer.
   */
  void insert(gint idx, Glib::RefPtr<Gst::Buffer>&& buffer);

  /// A insert() convenience overload. Allows to re-use @a buffer parameter after function call.
  void insert(gint idx, const Glib::RefPtr<Gst::Buffer>& buffer);

  /** Call @a slot for each buffer in @a list.
   *
   * @a slot can modify the passed buffer pointer or its contents. The return
   * value of @a slot define if this function returns or if the remaining
   * buffers in a group should be skipped.
   *
   * @param slot A SlotForeach to call on each buffer.
   *
   * Since 0.10.24
   */
  void foreach(const SlotForeach& slot);
  

  /** Get the buffer at @a idx.
   * 
   * @param idx The index.
   * @return The buffer at @a idx in @a group
   * or <tt>nullptr</tt> when there is no buffer. The buffer remains valid as
   * long as @a list is valid and buffer is not removed from the list.
   */
  Glib::RefPtr<Gst::Buffer> get(guint idx);
  
  /** Get the buffer at @a idx.
   * 
   * @param idx The index.
   * @return The buffer at @a idx in @a group
   * or <tt>nullptr</tt> when there is no buffer. The buffer remains valid as
   * long as @a list is valid and buffer is not removed from the list.
   */
  Glib::RefPtr<const Gst::Buffer> get(guint idx) const;


};

} // namespace Gst


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::BufferList
 */

Glib::RefPtr<Gst::BufferList> wrap(GstBufferList* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_BUFFERLIST_H */

