/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.GridRow;
import impl.org.controlsfx.skin.GridViewSkin;
import javafx.scene.Node;
import javafx.scene.control.skin.CellSkinBase;
import org.controlsfx.control.GridCell;
import org.controlsfx.control.GridView;

public class GridRowSkin<T>
extends CellSkinBase<GridRow<T>> {
    public GridRowSkin(GridRow<T> control) {
        super(control);
        this.getChildren().clear();
        this.updateCells();
        this.registerChangeListener(((GridRow)this.getSkinnable()).widthProperty(), e -> this.updateCells());
        this.registerChangeListener(((GridRow)this.getSkinnable()).heightProperty(), e -> this.updateCells());
    }

    public GridCell<T> getCellAtIndex(int index) {
        if (index < this.getChildren().size()) {
            return (GridCell)this.getChildren().get(index);
        }
        return null;
    }

    public void updateCells() {
        int rowIndex = ((GridRow)this.getSkinnable()).getIndex();
        if (rowIndex >= 0) {
            GridView gridView = ((GridRow)this.getSkinnable()).getGridView();
            int maxCellsInRow = ((GridViewSkin)gridView.getSkin()).computeMaxCellsInRow();
            int totalCellsInGrid = gridView.getItems().size();
            int startCellIndex = rowIndex * maxCellsInRow;
            int endCellIndex = startCellIndex + maxCellsInRow - 1;
            int cacheIndex = 0;
            int cellIndex = startCellIndex;
            while (cellIndex <= endCellIndex && cellIndex < totalCellsInGrid) {
                GridCell<T> cell = this.getCellAtIndex(cacheIndex);
                if (cell == null) {
                    cell = this.createCell();
                    this.getChildren().add(cell);
                }
                cell.updateIndex(-1);
                cell.updateIndex(cellIndex);
                ++cellIndex;
                ++cacheIndex;
            }
            this.getChildren().remove(cacheIndex, this.getChildren().size());
        }
    }

    private GridCell<T> createCell() {
        GridView gridView = (GridView)((GridRow)this.getSkinnable()).gridViewProperty().get();
        GridCell<T> cell = gridView.getCellFactory() != null ? gridView.getCellFactory().call(gridView) : this.createDefaultCellImpl();
        cell.updateGridView(gridView);
        return cell;
    }

    private GridCell<T> createDefaultCellImpl() {
        return new GridCell<T>(){

            @Override
            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item.toString());
                }
            }
        };
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Double.MAX_VALUE;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        GridView gv = (GridView)((GridRow)this.getSkinnable()).gridViewProperty().get();
        return gv.getCellHeight() + gv.getVerticalCellSpacing() * 2.0;
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h2) {
        double cellWidth = ((GridView)((GridRow)this.getSkinnable()).gridViewProperty().get()).getCellWidth();
        double cellHeight = ((GridView)((GridRow)this.getSkinnable()).gridViewProperty().get()).getCellHeight();
        double horizontalCellSpacing = ((GridView)((GridRow)this.getSkinnable()).gridViewProperty().get()).getHorizontalCellSpacing();
        double verticalCellSpacing = ((GridView)((GridRow)this.getSkinnable()).gridViewProperty().get()).getVerticalCellSpacing();
        double xPos = 0.0;
        double yPos = 0.0;
        for (Node child : this.getChildren()) {
            child.relocate(xPos + horizontalCellSpacing, yPos + verticalCellSpacing);
            child.resize(cellWidth, cellHeight);
            xPos = xPos + horizontalCellSpacing + cellWidth + horizontalCellSpacing;
        }
    }
}

