/*
 * Decompiled with CFR 0.152.
 */
package gnu.activation.viewers;

import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class TextEditor
extends TextArea
implements CommandObject,
ActionListener {
    private transient DataHandler dh;

    public TextEditor() {
        super("", 24, 80, 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize(24, 80);
    }

    @Override
    public void setCommandContext(String string, DataHandler dataHandler) throws IOException {
        this.dh = dataHandler;
        InputStream inputStream = dataHandler.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        this.setText(byteArrayOutputStream.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("save".equals(actionEvent.getActionCommand()) && this.dh != null) {
            OutputStream outputStream = null;
            try {
                outputStream = this.dh.getOutputStream();
                if (outputStream != null) {
                    outputStream.write(this.getText().getBytes());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        }
    }
}

