/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineArgs;
import sun.security.ssl.EngineWriter;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLEngineImpl;

final class EngineOutputRecord
extends OutputRecord {
    private SSLEngineImpl engine;
    private EngineWriter writer;
    private boolean finishedMsg = false;

    EngineOutputRecord(byte by, SSLEngineImpl sSLEngineImpl) {
        super(by, EngineOutputRecord.recordSize(by));
        this.engine = sSLEngineImpl;
        this.writer = sSLEngineImpl.writer;
    }

    private static int recordSize(byte by) {
        switch (by) {
            case 20: 
            case 21: {
                return 539;
            }
            case 22: {
                return 16921;
            }
            case 23: {
                return 0;
            }
        }
        throw new RuntimeException("Unknown record type: " + by);
    }

    void setFinishedMsg() {
        this.finishedMsg = true;
    }

    @Override
    public void flush() throws IOException {
        this.finishedMsg = false;
    }

    boolean isFinishedMsg() {
        return this.finishedMsg;
    }

    @Override
    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = (ByteBuffer)ByteBuffer.allocate(n2).put(byArray, n, n2).flip();
        this.writer.putOutboundData(byteBuffer);
    }

    void write(Authenticator authenticator, CipherBox cipherBox) throws IOException {
        switch (this.contentType()) {
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            default: {
                throw new RuntimeException("unexpected byte buffers");
            }
        }
        if (!this.isEmpty()) {
            this.encrypt(authenticator, cipherBox);
            this.write((OutputStream)null, false, (ByteArrayOutputStream)null);
        }
    }

    void write(EngineArgs engineArgs, Authenticator authenticator, CipherBox cipherBox) throws IOException {
        int n;
        assert (this.contentType() == 23);
        if (authenticator == MAC.NULL) {
            return;
        }
        if (engineArgs.getAppRemaining() == 0) {
            return;
        }
        if (this.engine.needToSplitPayload(cipherBox, this.protocolVersion)) {
            this.write(engineArgs, authenticator, cipherBox, 1);
            engineArgs.resetLim();
            n = Math.min(engineArgs.getAppRemaining(), 15846);
        } else {
            n = Math.min(engineArgs.getAppRemaining(), 16384);
        }
        if (n > 0) {
            this.write(engineArgs, authenticator, cipherBox, n);
        }
    }

    void write(EngineArgs engineArgs, Authenticator authenticator, CipherBox cipherBox, int n) throws IOException {
        Object object;
        ByteBuffer byteBuffer = engineArgs.netData;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = n2 + 5 + cipherBox.getExplicitNonceSize();
        byteBuffer.position(n4);
        engineArgs.gather(n);
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n4);
        if (authenticator instanceof MAC && ((MAC)(object = (MAC)authenticator)).MAClen() != 0) {
            byte[] byArray = ((MAC)object).compute(this.contentType(), byteBuffer, false);
            byteBuffer.limit(byteBuffer.limit() + byArray.length);
            byteBuffer.put(byArray);
            byteBuffer.limit(byteBuffer.position());
            byteBuffer.position(n4);
        }
        if (!cipherBox.isNullCipher()) {
            if (this.protocolVersion.v >= ProtocolVersion.TLS11.v && (cipherBox.isCBCMode() || cipherBox.isAEADMode())) {
                object = cipherBox.createExplicitNonce(authenticator, this.contentType(), byteBuffer.remaining());
                byteBuffer.position(n2 + 5);
                byteBuffer.put((byte[])object);
                if (!cipherBox.isAEADMode()) {
                    byteBuffer.position(n2 + 5);
                }
            }
            cipherBox.encrypt(byteBuffer, n3);
            if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake") && this.contentType() == 20)) {
                System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + n);
            }
        } else {
            byteBuffer.position(byteBuffer.limit());
        }
        int n5 = byteBuffer.limit() - n2 - 5;
        byteBuffer.put(n2, this.contentType());
        byteBuffer.put(n2 + 1, this.protocolVersion.major);
        byteBuffer.put(n2 + 2, this.protocolVersion.minor);
        byteBuffer.put(n2 + 3, (byte)(n5 >> 8));
        byteBuffer.put(n2 + 4, (byte)n5);
        byteBuffer.limit(n3);
    }
}

