/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nio.zipfs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

final class ZipCoder {
    private Charset cs;
    private boolean isutf8;
    private ZipCoder utf8;
    private final ThreadLocal<CharsetDecoder> decTL = new ThreadLocal();
    private final ThreadLocal<CharsetEncoder> encTL = new ThreadLocal();

    String toString(byte[] byArray, int n) {
        CharBuffer charBuffer;
        CharsetDecoder charsetDecoder = this.decoder().reset();
        int n2 = (int)((float)n * charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n2];
        if (n2 == 0) {
            return new String(cArray);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n);
        CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer = CharBuffer.wrap(cArray), true);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        coderResult = charsetDecoder.flush(charBuffer);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        return new String(cArray, 0, charBuffer.position());
    }

    String toString(byte[] byArray) {
        return this.toString(byArray, byArray.length);
    }

    byte[] getBytes(String string) {
        CharsetEncoder charsetEncoder = this.encoder().reset();
        char[] cArray = string.toCharArray();
        int n = (int)((float)cArray.length * charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n];
        if (n == 0) {
            return byArray;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        coderResult = charsetEncoder.flush(byteBuffer);
        if (!coderResult.isUnderflow()) {
            throw new IllegalArgumentException(coderResult.toString());
        }
        if (byteBuffer.position() == byArray.length) {
            return byArray;
        }
        return Arrays.copyOf(byArray, byteBuffer.position());
    }

    byte[] getBytesUTF8(String string) {
        if (this.isutf8) {
            return this.getBytes(string);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(Charset.forName("UTF-8"));
        }
        return this.utf8.getBytes(string);
    }

    String toStringUTF8(byte[] byArray, int n) {
        if (this.isutf8) {
            return this.toString(byArray, n);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(Charset.forName("UTF-8"));
        }
        return this.utf8.toString(byArray, n);
    }

    boolean isUTF8() {
        return this.isutf8;
    }

    private ZipCoder(Charset charset) {
        this.cs = charset;
        this.isutf8 = charset.name().equals("UTF-8");
    }

    static ZipCoder get(Charset charset) {
        return new ZipCoder(charset);
    }

    static ZipCoder get(String string) {
        try {
            return new ZipCoder(Charset.forName(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new ZipCoder(Charset.defaultCharset());
        }
    }

    private CharsetDecoder decoder() {
        CharsetDecoder charsetDecoder = this.decTL.get();
        if (charsetDecoder == null) {
            charsetDecoder = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.decTL.set(charsetDecoder);
        }
        return charsetDecoder;
    }

    private CharsetEncoder encoder() {
        CharsetEncoder charsetEncoder = this.encTL.get();
        if (charsetEncoder == null) {
            charsetEncoder = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encTL.set(charsetEncoder);
        }
        return charsetEncoder;
    }
}

