/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Node;
import org.xml.sax.Attributes;

class Dumper {
    Dumper() {
    }

    public static void dump(Node node) {
        try {
            node.accept(new DumpVisitor());
        }
        catch (JasperException jasperException) {
            jasperException.printStackTrace();
        }
    }

    public static void dump(Node.Nodes nodes) {
        try {
            nodes.visit(new DumpVisitor());
        }
        catch (JasperException jasperException) {
            jasperException.printStackTrace();
        }
    }

    static class DumpVisitor
    extends Node.Visitor {
        private int indent = 0;

        DumpVisitor() {
        }

        private String getAttributes(Attributes attributes) {
            if (attributes == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < attributes.getLength(); ++i) {
                stringBuilder.append(" " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"");
            }
            return stringBuilder.toString();
        }

        private void printString(String string) {
            this.printIndent();
            System.out.print(string);
        }

        private void printString(String string, String string2, String string3) {
            this.printIndent();
            if (string2 != null) {
                System.out.print(string + string2 + string3);
            } else {
                System.out.print(string + string3);
            }
        }

        private void printAttributes(String string, Attributes attributes, String string2) {
            this.printString(string, this.getAttributes(attributes), string2);
        }

        private void dumpBody(Node node) throws JasperException {
            Node.Nodes nodes = node.getBody();
            if (nodes != null) {
                nodes.visit(this);
            }
        }

        @Override
        public void visit(Node.PageDirective pageDirective) throws JasperException {
            this.printAttributes("<%@ page", pageDirective.getAttributes(), "%>");
        }

        @Override
        public void visit(Node.TaglibDirective taglibDirective) throws JasperException {
            this.printAttributes("<%@ taglib", taglibDirective.getAttributes(), "%>");
        }

        @Override
        public void visit(Node.IncludeDirective includeDirective) throws JasperException {
            this.printAttributes("<%@ include", includeDirective.getAttributes(), "%>");
            this.dumpBody(includeDirective);
        }

        @Override
        public void visit(Node.Comment comment) throws JasperException {
            this.printString("<%--", comment.getText(), "--%>");
        }

        @Override
        public void visit(Node.Declaration declaration) throws JasperException {
            this.printString("<%!", declaration.getText(), "%>");
        }

        @Override
        public void visit(Node.Expression expression) throws JasperException {
            this.printString("<%=", expression.getText(), "%>");
        }

        @Override
        public void visit(Node.Scriptlet scriptlet) throws JasperException {
            this.printString("<%", scriptlet.getText(), "%>");
        }

        @Override
        public void visit(Node.IncludeAction includeAction) throws JasperException {
            this.printAttributes("<jsp:include", includeAction.getAttributes(), ">");
            this.dumpBody(includeAction);
            this.printString("</jsp:include>");
        }

        @Override
        public void visit(Node.ForwardAction forwardAction) throws JasperException {
            this.printAttributes("<jsp:forward", forwardAction.getAttributes(), ">");
            this.dumpBody(forwardAction);
            this.printString("</jsp:forward>");
        }

        @Override
        public void visit(Node.GetProperty getProperty) throws JasperException {
            this.printAttributes("<jsp:getProperty", getProperty.getAttributes(), "/>");
        }

        @Override
        public void visit(Node.SetProperty setProperty) throws JasperException {
            this.printAttributes("<jsp:setProperty", setProperty.getAttributes(), ">");
            this.dumpBody(setProperty);
            this.printString("</jsp:setProperty>");
        }

        @Override
        public void visit(Node.UseBean useBean) throws JasperException {
            this.printAttributes("<jsp:useBean", useBean.getAttributes(), ">");
            this.dumpBody(useBean);
            this.printString("</jsp:useBean>");
        }

        @Override
        public void visit(Node.PlugIn plugIn) throws JasperException {
            this.printAttributes("<jsp:plugin", plugIn.getAttributes(), ">");
            this.dumpBody(plugIn);
            this.printString("</jsp:plugin>");
        }

        @Override
        public void visit(Node.ParamsAction paramsAction) throws JasperException {
            this.printAttributes("<jsp:params", paramsAction.getAttributes(), ">");
            this.dumpBody(paramsAction);
            this.printString("</jsp:params>");
        }

        @Override
        public void visit(Node.ParamAction paramAction) throws JasperException {
            this.printAttributes("<jsp:param", paramAction.getAttributes(), ">");
            this.dumpBody(paramAction);
            this.printString("</jsp:param>");
        }

        @Override
        public void visit(Node.NamedAttribute namedAttribute) throws JasperException {
            this.printAttributes("<jsp:attribute", namedAttribute.getAttributes(), ">");
            this.dumpBody(namedAttribute);
            this.printString("</jsp:attribute>");
        }

        @Override
        public void visit(Node.JspBody jspBody) throws JasperException {
            this.printAttributes("<jsp:body", jspBody.getAttributes(), ">");
            this.dumpBody(jspBody);
            this.printString("</jsp:body>");
        }

        @Override
        public void visit(Node.ELExpression eLExpression) throws JasperException {
            this.printString("${" + eLExpression.getText() + "}");
        }

        @Override
        public void visit(Node.CustomTag customTag) throws JasperException {
            this.printAttributes("<" + customTag.getQName(), customTag.getAttributes(), ">");
            this.dumpBody(customTag);
            this.printString("</" + customTag.getQName() + ">");
        }

        @Override
        public void visit(Node.UninterpretedTag uninterpretedTag) throws JasperException {
            String string = uninterpretedTag.getQName();
            this.printAttributes("<" + string, uninterpretedTag.getAttributes(), ">");
            this.dumpBody(uninterpretedTag);
            this.printString("</" + string + ">");
        }

        @Override
        public void visit(Node.TemplateText templateText) throws JasperException {
            this.printString(templateText.getText());
        }

        private void printIndent() {
            for (int i = 0; i < this.indent; ++i) {
                System.out.print("  ");
            }
        }
    }
}

