/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class WebXml {
    private static final String FILE_PROTOCOL = "file:";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private final Log log = LogFactory.getLog(WebXml.class);
    private InputStream stream;
    private InputSource source;
    private String systemId;

    public WebXml(ServletContext servletContext) throws IOException {
        Object object;
        String string = (String)servletContext.getAttribute("org.apache.tomcat.util.scan.MergedWebXml");
        if (string != null) {
            this.source = new InputSource(new StringReader(string));
            this.systemId = "org.apache.tomcat.util.scan.MergedWebXml";
        }
        if (this.source == null && (object = (String)servletContext.getAttribute(Constants.ALT_DD_ATTR)) != null) {
            try {
                URL uRL = new URL(FILE_PROTOCOL + ((String)object).replace('\\', '/'));
                this.stream = uRL.openStream();
                this.source = new InputSource(this.stream);
                this.systemId = uRL.toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", object));
            }
        }
        if (this.source == null) {
            object = servletContext.getResource(WEB_XML);
            if (object == null) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
            } else {
                this.stream = ((URL)object).openStream();
                this.source = new InputSource(this.stream);
                this.systemId = ((URL)object).toExternalForm();
            }
        }
        if (this.source == null) {
            this.systemId = null;
        } else {
            this.source.setSystemId(this.systemId);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public InputSource getInputSource() {
        return this.source;
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                this.log.error((Object)Localizer.getMessage("jsp.error.stream.close.failed"));
            }
        }
    }
}

