/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.tomcat.dbcp.dbcp.DbcpException;
import org.apache.tomcat.dbcp.dbcp.DelegatingCallableStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.DelegatingStatement;
import org.apache.tomcat.dbcp.dbcp.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.jocl.JOCLContentHandler;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.xml.sax.SAXException;

public class PoolingDriver
implements Driver {
    protected static final HashMap<String, ObjectPool<? extends Connection>> _pools;
    private static boolean accessToUnderlyingConnectionAllowed;
    protected static final String URL_PREFIX = "jdbc:apache:commons:dbcp:";
    protected static final int URL_PREFIX_LEN;
    protected static final int MAJOR_VERSION = 1;
    protected static final int MINOR_VERSION = 0;

    public static synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return accessToUnderlyingConnectionAllowed;
    }

    public static synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        accessToUnderlyingConnectionAllowed = bl;
    }

    @Deprecated
    public synchronized ObjectPool<? extends Connection> getPool(String string) {
        try {
            return this.getConnectionPool(string);
        }
        catch (Exception exception) {
            throw new DbcpException(exception);
        }
    }

    public synchronized ObjectPool<? extends Connection> getConnectionPool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = _pools.get(string);
        if (null == objectPool) {
            InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(string) + ".jocl");
            if (inputStream == null) {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.valueOf(string) + ".jocl");
            }
            if (null != inputStream) {
                JOCLContentHandler jOCLContentHandler = null;
                try {
                    jOCLContentHandler = JOCLContentHandler.parse(inputStream);
                }
                catch (SAXException sAXException) {
                    throw (SQLException)new SQLException("Could not parse configuration file").initCause(sAXException);
                }
                catch (IOException iOException) {
                    throw (SQLException)new SQLException("Could not load configuration file").initCause(iOException);
                }
                if (jOCLContentHandler.getType(0).equals(String.class)) {
                    objectPool = this.getPool((String)jOCLContentHandler.getValue(0));
                    if (null != objectPool) {
                        this.registerPool(string, objectPool);
                    }
                } else {
                    objectPool = ((PoolableConnectionFactory)jOCLContentHandler.getValue(0)).getPool();
                    if (null != objectPool) {
                        this.registerPool(string, objectPool);
                    }
                }
            } else {
                throw new SQLException("Configuration file not found");
            }
        }
        return objectPool;
    }

    public synchronized void registerPool(String string, ObjectPool<? extends Connection> objectPool) {
        _pools.put(string, objectPool);
    }

    public synchronized void closePool(String string) throws SQLException {
        ObjectPool<? extends Connection> objectPool = _pools.get(string);
        if (objectPool != null) {
            _pools.remove(string);
            try {
                objectPool.close();
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Error closing pool " + string).initCause(exception);
            }
        }
    }

    public synchronized String[] getPoolNames() {
        Set<String> set = _pools.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        try {
            return string.startsWith(URL_PREFIX);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            ObjectPool<? extends Connection> objectPool = this.getConnectionPool(string.substring(URL_PREFIX_LEN));
            if (null == objectPool) {
                throw new SQLException("No pool found for " + string + ".");
            }
            try {
                Connection connection = objectPool.borrowObject();
                if (connection != null) {
                    connection = new PoolGuardConnectionWrapper(objectPool, connection);
                }
                return connection;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (NoSuchElementException noSuchElementException) {
                throw (SQLException)new SQLException("Cannot get a connection, pool error: " + noSuchElementException.getMessage()).initCause(noSuchElementException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (SQLException)new SQLException("Cannot get a connection, general error: " + exception.getMessage()).initCause(exception);
            }
        }
        return null;
    }

    public void invalidateConnection(Connection connection) throws SQLException {
        PoolGuardConnectionWrapper poolGuardConnectionWrapper;
        if (connection instanceof PoolGuardConnectionWrapper) {
            poolGuardConnectionWrapper = (PoolGuardConnectionWrapper)connection;
            ObjectPool objectPool = poolGuardConnectionWrapper.pool;
            Connection connection2 = poolGuardConnectionWrapper.delegate;
            try {
                objectPool.invalidateObject(connection2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            throw new SQLException("Invalid connection class");
        }
        poolGuardConnectionWrapper.delegate = null;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        _pools = new HashMap();
        accessToUnderlyingConnectionAllowed = false;
        URL_PREFIX_LEN = URL_PREFIX.length();
    }

    private static class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private final ObjectPool<? extends Connection> pool;
        private Connection delegate;

        PoolGuardConnectionWrapper(ObjectPool<? extends Connection> objectPool, Connection connection) {
            super(connection);
            this.pool = objectPool;
            this.delegate = connection;
        }

        @Override
        protected void checkOpen() throws SQLException {
            if (this.delegate == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        @Override
        public void close() throws SQLException {
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
                super.setDelegate(null);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            if (this.delegate == null) {
                return true;
            }
            return this.delegate.isClosed();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this.delegate.clearWarnings();
        }

        @Override
        public void commit() throws SQLException {
            this.checkOpen();
            this.delegate.commit();
        }

        @Override
        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement());
        }

        @Override
        public Statement createStatement(int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2));
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.delegate == null) {
                return false;
            }
            return this.delegate.equals(object);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this.delegate.getAutoCommit();
        }

        @Override
        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this.delegate.getCatalog();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this.delegate.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this.delegate.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            this.checkOpen();
            return this.delegate.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this.delegate.getWarnings();
        }

        @Override
        public int hashCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.hashCode();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this.delegate.isReadOnly();
        }

        @Override
        public String nativeSQL(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.nativeSQL(string);
        }

        @Override
        public CallableStatement prepareCall(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string));
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2));
        }

        @Override
        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2));
        }

        @Override
        public void rollback() throws SQLException {
            this.checkOpen();
            this.delegate.rollback();
        }

        @Override
        public void setAutoCommit(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setAutoCommit(bl);
        }

        @Override
        public void setCatalog(String string) throws SQLException {
            this.checkOpen();
            this.delegate.setCatalog(string);
        }

        @Override
        public void setReadOnly(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setReadOnly(bl);
        }

        @Override
        public void setTransactionIsolation(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setTransactionIsolation(n);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.checkOpen();
            this.delegate.setTypeMap(map);
        }

        @Override
        public String toString() {
            if (this.delegate == null) {
                return "NULL";
            }
            return this.delegate.toString();
        }

        @Override
        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this.delegate.getHoldability();
        }

        @Override
        public void setHoldability(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setHoldability(n);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint(string);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.releaseSavepoint(savepoint);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.rollback(savepoint);
        }

        @Override
        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2, n3));
        }

        @Override
        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2, n3));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2, n3));
        }

        @Override
        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, nArray));
        }

        @Override
        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, stringArray));
        }

        @Override
        public Connection getDelegate() {
            if (PoolingDriver.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        @Override
        public Connection getInnermostDelegate() {
            if (PoolingDriver.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

