/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.collections.SynchronizedStack;

public abstract class ClusterManagerBase
extends ManagerBase
implements ClusterManager {
    private final Log log = LogFactory.getLog(ClusterManagerBase.class);
    protected CatalinaCluster cluster = null;
    private boolean notifyListenersOnReplication = true;
    private volatile ReplicationValve replicationValve = null;
    private boolean recordAllActions = false;
    private SynchronizedStack<DeltaRequest> deltaRequestPool = new SynchronizedStack();

    protected SynchronizedStack<DeltaRequest> getDeltaRequestPool() {
        return this.deltaRequestPool;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster catalinaCluster) {
        this.cluster = catalinaCluster;
    }

    @Override
    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean bl) {
        this.notifyListenersOnReplication = bl;
    }

    @Deprecated
    public String getSessionAttributeFilter() {
        return this.getSessionAttributeNameFilter();
    }

    @Deprecated
    public void setSessionAttributeFilter(String string) {
        this.setSessionAttributeNameFilter(string);
    }

    public boolean isRecordAllActions() {
        return this.recordAllActions;
    }

    public void setRecordAllActions(boolean bl) {
        this.recordAllActions = bl;
    }

    @Deprecated
    public boolean willAttributeDistribute(String string) {
        return this.willAttributeDistribute(string, null);
    }

    public static ClassLoader[] getClassLoaders(Container container) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Loader loader = container.getLoader();
        ClassLoader classLoader2 = null;
        if (loader != null) {
            classLoader2 = loader.getClassLoader();
        }
        if (classLoader2 == null) {
            classLoader2 = classLoader;
        }
        if (classLoader2 == classLoader) {
            return new ClassLoader[]{classLoader2};
        }
        return new ClassLoader[]{classLoader2, classLoader};
    }

    public ClassLoader[] getClassLoaders() {
        return ClusterManagerBase.getClassLoaders(this.getContainer());
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] byArray) throws IOException {
        return this.getReplicationStream(byArray, 0, byArray.length);
    }

    @Override
    public ReplicationStream getReplicationStream(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        return new ReplicationStream((InputStream)byteArrayInputStream, this.getClassLoaders());
    }

    public void load() {
    }

    public void unload() {
    }

    protected void clone(ClusterManagerBase clusterManagerBase) {
        clusterManagerBase.setName("Clone-from-" + this.getName());
        clusterManagerBase.setMaxActiveSessions(this.getMaxActiveSessions());
        clusterManagerBase.setProcessExpiresFrequency(this.getProcessExpiresFrequency());
        clusterManagerBase.setNotifyListenersOnReplication(this.isNotifyListenersOnReplication());
        clusterManagerBase.setSessionAttributeNameFilter(this.getSessionAttributeNameFilter());
        clusterManagerBase.setSessionAttributeValueClassNameFilter(this.getSessionAttributeValueClassNameFilter());
        clusterManagerBase.setWarnOnSessionAttributeFilterFailure(this.getWarnOnSessionAttributeFilterFailure());
        clusterManagerBase.setSecureRandomClass(this.getSecureRandomClass());
        clusterManagerBase.setSecureRandomProvider(this.getSecureRandomProvider());
        clusterManagerBase.setSecureRandomAlgorithm(this.getSecureRandomAlgorithm());
        if (this.getSessionIdGenerator() != null) {
            try {
                SessionIdGenerator sessionIdGenerator = (SessionIdGenerator)this.sessionIdGeneratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                sessionIdGenerator.setSessionIdLength(this.getSessionIdGenerator().getSessionIdLength());
                sessionIdGenerator.setJvmRoute(this.getSessionIdGenerator().getJvmRoute());
                clusterManagerBase.setSessionIdGenerator(sessionIdGenerator);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        clusterManagerBase.setRecordAllActions(this.isRecordAllActions());
    }

    protected void registerSessionAtReplicationValve(DeltaSession deltaSession) {
        Valve[] valveArray;
        CatalinaCluster catalinaCluster;
        if (this.replicationValve == null && (catalinaCluster = this.getCluster()) != null && (valveArray = catalinaCluster.getValves()) != null && valveArray.length > 0) {
            for (int i = 0; this.replicationValve == null && i < valveArray.length; ++i) {
                if (!(valveArray[i] instanceof ReplicationValve)) continue;
                this.replicationValve = (ReplicationValve)valveArray[i];
            }
            if (this.replicationValve == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"no ReplicationValve found for CrossContext Support");
            }
        }
        if (this.replicationValve != null) {
            this.replicationValve.registerReplicationSession(deltaSession);
        }
    }

    protected void startInternal() throws LifecycleException {
        Cluster cluster;
        super.startInternal();
        if (this.getCluster() == null && (cluster = this.getContainer().getCluster()) instanceof CatalinaCluster) {
            this.setCluster((CatalinaCluster)cluster);
        }
        if (this.cluster != null) {
            this.cluster.registerManager(this);
        }
    }

    protected void stopInternal() throws LifecycleException {
        if (this.cluster != null) {
            this.cluster.removeManager(this);
        }
        this.replicationValve = null;
        super.stopInternal();
    }
}

