/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.McastServiceImpl;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastService
implements MembershipService,
MembershipListener,
MessageListener {
    private static final Log log = LogFactory.getLog(McastService.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    private static final String info = "McastService/2.1";
    protected Properties properties = new Properties();
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected MessageListener msglistener;
    protected MemberImpl localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    protected byte[] payload;
    protected byte[] domain;
    private Channel channel;
    protected static final Member[] EMPTY_MEMBERS = new Member[0];

    public McastService() {
        this.setDefaults(this.properties);
    }

    public String getInfo() {
        return info;
    }

    @Override
    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "mcastFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.setDefaults(properties);
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public String getLocalMemberName() {
        return this.localMember.toString();
    }

    @Override
    public Member getLocalMember(boolean bl) {
        if (bl && this.localMember != null && this.impl != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        }
        return this.localMember;
    }

    @Override
    public void setLocalMemberProperties(String string, int n, int n2, int n3) {
        this.properties.setProperty("tcpListenHost", string);
        this.properties.setProperty("tcpListenPort", String.valueOf(n));
        this.properties.setProperty("udpListenPort", String.valueOf(n3));
        this.properties.setProperty("tcpSecurePort", String.valueOf(n2));
        try {
            if (this.localMember != null) {
                this.localMember.setHostname(string);
                this.localMember.setPort(n);
            } else {
                this.localMember = new MemberImpl(string, n, 0L);
                this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
                this.localMember.setPayload(this.getPayload());
                this.localMember.setDomain(this.getDomain());
                this.localMember.setLocal(true);
            }
            this.localMember.setSecurePort(n2);
            this.localMember.setUdpPort(n3);
            this.localMember.getData(true, true);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    public void setAddress(String string) {
        this.properties.setProperty("mcastAddress", string);
    }

    @Deprecated
    public void setMcastAddr(String string) {
        this.setAddress(string);
    }

    public String getAddress() {
        return this.properties.getProperty("mcastAddress");
    }

    @Deprecated
    public String getMcastAddr() {
        return this.getAddress();
    }

    public void setMcastBindAddress(String string) {
        this.setBind(string);
    }

    public void setBind(String string) {
        this.properties.setProperty("mcastBindAddress", string);
    }

    @Deprecated
    public String getMcastBindAddress() {
        return this.getBind();
    }

    public String getBind() {
        return this.properties.getProperty("mcastBindAddress");
    }

    @Deprecated
    public void setMcastPort(int n) {
        this.setPort(n);
    }

    public void setPort(int n) {
        this.properties.setProperty("mcastPort", String.valueOf(n));
    }

    public void setRecoveryCounter(int n) {
        this.properties.setProperty("recoveryCounter", String.valueOf(n));
    }

    public int getRecoveryCounter() {
        String string = this.properties.getProperty("recoveryCounter");
        if (string != null) {
            return Integer.parseInt(string);
        }
        return -1;
    }

    public void setRecoveryEnabled(boolean bl) {
        this.properties.setProperty("recoveryEnabled", String.valueOf(bl));
    }

    public boolean getRecoveryEnabled() {
        String string = this.properties.getProperty("recoveryEnabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public void setRecoverySleepTime(long l) {
        this.properties.setProperty("recoverySleepTime", String.valueOf(l));
    }

    public long getRecoverySleepTime() {
        String string = this.properties.getProperty("recoverySleepTime");
        if (string != null) {
            return Long.parseLong(string);
        }
        return -1L;
    }

    public void setLocalLoopbackDisabled(boolean bl) {
        this.properties.setProperty("localLoopbackDisabled", String.valueOf(bl));
    }

    public boolean getLocalLoopbackDisabled(boolean bl) {
        String string = this.properties.getProperty("localLoopbackDisabled");
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    @Deprecated
    public int getMcastPort() {
        return this.getPort();
    }

    public int getPort() {
        String string = this.properties.getProperty("mcastPort");
        return Integer.parseInt(string);
    }

    @Deprecated
    public void setMcastFrequency(long l) {
        this.setFrequency(l);
    }

    public void setFrequency(long l) {
        this.properties.setProperty("mcastFrequency", String.valueOf(l));
    }

    @Deprecated
    public long getMcastFrequency() {
        return this.getFrequency();
    }

    public long getFrequency() {
        String string = this.properties.getProperty("mcastFrequency");
        return Long.parseLong(string);
    }

    public void setMcastDropTime(long l) {
        this.setDropTime(l);
    }

    public void setDropTime(long l) {
        this.properties.setProperty("memberDropTime", String.valueOf(l));
    }

    @Deprecated
    public long getMcastDropTime() {
        return this.getDropTime();
    }

    public long getDropTime() {
        String string = this.properties.getProperty("memberDropTime");
        return Long.parseLong(string);
    }

    protected void hasProperty(Properties properties, String string) {
        if (properties.getProperty(string) == null) {
            throw new IllegalArgumentException("McastService:Required property \"" + string + "\" is missing.");
        }
    }

    @Override
    public void start() throws Exception {
        this.start(4);
        this.start(8);
    }

    @Override
    public void start(int n) throws Exception {
        this.hasProperty(this.properties, "mcastPort");
        this.hasProperty(this.properties, "mcastAddress");
        this.hasProperty(this.properties, "memberDropTime");
        this.hasProperty(this.properties, "mcastFrequency");
        this.hasProperty(this.properties, "tcpListenPort");
        this.hasProperty(this.properties, "tcpListenHost");
        this.hasProperty(this.properties, "tcpSecurePort");
        this.hasProperty(this.properties, "udpListenPort");
        if (this.impl != null) {
            this.impl.start(n);
            return;
        }
        String string = this.getProperties().getProperty("tcpListenHost");
        int n2 = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        int n3 = Integer.parseInt(this.getProperties().getProperty("tcpSecurePort"));
        int n4 = Integer.parseInt(this.getProperties().getProperty("udpListenPort"));
        if (this.localMember == null) {
            this.localMember = new MemberImpl(string, n2, 100L);
            this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
            this.localMember.setLocal(true);
        } else {
            this.localMember.setHostname(string);
            this.localMember.setPort(n2);
            this.localMember.setMemberAliveTime(100L);
        }
        this.localMember.setSecurePort(n3);
        this.localMember.setUdpPort(n4);
        if (this.payload != null) {
            this.localMember.setPayload(this.payload);
        }
        if (this.domain != null) {
            this.localMember.setDomain(this.domain);
        }
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        InetAddress inetAddress = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            inetAddress = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int n5 = -1;
        int n6 = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                n5 = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception exception) {
                log.error((Object)("Unable to parse mcastTTL=" + this.properties.getProperty("mcastTTL")), (Throwable)exception);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                n6 = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception exception) {
                log.error((Object)("Unable to parse mcastSoTimeout=" + this.properties.getProperty("mcastSoTimeout")), (Throwable)exception);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("mcastFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), inetAddress, InetAddress.getByName(this.properties.getProperty("mcastAddress")), n5, n6, this, this, Boolean.parseBoolean(this.properties.getProperty("localLoopbackDisabled")));
        String string2 = this.properties.getProperty("recoveryEnabled");
        boolean bl = Boolean.parseBoolean(string2);
        this.impl.setRecoveryEnabled(bl);
        int n7 = Integer.parseInt(this.properties.getProperty("recoveryCounter"));
        this.impl.setRecoveryCounter(n7);
        long l = Long.parseLong(this.properties.getProperty("recoverySleepTime"));
        this.impl.setRecoverySleepTime(l);
        this.impl.setChannel(this.channel);
        this.impl.start(n);
    }

    @Override
    public void stop(int n) {
        try {
            if (this.impl != null && this.impl.stop(n)) {
                this.impl.setChannel(null);
                this.impl = null;
                this.channel = null;
            }
        }
        catch (Exception exception) {
            log.error((Object)("Unable to stop the mcast service, level:" + n + "."), (Throwable)exception);
        }
    }

    @Override
    public String[] getMembersByName() {
        String[] stringArray;
        Member[] memberArray = this.getMembers();
        if (memberArray != null) {
            stringArray = new String[memberArray.length];
            for (int i = 0; i < memberArray.length; ++i) {
                stringArray[i] = memberArray[i].toString();
            }
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @Override
    public Member findMemberByName(String string) {
        Member[] memberArray = this.getMembers();
        for (int i = 0; i < memberArray.length; ++i) {
            if (!string.equals(memberArray[i].toString())) continue;
            return memberArray[i];
        }
        return null;
    }

    @Override
    public boolean hasMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return false;
        }
        return this.impl.membership.hasMembers();
    }

    @Override
    public Member getMember(Member member) {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMember(member);
    }

    @Override
    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return EMPTY_MEMBERS;
        }
        return this.impl.membership.getMembers();
    }

    @Override
    public void setMembershipListener(MembershipListener membershipListener) {
        this.listener = membershipListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.msglistener = messageListener;
    }

    public void removeMessageListener() {
        this.msglistener = null;
    }

    @Override
    public void removeMembershipListener() {
        this.listener = null;
    }

    @Override
    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (this.msglistener != null && this.msglistener.accept(channelMessage)) {
            this.msglistener.messageReceived(channelMessage);
        }
    }

    @Override
    public boolean accept(ChannelMessage channelMessage) {
        return true;
    }

    @Override
    public void broadcast(ChannelMessage channelMessage) throws ChannelException {
        if (this.impl == null || (this.impl.startLevel & 8) != 8) {
            throw new ChannelException("Multicast send is not started or enabled.");
        }
        byte[] byArray = XByteBuffer.createDataPackage((ChannelData)channelMessage);
        if (byArray.length > McastServiceImpl.MAX_PACKET_SIZE) {
            throw new ChannelException("Packet length[" + byArray.length + "] exceeds max packet size of " + McastServiceImpl.MAX_PACKET_SIZE + " bytes.");
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, byArray.length);
        try {
            this.impl.send(false, datagramPacket);
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    @Deprecated
    public int getMcastSoTimeout() {
        return this.getSoTimeout();
    }

    public int getSoTimeout() {
        return this.mcastSoTimeout;
    }

    @Deprecated
    public void setMcastSoTimeout(int n) {
        this.setSoTimeout(n);
    }

    public void setSoTimeout(int n) {
        this.mcastSoTimeout = n;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(n));
    }

    @Deprecated
    public int getMcastTTL() {
        return this.getTtl();
    }

    public int getTtl() {
        return this.mcastTTL;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getDomain() {
        return this.domain;
    }

    @Deprecated
    public void setMcastTTL(int n) {
        this.setTtl(n);
    }

    public void setTtl(int n) {
        this.mcastTTL = n;
        this.properties.setProperty("mcastTTL", String.valueOf(n));
    }

    @Override
    public void setPayload(byte[] byArray) {
        this.payload = byArray;
        if (this.localMember != null) {
            this.localMember.setPayload(byArray);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Unable to send payload update.", (Throwable)exception);
            }
        }
    }

    @Override
    public void setDomain(byte[] byArray) {
        this.domain = byArray;
        if (this.localMember != null) {
            this.localMember.setDomain(byArray);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception exception) {
                log.error((Object)"Unable to send domain update.", (Throwable)exception);
            }
        }
    }

    public void setDomain(String string) {
        if (string == null) {
            return;
        }
        if (string.startsWith("{")) {
            this.setDomain(Arrays.fromString(string));
        } else {
            this.setDomain(Arrays.convert(string));
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    protected void setDefaults(Properties properties) {
        if (properties.getProperty("mcastPort") == null) {
            properties.setProperty("mcastPort", "45564");
        }
        if (properties.getProperty("mcastAddress") == null) {
            properties.setProperty("mcastAddress", "228.0.0.4");
        }
        if (properties.getProperty("memberDropTime") == null) {
            properties.setProperty("memberDropTime", "3000");
        }
        if (properties.getProperty("mcastFrequency") == null) {
            properties.setProperty("mcastFrequency", "500");
        }
        if (properties.getProperty("recoveryCounter") == null) {
            properties.setProperty("recoveryCounter", "10");
        }
        if (properties.getProperty("recoveryEnabled") == null) {
            properties.setProperty("recoveryEnabled", "true");
        }
        if (properties.getProperty("recoverySleepTime") == null) {
            properties.setProperty("recoverySleepTime", "5000");
        }
        if (properties.getProperty("localLoopbackDisabled") == null) {
            properties.setProperty("localLoopbackDisabled", "false");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Usage McastService hostname tcpport");
        }
        McastService mcastService = new McastService();
        Properties properties = new Properties();
        properties.setProperty("mcastPort", "5555");
        properties.setProperty("mcastAddress", "224.10.10.10");
        properties.setProperty("mcastClusterDomain", "catalina");
        properties.setProperty("bindAddress", "localhost");
        properties.setProperty("memberDropTime", "3000");
        properties.setProperty("mcastFrequency", "500");
        properties.setProperty("tcpListenPort", "4000");
        properties.setProperty("tcpListenHost", "127.0.0.1");
        properties.setProperty("tcpSecurePort", "4100");
        properties.setProperty("udpListenPort", "4200");
        mcastService.setProperties(properties);
        mcastService.start();
        Thread.sleep(3600000L);
    }
}

