/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.websocket.WebSocketContainer;

public abstract class ContainerProvider {
    private static final String DEFAULT_PROVIDER_CLASS_NAME = "org.apache.tomcat.websocket.WsWebSocketContainer";

    public static WebSocketContainer getWebSocketContainer() {
        WebSocketContainer webSocketContainer = null;
        ServiceLoader<ContainerProvider> serviceLoader = ServiceLoader.load(ContainerProvider.class);
        Iterator<ContainerProvider> iterator = serviceLoader.iterator();
        while (webSocketContainer == null && iterator.hasNext()) {
            webSocketContainer = iterator.next().getContainer();
        }
        if (webSocketContainer == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_PROVIDER_CLASS_NAME);
                webSocketContainer = (WebSocketContainer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return webSocketContainer;
    }

    protected abstract WebSocketContainer getContainer();
}

