/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.HeaderUtil;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractInputBuffer<S>
implements InputBuffer {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected Request request;
    protected MimeHeaders headers;
    protected boolean parsingHeader;
    protected boolean swallowInput;
    protected byte[] buf;
    protected int lastValid;
    protected int pos;
    protected int end;
    protected InputBuffer inputStreamInputBuffer;
    protected InputFilter[] filterLibrary;
    protected InputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected boolean rejectIllegalHeaderName;
    protected HttpParser httpParser;
    protected byte prevChr = 0;
    protected byte chr = 0;

    public void addFilter(InputFilter inputFilter) {
        InputFilter[] inputFilterArray = new InputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            inputFilterArray[i] = this.filterLibrary[i];
        }
        inputFilterArray[this.filterLibrary.length] = inputFilter;
        this.filterLibrary = inputFilterArray;
        this.activeFilters = new InputFilter[this.filterLibrary.length];
    }

    public InputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(InputFilter inputFilter) {
        if (this.lastActiveFilter == -1) {
            inputFilter.setBuffer(this.inputStreamInputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != inputFilter) continue;
                return;
            }
            inputFilter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = inputFilter;
        inputFilter.setRequest(this.request);
    }

    public void setSwallowInput(boolean bl) {
        this.swallowInput = bl;
    }

    protected String parseInvalid(int n, byte[] byArray) {
        int n2;
        for (n2 = n; n2 < this.lastValid && byArray[n2] != 32; ++n2) {
        }
        String string = HeaderUtil.toPrintableString(byArray, n, n2 - n);
        if (n2 == this.lastValid) {
            string = string + "...";
        }
        return string;
    }

    public abstract boolean parseRequestLine(boolean var1) throws IOException;

    public abstract boolean parseHeaders() throws IOException;

    protected abstract boolean fill(boolean var1) throws IOException;

    protected abstract void init(SocketWrapper<S> var1, AbstractEndpoint<S> var2) throws IOException;

    public void recycle() {
        this.request.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.prevChr = 0;
        this.chr = 0;
        this.lastValid = 0;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void nextRequest() {
        this.request.recycle();
        if (this.lastValid - this.pos > 0 && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.lastValid - this.pos);
        }
        this.lastValid -= this.pos;
        this.pos = 0;
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.swallowInput = true;
    }

    public void endRequest() throws IOException {
        if (this.swallowInput && this.lastActiveFilter != -1) {
            int n = (int)this.activeFilters[this.lastActiveFilter].end();
            this.pos -= n;
        }
    }

    @Override
    public int available() {
        int n = this.lastValid - this.pos;
        if (n == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; n == 0 && i <= this.lastActiveFilter; ++i) {
                n = this.activeFilters[i].available();
            }
        }
        return n;
    }

    @Override
    public int doRead(ByteChunk byteChunk, Request request) throws IOException {
        if (this.lastActiveFilter == -1) {
            return this.inputStreamInputBuffer.doRead(byteChunk, request);
        }
        return this.activeFilters[this.lastActiveFilter].doRead(byteChunk, request);
    }
}

