/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HeaderUtil;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalNioInputBuffer
extends AbstractInputBuffer<NioChannel> {
    private static final Log log = LogFactory.getLog(InternalNioInputBuffer.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private boolean parsingRequestLine;
    private int parsingRequestLinePhase = 0;
    private boolean parsingRequestLineEol = false;
    private int parsingRequestLineStart = 0;
    private int parsingRequestLineQPos = -1;
    private HeaderParsePosition headerParsePos;
    private NioChannel socket;
    private NioSelectorPool pool;
    private final int headerBufferSize;
    private int socketReadBufferSize;
    private HeaderParseData headerData = new HeaderParseData();

    public InternalNioInputBuffer(Request request, int n, boolean bl, HttpParser httpParser) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.headerBufferSize = n;
        this.rejectIllegalHeaderName = bl;
        this.httpParser = httpParser;
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.socket = null;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    @Override
    public boolean parseRequestLine(boolean bl) throws IOException {
        int n;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase == 0) {
            do {
                if (this.pos >= this.lastValid) {
                    if (bl) {
                        return false;
                    }
                    if (!this.fill(true, false)) {
                        return false;
                    }
                }
                if (this.request.getStartTime() < 0L) {
                    this.request.setStartTime(System.currentTimeMillis());
                }
                this.chr = this.buf[this.pos++];
            } while (this.chr == 13 || this.chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received [" + new String(this.buf, this.pos, this.lastValid - this.pos, DEFAULT_CHARSET) + "]"));
            }
        }
        if (this.parsingRequestLinePhase == 2) {
            n = 0;
            while (n == 0) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    n = 1;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                } else if (!HttpParser.isToken(this.buf[this.pos])) {
                    String string = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidmethod", new Object[]{string}));
                }
                ++this.pos;
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            n = 1;
            while (n != 0) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                n = 0;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            n = 0;
            boolean bl2 = false;
            while (!bl2) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] != 10) {
                    this.request.protocol().setString("HTTP/1.1");
                    String string = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                    throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    bl2 = true;
                    n = this.pos;
                } else if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos] == 10) {
                        bl2 = true;
                        this.request.protocol().setString("");
                        this.parsingRequestLinePhase = 7;
                        n = this.buf[this.pos - 1] == 13 ? this.pos - 1 : this.pos;
                    } else if (this.buf[this.pos] == 63 && this.parsingRequestLineQPos == -1) {
                        this.parsingRequestLineQPos = this.pos;
                    } else {
                        if (this.parsingRequestLineQPos != -1 && !this.httpParser.isQueryRelaxed(this.buf[this.pos])) {
                            String string = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                            throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                        }
                        if (this.httpParser.isNotRequestTargetRelaxed(this.buf[this.pos])) {
                            String string = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                            throw new IllegalArgumentException(sm.getString("iib.invalidRequestTarget", new Object[]{string}));
                        }
                    }
                }
                ++this.pos;
            }
            this.request.unparsedURI().setBytes(this.buf, this.parsingRequestLineStart, n - this.parsingRequestLineStart);
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, n - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, n - this.parsingRequestLineStart);
            }
            if (this.parsingRequestLinePhase == 4) {
                this.parsingRequestLinePhase = 5;
            }
        }
        if (this.parsingRequestLinePhase == 5) {
            n = 1;
            while (n != 0) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                n = 0;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 6;
            this.end = 0;
        }
        if (this.parsingRequestLinePhase == 6) {
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] != 13) {
                    if (this.buf[this.pos - 1] == 13 && this.buf[this.pos] == 10) {
                        this.end = this.pos - 1;
                        this.parsingRequestLineEol = true;
                    } else if (!HttpParser.isHttpProtocol(this.buf[this.pos])) {
                        String string = this.parseInvalid(this.parsingRequestLineStart, this.buf);
                        throw new IllegalArgumentException(sm.getString("iib.invalidHttpProtocol", new Object[]{string}));
                    }
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
                this.parsingRequestLinePhase = 7;
            }
        }
        if (this.parsingRequestLinePhase == 7) {
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException(sm.getString("iib.invalidPhase", new Object[]{this.parsingRequestLinePhase}));
    }

    private void expand(int n) {
        if (n > this.buf.length) {
            if (this.parsingHeader) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            log.warn((Object)("Expanding buffer size. Old size: " + this.buf.length + ", new size: " + n), (Throwable)new Exception());
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(boolean bl, boolean bl2) throws IOException {
        int n = 0;
        this.socket.getBufHandler().getReadBuffer().clear();
        if (bl2) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.socket.getAttachment();
                if (keyAttachment == null) {
                    throw new IOException("Key must be cancelled.");
                }
                n = this.pool.read(this.socket.getBufHandler().getReadBuffer(), this.socket, selector, keyAttachment.getTimeout());
            }
            catch (EOFException eOFException) {
                n = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            n = this.socket.read(this.socket.getBufHandler().getReadBuffer());
        }
        if (n > 0) {
            this.socket.getBufHandler().getReadBuffer().flip();
            this.socket.getBufHandler().getReadBuffer().limit(n);
            this.expand(n + this.pos);
            this.socket.getBufHandler().getReadBuffer().get(this.buf, this.pos, n);
            this.lastValid = this.pos + n;
            return n;
        }
        if (n == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }

    @Override
    public boolean parseHeaders() throws IOException {
        if (!this.parsingHeader) {
            throw new IllegalStateException(sm.getString("iib.parseheaders.ise.error"));
        }
        HeaderParseStatus headerParseStatus = HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            headerParseStatus = this.parseHeader();
            if (this.pos <= this.headerBufferSize && this.buf.length - this.pos >= this.socketReadBufferSize) continue;
            throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
        } while (headerParseStatus == HeaderParseStatus.HAVE_MORE_HEADERS);
        if (headerParseStatus == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    private HeaderParseStatus parseHeader() throws IOException {
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13 || this.prevChr == 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    ++this.pos;
                    return HeaderParseStatus.DONE;
                }
                if (this.prevChr != 13) break;
                --this.pos;
                break;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.lineStart = this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.chr = this.buf[this.pos];
            if (this.chr == 58) {
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, this.pos - this.headerData.start);
                ++this.pos;
                this.headerData.start = this.pos;
                this.headerData.realPos = this.pos;
                this.headerData.lastSignificantChar = this.pos;
                break;
            }
            if (!HttpParser.isToken(this.chr)) {
                this.headerData.lastSignificantChar = this.pos;
                return this.skipLine();
            }
            if (this.chr >= 65 && this.chr <= 90) {
                this.buf[this.pos] = (byte)(this.chr - -32);
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine();
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            byte by;
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                while (true) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.chr = this.buf[this.pos];
                    if (this.chr != 32 && this.chr != 9) break;
                    ++this.pos;
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                by = 0;
                while (by == 0) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.prevChr = this.chr;
                    this.chr = this.buf[this.pos];
                    if (this.chr != 13) {
                        if (this.prevChr == 13 && this.chr == 10) {
                            by = 1;
                        } else {
                            if (this.prevChr == 13) {
                                this.headers.removeHeader(this.headers.size() - 1);
                                return this.skipLine();
                            }
                            if (this.chr != 9 && HttpParser.isControl(this.chr)) {
                                this.headers.removeHeader(this.headers.size() - 1);
                                return this.skipLine();
                            }
                            if (this.chr == 32 || this.chr == 9) {
                                this.buf[this.headerData.realPos] = this.chr;
                                ++this.headerData.realPos;
                            } else {
                                this.buf[this.headerData.realPos] = this.chr;
                                this.headerData.lastSignificantChar = ++this.headerData.realPos;
                            }
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            by = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (by != 32 && by != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.buf[this.headerData.realPos] = by;
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    public int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    private HeaderParseStatus skipLine() throws IOException {
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean bl = false;
        while (!bl) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.prevChr = this.chr;
            this.chr = this.buf[this.pos];
            if (this.chr != 13) {
                if (this.prevChr == 13 && this.chr == 10) {
                    bl = true;
                } else {
                    this.headerData.lastSignificantChar = this.pos;
                }
            }
            ++this.pos;
        }
        if (this.rejectIllegalHeaderName || log.isDebugEnabled()) {
            String string = sm.getString("iib.invalidheader", new Object[]{HeaderUtil.toPrintableString(this.buf, this.headerData.lineStart, this.headerData.lastSignificantChar - this.headerData.lineStart + 1)});
            if (this.rejectIllegalHeaderName) {
                throw new IllegalArgumentException(string);
            }
            log.debug((Object)string);
        }
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    @Override
    protected void init(SocketWrapper<NioChannel> socketWrapper, AbstractEndpoint<NioChannel> abstractEndpoint) throws IOException {
        this.socket = socketWrapper.getSocket();
        this.socketReadBufferSize = this.socket.getBufHandler().getReadBuffer().capacity();
        int n = this.headerBufferSize + this.socketReadBufferSize;
        if (this.buf == null || this.buf.length < n) {
            this.buf = new byte[n];
        }
        this.pool = ((NioEndpoint)abstractEndpoint).getSelectorPool();
    }

    @Override
    protected boolean fill(boolean bl) throws IOException, EOFException {
        return this.fill(true, bl);
    }

    protected boolean fill(boolean bl, boolean bl2) throws IOException, EOFException {
        boolean bl3 = false;
        if (this.parsingHeader) {
            if (this.lastValid > this.headerBufferSize) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            bl3 = this.readSocket(bl, bl2) > 0;
        } else {
            this.lastValid = this.pos = this.end;
            bl3 = this.readSocket(bl, bl2) > 0;
        }
        return bl3;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk byteChunk, Request request) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid && !InternalNioInputBuffer.this.fill(true, true)) {
                return -1;
            }
            int n = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            byteChunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, n);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return n;
        }

        @Override
        public int available() {
            if (InternalNioInputBuffer.this.lastValid > InternalNioInputBuffer.this.pos) {
                return InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            }
            return 0;
        }
    }

    public static class HeaderParseData {
        int lineStart = 0;
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        public void recycle() {
            this.lineStart = 0;
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

