/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;

public class IdentityOutputFilter
implements OutputFilter {
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected OutputBuffer buffer;

    @Override
    public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
        int n = -1;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                n = byteChunk.getLength();
                if ((long)n > this.remaining) {
                    byteChunk.setBytes(byteChunk.getBytes(), byteChunk.getStart(), (int)this.remaining);
                    n = (int)this.remaining;
                    this.remaining = 0L;
                } else {
                    this.remaining -= (long)n;
                }
                this.buffer.doWrite(byteChunk, response);
            } else {
                byteChunk.recycle();
                n = -1;
            }
        } else {
            this.buffer.doWrite(byteChunk, response);
            n = byteChunk.getLength();
        }
        return n;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
        this.remaining = this.contentLength = response.getContentLengthLong();
    }

    @Override
    public void setBuffer(OutputBuffer outputBuffer) {
        this.buffer = outputBuffer;
    }

    @Override
    public long end() throws IOException {
        if (this.remaining > 0L) {
            return this.remaining;
        }
        return 0L;
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }
}

