/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.tomcat.util.buf.B2CConverter;

public class Utf8Decoder
extends CharsetDecoder {
    private static final int[] remainingBytes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] remainingNumbers = new int[]{0, 4224, 401536, 29892736};
    private static final int[] lowerEncodingLimit = new int[]{-1, 128, 2048, 65536};

    public Utf8Decoder() {
        super(B2CConverter.UTF_8, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.decodeHasArray(byteBuffer, charBuffer);
        }
        return this.decodeNotHasArray(byteBuffer, charBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeNotHasArray(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        int n2 = charBuffer.remaining();
        int n3 = byteBuffer.limit();
        try {
            for (n = byteBuffer.position(); n < n3; ++n) {
                if (n2 == 0) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                int n4 = byteBuffer.get();
                if (n4 < 0) {
                    int n5 = remainingBytes[n4 &= 0x7F];
                    if (n5 == -1) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (n3 - n < 1 + n5) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    for (int i = 0; i < n5; ++i) {
                        int n6 = byteBuffer.get() & 0xFF;
                        if ((n6 & 0xC0) != 128) {
                            CoderResult coderResult = CoderResult.malformedForLength(1 + i);
                            return coderResult;
                        }
                        n4 = (n4 << 6) + n6;
                    }
                    if ((n4 -= remainingNumbers[n5]) < lowerEncodingLimit[n5]) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    n += n5;
                }
                if (n4 >= 55296 && n4 <= 57343) {
                    CoderResult coderResult = CoderResult.unmappableForLength(3);
                    return coderResult;
                }
                if (n4 > 0x10FFFF) {
                    CoderResult coderResult = CoderResult.unmappableForLength(4);
                    return coderResult;
                }
                if (n4 <= 65535) {
                    charBuffer.put((char)n4);
                    --n2;
                    continue;
                }
                if (n2 < 2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                charBuffer.put((char)((n4 >> 10) + 55232));
                charBuffer.put((char)((n4 & 0x3FF) + 56320));
                n2 -= 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    private CoderResult decodeHasArray(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        int n2 = charBuffer.remaining();
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        byte[] byArray = byteBuffer.array();
        char[] cArray = charBuffer.array();
        int n5 = n4 + byteBuffer.arrayOffset();
        int n6 = charBuffer.position() + charBuffer.arrayOffset();
        for (n = n3 + byteBuffer.arrayOffset(); n < n5 && n2 > 0; ++n) {
            int n7 = byArray[n];
            if (n7 < 0) {
                int n8 = remainingBytes[n7 &= 0x7F];
                if (n8 == -1) {
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    charBuffer.position(n6 - charBuffer.arrayOffset());
                    return CoderResult.malformedForLength(1);
                }
                int n9 = n5 - n - 1;
                if (n9 > 0) {
                    if (n7 > 65 && n7 < 96 && (byArray[n + 1] & 0xC0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 == 96 && (byArray[n + 1] & 0xE0) != 160) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 > 96 && n7 < 109 && (byArray[n + 1] & 0xC0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 == 109 && (byArray[n + 1] & 0xE0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 > 109 && n7 < 112 && (byArray[n + 1] & 0xC0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 == 112 && ((byArray[n + 1] & 0xFF) < 144 || (byArray[n + 1] & 0xFF) > 191)) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 > 112 && n7 < 116 && (byArray[n + 1] & 0xC0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                    if (n7 == 116 && (byArray[n + 1] & 0xF0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1);
                    }
                }
                if (n9 > 1 && n8 > 1 && (byArray[n + 2] & 0xC0) != 128) {
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    charBuffer.position(n6 - charBuffer.arrayOffset());
                    return CoderResult.malformedForLength(2);
                }
                if (n9 > 2 && n8 > 2 && (byArray[n + 3] & 0xC0) != 128) {
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    charBuffer.position(n6 - charBuffer.arrayOffset());
                    return CoderResult.malformedForLength(3);
                }
                if (n9 < n8) break;
                for (int i = 0; i < n8; ++i) {
                    int n10 = byArray[n + i + 1] & 0xFF;
                    if ((n10 & 0xC0) != 128) {
                        byteBuffer.position(n - byteBuffer.arrayOffset());
                        charBuffer.position(n6 - charBuffer.arrayOffset());
                        return CoderResult.malformedForLength(1 + i);
                    }
                    n7 = (n7 << 6) + n10;
                }
                if ((n7 -= remainingNumbers[n8]) < lowerEncodingLimit[n8]) {
                    byteBuffer.position(n - byteBuffer.arrayOffset());
                    charBuffer.position(n6 - charBuffer.arrayOffset());
                    return CoderResult.malformedForLength(1);
                }
                n += n8;
            }
            if (n7 >= 55296 && n7 <= 57343) {
                return CoderResult.unmappableForLength(3);
            }
            if (n7 > 0x10FFFF) {
                return CoderResult.unmappableForLength(4);
            }
            if (n7 <= 65535) {
                cArray[n6++] = (char)n7;
                --n2;
                continue;
            }
            if (n2 < 2) {
                byteBuffer.position((n -= 3) - byteBuffer.arrayOffset());
                charBuffer.position(n6 - charBuffer.arrayOffset());
                return CoderResult.OVERFLOW;
            }
            cArray[n6++] = (char)((n7 >> 10) + 55232);
            cArray[n6++] = (char)((n7 & 0x3FF) + 56320);
            n2 -= 2;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n6 - charBuffer.arrayOffset());
        return n2 == 0 && n < n5 ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
    }
}

