/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.ArrayList;
import java.util.List;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.Rules;

public class WithDefaultsRulesWrapper
implements Rules {
    private Rules wrappedRules;
    private List<Rule> defaultRules = new ArrayList<Rule>();
    private List<Rule> allRules = new ArrayList<Rule>();

    public WithDefaultsRulesWrapper(Rules rules) {
        if (rules == null) {
            throw new IllegalArgumentException("Wrapped rules must not be null");
        }
        this.wrappedRules = rules;
    }

    @Override
    public Digester getDigester() {
        return this.wrappedRules.getDigester();
    }

    @Override
    public void setDigester(Digester digester) {
        this.wrappedRules.setDigester(digester);
        for (Rule rule : this.defaultRules) {
            rule.setDigester(digester);
        }
    }

    @Override
    public String getNamespaceURI() {
        return this.wrappedRules.getNamespaceURI();
    }

    @Override
    public void setNamespaceURI(String string) {
        this.wrappedRules.setNamespaceURI(string);
    }

    public List<Rule> getDefaults() {
        return this.defaultRules;
    }

    @Override
    public List<Rule> match(String string, String string2) {
        List<Rule> list = this.wrappedRules.match(string, string2);
        if (list == null || list.isEmpty()) {
            return new ArrayList<Rule>(this.defaultRules);
        }
        return list;
    }

    public void addDefault(Rule rule) {
        if (this.wrappedRules.getDigester() != null) {
            rule.setDigester(this.wrappedRules.getDigester());
        }
        if (this.wrappedRules.getNamespaceURI() != null) {
            rule.setNamespaceURI(this.wrappedRules.getNamespaceURI());
        }
        this.defaultRules.add(rule);
        this.allRules.add(rule);
    }

    @Override
    public List<Rule> rules() {
        return this.allRules;
    }

    @Override
    public void clear() {
        this.wrappedRules.clear();
        this.allRules.clear();
        this.defaultRules.clear();
    }

    @Override
    public void add(String string, Rule rule) {
        this.wrappedRules.add(string, rule);
        this.allRules.add(rule);
    }
}

