/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardEngineValve;
import org.apache.catalina.realm.NullRealm;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StandardEngine
extends ContainerBase
implements Engine {
    private static final Log log = LogFactory.getLog(StandardEngine.class);
    private String defaultHost = null;
    private static final String info = "org.apache.catalina.core.StandardEngine/1.0";
    private Service service = null;
    private String baseDir = null;
    private String jvmRouteId;
    private final AtomicReference<AccessLog> defaultAccessLog = new AtomicReference();

    public StandardEngine() {
        this.pipeline.setBasic(new StandardEngineValve());
        try {
            this.setJvmRoute(System.getProperty("jvmRoute"));
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("standardEngine.jvmRouteFail"));
        }
        this.backgroundProcessorDelay = 10;
    }

    @Override
    public Realm getRealm() {
        Realm realm = super.getRealm();
        if (realm == null) {
            realm = new NullRealm();
            this.setRealm(realm);
        }
        return realm;
    }

    @Override
    public String getDefaultHost() {
        return this.defaultHost;
    }

    @Override
    public void setDefaultHost(String string) {
        String string2 = this.defaultHost;
        this.defaultHost = string == null ? null : string.toLowerCase(Locale.ENGLISH);
        this.support.firePropertyChange("defaultHost", string2, this.defaultHost);
    }

    @Override
    public void setJvmRoute(String string) {
        this.jvmRouteId = string;
    }

    @Override
    public String getJvmRoute() {
        return this.jvmRouteId;
    }

    @Override
    public Service getService() {
        return this.service;
    }

    @Override
    public void setService(Service service) {
        this.service = service;
    }

    public String getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.base");
        }
        if (this.baseDir == null) {
            this.baseDir = System.getProperty("catalina.home");
        }
        return this.baseDir;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    @Override
    public void addChild(Container container) {
        if (!(container instanceof Host)) {
            throw new IllegalArgumentException(sm.getString("standardEngine.notHost"));
        }
        super.addChild(container);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setParent(Container container) {
        throw new IllegalArgumentException(sm.getString("standardEngine.notParent"));
    }

    @Override
    protected void initInternal() throws LifecycleException {
        this.getRealm();
        super.initInternal();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Starting Servlet Engine: " + ServerInfo.getServerInfo()));
        }
        super.startInternal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StandardEngine[");
        stringBuilder.append(this.getName());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void logAccess(Request request, Response response, long l, boolean bl) {
        boolean bl2 = false;
        if (this.getAccessLog() != null) {
            this.accessLog.log(request, response, l);
            bl2 = true;
        }
        if (!bl2 && bl) {
            AccessLog accessLog = this.defaultAccessLog.get();
            if (accessLog == null) {
                AccessLogListener accessLogListener;
                Host host = (Host)this.findChild(this.getDefaultHost());
                Context context = null;
                if (host != null && host.getState().isAvailable()) {
                    accessLog = host.getAccessLog();
                    if (accessLog != null) {
                        if (this.defaultAccessLog.compareAndSet(null, accessLog)) {
                            accessLogListener = new AccessLogListener(this, host, null);
                            accessLogListener.install();
                        }
                    } else {
                        context = (Context)host.findChild("");
                        if (context != null && context.getState().isAvailable() && (accessLog = context.getAccessLog()) != null && this.defaultAccessLog.compareAndSet(null, accessLog)) {
                            accessLogListener = new AccessLogListener(this, null, context);
                            accessLogListener.install();
                        }
                    }
                }
                if (accessLog == null && this.defaultAccessLog.compareAndSet(null, accessLog = new NoopAccessLog())) {
                    accessLogListener = new AccessLogListener(this, host, context);
                    accessLogListener.install();
                }
            }
            accessLog.log(request, response, l);
        }
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.service != null) {
            return this.service.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Engine";
    }

    protected static final class AccessLogListener
    implements PropertyChangeListener,
    LifecycleListener,
    ContainerListener {
        private StandardEngine engine;
        private Host host;
        private Context context;
        private volatile boolean disabled = false;

        public AccessLogListener(StandardEngine standardEngine, Host host, Context context) {
            this.engine = standardEngine;
            this.host = host;
            this.context = context;
        }

        public void install() {
            this.engine.addPropertyChangeListener(this);
            if (this.host != null) {
                this.host.addContainerListener(this);
                this.host.addLifecycleListener(this);
            }
            if (this.context != null) {
                this.context.addLifecycleListener(this);
            }
        }

        private void uninstall() {
            this.disabled = true;
            if (this.context != null) {
                this.context.removeLifecycleListener(this);
            }
            if (this.host != null) {
                this.host.removeLifecycleListener(this);
                this.host.removeContainerListener(this);
            }
            this.engine.removePropertyChangeListener(this);
        }

        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if (this.disabled) {
                return;
            }
            String string = lifecycleEvent.getType();
            if ("after_start".equals(string) || "before_stop".equals(string) || "before_destroy".equals(string)) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.disabled) {
                return;
            }
            if ("defaultHost".equals(propertyChangeEvent.getPropertyName())) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }

        @Override
        public void containerEvent(ContainerEvent containerEvent) {
            Context context;
            if (this.disabled) {
                return;
            }
            if ("addChild".equals(containerEvent.getType()) && "".equals((context = (Context)containerEvent.getData()).getPath())) {
                this.engine.defaultAccessLog.set(null);
                this.uninstall();
            }
        }
    }

    protected static final class NoopAccessLog
    implements AccessLog {
        protected NoopAccessLog() {
        }

        @Override
        public void log(Request request, Response response, long l) {
        }

        @Override
        public void setRequestAttributesEnabled(boolean bl) {
        }

        @Override
        public boolean getRequestAttributesEnabled() {
            return false;
        }
    }
}

