/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Stack;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.EncodingDetector;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspDocumentParser;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.TagConstants;
import org.apache.tomcat.Jar;
import org.xml.sax.Attributes;

class ParserController
implements TagConstants {
    private static final String CHARSET = "charset=";
    private final JspCompilationContext ctxt;
    private final Compiler compiler;
    private final ErrorDispatcher err;
    private boolean isXml;
    private final Stack<String> baseDirStack = new Stack();
    private boolean isEncodingSpecifiedInProlog;
    private boolean isBomPresent;
    private int skip;
    private String sourceEnc;
    private boolean isDefaultPageEncoding;
    private boolean isTagFile;
    private boolean directiveOnly;

    public ParserController(JspCompilationContext jspCompilationContext, Compiler compiler) {
        this.ctxt = jspCompilationContext;
        this.compiler = compiler;
        this.err = compiler.getErrorDispatcher();
    }

    public JspCompilationContext getJspCompilationContext() {
        return this.ctxt;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public Node.Nodes parse(String string) throws JasperException, IOException {
        this.isTagFile = this.ctxt.isTagFile();
        this.directiveOnly = false;
        return this.doParse(string, null, this.ctxt.getTagFileJar());
    }

    public Node.Nodes parseDirectives(String string) throws JasperException, IOException {
        this.isTagFile = this.ctxt.isTagFile();
        this.directiveOnly = true;
        return this.doParse(string, null, this.ctxt.getTagFileJar());
    }

    public Node.Nodes parse(String string, Node node, Jar jar) throws JasperException, IOException {
        return this.doParse(string, node, jar);
    }

    public Node.Nodes parseTagFileDirectives(String string, Jar jar) throws JasperException, IOException {
        boolean bl = this.isTagFile;
        boolean bl2 = this.directiveOnly;
        this.isTagFile = true;
        this.directiveOnly = true;
        Node.Nodes nodes = this.doParse(string, null, jar);
        this.directiveOnly = bl2;
        this.isTagFile = bl;
        return nodes;
    }

    private Node.Nodes doParse(String string, Node node, Jar jar) throws FileNotFoundException, JasperException, IOException {
        Object object;
        Node.Nodes nodes = null;
        this.isEncodingSpecifiedInProlog = false;
        this.isBomPresent = false;
        this.isDefaultPageEncoding = false;
        String string2 = this.resolveFileName(string);
        String string3 = this.getJspConfigPageEncoding(string2);
        this.determineSyntaxAndEncoding(string2, jar, string3);
        if (node != null) {
            if (jar == null) {
                this.compiler.getPageInfo().addDependant(string2, this.ctxt.getLastModified(string2));
            } else {
                object = string2.substring(1);
                this.compiler.getPageInfo().addDependant(jar.getURL((String)object), jar.getLastModified((String)object));
            }
        }
        if ((this.isXml && this.isEncodingSpecifiedInProlog || this.isBomPresent) && string3 != null && !string3.equals(this.sourceEnc) && (!string3.startsWith("UTF-16") || !this.sourceEnc.startsWith("UTF-16"))) {
            this.err.jspError("jsp.error.prolog_config_encoding_mismatch", this.sourceEnc, string3);
        }
        if (this.isXml) {
            nodes = JspDocumentParser.parse(this, string2, jar, node, this.isTagFile, this.directiveOnly, this.sourceEnc, string3, this.isEncodingSpecifiedInProlog, this.isBomPresent);
        } else {
            object = JspUtil.getReader(string2, this.sourceEnc, jar, this.ctxt, this.err, this.skip);
            Throwable throwable = null;
            try {
                JspReader jspReader = new JspReader(this.ctxt, string2, (InputStreamReader)object, this.err);
                nodes = Parser.parse(this, jspReader, node, this.isTagFile, this.directiveOnly, jar, this.sourceEnc, string3, this.isDefaultPageEncoding, this.isBomPresent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStreamReader)object).close();
                    }
                }
            }
        }
        this.baseDirStack.pop();
        return nodes;
    }

    private String getJspConfigPageEncoding(String string) {
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(string);
        return jspProperty.getPageEncoding();
    }

    private void determineSyntaxAndEncoding(String string, Jar jar, String string2) throws JasperException, IOException {
        Object object;
        Object object2;
        this.isXml = false;
        boolean bl = false;
        boolean bl2 = false;
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(string);
        if (jspProperty.isXml() != null) {
            this.isXml = JspUtil.booleanValue(jspProperty.isXml());
            bl = true;
        } else if (string.endsWith(".jspx") || string.endsWith(".tagx")) {
            this.isXml = true;
            bl = true;
        }
        if (bl && !this.isXml) {
            this.sourceEnc = string2;
            if (this.sourceEnc != null) {
                return;
            }
            this.sourceEnc = "ISO-8859-1";
        } else {
            object2 = JspUtil.getInputStream(string, jar, this.ctxt);
            Throwable throwable = null;
            try {
                object = new EncodingDetector((InputStream)object2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
            this.sourceEnc = ((EncodingDetector)object).getEncoding();
            this.isEncodingSpecifiedInProlog = ((EncodingDetector)object).isEncodingSpecifiedInProlog();
            this.isBomPresent = ((EncodingDetector)object).getSkip() > 0;
            this.skip = ((EncodingDetector)object).getSkip();
            if (!this.isXml && this.sourceEnc.equals("UTF-8")) {
                this.sourceEnc = "ISO-8859-1";
                bl2 = true;
            }
        }
        if (this.isXml) {
            return;
        }
        object = null;
        try {
            object = new JspReader(this.ctxt, string, this.sourceEnc, jar, this.err);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JasperException(fileNotFoundException);
        }
        object2 = ((JspReader)object).mark();
        if (!bl) {
            ((JspReader)object).reset((Mark)object2);
            if (this.hasJspRoot((JspReader)object)) {
                if (bl2) {
                    this.sourceEnc = "UTF-8";
                }
                this.isXml = true;
                return;
            }
            if (bl2 && this.isBomPresent) {
                this.sourceEnc = "UTF-8";
            }
            this.isXml = false;
        }
        if (!this.isBomPresent) {
            this.sourceEnc = string2;
            if (this.sourceEnc == null) {
                this.sourceEnc = this.getPageEncodingForJspSyntax((JspReader)object, (Mark)object2);
                if (this.sourceEnc == null) {
                    this.sourceEnc = "ISO-8859-1";
                    this.isDefaultPageEncoding = true;
                }
            }
        }
    }

    private String getPageEncodingForJspSyntax(JspReader jspReader, Mark mark) throws JasperException {
        String string = null;
        String string2 = null;
        jspReader.reset(mark);
        while (jspReader.skipUntil("<") != null) {
            if (jspReader.matches("%--")) {
                if (jspReader.skipUntil("--%>") != null) continue;
                break;
            }
            boolean bl = jspReader.matches("%@");
            if (bl) {
                jspReader.skipSpaces();
            } else {
                bl = jspReader.matches("jsp:directive.");
            }
            if (!bl || !jspReader.matches("tag ") && !jspReader.matches("page")) continue;
            jspReader.skipSpaces();
            Attributes attributes = Parser.parseAttributes(this, jspReader);
            string = this.getPageEncodingFromDirective(attributes, "pageEncoding");
            if (string != null) break;
            string = this.getPageEncodingFromDirective(attributes, "contentType");
            if (string == null) continue;
            string2 = string;
        }
        if (string == null) {
            string = string2;
        }
        return string;
    }

    private String getPageEncodingFromDirective(Attributes attributes, String string) {
        int n;
        String string2 = attributes.getValue(string);
        if (string.equals("pageEncoding")) {
            return string2;
        }
        String string3 = string2;
        String string4 = null;
        if (string3 != null && (n = string3.indexOf(CHARSET)) != -1) {
            string4 = string3.substring(n + CHARSET.length());
        }
        return string4;
    }

    private String resolveFileName(String string) {
        String string2 = string.replace('\\', '/');
        boolean bl = string2.startsWith("/");
        string2 = bl ? string2 : this.baseDirStack.peek() + string2;
        String string3 = string2.substring(0, string2.lastIndexOf(47) + 1);
        this.baseDirStack.push(string3);
        return string2;
    }

    private boolean hasJspRoot(JspReader jspReader) {
        String string;
        int n;
        Mark mark = null;
        while ((mark = jspReader.skipUntil("<")) != null && ((n = jspReader.nextChar()) == 33 || n == 63)) {
        }
        if (mark == null) {
            return false;
        }
        Mark mark2 = jspReader.skipUntil(":root");
        if (mark2 == null) {
            return false;
        }
        String string2 = jspReader.getText(mark, mark2).substring(1);
        mark = mark2;
        mark2 = jspReader.skipUntil(">");
        if (mark2 == null) {
            return false;
        }
        String string3 = jspReader.getText(mark, mark2);
        int n2 = string3.indexOf(string = "xmlns:" + string2);
        if (n2 == -1) {
            return false;
        }
        n2 += string.length();
        while (n2 < string3.length() && Character.isWhitespace(string3.charAt(n2))) {
            ++n2;
        }
        if (n2 < string3.length() && string3.charAt(n2) == '=') {
            ++n2;
            while (n2 < string3.length() && Character.isWhitespace(string3.charAt(n2))) {
                ++n2;
            }
            if (n2 < string3.length() && (string3.charAt(n2) == '\"' || string3.charAt(n2) == '\'') && string3.regionMatches(++n2, "http://java.sun.com/JSP/Page", 0, "http://java.sun.com/JSP/Page".length())) {
                return true;
            }
        }
        return false;
    }
}

