/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import sun.nio.fs.LinuxFileSystem;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileStore;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class LinuxFileStore
extends UnixFileStore {
    private volatile boolean xattrChecked;
    private volatile boolean xattrEnabled;

    LinuxFileStore(UnixPath file) throws IOException {
        super(file);
    }

    LinuxFileStore(UnixFileSystem fs, UnixMountEntry entry) throws IOException {
        super(fs, entry);
    }

    @Override
    UnixMountEntry findMountEntry() throws IOException {
        LinuxFileSystem fs = (LinuxFileSystem)this.file().getFileSystem();
        UnixPath path = null;
        try {
            byte[] rp = UnixNativeDispatcher.realpath(this.file());
            path = new UnixPath((UnixFileSystem)fs, rp);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(this.file());
        }
        for (UnixPath parent = path.getParent(); parent != null; parent = parent.getParent()) {
            UnixFileAttributes attrs = null;
            try {
                attrs = UnixFileAttributes.get(parent, true);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(parent);
            }
            if (attrs.dev() != this.dev()) break;
            path = parent;
        }
        byte[] dir = path.asByteArray();
        for (UnixMountEntry entry : fs.getMountEntries("/proc/mounts")) {
            if (!Arrays.equals(dir, entry.dir())) continue;
            return entry;
        }
        throw new IOException("Mount point not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExtendedAttributesEnabled(UnixPath path) {
        try {
            int fd = path.openForAttributeAccess(false);
            try {
                byte[] name = Util.toBytes("user.java");
                LinuxNativeDispatcher.fgetxattr(fd, name, 0L, 0);
                boolean bl = true;
                return bl;
            }
            catch (UnixException e) {
                if (e.errno() != 61) return false;
                boolean bl2 = true;
                return bl2;
            }
            finally {
                UnixNativeDispatcher.close(fd);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        if (type == DosFileAttributeView.class || type == UserDefinedFileAttributeView.class) {
            UnixFileStore.FeatureStatus status = this.checkIfFeaturePresent("user_xattr");
            if (status == UnixFileStore.FeatureStatus.PRESENT) {
                return true;
            }
            if (status == UnixFileStore.FeatureStatus.NOT_PRESENT) {
                return false;
            }
            if (this.entry().hasOption("user_xattr")) {
                return true;
            }
            if (this.entry().fstype().equals("ext3") || this.entry().fstype().equals("ext4")) {
                return false;
            }
            if (!this.xattrChecked) {
                UnixPath dir = new UnixPath(this.file().getFileSystem(), this.entry().dir());
                this.xattrEnabled = this.isExtendedAttributesEnabled(dir);
                this.xattrChecked = true;
            }
            return this.xattrEnabled;
        }
        return super.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        if (name.equals("dos")) {
            return this.supportsFileAttributeView(DosFileAttributeView.class);
        }
        if (name.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return super.supportsFileAttributeView(name);
    }
}

