/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import sun.security.action.GetPropertyAction;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ErrorOKButtonListener;
import sun.security.tools.policytool.FileMenuListener;
import sun.security.tools.policytool.MainWindowListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.StatusOKButtonListener;
import sun.security.tools.policytool.ToolDialog;
import sun.security.tools.policytool.ToolWindowListener;

class ToolWindow
extends JFrame {
    private static final long serialVersionUID = 5682568601210376777L;
    static final KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final Insets TOP_BOTTOM_PADDING = new Insets(15, 0, 15, 0);
    public static final Insets L_TOP_BOTTOM_PADDING = new Insets(5, 10, 15, 0);
    public static final Insets LR_TOP_BOTTOM_PADDING = new Insets(15, 4, 15, 4);
    public static final Insets LR_BOTTOM_PADDING = new Insets(0, 10, 5, 10);
    public static final Insets L_BOTTOM_PADDING = new Insets(0, 10, 5, 0);
    public static final Insets R_BOTTOM_PADDING = new Insets(0, 0, 25, 5);
    public static final Insets R_PADDING = new Insets(0, 0, 0, 5);
    public static final String NEW_POLICY_FILE = "New";
    public static final String OPEN_POLICY_FILE = "Open";
    public static final String SAVE_POLICY_FILE = "Save";
    public static final String SAVE_AS_POLICY_FILE = "Save.As";
    public static final String VIEW_WARNINGS = "View.Warning.Log";
    public static final String QUIT = "Exit";
    public static final String ADD_POLICY_ENTRY = "Add.Policy.Entry";
    public static final String EDIT_POLICY_ENTRY = "Edit.Policy.Entry";
    public static final String REMOVE_POLICY_ENTRY = "Remove.Policy.Entry";
    public static final String EDIT_KEYSTORE = "Edit";
    public static final String ADD_PUBKEY_ALIAS = "Add.Public.Key.Alias";
    public static final String REMOVE_PUBKEY_ALIAS = "Remove.Public.Key.Alias";
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_PANEL = 2;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 3;
    static final int TEXTFIELD_HEIGHT = new JComboBox<E>().getPreferredSize().height;
    private PolicyTool tool;
    private int shortCutModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    @Override
    public Component getComponent(int n) {
        Component component = this.getContentPane().getComponent(n);
        if (component instanceof JScrollPane) {
            component = ((JScrollPane)component).getViewport().getView();
        }
        return component;
    }

    private void initWindow() {
        Object object;
        this.setDefaultCloseOperation(0);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        ToolWindow.configureButton(jMenu, "File");
        ActionListener actionListener = new FileMenuListener(this.tool, this);
        this.addMenuItem(jMenu, NEW_POLICY_FILE, actionListener, "N");
        this.addMenuItem(jMenu, OPEN_POLICY_FILE, actionListener, "O");
        this.addMenuItem(jMenu, SAVE_POLICY_FILE, actionListener, "S");
        this.addMenuItem(jMenu, SAVE_AS_POLICY_FILE, actionListener, null);
        this.addMenuItem(jMenu, VIEW_WARNINGS, actionListener, null);
        this.addMenuItem(jMenu, QUIT, actionListener, null);
        jMenuBar.add(jMenu);
        jMenu = new JMenu();
        ToolWindow.configureButton(jMenu, "KeyStore");
        actionListener = new MainWindowListener(this.tool, this);
        this.addMenuItem(jMenu, EDIT_KEYSTORE, actionListener, null);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(6, 6, 6, 6));
        JLabel jLabel = new JLabel(PolicyTool.getMessage("Policy.File."));
        this.addNewComponent(this, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_TOP_BOTTOM_PADDING);
        JTextField jTextField = new JTextField(50);
        jTextField.setPreferredSize(new Dimension(jTextField.getPreferredSize().width, TEXTFIELD_HEIGHT));
        jTextField.getAccessibleContext().setAccessibleName(PolicyTool.getMessage("Policy.File."));
        jTextField.setEditable(false);
        this.addNewComponent(this, jTextField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_TOP_BOTTOM_PADDING);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JButton jButton = new JButton();
        ToolWindow.configureButton(jButton, ADD_POLICY_ENTRY);
        jButton.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, EDIT_POLICY_ENTRY);
        jButton.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton, 1, 1, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        jButton = new JButton();
        ToolWindow.configureButton(jButton, REMOVE_POLICY_ENTRY);
        jButton.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton, 2, 2, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        this.addNewComponent(this, jPanel, 2, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            string = (String)object + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(string);
            object = new DefaultListModel();
            JList jList = new JList(object);
            jList.setVisibleRowCount(15);
            jList.setSelectionMode(0);
            jList.addMouseListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                for (int i = 0; i < policyEntryArray.length; ++i) {
                    ((DefaultListModel)object).addElement(policyEntryArray[i].headerToString());
                }
            }
            JTextField jTextField2 = (JTextField)this.getComponent(1);
            jTextField2.setText(string);
            this.initPolicyList(jList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JList jList = new JList(new DefaultListModel());
            jList.setVisibleRowCount(15);
            jList.setSelectionMode(0);
            jList.addMouseListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(jList);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            this.tool.warnings.addElement(fileNotFoundException.toString());
        }
        catch (Exception exception) {
            JList jList = new JList(new DefaultListModel());
            jList.setVisibleRowCount(15);
            jList.setSelectionMode(0);
            jList.addMouseListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(jList);
            this.tool.setPolicyFileName(null);
            this.tool.modified = false;
            MessageFormat messageFormat = new MessageFormat(PolicyTool.getMessage("Could.not.open.policy.file.policyFile.e.toString."));
            Object[] objectArray = new Object[]{string, exception.toString()};
            this.displayErrorDialog(null, messageFormat.format(objectArray));
        }
    }

    private void addMenuItem(JMenu jMenu, String string, ActionListener actionListener, String string2) {
        JMenuItem jMenuItem = new JMenuItem();
        ToolWindow.configureButton(jMenuItem, string);
        if (PolicyTool.rb.containsKey(string + ".accelerator")) {
            string2 = PolicyTool.getMessage(string + ".accelerator");
        }
        if (string2 != null && !string2.isEmpty()) {
            KeyStroke keyStroke = string2.length() == 1 ? KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(string2.charAt(0)), this.shortCutModifier) : KeyStroke.getKeyStroke(string2);
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
    }

    static void configureButton(AbstractButton abstractButton, String string) {
        abstractButton.setText(PolicyTool.getMessage(string));
        abstractButton.setActionCommand(string);
        int n = PolicyTool.getMnemonicInt(string);
        if (n > 0) {
            abstractButton.setMnemonic(n);
            abstractButton.setDisplayedMnemonicIndex(PolicyTool.getDisplayedMnemonicIndex(string));
        }
    }

    static void configureLabelFor(JLabel jLabel, JComponent jComponent, String string) {
        jLabel.setText(PolicyTool.getMessage(string));
        jLabel.setLabelFor(jComponent);
        int n = PolicyTool.getMnemonicInt(string);
        if (n > 0) {
            jLabel.setDisplayedMnemonic(n);
            jLabel.setDisplayedMnemonicIndex(PolicyTool.getDisplayedMnemonicIndex(string));
        }
    }

    void addNewComponent(Container container, JComponent jComponent, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, Insets insets) {
        if (container instanceof JFrame) {
            container = ((JFrame)container).getContentPane();
        } else if (container instanceof JDialog) {
            container = ((JDialog)container).getContentPane();
        }
        container.add((Component)jComponent, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
    }

    void addNewComponent(Container container, JComponent jComponent, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.addNewComponent(container, jComponent, n, n2, n3, n4, n5, d, d2, n6, null);
    }

    void initPolicyList(JList jList) {
        JScrollPane jScrollPane = new JScrollPane(jList);
        this.addNewComponent(this, jScrollPane, 3, 0, 3, 2, 1, 1.0, 1.0, 1);
    }

    void replacePolicyList(JList jList) {
        JList jList2 = (JList)this.getComponent(3);
        jList2.setModel(jList.getModel());
    }

    void displayToolWindow(String[] stringArray) {
        this.setTitle(PolicyTool.getMessage("Policy.Tool"));
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this.tool, this));
        this.getContentPane().setLayout(new GridBagLayout());
        this.initWindow();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.getMessage("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
        }
    }

    void displayErrorDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Error"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        this.addNewComponent(toolDialog, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        JButton jButton = new JButton(PolicyTool.getMessage("OK"));
        ErrorOKButtonListener errorOKButtonListener = new ErrorOKButtonListener(toolDialog);
        jButton.addActionListener(errorOKButtonListener);
        this.addNewComponent(toolDialog, jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.getRootPane().registerKeyboardAction(errorOKButtonListener, escKey, 2);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(window);
        toolDialog.setVisible(true);
    }

    void displayErrorDialog(Window window, Throwable throwable) {
        if (throwable instanceof NoDisplayException) {
            return;
        }
        this.displayErrorDialog(window, throwable.toString());
    }

    void displayStatusDialog(Window window, String string) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Status"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(string);
        this.addNewComponent(toolDialog, jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        JButton jButton = new JButton(PolicyTool.getMessage("OK"));
        StatusOKButtonListener statusOKButtonListener = new StatusOKButtonListener(toolDialog);
        jButton.addActionListener(statusOKButtonListener);
        this.addNewComponent(toolDialog, jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.getRootPane().registerKeyboardAction(statusOKButtonListener, escKey, 2);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(window);
        toolDialog.setVisible(true);
    }

    void displayWarningLog(Window window) {
        ToolDialog toolDialog = new ToolDialog(PolicyTool.getMessage("Warning"), this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            jTextArea.append(this.tool.warnings.elementAt(i));
            jTextArea.append(PolicyTool.getMessage("NEWLINE"));
        }
        this.addNewComponent(toolDialog, jTextArea, 0, 0, 0, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        jTextArea.setFocusable(false);
        JButton jButton = new JButton(PolicyTool.getMessage("OK"));
        CancelButtonListener cancelButtonListener = new CancelButtonListener(toolDialog);
        jButton.addActionListener(cancelButtonListener);
        this.addNewComponent(toolDialog, jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.getRootPane().registerKeyboardAction(cancelButtonListener, escKey, 2);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(window);
        toolDialog.setVisible(true);
    }

    char displayYesNoDialog(Window window, String string, String string2, String string3, String string4) {
        final ToolDialog toolDialog = new ToolDialog(string, this.tool, this, true);
        Point point = window == null ? this.getLocationOnScreen() : window.getLocationOnScreen();
        toolDialog.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea(string2, 10, 50);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
        this.addNewComponent(toolDialog, jScrollPane, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        jTextArea.setFocusable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        final StringBuffer stringBuffer = new StringBuffer();
        JButton jButton = new JButton(string3);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringBuffer.append('Y');
                toolDialog.setVisible(false);
                toolDialog.dispose();
            }
        });
        this.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        jButton = new JButton(string4);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringBuffer.append('N');
                toolDialog.setVisible(false);
                toolDialog.dispose();
            }
        });
        this.addNewComponent(jPanel, jButton, 1, 1, 0, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        this.addNewComponent(toolDialog, jPanel, 1, 0, 1, 1, 1, 0.0, 0.0, 3);
        toolDialog.pack();
        toolDialog.setLocationRelativeTo(window);
        toolDialog.setVisible(true);
        if (stringBuffer.length() > 0) {
            return stringBuffer.charAt(0);
        }
        return 'N';
    }
}

