/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.tomcat.dbcp.pool.BaseKeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;
import org.apache.tomcat.dbcp.pool.PoolUtils;
import org.apache.tomcat.dbcp.pool.impl.CursorableLinkedList;
import org.apache.tomcat.dbcp.pool.impl.EvictionTimer;

public class GenericKeyedObjectPool<K, V>
extends BaseKeyedObjectPool<K, V> {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final int DEFAULT_MAX_TOTAL = -1;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final boolean DEFAULT_LIFO = true;
    private int _maxIdle = 8;
    private volatile int _minIdle = 0;
    private int _maxActive = 8;
    private int _maxTotal = -1;
    private long _maxWait = -1L;
    private byte _whenExhaustedAction = 1;
    private volatile boolean _testOnBorrow = false;
    private volatile boolean _testOnReturn = false;
    private boolean _testWhileIdle = false;
    private long _timeBetweenEvictionRunsMillis = -1L;
    private int _numTestsPerEvictionRun = 3;
    private long _minEvictableIdleTimeMillis = 1800000L;
    private Map<K, ObjectQueue> _poolMap = null;
    private int _totalActive = 0;
    private int _totalIdle = 0;
    private int _totalInternalProcessing = 0;
    private KeyedPoolableObjectFactory<K, V> _factory = null;
    private ClassLoader _factoryClassLoader = null;
    private Evictor _evictor = null;
    private CursorableLinkedList<K> _poolList = null;
    private CursorableLinkedList.Cursor _evictionCursor = null;
    private CursorableLinkedList.Cursor _evictionKeyCursor = null;
    private boolean _lifo = true;
    private final LinkedList<Latch<K, V>> _allocationQueue = new LinkedList();

    public GenericKeyedObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, Config config) {
        this(keyedPoolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.maxTotal, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle, config.lifo);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n) {
        this(keyedPoolableObjectFactory, n, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l) {
        this(keyedPoolableObjectFactory, n, by, l, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n, by, l, 8, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2) {
        this(keyedPoolableObjectFactory, n, by, l, n2, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n, by, l, n2, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2, boolean bl, boolean bl2, long l2, int n3, long l3, boolean bl3) {
        this(keyedPoolableObjectFactory, n, by, l, n2, -1, bl, bl2, l2, n3, l3, bl3);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2, int n3, boolean bl, boolean bl2, long l2, int n4, long l3, boolean bl3) {
        this(keyedPoolableObjectFactory, n, by, l, n2, n3, 0, bl, bl2, l2, n4, l3, bl3);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2, int n3, int n4, boolean bl, boolean bl2, long l2, int n5, long l3, boolean bl3) {
        this(keyedPoolableObjectFactory, n, by, l, n2, n3, n4, bl, bl2, l2, n5, l3, bl3, true);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, byte by, long l, int n2, int n3, int n4, boolean bl, boolean bl2, long l2, int n5, long l3, boolean bl3, boolean bl4) {
        this._factory = keyedPoolableObjectFactory;
        this._factoryClassLoader = Thread.currentThread().getContextClassLoader();
        this._maxActive = n;
        this._lifo = bl4;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this._whenExhaustedAction = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this._maxWait = l;
        this._maxIdle = n2;
        this._maxTotal = n3;
        this._minIdle = n4;
        this._testOnBorrow = bl;
        this._testOnReturn = bl2;
        this._timeBetweenEvictionRunsMillis = l2;
        this._numTestsPerEvictionRun = n5;
        this._minEvictableIdleTimeMillis = l3;
        this._testWhileIdle = bl3;
        this._poolMap = new HashMap<K, ObjectQueue>();
        this._poolList = new CursorableLinkedList();
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getMaxActive() {
        return this._maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxActive(int n) {
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this._maxActive = n;
        }
        this.allocate();
    }

    public synchronized int getMaxTotal() {
        return this._maxTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTotal(int n) {
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this._maxTotal = n;
        }
        this.allocate();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this._whenExhaustedAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhenExhaustedAction(byte by) {
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            switch (by) {
                case 0: 
                case 1: 
                case 2: {
                    this._whenExhaustedAction = by;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
                }
            }
        }
        this.allocate();
    }

    public synchronized long getMaxWait() {
        return this._maxWait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWait(long l) {
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this._maxWait = l;
        }
        this.allocate();
    }

    public synchronized int getMaxIdle() {
        return this._maxIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxIdle(int n) {
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this._maxIdle = n;
        }
        this.allocate();
    }

    public void setMinIdle(int n) {
        this._minIdle = n;
    }

    public int getMinIdle() {
        int n = this.getMaxIdle();
        if (this._minIdle > n) {
            return n;
        }
        return this._minIdle;
    }

    public boolean getTestOnBorrow() {
        return this._testOnBorrow;
    }

    public void setTestOnBorrow(boolean bl) {
        this._testOnBorrow = bl;
    }

    public boolean getTestOnReturn() {
        return this._testOnReturn;
    }

    public void setTestOnReturn(boolean bl) {
        this._testOnReturn = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this._timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this._timeBetweenEvictionRunsMillis = l;
        this.startEvictor(this._timeBetweenEvictionRunsMillis);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this._numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this._numTestsPerEvictionRun = n;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this._minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this._minEvictableIdleTimeMillis = l;
    }

    public synchronized boolean getTestWhileIdle() {
        return this._testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this._testWhileIdle = bl;
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxTotal(config.maxTotal);
        this.setMinIdle(config.minIdle);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
    }

    public synchronized boolean getLifo() {
        return this._lifo;
    }

    public synchronized void setLifo(boolean bl) {
        this._lifo = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V borrowObject(K k) throws Exception {
        long l;
        byte by;
        long l2 = System.currentTimeMillis();
        Latch latch = new Latch(k);
        Object object = this;
        synchronized (object) {
            by = this._whenExhaustedAction;
            l = this._maxWait;
            this._allocationQueue.add(latch);
        }
        this.allocate();
        block47: while (true) {
            GenericKeyedObjectPool genericKeyedObjectPool;
            object = this;
            synchronized (object) {
                this.assertOpen();
            }
            if (null == latch.getPair() && !latch.mayCreate()) {
                switch (by) {
                    case 2: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() == null && !latch.mayCreate()) {
                                this._allocationQueue.remove(latch);
                                latch.getPool().incrementInternalProcessingCount();
                            }
                            break;
                        }
                    }
                    case 0: {
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Pool exhausted");
                        }
                    }
                    case 1: {
                        try {
                            object = latch;
                            synchronized (object) {
                                if (latch.getPair() != null || latch.mayCreate()) {
                                    break;
                                }
                                if (l <= 0L) {
                                    latch.wait();
                                } else {
                                    long l3 = System.currentTimeMillis() - l2;
                                    long l4 = l - l3;
                                    if (l4 > 0L) {
                                        latch.wait(l4);
                                    }
                                }
                            }
                            if (this.isClosed()) {
                                throw new IllegalStateException("Pool closed");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            boolean bl;
                            boolean bl2 = false;
                            genericKeyedObjectPool = this;
                            synchronized (genericKeyedObjectPool) {
                                if (latch.getPair() == null && !latch.mayCreate()) {
                                    this._allocationQueue.remove(latch);
                                } else if (latch.getPair() == null && latch.mayCreate()) {
                                    latch.getPool().decrementInternalProcessingCount();
                                    bl = true;
                                } else {
                                    latch.getPool().decrementInternalProcessingCount();
                                    latch.getPool().incrementActiveCount();
                                    this.returnObject(latch.getkey(), latch.getPair().getValue());
                                }
                            }
                            if (bl) {
                                this.allocate();
                            }
                            Thread.currentThread().interrupt();
                            throw interruptedException;
                        }
                        if (l <= 0L || System.currentTimeMillis() - l2 < l) continue block47;
                        object = this;
                        synchronized (object) {
                            if (latch.getPair() != null || latch.mayCreate()) {
                                break;
                            }
                            this._allocationQueue.remove(latch);
                            throw new NoSuchElementException("Timeout waiting for idle object");
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
                    }
                }
            }
            boolean bl = false;
            if (null == latch.getPair()) {
                try {
                    V v = this._factory.makeObject(k);
                    latch.setPair(new ObjectTimestampPair<V>(v));
                    bl = true;
                }
                finally {
                    if (!bl) {
                        GenericKeyedObjectPool genericKeyedObjectPool2 = this;
                        synchronized (genericKeyedObjectPool2) {
                            latch.getPool().decrementInternalProcessingCount();
                        }
                        this.allocate();
                    }
                }
            }
            try {
                this._factory.activateObject(k, ((ObjectTimestampPair)latch.getPair()).value);
                if (this._testOnBorrow && !this._factory.validateObject(k, ((ObjectTimestampPair)latch.getPair()).value)) {
                    throw new Exception("ValidateObject failed");
                }
                GenericKeyedObjectPool genericKeyedObjectPool3 = this;
                synchronized (genericKeyedObjectPool3) {
                    latch.getPool().decrementInternalProcessingCount();
                    latch.getPool().incrementActiveCount();
                    return (V)((ObjectTimestampPair)latch.getPair()).value;
                }
            }
            catch (Throwable throwable) {
                PoolUtils.checkRethrow(throwable);
                try {
                    this._factory.destroyObject(k, ((ObjectTimestampPair)latch.getPair()).value);
                }
                catch (Throwable throwable2) {
                    PoolUtils.checkRethrow(throwable2);
                }
                genericKeyedObjectPool = this;
                synchronized (genericKeyedObjectPool) {
                    latch.getPool().decrementInternalProcessingCount();
                    if (!bl) {
                        latch.reset();
                        this._allocationQueue.add(0, latch);
                    }
                }
                this.allocate();
                if (bl) throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate() {
        boolean bl = false;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            if (this.isClosed()) {
                return;
            }
            Iterator iterator = this._allocationQueue.iterator();
            while (iterator.hasNext()) {
                Latch latch;
                Latch latch2 = (Latch)iterator.next();
                ObjectQueue objectQueue = this._poolMap.get(latch2.getkey());
                if (null == objectQueue) {
                    objectQueue = new ObjectQueue();
                    this._poolMap.put(latch2.getkey(), objectQueue);
                    this._poolList.add(latch2.getkey());
                }
                latch2.setPool(objectQueue);
                if (!objectQueue.queue.isEmpty()) {
                    iterator.remove();
                    latch2.setPair((ObjectTimestampPair)objectQueue.queue.removeFirst());
                    objectQueue.incrementInternalProcessingCount();
                    --this._totalIdle;
                    latch = latch2;
                    synchronized (latch) {
                        latch2.notify();
                        continue;
                    }
                }
                if (this._maxTotal > 0 && this._totalActive + this._totalIdle + this._totalInternalProcessing >= this._maxTotal) {
                    bl = true;
                    break;
                }
                if (!(this._maxActive >= 0 && objectQueue.activeCount + objectQueue.internalProcessingCount >= this._maxActive || this._maxTotal >= 0 && this._totalActive + this._totalIdle + this._totalInternalProcessing >= this._maxTotal)) {
                    iterator.remove();
                    latch2.setMayCreate(true);
                    objectQueue.incrementInternalProcessingCount();
                    latch = latch2;
                    synchronized (latch) {
                        latch2.notify();
                        continue;
                    }
                }
                if (this._maxActive >= 0) continue;
                break;
            }
        }
        if (bl) {
            this.clearOldest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        HashMap hashMap = new HashMap();
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            Iterator<K> iterator = this._poolMap.keySet().iterator();
            while (iterator.hasNext()) {
                K k = iterator.next();
                ObjectQueue objectQueue = this._poolMap.get(k);
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(objectQueue.queue);
                hashMap.put(k, arrayList);
                iterator.remove();
                this._poolList.remove(k);
                this._totalIdle -= objectQueue.queue.size();
                this._totalInternalProcessing += objectQueue.queue.size();
                objectQueue.queue.clear();
            }
        }
        this.destroy(hashMap, this._factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOldest() {
        HashMap hashMap = new HashMap();
        TreeMap treeMap = new TreeMap();
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            Object object;
            Object object2;
            for (K k : this._poolMap.keySet()) {
                object2 = this._poolMap.get(k).queue;
                object = object2.iterator();
                while (object.hasNext()) {
                    treeMap.put(object.next(), k);
                }
            }
            Set set = treeMap.entrySet();
            object2 = set.iterator();
            for (int i = (int)((double)treeMap.size() * 0.15) + 1; object2.hasNext() && i > 0; --i) {
                object = (Map.Entry)object2.next();
                Object v = object.getValue();
                ObjectTimestampPair objectTimestampPair = (ObjectTimestampPair)object.getKey();
                ObjectQueue objectQueue = this._poolMap.get(v);
                CursorableLinkedList cursorableLinkedList = objectQueue.queue;
                cursorableLinkedList.remove(objectTimestampPair);
                if (hashMap.containsKey(v)) {
                    ((List)hashMap.get(v)).add(objectTimestampPair);
                } else {
                    ArrayList<ObjectTimestampPair> arrayList = new ArrayList<ObjectTimestampPair>();
                    arrayList.add(objectTimestampPair);
                    hashMap.put(v, arrayList);
                }
                objectQueue.incrementInternalProcessingCount();
                --this._totalIdle;
            }
        }
        this.destroy(hashMap, this._factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(K k) {
        HashMap hashMap = new HashMap();
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            ObjectQueue objectQueue = this._poolMap.remove(k);
            if (objectQueue == null) {
                return;
            }
            this._poolList.remove(k);
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(objectQueue.queue);
            hashMap.put(k, arrayList);
            this._totalIdle -= objectQueue.queue.size();
            this._totalInternalProcessing += objectQueue.queue.size();
            objectQueue.queue.clear();
        }
        this.destroy(hashMap, this._factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(Map<K, List<ObjectTimestampPair<V>>> map, KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) {
        for (Map.Entry<K, List<ObjectTimestampPair<V>>> entry : map.entrySet()) {
            K k = entry.getKey();
            List<ObjectTimestampPair<V>> list = entry.getValue();
            Iterator<ObjectTimestampPair<V>> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    keyedPoolableObjectFactory.destroyObject(k, ((ObjectTimestampPair)iterator.next()).value);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    GenericKeyedObjectPool genericKeyedObjectPool = this;
                    synchronized (genericKeyedObjectPool) {
                        ObjectQueue objectQueue = this._poolMap.get(k);
                        if (objectQueue != null) {
                            objectQueue.decrementInternalProcessingCount();
                            if (objectQueue.internalProcessingCount == 0 && objectQueue.activeCount == 0 && objectQueue.queue.isEmpty()) {
                                this._poolMap.remove(k);
                                this._poolList.remove(k);
                            }
                        } else {
                            --this._totalInternalProcessing;
                        }
                    }
                    this.allocate();
                }
            }
        }
    }

    @Override
    public synchronized int getNumActive() {
        return this._totalActive;
    }

    @Override
    public synchronized int getNumIdle() {
        return this._totalIdle;
    }

    @Override
    public synchronized int getNumActive(Object object) {
        ObjectQueue objectQueue = this._poolMap.get(object);
        return objectQueue != null ? objectQueue.activeCount : 0;
    }

    @Override
    public synchronized int getNumIdle(Object object) {
        ObjectQueue objectQueue = this._poolMap.get(object);
        return objectQueue != null ? objectQueue.queue.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(K k, V v) throws Exception {
        block8: {
            try {
                this.addObjectToPool(k, v, true);
            }
            catch (Exception exception) {
                if (this._factory == null) break block8;
                try {
                    this._factory.destroyObject(k, v);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                ObjectQueue objectQueue = this._poolMap.get(k);
                if (objectQueue == null) break block8;
                GenericKeyedObjectPool genericKeyedObjectPool = this;
                synchronized (genericKeyedObjectPool) {
                    objectQueue.decrementActiveCount();
                    if (objectQueue.queue.isEmpty() && objectQueue.activeCount == 0 && objectQueue.internalProcessingCount == 0) {
                        this._poolMap.remove(k);
                        this._poolList.remove(k);
                    }
                }
                this.allocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectToPool(K k, V v, boolean bl) throws Exception {
        ObjectQueue objectQueue;
        boolean bl2 = true;
        if (this._testOnReturn && !this._factory.validateObject(k, v)) {
            bl2 = false;
        } else {
            this._factory.passivateObject(k, v);
        }
        boolean bl3 = !bl2;
        boolean bl4 = false;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            objectQueue = this._poolMap.get(k);
            if (null == objectQueue) {
                objectQueue = new ObjectQueue();
                this._poolMap.put(k, objectQueue);
                this._poolList.add(k);
            }
            if (this.isClosed()) {
                bl3 = true;
            } else if (this._maxIdle >= 0 && objectQueue.queue.size() >= this._maxIdle) {
                bl3 = true;
            } else if (bl2) {
                if (this._lifo) {
                    objectQueue.queue.addFirst(new ObjectTimestampPair<V>(v));
                } else {
                    objectQueue.queue.addLast(new ObjectTimestampPair<V>(v));
                }
                ++this._totalIdle;
                if (bl) {
                    objectQueue.decrementActiveCount();
                }
                bl4 = true;
            }
        }
        if (bl4) {
            this.allocate();
        }
        if (bl3) {
            try {
                this._factory.destroyObject(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                genericKeyedObjectPool = this;
                synchronized (genericKeyedObjectPool) {
                    objectQueue.decrementActiveCount();
                    if (objectQueue.queue.isEmpty() && objectQueue.activeCount == 0 && objectQueue.internalProcessingCount == 0) {
                        this._poolMap.remove(k);
                        this._poolList.remove(k);
                    }
                }
                this.allocate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObject(K k, V v) throws Exception {
        try {
            this._factory.destroyObject(k, v);
        }
        finally {
            GenericKeyedObjectPool genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                ObjectQueue objectQueue = this._poolMap.get(k);
                if (null == objectQueue) {
                    objectQueue = new ObjectQueue();
                    this._poolMap.put(k, objectQueue);
                    this._poolList.add(k);
                }
                objectQueue.decrementActiveCount();
            }
            this.allocate();
        }
    }

    @Override
    public void addObject(K k) throws Exception {
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        V v = this._factory.makeObject(k);
        try {
            this.assertOpen();
            this.addObjectToPool(k, v, false);
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this._factory.destroyObject(k, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw illegalStateException;
        }
    }

    public synchronized void preparePool(K k, boolean bl) {
        ObjectQueue objectQueue = this._poolMap.get(k);
        if (null == objectQueue) {
            objectQueue = new ObjectQueue();
            this._poolMap.put(k, objectQueue);
            this._poolList.add(k);
        }
        if (bl) {
            try {
                this.ensureMinIdle(k);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        super.close();
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.clear();
            if (null != this._evictionCursor) {
                this._evictionCursor.close();
                this._evictionCursor = null;
            }
            if (null != this._evictionKeyCursor) {
                this._evictionKeyCursor.close();
                this._evictionKeyCursor = null;
            }
            this.startEvictor(-1L);
            while (this._allocationQueue.size() > 0) {
                Latch<K, V> latch;
                Latch<K, V> latch2 = latch = this._allocationQueue.removeFirst();
                synchronized (latch2) {
                    latch.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException {
        HashMap hashMap = new HashMap();
        KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory2 = this._factory;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.assertOpen();
            if (0 < this.getNumActive()) {
                throw new IllegalStateException("Objects are already active");
            }
            Iterator<K> iterator = this._poolMap.keySet().iterator();
            while (iterator.hasNext()) {
                K k = iterator.next();
                ObjectQueue objectQueue = this._poolMap.get(k);
                if (objectQueue == null) continue;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(objectQueue.queue);
                hashMap.put(k, arrayList);
                iterator.remove();
                this._poolList.remove(k);
                this._totalIdle -= objectQueue.queue.size();
                this._totalInternalProcessing += objectQueue.queue.size();
                objectQueue.queue.clear();
            }
            this._factory = keyedPoolableObjectFactory;
            this._factoryClassLoader = Thread.currentThread().getContextClassLoader();
        }
        this.destroy(hashMap, keyedPoolableObjectFactory2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict() throws Exception {
        long l;
        boolean bl;
        Object object = null;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            bl = this._testWhileIdle;
            l = this._minEvictableIdleTimeMillis;
            if (this._evictionKeyCursor != null && this._evictionKeyCursor._lastReturned != null) {
                object = this._evictionKeyCursor._lastReturned.value();
            }
        }
        int n = this.getNumTests();
        for (int i = 0; i < n; ++i) {
            Object object2;
            ObjectTimestampPair objectTimestampPair;
            GenericKeyedObjectPool genericKeyedObjectPool2 = this;
            synchronized (genericKeyedObjectPool2) {
                if (this._poolMap == null || this._poolMap.size() == 0) {
                    continue;
                }
                if (null == this._evictionKeyCursor) {
                    this.resetEvictionKeyCursor();
                    object = null;
                }
                if (null == this._evictionCursor) {
                    if (this._evictionKeyCursor.hasNext()) {
                        object = this._evictionKeyCursor.next();
                        this.resetEvictionObjectCursor(object);
                    } else {
                        this.resetEvictionKeyCursor();
                        if (this._evictionKeyCursor != null && this._evictionKeyCursor.hasNext()) {
                            object = this._evictionKeyCursor.next();
                            this.resetEvictionObjectCursor(object);
                        }
                    }
                }
                if (this._evictionCursor == null) {
                    continue;
                }
                if ((this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) && this._evictionKeyCursor != null) {
                    if (this._evictionKeyCursor.hasNext()) {
                        object = this._evictionKeyCursor.next();
                        this.resetEvictionObjectCursor(object);
                    } else {
                        this.resetEvictionKeyCursor();
                        if (this._evictionKeyCursor != null && this._evictionKeyCursor.hasNext()) {
                            object = this._evictionKeyCursor.next();
                            this.resetEvictionObjectCursor(object);
                        }
                    }
                }
                if (this._lifo && !this._evictionCursor.hasPrevious() || !this._lifo && !this._evictionCursor.hasNext()) {
                    continue;
                }
                objectTimestampPair = this._lifo ? (ObjectTimestampPair)this._evictionCursor.previous() : (ObjectTimestampPair)this._evictionCursor.next();
                this._evictionCursor.remove();
                object2 = this._poolMap.get(object);
                ((ObjectQueue)object2).incrementInternalProcessingCount();
                --this._totalIdle;
            }
            boolean bl2 = false;
            if (l > 0L && System.currentTimeMillis() - objectTimestampPair.tstamp > l) {
                bl2 = true;
            }
            if (bl && !bl2) {
                boolean bl3 = false;
                try {
                    this._factory.activateObject(object, objectTimestampPair.value);
                    bl3 = true;
                }
                catch (Exception exception) {
                    bl2 = true;
                }
                if (bl3) {
                    if (!this._factory.validateObject(object, objectTimestampPair.value)) {
                        bl2 = true;
                    } else {
                        try {
                            this._factory.passivateObject(object, objectTimestampPair.value);
                        }
                        catch (Exception exception) {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2) {
                try {
                    this._factory.destroyObject(object, objectTimestampPair.value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object2 = this;
            synchronized (object2) {
                ObjectQueue objectQueue = this._poolMap.get(object);
                objectQueue.decrementInternalProcessingCount();
                if (bl2) {
                    if (objectQueue.queue.isEmpty() && objectQueue.activeCount == 0 && objectQueue.internalProcessingCount == 0) {
                        this._poolMap.remove(object);
                        this._poolList.remove(object);
                    }
                } else {
                    this._evictionCursor.add(objectTimestampPair);
                    ++this._totalIdle;
                    if (this._lifo) {
                        this._evictionCursor.previous();
                    }
                }
                continue;
            }
        }
        this.allocate();
    }

    private void resetEvictionKeyCursor() {
        if (this._evictionKeyCursor != null) {
            this._evictionKeyCursor.close();
        }
        this._evictionKeyCursor = this._poolList.cursor();
        if (null != this._evictionCursor) {
            this._evictionCursor.close();
            this._evictionCursor = null;
        }
    }

    private void resetEvictionObjectCursor(Object object) {
        if (this._evictionCursor != null) {
            this._evictionCursor.close();
        }
        if (this._poolMap == null) {
            return;
        }
        ObjectQueue objectQueue = this._poolMap.get(object);
        if (objectQueue != null) {
            CursorableLinkedList cursorableLinkedList = objectQueue.queue;
            this._evictionCursor = cursorableLinkedList.cursor(this._lifo ? cursorableLinkedList.size() : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMinIdle() throws Exception {
        if (this.getMinIdle() > 0) {
            Object[] objectArray;
            GenericKeyedObjectPool genericKeyedObjectPool = this;
            synchronized (genericKeyedObjectPool) {
                objectArray = this._poolMap.keySet().toArray();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                this.ensureMinIdle(objectArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMinIdle(K k) throws Exception {
        ObjectQueue objectQueue;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            objectQueue = this._poolMap.get(k);
        }
        if (objectQueue == null) {
            return;
        }
        int n = this.calculateDeficit(objectQueue, false);
        for (int i = 0; i < n && this.calculateDeficit(objectQueue, true) > 0; ++i) {
            try {
                this.addObject(k);
                continue;
            }
            finally {
                GenericKeyedObjectPool genericKeyedObjectPool2 = this;
                synchronized (genericKeyedObjectPool2) {
                    objectQueue.decrementInternalProcessingCount();
                }
                this.allocate();
            }
        }
    }

    protected synchronized void startEvictor(long l) {
        if (null != this._evictor) {
            EvictionTimer.cancel(this._evictor);
            this._evictor = null;
        }
        if (l > 0L) {
            this._evictor = new Evictor();
            EvictionTimer.schedule(this._evictor, l, l);
        }
    }

    synchronized String debugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Active: ").append(this.getNumActive()).append("\n");
        stringBuffer.append("Idle: ").append(this.getNumIdle()).append("\n");
        for (K k : this._poolMap.keySet()) {
            stringBuffer.append("\t").append(k).append(" ").append(this._poolMap.get(k)).append("\n");
        }
        return stringBuffer.toString();
    }

    private synchronized int getNumTests() {
        if (this._numTestsPerEvictionRun >= 0) {
            return Math.min(this._numTestsPerEvictionRun, this._totalIdle);
        }
        return (int)Math.ceil((double)this._totalIdle / Math.abs((double)this._numTestsPerEvictionRun));
    }

    private synchronized int calculateDeficit(ObjectQueue objectQueue, boolean bl) {
        int n;
        int n2 = 0;
        n2 = this.getMinIdle() - objectQueue.queue.size();
        if (this.getMaxActive() > 0) {
            n = Math.max(0, this.getMaxActive() - objectQueue.activeCount - objectQueue.queue.size() - objectQueue.internalProcessingCount);
            n2 = Math.min(n2, n);
        }
        if (this.getMaxTotal() > 0) {
            n = Math.max(0, this.getMaxTotal() - this.getNumActive() - this.getNumIdle() - this._totalInternalProcessing);
            n2 = Math.min(n2, n);
        }
        if (bl && n2 > 0) {
            objectQueue.incrementInternalProcessingCount();
        }
        return n2;
    }

    private final class Latch<LK, LV> {
        private final LK _key;
        private ObjectQueue _pool;
        private ObjectTimestampPair<LV> _pair;
        private boolean _mayCreate = false;

        private Latch(LK LK) {
            this._key = LK;
        }

        private synchronized LK getkey() {
            return this._key;
        }

        private synchronized ObjectQueue getPool() {
            return this._pool;
        }

        private synchronized void setPool(ObjectQueue objectQueue) {
            this._pool = objectQueue;
        }

        private synchronized ObjectTimestampPair<LV> getPair() {
            return this._pair;
        }

        private synchronized void setPair(ObjectTimestampPair<LV> objectTimestampPair) {
            this._pair = objectTimestampPair;
        }

        private synchronized boolean mayCreate() {
            return this._mayCreate;
        }

        private synchronized void setMayCreate(boolean bl) {
            this._mayCreate = bl;
        }

        private synchronized void reset() {
            this._pair = null;
            this._mayCreate = false;
        }
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public int maxTotal = -1;
        public int minIdle = 0;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
        public boolean lifo = true;
    }

    private class Evictor
    extends TimerTask {
        private Evictor() {
        }

        @Override
        public void run() {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(GenericKeyedObjectPool.this._factoryClassLoader);
                try {
                    GenericKeyedObjectPool.this.evict();
                }
                catch (Exception exception) {
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    outOfMemoryError.printStackTrace(System.err);
                }
                try {
                    GenericKeyedObjectPool.this.ensureMinIdle();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    static class ObjectTimestampPair<T>
    implements Comparable<T> {
        private final T value;
        private final long tstamp;

        ObjectTimestampPair(T t) {
            this(t, System.currentTimeMillis());
        }

        ObjectTimestampPair(T t, long l) {
            this.value = t;
            this.tstamp = l;
        }

        public String toString() {
            return this.value + ";" + this.tstamp;
        }

        @Override
        public int compareTo(Object object) {
            return this.compareTo((ObjectTimestampPair)object);
        }

        @Override
        public int compareTo(ObjectTimestampPair<T> objectTimestampPair) {
            long l = this.tstamp - objectTimestampPair.tstamp;
            if (l == 0L) {
                return System.identityHashCode(this) - System.identityHashCode(objectTimestampPair);
            }
            return (int)Math.min(Math.max(l, Integer.MIN_VALUE), Integer.MAX_VALUE);
        }

        public T getValue() {
            return this.value;
        }

        public long getTstamp() {
            return this.tstamp;
        }
    }

    private class ObjectQueue {
        private int activeCount = 0;
        private final CursorableLinkedList<ObjectTimestampPair<V>> queue = new CursorableLinkedList();
        private int internalProcessingCount = 0;

        private ObjectQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementActiveCount() {
            GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
            synchronized (genericKeyedObjectPool) {
                GenericKeyedObjectPool.this._totalActive++;
            }
            ++this.activeCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decrementActiveCount() {
            GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
            synchronized (genericKeyedObjectPool) {
                GenericKeyedObjectPool.this._totalActive--;
            }
            if (this.activeCount > 0) {
                --this.activeCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void incrementInternalProcessingCount() {
            GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
            synchronized (genericKeyedObjectPool) {
                GenericKeyedObjectPool.this._totalInternalProcessing++;
            }
            ++this.internalProcessingCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decrementInternalProcessingCount() {
            GenericKeyedObjectPool genericKeyedObjectPool = GenericKeyedObjectPool.this;
            synchronized (genericKeyedObjectPool) {
                GenericKeyedObjectPool.this._totalInternalProcessing--;
            }
            --this.internalProcessingCount;
        }
    }
}

