/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import javax.servlet.ServletContext;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ELInterpreter;
import org.apache.jasper.compiler.JspUtil;

public class ELInterpreterFactory {
    public static final String EL_INTERPRETER_CLASS_NAME = ELInterpreter.class.getName();
    private static final ELInterpreter DEFAULT_INSTANCE = new DefaultELInterpreter();

    public static ELInterpreter getELInterpreter(ServletContext servletContext) throws Exception {
        String string;
        ELInterpreter eLInterpreter = null;
        Object object = servletContext.getAttribute(EL_INTERPRETER_CLASS_NAME);
        if (object instanceof ELInterpreter) {
            return (ELInterpreter)object;
        }
        if (object instanceof String) {
            eLInterpreter = ELInterpreterFactory.createInstance(servletContext, (String)object);
        }
        if (eLInterpreter == null && (string = servletContext.getInitParameter(EL_INTERPRETER_CLASS_NAME)) != null) {
            eLInterpreter = ELInterpreterFactory.createInstance(servletContext, string);
        }
        if (eLInterpreter == null) {
            eLInterpreter = DEFAULT_INSTANCE;
        }
        servletContext.setAttribute(EL_INTERPRETER_CLASS_NAME, (Object)eLInterpreter);
        return eLInterpreter;
    }

    private static ELInterpreter createInstance(ServletContext servletContext, String string) throws Exception {
        return (ELInterpreter)servletContext.getClassLoader().loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private ELInterpreterFactory() {
    }

    public static class DefaultELInterpreter
    implements ELInterpreter {
        @Override
        public String interpreterCall(JspCompilationContext jspCompilationContext, boolean bl, String string, Class<?> clazz, String string2, boolean bl2) {
            return JspUtil.interpreterCall(bl, string, clazz, string2, bl2);
        }
    }
}

