/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.annotation.HandlesTypes;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.ServletDef;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.startup.WebappServiceLoader;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.Introspection;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLConnection;
import org.apache.naming.resources.FileDirContext;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.bcel.classfile.AnnotationElementValue;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ArrayElementValue;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ClassParser;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.InputSourceUtil;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(ContextConfig.class);
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    protected static final LoginConfig DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);
    protected static final Properties authenticators;
    private static final Set<String> pluggabilityJarsToSkip;
    protected static long deploymentCount;
    protected static final Map<Host, DefaultWebXmlCacheEntry> hostWebXmlCache;
    private static final Set<ServletContainerInitializer> EMPTY_SCI_SET;
    protected Map<String, Authenticator> customAuthenticators;
    protected volatile Context context = null;
    @Deprecated
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected String originalDocBase = null;
    private File antiLockingDocBase = null;
    protected final Map<ServletContainerInitializer, Set<Class<?>>> initializerClassMap = new LinkedHashMap();
    protected final Map<Class<?>, Set<ServletContainerInitializer>> typeInitializerMap = new HashMap();
    protected final Map<String, JavaClassCacheEntry> javaClassCache = new HashMap<String, JavaClassCacheEntry>();
    protected boolean handlesTypesAnnotations = false;
    protected boolean handlesTypesNonAnnotations = false;
    protected Digester webDigester = null;
    protected WebRuleSet webRuleSet = null;
    protected Digester webFragmentDigester = null;
    protected WebRuleSet webFragmentRuleSet = null;

    private static void addJarsToSkip(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.length() <= 0) continue;
                pluggabilityJarsToSkip.add(string3);
            }
        }
    }

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String string) {
        this.defaultWebXml = string;
    }

    @Deprecated
    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "conf/context.xml";
        }
        return this.defaultContextXml;
    }

    @Deprecated
    public void setDefaultContextXml(String string) {
        this.defaultContextXml = string;
    }

    public void setCustomAuthenticators(Map<String, Authenticator> map) {
        this.customAuthenticators = map;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.context = (Context)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("contextConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("configure_start")) {
            this.configureStart();
        } else if (lifecycleEvent.getType().equals("before_start")) {
            this.beforeStart();
        } else if (lifecycleEvent.getType().equals("after_start")) {
            if (this.originalDocBase != null) {
                this.context.setDocBase(this.originalDocBase);
            }
        } else if (lifecycleEvent.getType().equals("configure_stop")) {
            this.configureStop();
        } else if (lifecycleEvent.getType().equals("after_init")) {
            this.init();
        } else if (lifecycleEvent.getType().equals("after_destroy")) {
            this.destroy();
        }
    }

    protected void applicationAnnotationsConfig() {
        long l = System.currentTimeMillis();
        WebAnnotationSet.loadApplicationAnnotations(this.context);
        long l2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(l2 - l + ((StandardContext)this.context).getStartupTime());
        }
    }

    protected void authenticatorConfig() {
        Object object;
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context.getAuthenticator() != null) {
            return;
        }
        if (!(this.context instanceof ContainerBase)) {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        Valve valve = null;
        if (this.customAuthenticators != null) {
            valve = (Valve)((Object)this.customAuthenticators.get(loginConfig.getAuthMethod()));
        }
        if (valve == null) {
            if (authenticators == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                this.ok = false;
                return;
            }
            object = authenticators.getProperty(loginConfig.getAuthMethod());
            if (object == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorMissing", new Object[]{loginConfig.getAuthMethod()}));
                this.ok = false;
                return;
            }
            try {
                Class<?> clazz = Class.forName((String)object);
                valve = (Valve)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", new Object[]{object}), throwable);
                this.ok = false;
            }
        }
        if (valve != null && this.context instanceof ContainerBase && (object = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).getPipeline().addValve(valve);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", new Object[]{loginConfig.getAuthMethod()}));
            }
        }
    }

    public void createWebXmlDigester(boolean bl, boolean bl2) {
        boolean bl3 = this.context.getXmlBlockExternal();
        this.webRuleSet = new WebRuleSet(false);
        this.webDigester = DigesterFactory.newDigester((boolean)bl2, (boolean)bl, (RuleSet)this.webRuleSet, (boolean)bl3);
        this.webDigester.getParser();
        this.webFragmentRuleSet = new WebRuleSet(true);
        this.webFragmentDigester = DigesterFactory.newDigester((boolean)bl2, (boolean)bl, (RuleSet)this.webFragmentRuleSet, (boolean)bl3);
        this.webFragmentDigester.getParser();
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("className");
        hashMap.put(Object.class, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("source");
        hashMap.put(StandardContext.class, arrayList2);
        digester.setFakeAttributes(hashMap);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet((RuleSet)contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet((RuleSet)namingRuleSet);
        return digester;
    }

    protected String getBaseDir() {
        Container container = this.context.getParent().getParent();
        if (container instanceof StandardEngine) {
            return ((StandardEngine)container).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    protected void contextConfig(Digester digester) {
        if (this.defaultContextXml == null && this.context instanceof StandardContext) {
            this.defaultContextXml = ((StandardContext)this.context).getDefaultContextXml();
        }
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            Serializable serializable;
            File file = new File(this.defaultContextXml);
            if (!file.isAbsolute()) {
                file = new File(this.getBaseDir(), this.defaultContextXml);
            }
            if (file.exists()) {
                try {
                    serializable = file.toURI().toURL();
                    this.processContextConfig(digester, (URL)serializable);
                }
                catch (MalformedURLException malformedURLException) {
                    log.error((Object)sm.getString("contextConfig.badUrl", new Object[]{file}), (Throwable)malformedURLException);
                }
            }
            if (((File)(serializable = new File(this.getHostConfigBase(), "context.xml.default"))).exists()) {
                try {
                    URL uRL = ((File)serializable).toURI().toURL();
                    this.processContextConfig(digester, uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    log.error((Object)sm.getString("contextConfig.badUrl", new Object[]{serializable}), (Throwable)malformedURLException);
                }
            }
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(digester, this.context.getConfigFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(Digester digester, URL uRL) {
        URLConnection uRLConnection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] configuration file [" + uRL + "]"));
        }
        InputSource inputSource = null;
        InputStream inputStream = null;
        try {
            inputSource = new InputSource(uRL.toString());
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.contextMissing", new Object[]{uRL}), (Throwable)exception);
        }
        if (inputSource == null) {
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.setClassLoader(this.getClass().getClassLoader());
            digester.setUseContextClassLoader(false);
            digester.push((Object)this.context.getParent());
            digester.push((Object)this.context);
            uRLConnection = new XmlErrorHandler();
            digester.setErrorHandler((ErrorHandler)((Object)uRLConnection));
            digester.parse(inputSource);
            if (uRLConnection.getWarnings().size() > 0 || uRLConnection.getErrors().size() > 0) {
                uRLConnection.logFindings(log, uRL.toString());
                this.ok = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully processed context [" + this.context.getName() + "] configuration file [" + uRL + "]"));
            }
        }
        catch (SAXParseException sAXParseException) {
            log.error((Object)sm.getString("contextConfig.contextParse", new Object[]{this.context.getName()}), (Throwable)sAXParseException);
            log.error((Object)sm.getString("contextConfig.defaultPosition", new Object[]{"" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()}));
            this.ok = false;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.contextParse", new Object[]{this.context.getName()}), (Throwable)exception);
            this.ok = false;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)iOException);
            }
        }
    }

    protected void fixDocBase() throws IOException {
        Object object;
        Object object2;
        Host host = (Host)this.context.getParent();
        String string = host.getAppBase();
        File file = new File(string);
        file = file.isAbsolute() ? file.getCanonicalFile() : new File(this.getBaseDir(), string).getCanonicalFile();
        String string2 = this.context.getDocBase();
        if (string2 == null) {
            object2 = this.context.getPath();
            if (object2 == null) {
                return;
            }
            object = new ContextName((String)object2, this.context.getWebappVersion());
            string2 = ((ContextName)object).getBaseName();
        }
        string2 = !((File)(object2 = new File(string2))).isAbsolute() ? new File(file, string2).getCanonicalPath() : ((File)object2).getCanonicalPath();
        object2 = new File(string2);
        object = string2;
        ContextName contextName = new ContextName(this.context.getPath(), this.context.getWebappVersion());
        String string3 = contextName.getBaseName();
        boolean bl = true;
        if (host instanceof StandardHost && (bl = ((StandardHost)host).isUnpackWARs()) && this.context instanceof StandardContext) {
            bl = ((StandardContext)this.context).getUnpackWAR();
        }
        if (string2.toLowerCase(Locale.ENGLISH).endsWith(".war") && !((File)object2).isDirectory()) {
            URL uRL = UriUtil.buildJarUrl((File)new File(string2));
            if (bl) {
                string2 = ExpandWar.expand(host, uRL, string3);
                object2 = new File(string2);
                string2 = ((File)object2).getCanonicalPath();
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase((String)object);
                }
            } else {
                ExpandWar.validate(host, uRL, string3);
            }
        } else {
            File file2 = new File(string2);
            if (!file2.exists()) {
                File file3 = new File(string2 + ".war");
                if (file3.exists()) {
                    URL uRL = UriUtil.buildJarUrl((File)file3);
                    if (bl) {
                        string2 = ExpandWar.expand(host, uRL, string3);
                        object2 = new File(string2);
                        string2 = ((File)object2).getCanonicalPath();
                    } else {
                        string2 = file3.getCanonicalPath();
                        ExpandWar.validate(host, uRL, string3);
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase((String)object);
                }
            }
        }
        if (string2.startsWith(file.getPath() + File.separatorChar)) {
            string2 = string2.substring(file.getPath().length());
            if ((string2 = string2.replace(File.separatorChar, '/')).startsWith("/")) {
                string2 = string2.substring(1);
            }
        } else {
            string2 = string2.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(string2);
    }

    protected void antiLocking() {
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getAntiResourceLocking()) {
            Object object;
            Host host = (Host)this.context.getParent();
            String string = host.getAppBase();
            String string2 = this.context.getDocBase();
            if (string2 == null) {
                return;
            }
            this.originalDocBase = string2;
            File file = new File(string2);
            if (!file.isAbsolute()) {
                object = new File(string);
                if (!((File)object).isAbsolute()) {
                    object = new File(this.getBaseDir(), string);
                }
                file = new File((File)object, string2);
            }
            if ((object = this.context.getPath()) == null) {
                return;
            }
            ContextName contextName = new ContextName((String)object, this.context.getWebappVersion());
            string2 = contextName.getBaseName();
            this.antiLockingDocBase = this.originalDocBase.toLowerCase(Locale.ENGLISH).endsWith(".war") ? new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + string2 + ".war") : new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + string2);
            this.antiLockingDocBase = this.antiLockingDocBase.getAbsoluteFile();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anti locking context[" + this.context.getName() + "] setting docBase to " + this.antiLockingDocBase.getPath()));
            }
            ExpandWar.delete(this.antiLockingDocBase);
            if (ExpandWar.copy(file, this.antiLockingDocBase)) {
                this.context.setDocBase(this.antiLockingDocBase.getPath());
            }
        }
    }

    protected synchronized void init() {
        Digester digester = this.createContextDigester();
        digester.getParser();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig(digester);
        this.createWebXmlDigester(this.context.getXmlNamespaceAware(), this.context.getXmlValidation());
    }

    protected synchronized void beforeStart() {
        try {
            this.fixDocBase();
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.fixDocBase", new Object[]{this.context.getName()}), (Throwable)iOException);
        }
        this.antiLocking();
    }

    protected synchronized void configureStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.xmlSettings", new Object[]{this.context.getName(), this.context.getXmlValidation(), this.context.getXmlNamespaceAware()}));
        }
        this.webConfig();
        if (!this.context.getIgnoreAnnotations()) {
            this.applicationAnnotationsConfig();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (log.isDebugEnabled() && this.context instanceof ContainerBase) {
            log.debug((Object)"Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valveArray = null;
            if (pipeline != null) {
                valveArray = pipeline.getValves();
            }
            if (valveArray != null) {
                for (Valve valve : valveArray) {
                    log.debug((Object)("  " + valve.getInfo()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected synchronized void configureStop() {
        int n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] containerArray = this.context.findChildren();
        for (n = 0; n < containerArray.length; ++n) {
            this.context.removeChild(containerArray[n]);
        }
        SecurityConstraint[] securityConstraintArray = this.context.findConstraints();
        for (n = 0; n < securityConstraintArray.length; ++n) {
            this.context.removeConstraint(securityConstraintArray[n]);
        }
        ErrorPage[] errorPageArray = this.context.findErrorPages();
        for (n = 0; n < errorPageArray.length; ++n) {
            this.context.removeErrorPage(errorPageArray[n]);
        }
        FilterDef[] filterDefArray = this.context.findFilterDefs();
        for (n = 0; n < filterDefArray.length; ++n) {
            this.context.removeFilterDef(filterDefArray[n]);
        }
        FilterMap[] filterMapArray = this.context.findFilterMaps();
        for (n = 0; n < filterMapArray.length; ++n) {
            this.context.removeFilterMap(filterMapArray[n]);
        }
        String[] stringArray = this.context.findMimeMappings();
        for (n = 0; n < stringArray.length; ++n) {
            this.context.removeMimeMapping(stringArray[n]);
        }
        String[] stringArray2 = this.context.findParameters();
        for (n = 0; n < stringArray2.length; ++n) {
            this.context.removeParameter(stringArray2[n]);
        }
        String[] stringArray3 = this.context.findSecurityRoles();
        for (n = 0; n < stringArray3.length; ++n) {
            this.context.removeSecurityRole(stringArray3[n]);
        }
        String[] stringArray4 = this.context.findServletMappings();
        for (n = 0; n < stringArray4.length; ++n) {
            this.context.removeServletMapping(stringArray4[n]);
        }
        String[] stringArray5 = this.context.findWelcomeFiles();
        for (n = 0; n < stringArray5.length; ++n) {
            this.context.removeWelcomeFile(stringArray5[n]);
        }
        String[] stringArray6 = this.context.findWrapperLifecycles();
        for (n = 0; n < stringArray6.length; ++n) {
            this.context.removeWrapperLifecycle(stringArray6[n]);
        }
        String[] stringArray7 = this.context.findWrapperListeners();
        for (n = 0; n < stringArray7.length; ++n) {
            this.context.removeWrapperListener(stringArray7[n]);
        }
        if (this.antiLockingDocBase != null) {
            ExpandWar.delete(this.antiLockingDocBase, false);
        }
        this.initializerClassMap.clear();
        this.typeInitializerMap.clear();
        this.ok = true;
    }

    protected synchronized void destroy() {
        String string;
        Server server;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.destroy"));
        }
        if ((server = this.getServer()) != null && !server.getState().isAvailable()) {
            return;
        }
        if (this.context instanceof StandardContext && (string = ((StandardContext)this.context).getWorkPath()) != null) {
            ExpandWar.delete(new File(string));
        }
    }

    private Server getServer() {
        Container container;
        for (container = this.context; container != null && !(container instanceof Engine); container = container.getParent()) {
        }
        if (container == null) {
            return null;
        }
        Service service = ((Engine)container).getService();
        if (service == null) {
            return null;
        }
        return service.getServer();
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] securityConstraintArray = this.context.findConstraints();
        Object[] objectArray = securityConstraintArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            SecurityConstraint securityConstraint = objectArray[i];
            String[] object = securityConstraint.findAuthRoles();
            for (String string : object) {
                if ("*".equals(string) || this.context.findSecurityRole(string)) continue;
                log.warn((Object)sm.getString("contextConfig.role.auth", new Object[]{string}));
                this.context.addSecurityRole(string);
            }
        }
        for (Object object : objectArray = this.context.findChildren()) {
            String[] stringArray;
            Wrapper wrapper = (Wrapper)object;
            String string = wrapper.getRunAs();
            if (string != null && !this.context.findSecurityRole(string)) {
                log.warn((Object)sm.getString("contextConfig.role.runas", new Object[]{string}));
                this.context.addSecurityRole(string);
            }
            for (String string2 : stringArray = wrapper.findSecurityReferences()) {
                String string3 = wrapper.findSecurityReference(string2);
                if (string3 == null || this.context.findSecurityRole(string3)) continue;
                log.warn((Object)sm.getString("contextConfig.role.link", new Object[]{string3}));
                this.context.addSecurityRole(string3);
            }
        }
    }

    @Deprecated
    protected File getConfigBase() {
        File file = new File(this.getBaseDir(), "conf");
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    protected File getHostConfigBase() {
        File file = null;
        Host host = null;
        Engine engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = (Host)container;
            }
            if (!(container instanceof Engine)) continue;
            engine = (Engine)container;
        }
        if (host != null && host.getXmlBase() != null) {
            String string = host.getXmlBase();
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this.getBaseDir(), string);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            if (engine != null) {
                stringBuilder.append(engine.getName()).append('/');
            }
            if (host != null) {
                stringBuilder.append(host.getName()).append('/');
            }
            file = new File(this.getConfigBase(), stringBuilder.toString());
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    protected void webConfig() {
        HashSet<WebXml> hashSet = new HashSet<WebXml>();
        hashSet.add(this.getDefaultWebXmlFragment());
        WebXml webXml = this.createWebXml();
        InputSource inputSource = this.getContextWebXmlSource();
        this.parseWebXml(inputSource, webXml, false);
        ServletContext servletContext = this.context.getServletContext();
        Map<String, WebXml> map = this.processJarsForWebFragments(webXml);
        Set<WebXml> set = null;
        set = WebXml.orderWebFragments(webXml, map, servletContext);
        if (this.ok) {
            this.processServletContainerInitializers();
        }
        if (!webXml.isMetadataComplete() || this.typeInitializerMap.size() > 0) {
            this.processClasses(webXml, set);
        }
        if (!webXml.isMetadataComplete()) {
            if (this.ok) {
                this.ok = webXml.merge(set);
            }
            webXml.merge(hashSet);
            if (this.ok) {
                this.convertJsps(webXml);
            }
            if (this.ok) {
                webXml.configureContext(this.context);
            }
        } else {
            webXml.merge(hashSet);
            this.convertJsps(webXml);
            webXml.configureContext(this.context);
        }
        String string = webXml.toXml();
        servletContext.setAttribute("org.apache.tomcat.util.scan.MergedWebXml", (Object)string);
        if (this.context.getLogEffectiveWebXml()) {
            log.info((Object)("web.xml:\n" + string));
        }
        if (this.ok) {
            LinkedHashSet<WebXml> linkedHashSet = new LinkedHashSet<WebXml>(set);
            for (WebXml webXml2 : map.values()) {
                if (linkedHashSet.contains(webXml2)) continue;
                linkedHashSet.add(webXml2);
            }
            this.processResourceJARs((Set<WebXml>)linkedHashSet);
        }
        if (this.ok) {
            for (Map.Entry entry : this.initializerClassMap.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) {
                    this.context.addServletContainerInitializer((ServletContainerInitializer)entry.getKey(), null);
                    continue;
                }
                this.context.addServletContainerInitializer((ServletContainerInitializer)entry.getKey(), (Set)entry.getValue());
            }
        }
    }

    protected void processClasses(WebXml webXml, Set<WebXml> set) {
        if (this.ok) {
            NamingEnumeration<Binding> namingEnumeration = null;
            try {
                try {
                    namingEnumeration = this.context.getResources().listBindings("/WEB-INF/classes");
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    Object object;
                    Binding binding = (Binding)namingEnumeration.nextElement();
                    if (binding.getObject() instanceof FileDirContext) {
                        object = new File(((FileDirContext)binding.getObject()).getDocBase());
                        this.processAnnotationsFile((File)object, webXml, webXml.isMetadataComplete());
                        continue;
                    }
                    if ("META-INF".equals(binding.getName())) continue;
                    object = "/WEB-INF/classes/" + binding.getName();
                    try {
                        URL uRL = this.context.getServletContext().getResource((String)object);
                        this.processAnnotationsUrl(uRL, webXml, webXml.isMetadataComplete());
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.webinfClassesUrl", new Object[]{object}), (Throwable)malformedURLException);
                    }
                }
            }
            catch (NamingException namingException) {
                log.error((Object)sm.getString("contextConfig.webinfClassesUrl", new Object[]{"/WEB-INF/classes"}), (Throwable)namingException);
            }
        }
        if (this.ok) {
            this.processAnnotations(set, webXml.isMetadataComplete());
        }
        this.javaClassCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebXml getDefaultWebXmlFragment() {
        Object object;
        Object object2;
        Host host = (Host)this.context.getParent();
        DefaultWebXmlCacheEntry defaultWebXmlCacheEntry = hostWebXmlCache.get(host);
        InputSource inputSource = this.getGlobalWebXmlSource();
        InputSource inputSource2 = this.getHostWebXmlSource();
        long l = 0L;
        long l2 = 0L;
        if (inputSource != null) {
            object2 = null;
            try {
                object = new URL(inputSource.getSystemId());
                object2 = ((URL)object).openConnection();
                l = ((URLConnection)object2).getLastModified();
            }
            catch (IOException iOException) {
                l = -1L;
            }
            finally {
                if (object2 != null) {
                    try {
                        ((URLConnection)object2).getInputStream().close();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.handleThrowable((Throwable)iOException);
                        l = -1L;
                    }
                }
            }
        }
        if (inputSource2 != null) {
            object2 = null;
            try {
                object = new URL(inputSource2.getSystemId());
                object2 = ((URL)object).openConnection();
                l2 = ((URLConnection)object2).getLastModified();
            }
            catch (IOException iOException) {
                l2 = -1L;
            }
            finally {
                if (object2 != null) {
                    try {
                        ((URLConnection)object2).getInputStream().close();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.handleThrowable((Throwable)iOException);
                        l2 = -1L;
                    }
                }
            }
        }
        if (defaultWebXmlCacheEntry != null && defaultWebXmlCacheEntry.getGlobalTimeStamp() == l && defaultWebXmlCacheEntry.getHostTimeStamp() == l2) {
            InputSourceUtil.close((InputSource)inputSource);
            InputSourceUtil.close((InputSource)inputSource2);
            return defaultWebXmlCacheEntry.getWebXml();
        }
        object2 = host.getPipeline();
        synchronized (object2) {
            defaultWebXmlCacheEntry = hostWebXmlCache.get(host);
            if (defaultWebXmlCacheEntry != null && defaultWebXmlCacheEntry.getGlobalTimeStamp() == l && defaultWebXmlCacheEntry.getHostTimeStamp() == l2) {
                return defaultWebXmlCacheEntry.getWebXml();
            }
            object = this.createWebXml();
            ((WebXml)object).setOverridable(true);
            ((WebXml)object).setDistributable(true);
            ((WebXml)object).setAlwaysAddWelcomeFiles(false);
            if (inputSource == null) {
                log.info((Object)sm.getString("contextConfig.defaultMissing"));
            } else {
                this.parseWebXml(inputSource, (WebXml)object, false);
            }
            ((WebXml)object).setReplaceWelcomeFiles(true);
            this.parseWebXml(inputSource2, (WebXml)object, false);
            if (l != -1L && l2 != -1L) {
                defaultWebXmlCacheEntry = new DefaultWebXmlCacheEntry((WebXml)object, l, l2);
                hostWebXmlCache.put(host, defaultWebXmlCacheEntry);
                host.addLifecycleListener(new HostWebXmlCacheCleaner());
            }
            return object;
        }
    }

    private void convertJsps(WebXml webXml) {
        Map<String, String> map;
        ServletDef servletDef = webXml.getServlets().get("jsp");
        if (servletDef == null) {
            map = new HashMap<String, String>();
            Wrapper wrapper = (Wrapper)this.context.findChild("jsp");
            if (wrapper != null) {
                String[] object;
                for (String string : object = wrapper.findInitParameters()) {
                    map.put(string, wrapper.findInitParameter(string));
                }
            }
        } else {
            map = servletDef.getParameterMap();
        }
        for (ServletDef servletDef2 : webXml.getServlets().values()) {
            if (servletDef2.getJspFile() == null) continue;
            this.convertJsp(servletDef2, map);
        }
    }

    private void convertJsp(ServletDef servletDef, Map<String, String> map) {
        servletDef.setServletClass("org.apache.jasper.servlet.JspServlet");
        String string = servletDef.getJspFile();
        if (string != null && !string.startsWith("/")) {
            if (this.context.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.jspFile.warning", new Object[]{string}));
                }
                string = "/" + string;
            } else {
                throw new IllegalArgumentException(sm.getString("contextConfig.jspFile.error", new Object[]{string}));
            }
        }
        servletDef.getParameterMap().put("jspFile", string);
        servletDef.setJspFile(null);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            servletDef.addInitParameter(entry.getKey(), entry.getValue());
        }
    }

    protected WebXml createWebXml() {
        return new WebXml();
    }

    protected void processServletContainerInitializers() {
        List<ServletContainerInitializer> list;
        try {
            WebappServiceLoader<ServletContainerInitializer> webappServiceLoader = new WebappServiceLoader<ServletContainerInitializer>(this.context);
            list = webappServiceLoader.load(ServletContainerInitializer.class);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.servletContainerInitializerFail", new Object[]{this.context.getName()}), (Throwable)iOException);
            this.ok = false;
            return;
        }
        for (ServletContainerInitializer servletContainerInitializer : list) {
            Class[] classArray;
            HandlesTypes handlesTypes;
            this.initializerClassMap.put(servletContainerInitializer, new HashSet());
            try {
                handlesTypes = servletContainerInitializer.getClass().getAnnotation(HandlesTypes.class);
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.info((Object)sm.getString("contextConfig.sci.debug", new Object[]{servletContainerInitializer.getClass().getName()}), (Throwable)exception);
                    continue;
                }
                log.info((Object)sm.getString("contextConfig.sci.info", new Object[]{servletContainerInitializer.getClass().getName()}));
                continue;
            }
            if (handlesTypes == null || (classArray = handlesTypes.value()) == null) continue;
            for (Class clazz : classArray) {
                if (clazz.isAnnotation()) {
                    this.handlesTypesAnnotations = true;
                } else {
                    this.handlesTypesNonAnnotations = true;
                }
                Set<ServletContainerInitializer> set = this.typeInitializerMap.get(clazz);
                if (set == null) {
                    set = new HashSet<ServletContainerInitializer>();
                    this.typeInitializerMap.put(clazz, set);
                }
                set.add(servletContainerInitializer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResourceJARs(Set<WebXml> set) {
        block9: for (WebXml webXml : set) {
            URL uRL = webXml.getURL();
            Jar jar = null;
            try {
                Object object;
                if ("jar".equals(uRL.getProtocol())) {
                    jar = JarFactory.newInstance((URL)uRL);
                    jar.nextEntry();
                    object = jar.getEntryName();
                    while (object != null) {
                        if (((String)object).startsWith("META-INF/resources/")) {
                            this.context.addResourceJarUrl(uRL);
                            continue block9;
                        }
                        jar.nextEntry();
                        object = jar.getEntryName();
                    }
                    continue;
                }
                if (!"file".equals(uRL.getProtocol())) continue;
                object = new FileDirContext();
                ((FileDirContext)object).setDocBase(new File(uRL.toURI()).getAbsolutePath());
                try {
                    ((BaseDirContext)object).lookup("META-INF/resources/");
                    if (!(this.context instanceof StandardContext)) continue;
                    ((StandardContext)this.context).addResourcesDirContext((DirContext)object);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("contextConfig.resourceJarFail", new Object[]{uRL, this.context.getName()}));
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error((Object)sm.getString("contextConfig.resourceJarFail", new Object[]{uRL, this.context.getName()}));
            }
            finally {
                if (jar == null) continue;
                jar.close();
            }
        }
    }

    protected InputSource getGlobalWebXmlSource() {
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        if ("org/apache/catalina/startup/NO_DEFAULT_XML".equals(this.defaultWebXml)) {
            return null;
        }
        return this.getWebXmlSource(this.defaultWebXml, this.getBaseDir());
    }

    protected InputSource getHostWebXmlSource() {
        File file = this.getHostConfigBase();
        if (!file.exists()) {
            return null;
        }
        return this.getWebXmlSource("web.xml.default", file.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputSource getContextWebXmlSource() {
        InputStream inputStream = null;
        InputSource inputSource = null;
        URL uRL = null;
        String string = null;
        ServletContext servletContext = this.context.getServletContext();
        try {
            if (servletContext != null) {
                string = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
                if (string != null) {
                    try {
                        inputStream = new FileInputStream(string);
                        uRL = new File(string).toURI().toURL();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)sm.getString("contextConfig.altDDNotFound", new Object[]{string}));
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.applicationUrl"));
                    }
                } else {
                    inputStream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                    try {
                        uRL = servletContext.getResource("/WEB-INF/web.xml");
                    }
                    catch (MalformedURLException malformedURLException) {
                        log.error((Object)sm.getString("contextConfig.applicationUrl"));
                    }
                }
            }
            if (inputStream == null || uRL == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
                }
            } else {
                inputSource = new InputSource(uRL.toExternalForm());
                inputSource.setByteStream(inputStream);
            }
        }
        finally {
            if (inputSource == null && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputSource getWebXmlSource(String string, String string2) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(string2, string);
        }
        InputStream inputStream = null;
        InputSource inputSource = null;
        try {
            if (!file.exists()) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                if (inputStream != null) {
                    inputSource = new InputSource(this.getClass().getClassLoader().getResource(string).toURI().toString());
                }
            } else {
                inputSource = new InputSource(file.getAbsoluteFile().toURI().toString());
                inputStream = new FileInputStream(file);
            }
            if (inputStream != null && inputSource != null) {
                inputSource.setByteStream(inputStream);
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.defaultError", new Object[]{string, file}), (Throwable)exception);
        }
        finally {
            if (inputSource == null && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseWebXml(InputSource inputSource, WebXml webXml, boolean bl) {
        WebRuleSet webRuleSet;
        Digester digester;
        if (inputSource == null) {
            return;
        }
        XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
        if (bl) {
            digester = this.webFragmentDigester;
            webRuleSet = this.webFragmentRuleSet;
        } else {
            digester = this.webDigester;
            webRuleSet = this.webRuleSet;
        }
        digester.push((Object)webXml);
        digester.setErrorHandler((ErrorHandler)xmlErrorHandler);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.applicationStart", new Object[]{inputSource.getSystemId()}));
        }
        try {
            digester.parse(inputSource);
            if (xmlErrorHandler.getWarnings().size() > 0 || xmlErrorHandler.getErrors().size() > 0) {
                this.ok = false;
                xmlErrorHandler.logFindings(log, inputSource.getSystemId());
            }
        }
        catch (SAXParseException sAXParseException) {
            log.error((Object)sm.getString("contextConfig.applicationParse", new Object[]{inputSource.getSystemId()}), (Throwable)sAXParseException);
            log.error((Object)sm.getString("contextConfig.applicationPosition", new Object[]{"" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()}));
            this.ok = false;
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("contextConfig.applicationParse", new Object[]{inputSource.getSystemId()}), (Throwable)exception);
            this.ok = false;
        }
        finally {
            digester.reset();
            webRuleSet.recycle();
            InputSourceUtil.close((InputSource)inputSource);
        }
    }

    protected Map<String, WebXml> processJarsForWebFragments(WebXml webXml) {
        JarScanner jarScanner = this.context.getJarScanner();
        boolean bl = true;
        Set<String> set = webXml.getAbsoluteOrdering();
        if (set != null && set.isEmpty() && !this.context.getXmlValidation()) {
            bl = false;
        }
        FragmentJarScannerCallback fragmentJarScannerCallback = new FragmentJarScannerCallback(bl);
        jarScanner.scan(this.context.getServletContext(), this.context.getLoader().getClassLoader(), (JarScannerCallback)fragmentJarScannerCallback, pluggabilityJarsToSkip);
        return fragmentJarScannerCallback.getFragments();
    }

    protected void processAnnotations(Set<WebXml> set, boolean bl) {
        for (WebXml webXml : set) {
            WebXml webXml2 = new WebXml();
            webXml2.setDistributable(true);
            URL uRL = webXml.getURL();
            this.processAnnotationsUrl(uRL, webXml2, bl || webXml.isMetadataComplete());
            HashSet<WebXml> hashSet = new HashSet<WebXml>();
            hashSet.add(webXml2);
            webXml.merge(hashSet);
        }
    }

    protected void processAnnotationsUrl(URL uRL, WebXml webXml, boolean bl) {
        if (uRL == null) {
            return;
        }
        if ("jar".equals(uRL.getProtocol())) {
            this.processAnnotationsJar(uRL, webXml, bl);
        } else if ("jndi".equals(uRL.getProtocol())) {
            this.processAnnotationsJndi(uRL, webXml, bl);
        } else if ("file".equals(uRL.getProtocol())) {
            try {
                this.processAnnotationsFile(new File(uRL.toURI()), webXml, bl);
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error((Object)sm.getString("contextConfig.fileUrl", new Object[]{uRL}), (Throwable)uRISyntaxException);
            }
        } else {
            log.error((Object)sm.getString("contextConfig.unknownUrlProtocol", new Object[]{uRL.getProtocol(), uRL}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsJar(URL uRL, WebXml webXml, boolean bl) {
        Jar jar = null;
        try {
            jar = JarFactory.newInstance((URL)uRL);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.processAnnotationsJar.debug", new Object[]{uRL}));
            }
            jar.nextEntry();
            String string = jar.getEntryName();
            while (string != null) {
                if (string.endsWith(".class")) {
                    InputStream inputStream = null;
                    try {
                        inputStream = jar.getEntryInputStream();
                        this.processAnnotationsStream(inputStream, webXml, bl);
                    }
                    catch (IOException iOException) {
                        log.error((Object)sm.getString("contextConfig.inputStreamJar", new Object[]{string, uRL}), (Throwable)iOException);
                    }
                    catch (ClassFormatException classFormatException) {
                        log.error((Object)sm.getString("contextConfig.inputStreamJar", new Object[]{string, uRL}), (Throwable)classFormatException);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                jar.nextEntry();
                string = jar.getEntryName();
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("contextConfig.jarFile", new Object[]{uRL}), (Throwable)iOException);
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsJndi(URL uRL, WebXml webXml, boolean bl) {
        block22: {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (!(uRLConnection instanceof DirContextURLConnection)) {
                    sm.getString("contextConfig.jndiUrlNotDirContextConn", new Object[]{uRL});
                    return;
                }
                DirContextURLConnection dirContextURLConnection = (DirContextURLConnection)uRLConnection;
                dirContextURLConnection.setUseCaches(false);
                String string = dirContextURLConnection.getHeaderField("resourcetype");
                if ("<collection/>".equals(string)) {
                    Enumeration<String> enumeration = dirContextURLConnection.list();
                    if (log.isDebugEnabled() && enumeration.hasMoreElements()) {
                        log.debug((Object)sm.getString("contextConfig.processAnnotationsWebDir.debug", new Object[]{uRL}));
                    }
                    while (enumeration.hasMoreElements()) {
                        String string2 = enumeration.nextElement();
                        URL uRL2 = new URL(uRL.toString() + '/' + string2);
                        this.processAnnotationsJndi(uRL2, webXml, bl);
                    }
                    break block22;
                }
                if (!uRL.getPath().endsWith(".class")) break block22;
                InputStream inputStream = null;
                try {
                    inputStream = dirContextURLConnection.getInputStream();
                    this.processAnnotationsStream(inputStream, webXml, bl);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("contextConfig.inputStreamJndi", new Object[]{uRL}), (Throwable)iOException);
                }
                catch (ClassFormatException classFormatException) {
                    log.error((Object)sm.getString("contextConfig.inputStreamJndi", new Object[]{uRL}), (Throwable)classFormatException);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable((Throwable)throwable);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("contextConfig.jndiUrl", new Object[]{uRL}), (Throwable)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsFile(File file, WebXml webXml, boolean bl) {
        block20: {
            block19: {
                if (!file.isDirectory()) break block19;
                String[] stringArray = file.list();
                if (stringArray == null) break block20;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("contextConfig.processAnnotationsDir.debug", new Object[]{file}));
                }
                for (String string : stringArray) {
                    this.processAnnotationsFile(new File(file, string), webXml, bl);
                }
                break block20;
            }
            if (file.getName().endsWith(".class") && file.canRead()) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    this.processAnnotationsStream(fileInputStream, webXml, bl);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("contextConfig.inputStreamFile", new Object[]{file.getAbsolutePath()}), (Throwable)iOException);
                }
                catch (ClassFormatException classFormatException) {
                    log.error((Object)sm.getString("contextConfig.inputStreamFile", new Object[]{file.getAbsolutePath()}), (Throwable)classFormatException);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable((Throwable)throwable);
                        }
                    }
                }
            }
        }
    }

    protected void processAnnotationsStream(InputStream inputStream, WebXml webXml, boolean bl) throws ClassFormatException, IOException {
        ClassParser classParser = new ClassParser(inputStream);
        JavaClass javaClass = classParser.parse();
        this.checkHandlesTypes(javaClass);
        if (bl) {
            return;
        }
        this.processClass(webXml, javaClass);
    }

    protected void processClass(WebXml webXml, JavaClass javaClass) {
        AnnotationEntry[] annotationEntryArray = javaClass.getAnnotationEntries();
        if (annotationEntryArray != null) {
            String string = javaClass.getClassName();
            for (AnnotationEntry annotationEntry : annotationEntryArray) {
                String string2 = annotationEntry.getAnnotationType();
                if ("Ljavax/servlet/annotation/WebServlet;".equals(string2)) {
                    this.processAnnotationWebServlet(string, annotationEntry, webXml);
                    continue;
                }
                if ("Ljavax/servlet/annotation/WebFilter;".equals(string2)) {
                    this.processAnnotationWebFilter(string, annotationEntry, webXml);
                    continue;
                }
                if (!"Ljavax/servlet/annotation/WebListener;".equals(string2)) continue;
                webXml.addListener(string);
            }
        }
    }

    protected void checkHandlesTypes(JavaClass javaClass) {
        if (this.typeInitializerMap.size() == 0) {
            return;
        }
        if ((javaClass.getAccessFlags() & 0x2000) != 0) {
            return;
        }
        String string = javaClass.getClassName();
        Class<?> clazz = null;
        if (this.handlesTypesNonAnnotations) {
            this.populateJavaClassCache(string, javaClass);
            JavaClassCacheEntry javaClassCacheEntry = this.javaClassCache.get(string);
            if (javaClassCacheEntry.getSciSet() == null) {
                try {
                    this.populateSCIsForCacheEntry(javaClassCacheEntry);
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new IllegalStateException(sm.getString("contextConfig.annotationsStackOverflow", new Object[]{this.context.getName(), this.classHierarchyToString(string, javaClassCacheEntry)}));
                }
            }
            if (!javaClassCacheEntry.getSciSet().isEmpty()) {
                clazz = Introspection.loadClass(this.context, string);
                if (clazz == null) {
                    return;
                }
                for (ServletContainerInitializer servletContainerInitializer : javaClassCacheEntry.getSciSet()) {
                    Object object = this.initializerClassMap.get(servletContainerInitializer);
                    if (object == null) {
                        object = new HashSet();
                        this.initializerClassMap.put(servletContainerInitializer, (Set<Class<?>>)object);
                    }
                    object.add(clazz);
                }
            }
        }
        if (this.handlesTypesAnnotations) {
            block3: for (Map.Entry entry : this.typeInitializerMap.entrySet()) {
                ServletContainerInitializer servletContainerInitializer;
                if (!((Class)entry.getKey()).isAnnotation() || (servletContainerInitializer = javaClass.getAnnotationEntries()) == null) continue;
                for (ServletContainerInitializer servletContainerInitializer2 : servletContainerInitializer) {
                    if (!((Class)entry.getKey()).getName().equals(ContextConfig.getClassName(servletContainerInitializer2.getAnnotationType()))) continue;
                    if (clazz == null && (clazz = Introspection.loadClass(this.context, string)) == null) {
                        return;
                    }
                    for (ServletContainerInitializer servletContainerInitializer3 : (Set)entry.getValue()) {
                        this.initializerClassMap.get(servletContainerInitializer3).add(clazz);
                    }
                    continue block3;
                }
            }
        }
    }

    private String classHierarchyToString(String string, JavaClassCacheEntry javaClassCacheEntry) {
        JavaClassCacheEntry javaClassCacheEntry2 = javaClassCacheEntry;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("->");
        String string2 = javaClassCacheEntry.getSuperclassName();
        JavaClassCacheEntry javaClassCacheEntry3 = this.javaClassCache.get(string2);
        for (int i = 0; i < 100 && javaClassCacheEntry3 != null && javaClassCacheEntry3 != javaClassCacheEntry2; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("->");
            string2 = javaClassCacheEntry3.getSuperclassName();
            javaClassCacheEntry3 = this.javaClassCache.get(string2);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void populateJavaClassCache(String string, JavaClass javaClass) {
        if (this.javaClassCache.containsKey(string)) {
            return;
        }
        this.javaClassCache.put(string, new JavaClassCacheEntry(javaClass));
        this.populateJavaClassCache(javaClass.getSuperclassName());
        for (String string2 : javaClass.getInterfaceNames()) {
            this.populateJavaClassCache(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateJavaClassCache(String string) {
        if (!this.javaClassCache.containsKey(string)) {
            String string2 = string.replace('.', '/') + ".class";
            InputStream inputStream = this.context.getLoader().getClassLoader().getResourceAsStream(string2);
            if (inputStream == null) {
                return;
            }
            ClassParser classParser = new ClassParser(inputStream);
            try {
                JavaClass javaClass = classParser.parse();
                this.populateJavaClassCache(javaClass.getClassName(), javaClass);
            }
            catch (ClassFormatException classFormatException) {
                log.debug((Object)sm.getString("contextConfig.invalidSciHandlesTypes", new Object[]{string}), (Throwable)classFormatException);
            }
            catch (IOException iOException) {
                log.debug((Object)sm.getString("contextConfig.invalidSciHandlesTypes", new Object[]{string}), (Throwable)iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void populateSCIsForCacheEntry(JavaClassCacheEntry javaClassCacheEntry) {
        HashSet<ServletContainerInitializer> hashSet = new HashSet<ServletContainerInitializer>();
        String string = javaClassCacheEntry.getSuperclassName();
        JavaClassCacheEntry javaClassCacheEntry2 = this.javaClassCache.get(string);
        if (javaClassCacheEntry.equals(javaClassCacheEntry2)) {
            javaClassCacheEntry.setSciSet(EMPTY_SCI_SET);
            return;
        }
        if (javaClassCacheEntry2 != null) {
            if (javaClassCacheEntry2.getSciSet() == null) {
                this.populateSCIsForCacheEntry(javaClassCacheEntry2);
            }
            hashSet.addAll(javaClassCacheEntry2.getSciSet());
        }
        hashSet.addAll(this.getSCIsForClass(string));
        for (String string2 : javaClassCacheEntry.getInterfaceNames()) {
            JavaClassCacheEntry javaClassCacheEntry3 = this.javaClassCache.get(string2);
            if (javaClassCacheEntry3 != null) {
                if (javaClassCacheEntry3.getSciSet() == null) {
                    this.populateSCIsForCacheEntry(javaClassCacheEntry3);
                }
                hashSet.addAll(javaClassCacheEntry3.getSciSet());
            }
            hashSet.addAll(this.getSCIsForClass(string2));
        }
        javaClassCacheEntry.setSciSet(hashSet.isEmpty() ? EMPTY_SCI_SET : hashSet);
    }

    private Set<ServletContainerInitializer> getSCIsForClass(String string) {
        for (Map.Entry<Class<?>, Set<ServletContainerInitializer>> entry : this.typeInitializerMap.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (clazz.isAnnotation() || !clazz.getName().equals(string)) continue;
            return entry.getValue();
        }
        return EMPTY_SCI_SET;
    }

    private static final String getClassName(String string) {
        if (!string.startsWith("L")) {
            return string;
        }
        return string.substring(1, string.length() - 1).replace('/', '.');
    }

    protected void processAnnotationWebServlet(String string, AnnotationEntry annotationEntry, WebXml webXml) {
        boolean bl;
        String string2 = null;
        List list = annotationEntry.getElementValuePairs();
        Object object = list.iterator();
        while (object.hasNext()) {
            ElementValuePair elementValuePair = (ElementValuePair)object.next();
            String string3 = elementValuePair.getNameString();
            if (!"name".equals(string3)) continue;
            string2 = elementValuePair.getValue().stringifyValue();
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        if ((object = webXml.getServlets().get(string2)) == null) {
            object = new ServletDef();
            ((ServletDef)object).setServletName(string2);
            ((ServletDef)object).setServletClass(string);
            bl = false;
        } else {
            bl = true;
        }
        boolean bl2 = false;
        String[] stringArray = null;
        for (ElementValuePair elementValuePair : list) {
            String string4 = elementValuePair.getNameString();
            if ("value".equals(string4) || "urlPatterns".equals(string4)) {
                if (bl2) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", new Object[]{"WebServlet", string}));
                }
                bl2 = true;
                stringArray = this.processAnnotationsStringArray(elementValuePair.getValue());
                continue;
            }
            if ("description".equals(string4)) {
                if (((ServletDef)object).getDescription() != null) continue;
                ((ServletDef)object).setDescription(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(string4)) {
                if (((ServletDef)object).getDisplayName() != null) continue;
                ((ServletDef)object).setDisplayName(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(string4)) {
                if (((ServletDef)object).getLargeIcon() != null) continue;
                ((ServletDef)object).setLargeIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(string4)) {
                if (((ServletDef)object).getSmallIcon() != null) continue;
                ((ServletDef)object).setSmallIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(string4)) {
                if (((ServletDef)object).getAsyncSupported() != null) continue;
                ((ServletDef)object).setAsyncSupported(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("loadOnStartup".equals(string4)) {
                if (((ServletDef)object).getLoadOnStartup() != null) continue;
                ((ServletDef)object).setLoadOnStartup(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(string4)) continue;
            Map<String, String> object2 = this.processAnnotationWebInitParams(elementValuePair.getValue());
            if (bl) {
                Map<String, String> map = ((ServletDef)object).getParameterMap();
                for (Map.Entry<String, String> entry : object2.entrySet()) {
                    if (map.get(entry.getKey()) != null) continue;
                    ((ServletDef)object).addInitParameter(entry.getKey(), entry.getValue());
                }
                continue;
            }
            for (Map.Entry entry : object2.entrySet()) {
                ((ServletDef)object).addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!bl && stringArray != null) {
            webXml.addServlet((ServletDef)object);
        }
        if (stringArray != null && !webXml.getServletMappings().containsValue(string2)) {
            for (Iterator iterator : stringArray) {
                webXml.addServletMapping((String)((Object)iterator), string2);
            }
        }
    }

    protected void processAnnotationWebFilter(String string, AnnotationEntry annotationEntry, WebXml webXml) {
        Object object;
        Object object2;
        boolean bl;
        Object object32;
        String string2 = null;
        List list = annotationEntry.getElementValuePairs();
        for (Object object32 : list) {
            String string3 = object32.getNameString();
            if (!"filterName".equals(string3)) continue;
            string2 = object32.getValue().stringifyValue();
            break;
        }
        if (string2 == null) {
            string2 = string;
        }
        Object object4 = webXml.getFilters().get(string2);
        object32 = new FilterMap();
        if (object4 == null) {
            object4 = new FilterDef();
            ((FilterDef)object4).setFilterName(string2);
            ((FilterDef)object4).setFilterClass(string);
            bl = false;
        } else {
            bl = true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String[] stringArray = null;
        for (String[] stringArray2 : list) {
            String string4;
            int n;
            object2 = stringArray2.getNameString();
            if ("value".equals(object2) || "urlPatterns".equals(object2)) {
                if (bl2) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", new Object[]{"WebFilter", string}));
                }
                stringArray = this.processAnnotationsStringArray(stringArray2.getValue());
                bl2 = stringArray.length > 0;
                for (String string5 : stringArray) {
                    ((FilterMap)object32).addURLPattern(string5);
                }
                continue;
            }
            if ("servletNames".equals(object2)) {
                object = this.processAnnotationsStringArray(stringArray2.getValue());
                bl3 = ((String[])object).length > 0;
                String[] stringArray3 = object;
                int n2 = stringArray3.length;
                for (n = 0; n < n2; ++n) {
                    string4 = stringArray3[n];
                    ((FilterMap)object32).addServletName(string4);
                }
                continue;
            }
            if ("dispatcherTypes".equals(object2)) {
                object = this.processAnnotationsStringArray(stringArray2.getValue());
                bl4 = ((String[])object).length > 0;
                String[] stringArray4 = object;
                int n3 = stringArray4.length;
                for (n = 0; n < n3; ++n) {
                    string4 = stringArray4[n];
                    ((FilterMap)object32).setDispatcher(string4);
                }
                continue;
            }
            if ("description".equals(object2)) {
                if (((FilterDef)object4).getDescription() != null) continue;
                ((FilterDef)object4).setDescription(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(object2)) {
                if (((FilterDef)object4).getDisplayName() != null) continue;
                ((FilterDef)object4).setDisplayName(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(object2)) {
                if (((FilterDef)object4).getLargeIcon() != null) continue;
                ((FilterDef)object4).setLargeIcon(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(object2)) {
                if (((FilterDef)object4).getSmallIcon() != null) continue;
                ((FilterDef)object4).setSmallIcon(stringArray2.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(object2)) {
                if (((FilterDef)object4).getAsyncSupported() != null) continue;
                ((FilterDef)object4).setAsyncSupported(stringArray2.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(object2)) continue;
            object = this.processAnnotationWebInitParams(stringArray2.getValue());
            if (bl) {
                Map<String, String> map = ((FilterDef)object4).getParameterMap();
                for (Map.Entry entry : object.entrySet()) {
                    if (map.get(entry.getKey()) != null) continue;
                    ((FilterDef)object4).addInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                continue;
            }
            for (Map.Entry entry : object.entrySet()) {
                ((FilterDef)object4).addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!bl) {
            webXml.addFilter((FilterDef)object4);
            if (bl2 || bl3) {
                ((FilterMap)object32).setFilterName(string2);
                webXml.addFilterMapping((FilterMap)object32);
            }
        }
        if (bl2 || bl4) {
            String[] stringArray2;
            Set<FilterMap> set = webXml.getFilterMappings();
            stringArray2 = null;
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = (String[])object2.next();
                if (!string2.equals(((FilterMap)object).getFilterName())) continue;
                stringArray2 = object;
                break;
            }
            if (stringArray2 != null) {
                object2 = stringArray2.getURLPatterns();
                if (bl2 && (object2 == null || ((String[])object2).length == 0)) {
                    for (String string6 : ((FilterMap)object32).getURLPatterns()) {
                        stringArray2.addURLPattern(string6);
                    }
                }
                object = stringArray2.getDispatcherNames();
                if (bl4 && (object == null || ((String[])object).length == 0)) {
                    for (String string4 : ((FilterMap)object32).getDispatcherNames()) {
                        stringArray2.setDispatcher(string4);
                    }
                }
            }
        }
    }

    protected String[] processAnnotationsStringArray(ElementValue elementValue) {
        Object[] objectArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (elementValue instanceof ArrayElementValue) {
            for (ElementValue elementValue2 : objectArray = ((ArrayElementValue)elementValue).getElementValuesArray()) {
                arrayList.add(elementValue2.stringifyValue());
            }
        } else {
            arrayList.add(elementValue.stringifyValue());
        }
        objectArray = new String[arrayList.size()];
        return (String[])arrayList.toArray(objectArray);
    }

    protected Map<String, String> processAnnotationWebInitParams(ElementValue elementValue) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (elementValue instanceof ArrayElementValue) {
            ElementValue[] elementValueArray;
            for (ElementValue elementValue2 : elementValueArray = ((ArrayElementValue)elementValue).getElementValuesArray()) {
                if (!(elementValue2 instanceof AnnotationElementValue)) continue;
                List list = ((AnnotationElementValue)elementValue2).getAnnotationEntry().getElementValuePairs();
                String string = null;
                String string2 = null;
                for (ElementValuePair elementValuePair : list) {
                    if ("name".equals(elementValuePair.getNameString())) {
                        string = elementValuePair.getValue().stringifyValue();
                        continue;
                    }
                    if (!"value".equals(elementValuePair.getNameString())) continue;
                    string2 = elementValuePair.getValue().stringifyValue();
                }
                hashMap.put(string, string2);
            }
        }
        return hashMap;
    }

    static {
        pluggabilityJarsToSkip = new HashSet<String>();
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = ContextConfig.class.getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            properties = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        authenticators = properties;
        ContextConfig.addJarsToSkip("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        ContextConfig.addJarsToSkip("org.apache.catalina.startup.ContextConfig.jarsToSkip");
        deploymentCount = 0L;
        hostWebXmlCache = new ConcurrentHashMap<Host, DefaultWebXmlCacheEntry>();
        EMPTY_SCI_SET = Collections.emptySet();
    }

    private static class JavaClassCacheEntry {
        public final String superclassName;
        public final String[] interfaceNames;
        private Set<ServletContainerInitializer> sciSet = null;

        public JavaClassCacheEntry(JavaClass javaClass) {
            this.superclassName = javaClass.getSuperclassName();
            this.interfaceNames = javaClass.getInterfaceNames();
        }

        public String getSuperclassName() {
            return this.superclassName;
        }

        public String[] getInterfaceNames() {
            return this.interfaceNames;
        }

        public Set<ServletContainerInitializer> getSciSet() {
            return this.sciSet;
        }

        public void setSciSet(Set<ServletContainerInitializer> set) {
            this.sciSet = set;
        }
    }

    private static class HostWebXmlCacheCleaner
    implements LifecycleListener {
        private HostWebXmlCacheCleaner() {
        }

        @Override
        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("after_destroy".equals(lifecycleEvent.getType())) {
                Host host = (Host)lifecycleEvent.getSource();
                hostWebXmlCache.remove(host);
            }
        }
    }

    private static class DefaultWebXmlCacheEntry {
        private final WebXml webXml;
        private final long globalTimeStamp;
        private final long hostTimeStamp;

        public DefaultWebXmlCacheEntry(WebXml webXml, long l, long l2) {
            this.webXml = webXml;
            this.globalTimeStamp = l;
            this.hostTimeStamp = l2;
        }

        public WebXml getWebXml() {
            return this.webXml;
        }

        public long getGlobalTimeStamp() {
            return this.globalTimeStamp;
        }

        public long getHostTimeStamp() {
            return this.hostTimeStamp;
        }
    }

    private class FragmentJarScannerCallback
    implements JarScannerCallback {
        private static final String FRAGMENT_LOCATION = "META-INF/web-fragment.xml";
        private Map<String, WebXml> fragments = new HashMap<String, WebXml>();
        private final boolean parseRequired;

        public FragmentJarScannerCallback(boolean bl) {
            this.parseRequired = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scan(JarURLConnection jarURLConnection) throws IOException {
            URL uRL = jarURLConnection.getURL();
            URL uRL2 = jarURLConnection.getJarFileURL();
            Jar jar = null;
            InputStream inputStream = null;
            WebXml webXml = new WebXml();
            try {
                jar = JarFactory.newInstance((URL)uRL);
                if (this.parseRequired || ContextConfig.this.context.getXmlValidation()) {
                    inputStream = jar.getInputStream(FRAGMENT_LOCATION);
                }
                if (inputStream == null) {
                    webXml.setDistributable(true);
                } else {
                    InputSource inputSource = new InputSource("jar:" + uRL2.toString() + "!/" + FRAGMENT_LOCATION);
                    inputSource.setByteStream(inputStream);
                    ContextConfig.this.parseWebXml(inputSource, webXml, true);
                }
            }
            finally {
                if (jar != null) {
                    jar.close();
                }
                this.addFragment(webXml, uRL);
            }
        }

        private String extractJarFileName(URL uRL) {
            String string = uRL.toString();
            if (string.endsWith("!/")) {
                string = string.substring(0, string.length() - 2);
            }
            return string.substring(string.lastIndexOf(47) + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scan(File file) throws IOException {
            InputStream inputStream = null;
            WebXml webXml = new WebXml();
            try {
                File file2 = new File(file, FRAGMENT_LOCATION);
                if (file2.isFile()) {
                    inputStream = new FileInputStream(file2);
                    InputSource inputSource = new InputSource(file2.toURI().toURL().toString());
                    inputSource.setByteStream(inputStream);
                    ContextConfig.this.parseWebXml(inputSource, webXml, true);
                } else {
                    webXml.setDistributable(true);
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                this.addFragment(webXml, file.toURI().toURL());
            }
        }

        private void addFragment(WebXml webXml, URL uRL) {
            webXml.setURL(uRL);
            if (webXml.getName() == null) {
                webXml.setName(uRL.toString());
            }
            webXml.setJarName(this.extractJarFileName(uRL));
            if (this.fragments.containsKey(webXml.getName())) {
                String string = webXml.getName();
                this.fragments.get(string).setDuplicated(true);
                webXml.setName(uRL.toString());
            }
            this.fragments.put(webXml.getName(), webXml);
        }

        public Map<String, WebXml> getFragments() {
            return this.fragments;
        }
    }
}

