/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.XmlEncodingBase;

public class SecurityCollection
extends XmlEncodingBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description = null;
    private String[] methods = new String[0];
    private String[] omittedMethods = new String[0];
    private String name = null;
    private String[] patterns = new String[0];
    private boolean isFromDescriptor = true;

    public SecurityCollection() {
        this(null, null);
    }

    public SecurityCollection(String string, String string2) {
        this.setName(string);
        this.setDescription(string2);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isFromDescriptor() {
        return this.isFromDescriptor;
    }

    public void setFromDescriptor(boolean bl) {
        this.isFromDescriptor = bl;
    }

    public void addMethod(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = new String[this.methods.length + 1];
        for (int i = 0; i < this.methods.length; ++i) {
            stringArray[i] = this.methods[i];
        }
        stringArray[this.methods.length] = string;
        this.methods = stringArray;
    }

    public void addOmittedMethod(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = new String[this.omittedMethods.length + 1];
        for (int i = 0; i < this.omittedMethods.length; ++i) {
            stringArray[i] = this.omittedMethods[i];
        }
        stringArray[this.omittedMethods.length] = string;
        this.omittedMethods = stringArray;
    }

    public void addPattern(String string) {
        this.addPatternDecoded(UDecoder.URLDecode((String)string, (Charset)StandardCharsets.UTF_8));
    }

    public void addPatternDecoded(String string) {
        if (string == null) {
            return;
        }
        String string2 = UDecoder.URLDecode((String)string, (Charset)this.getCharset());
        String[] stringArray = Arrays.copyOf(this.patterns, this.patterns.length + 1);
        stringArray[this.patterns.length] = string2;
        this.patterns = stringArray;
    }

    public boolean findMethod(String string) {
        if (this.methods.length == 0 && this.omittedMethods.length == 0) {
            return true;
        }
        if (this.methods.length > 0) {
            for (String string2 : this.methods) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }
        if (this.omittedMethods.length > 0) {
            for (String string3 : this.omittedMethods) {
                if (!string3.equals(string)) continue;
                return false;
            }
        }
        return true;
    }

    public String[] findMethods() {
        return this.methods;
    }

    public String[] findOmittedMethods() {
        return this.omittedMethods;
    }

    public boolean findPattern(String string) {
        for (String string2 : this.patterns) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String[] findPatterns() {
        return this.patterns;
    }

    public void removeMethod(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.methods.length; ++n) {
            if (!this.methods[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.methods.length - 1];
            for (int i = 0; i < this.methods.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.methods[i];
            }
            this.methods = stringArray;
        }
    }

    public void removeOmittedMethod(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.omittedMethods.length; ++n) {
            if (!this.omittedMethods[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.omittedMethods.length - 1];
            for (int i = 0; i < this.omittedMethods.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.omittedMethods[i];
            }
            this.omittedMethods = stringArray;
        }
    }

    public void removePattern(String string) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < this.patterns.length; ++n) {
            if (!this.patterns[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            n = 0;
            String[] stringArray = new String[this.patterns.length - 1];
            for (int i = 0; i < this.patterns.length; ++i) {
                if (i == n2) continue;
                stringArray[n++] = this.patterns[i];
            }
            this.patterns = stringArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SecurityCollection[");
        stringBuilder.append(this.name);
        if (this.description != null) {
            stringBuilder.append(", ");
            stringBuilder.append(this.description);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

